/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.util;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigXMLUtil {
    DocumentBuilderFactory dbFactory;
    DocumentBuilder dBuilder;
    Document doc;

    public ConfigXMLUtil(String xmlPath) {
        try {
            File xmlFile = new File(xmlPath);
            if (xmlFile.exists()) {
                this.dbFactory = DocumentBuilderFactory.newInstance();
                this.dBuilder = this.dbFactory.newDocumentBuilder();
                this.doc = this.dBuilder.parse(xmlFile);
                this.doc.getDocumentElement().normalize();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getAppID(String tempExt) {
        String appID = "";
        try {
            NodeList nList = null;
            if (tempExt.equals("wgt")) {
                nList = this.doc.getElementsByTagName("tizen:application");
            } else if (tempExt.equals("tpk") && (nList = this.doc.getElementsByTagName("ui-application")).getLength() == 0) {
                nList = this.doc.getElementsByTagName("service-application");
            }
            for (int temp = 0; temp < nList.getLength(); ++temp) {
                Node nNode = nList.item(temp);
                if (nNode.getNodeType() != 1) continue;
                Element eElement = (Element)nNode;
                if (tempExt.equals("wgt")) {
                    appID = eElement.getAttribute("id");
                } else if (tempExt.equals("tpk")) {
                    appID = eElement.getAttribute("appid");
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return appID;
    }

    public String getPackageID() {
        String packageID = "";
        try {
            NodeList nList = this.doc.getElementsByTagName("tizen:application");
            for (int temp = 0; temp < nList.getLength(); ++temp) {
                Node nNode = nList.item(temp);
                if (nNode.getNodeType() != 1) continue;
                Element eElement = (Element)nNode;
                packageID = eElement.getAttribute("package");
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return packageID;
    }
}

