/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.verrari.engine;

import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.Factory;
import org.tizen.common.FactoryWithArgument;
import org.tizen.common.util.io.BufferPool;
import org.tizen.common.verrari.ITemplateEngine;
import org.tizen.common.verrari.engine.freemarker.FreemarkerTemplateEngine;

public class TemplateEngineFactory
implements Factory<ITemplateEngine>,
FactoryWithArgument<ITemplateEngine, Class<?>> {
    protected static TemplateEngineFactory instance = new TemplateEngineFactory();
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final BufferPool bufferPool = new BufferPool();

    public static TemplateEngineFactory getInstance() {
        return instance;
    }

    protected TemplateEngineFactory() {
    }

    public ITemplateEngine create() {
        return new FreemarkerTemplateEngine();
    }

    public ITemplateEngine create(Class<?> engineClass) {
        if (engineClass == null) {
            return null;
        }
        if (ClassUtils.isAssignable(engineClass, ITemplateEngine.class)) {
            try {
                return (ITemplateEngine)engineClass.newInstance();
            }
            catch (InstantiationException e) {
                this.logger.warn("Engine class can't be instantiated:", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                this.logger.warn("Engine class can't be accessible:", (Throwable)e);
            }
        }
        return null;
    }
}

