/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.ListenableGraph;
import org.jgrapht.event.GraphEdgeChangeEvent;
import org.jgrapht.event.GraphListener;
import org.jgrapht.event.GraphVertexChangeEvent;
import org.jgrapht.event.VertexSetListener;
import org.jgrapht.graph.GraphDelegator;
import org.jgrapht.util.TypeUtil;

public class DefaultListenableGraph<V, E>
extends GraphDelegator<V, E>
implements ListenableGraph<V, E>,
Cloneable {
    private static final long serialVersionUID = 3977575900898471984L;
    private ArrayList<GraphListener<V, E>> graphListeners = new ArrayList();
    private ArrayList<VertexSetListener<V>> vertexSetListeners = new ArrayList();
    private FlyweightEdgeEvent<V, E> reuseableEdgeEvent;
    private FlyweightVertexEvent<V> reuseableVertexEvent;
    private boolean reuseEvents;

    public DefaultListenableGraph(Graph<V, E> graph) {
        this(graph, false);
    }

    public DefaultListenableGraph(Graph<V, E> graph, boolean bl) {
        super(graph);
        this.reuseEvents = bl;
        this.reuseableEdgeEvent = new FlyweightEdgeEvent((Object)this, -1, null);
        this.reuseableVertexEvent = new FlyweightVertexEvent<Object>((Object)this, -1, null);
        if (graph instanceof ListenableGraph) {
            throw new IllegalArgumentException("base graph cannot be listenable");
        }
    }

    public void setReuseEvents(boolean bl) {
        this.reuseEvents = bl;
    }

    public boolean isReuseEvents() {
        return this.reuseEvents;
    }

    @Override
    public E addEdge(V v, V v2) {
        Object e = super.addEdge(v, v2);
        if (e != null) {
            this.fireEdgeAdded(e);
        }
        return e;
    }

    @Override
    public boolean addEdge(V v, V v2, E e) {
        boolean bl = super.addEdge(v, v2, e);
        if (bl) {
            this.fireEdgeAdded(e);
        }
        return bl;
    }

    @Override
    public void addGraphListener(GraphListener<V, E> graphListener) {
        DefaultListenableGraph.addToListenerList(this.graphListeners, graphListener);
    }

    @Override
    public boolean addVertex(V v) {
        boolean bl = super.addVertex(v);
        if (bl) {
            this.fireVertexAdded(v);
        }
        return bl;
    }

    @Override
    public void addVertexSetListener(VertexSetListener<V> vertexSetListener) {
        DefaultListenableGraph.addToListenerList(this.vertexSetListeners, vertexSetListener);
    }

    public Object clone() {
        try {
            TypeUtil typeUtil = null;
            DefaultListenableGraph defaultListenableGraph = (DefaultListenableGraph)TypeUtil.uncheckedCast(super.clone(), typeUtil);
            defaultListenableGraph.graphListeners = new ArrayList();
            defaultListenableGraph.vertexSetListeners = new ArrayList();
            return defaultListenableGraph;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            throw new RuntimeException("internal error");
        }
    }

    @Override
    public E removeEdge(V v, V v2) {
        Object e = super.removeEdge(v, v2);
        if (e != null) {
            this.fireEdgeRemoved(e);
        }
        return e;
    }

    @Override
    public boolean removeEdge(E e) {
        boolean bl = super.removeEdge(e);
        if (bl) {
            this.fireEdgeRemoved(e);
        }
        return bl;
    }

    @Override
    public void removeGraphListener(GraphListener<V, E> graphListener) {
        this.graphListeners.remove(graphListener);
    }

    @Override
    public boolean removeVertex(V v) {
        if (this.containsVertex(v)) {
            Set set = this.edgesOf(v);
            this.removeAllEdges(new ArrayList(set));
            super.removeVertex(v);
            this.fireVertexRemoved(v);
            return true;
        }
        return false;
    }

    @Override
    public void removeVertexSetListener(VertexSetListener<V> vertexSetListener) {
        this.vertexSetListeners.remove(vertexSetListener);
    }

    protected void fireEdgeAdded(E e) {
        GraphEdgeChangeEvent<V, E> graphEdgeChangeEvent = this.createGraphEdgeChangeEvent(23, e);
        for (int i = 0; i < this.graphListeners.size(); ++i) {
            GraphListener<V, E> graphListener = this.graphListeners.get(i);
            graphListener.edgeAdded(graphEdgeChangeEvent);
        }
    }

    protected void fireEdgeRemoved(E e) {
        GraphEdgeChangeEvent<V, E> graphEdgeChangeEvent = this.createGraphEdgeChangeEvent(24, e);
        for (int i = 0; i < this.graphListeners.size(); ++i) {
            GraphListener<V, E> graphListener = this.graphListeners.get(i);
            graphListener.edgeRemoved(graphEdgeChangeEvent);
        }
    }

    protected void fireVertexAdded(V v) {
        VertexSetListener<V> vertexSetListener;
        int n;
        GraphVertexChangeEvent<V> graphVertexChangeEvent = this.createGraphVertexChangeEvent(13, v);
        for (n = 0; n < this.vertexSetListeners.size(); ++n) {
            vertexSetListener = this.vertexSetListeners.get(n);
            vertexSetListener.vertexAdded(graphVertexChangeEvent);
        }
        for (n = 0; n < this.graphListeners.size(); ++n) {
            vertexSetListener = this.graphListeners.get(n);
            vertexSetListener.vertexAdded(graphVertexChangeEvent);
        }
    }

    protected void fireVertexRemoved(V v) {
        VertexSetListener<V> vertexSetListener;
        int n;
        GraphVertexChangeEvent<V> graphVertexChangeEvent = this.createGraphVertexChangeEvent(14, v);
        for (n = 0; n < this.vertexSetListeners.size(); ++n) {
            vertexSetListener = this.vertexSetListeners.get(n);
            vertexSetListener.vertexRemoved(graphVertexChangeEvent);
        }
        for (n = 0; n < this.graphListeners.size(); ++n) {
            vertexSetListener = this.graphListeners.get(n);
            vertexSetListener.vertexRemoved(graphVertexChangeEvent);
        }
    }

    private static <L extends EventListener> void addToListenerList(List<L> list, L l) {
        if (!list.contains(l)) {
            list.add(l);
        }
    }

    private GraphEdgeChangeEvent<V, E> createGraphEdgeChangeEvent(int n, E e) {
        if (this.reuseEvents) {
            this.reuseableEdgeEvent.setType(n);
            this.reuseableEdgeEvent.setEdge(e);
            return this.reuseableEdgeEvent;
        }
        return new GraphEdgeChangeEvent(this, n, e);
    }

    private GraphVertexChangeEvent<V> createGraphVertexChangeEvent(int n, V v) {
        if (this.reuseEvents) {
            this.reuseableVertexEvent.setType(n);
            this.reuseableVertexEvent.setVertex(v);
            return this.reuseableVertexEvent;
        }
        return new GraphVertexChangeEvent<V>(this, n, v);
    }

    private static class FlyweightVertexEvent<VV>
    extends GraphVertexChangeEvent<VV> {
        private static final long serialVersionUID = 3257848787857585716L;

        public FlyweightVertexEvent(Object object, int n, VV VV) {
            super(object, n, VV);
        }

        protected void setType(int n) {
            this.type = n;
        }

        protected void setVertex(VV VV) {
            this.vertex = VV;
        }
    }

    private static class FlyweightEdgeEvent<VV, EE>
    extends GraphEdgeChangeEvent<VV, EE> {
        private static final long serialVersionUID = 3907207152526636089L;

        public FlyweightEdgeEvent(Object object, int n, EE EE) {
            super(object, n, EE);
        }

        protected void setEdge(EE EE) {
            this.edge = EE;
        }

        protected void setType(int n) {
            this.type = n;
        }
    }
}

