/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.ui.dialog;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.command.InputValidator;
import org.tizen.common.core.command.UserField;
import org.tizen.common.util.Assert;
import org.tizen.common.util.CollectionUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.StringUtil;

public class DynamicDialog
extends Dialog {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected String title = "Dynamic Dialog";
    protected int width = 500;
    protected Text errorMessageText;
    protected String errorMessage;
    protected Collection<UserField> fields;
    protected Map<String, Control> controlMap = new HashMap<String, Control>();

    public DynamicDialog(Shell parent, Collection<UserField> fields) {
        super(parent);
        Assert.notNull(fields);
        this.fields = fields;
    }

    public DynamicDialog(IShellProvider parentShell, Collection<UserField> fields) {
        super(parentShell);
        Assert.notNull(fields);
        this.fields = fields;
    }

    public DynamicDialog(Collection<UserField> fields) {
        this(SWTUtil.getActiveShell(), fields);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.getTitle());
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10000;
    }

    protected Point getInitialSize() {
        Point initialSize = super.getInitialSize();
        initialSize.x = this.width;
        return initialSize;
    }

    protected void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        if (this.errorMessageText != null && !this.errorMessageText.isDisposed()) {
            this.errorMessageText.setText(StringUtil.nvl(errorMessage));
            boolean hasError = StringUtil.hasLength(errorMessage);
            this.errorMessageText.setEnabled(hasError);
            this.errorMessageText.setVisible(hasError);
            this.errorMessageText.getParent().update();
            Button button = this.getButton(0);
            if (button != null) {
                button.setEnabled(!hasError);
            }
        }
    }

    protected Text createErrorMessageText(Composite parent) {
        this.errorMessageText = new Text(parent, 72);
        this.errorMessageText.setLayoutData((Object)new GridData(768));
        this.errorMessageText.setBackground(this.errorMessageText.getDisplay().getSystemColor(22));
        this.setErrorMessage(this.errorMessage);
        return this.errorMessageText;
    }

    private String validateInput(UserField userField) {
        String text;
        String errorMsg;
        Control control;
        InputValidator validator = userField.getValidator();
        if (validator != null && (control = this.controlMap.get(userField.getId())) instanceof Text && control.isEnabled() && StringUtil.hasText(errorMsg = validator.check(text = ((Text)control).getText()))) {
            return errorMsg;
        }
        Collection<UserField> children = userField.getChildren();
        if (children != null) {
            for (UserField child : children) {
                String errorMsg2 = this.validateInput(child);
                if (!StringUtil.hasText(errorMsg2)) continue;
                return errorMsg2;
            }
        }
        return "";
    }

    protected void validateInput() {
        String errorMessage = null;
        for (UserField userField : this.fields) {
            errorMessage = this.validateInput(userField);
            if (StringUtil.hasText(errorMessage)) break;
        }
        this.setErrorMessage(errorMessage);
    }

    protected Control createContents(Composite parent) {
        Composite superContents = (Composite)super.createContents(parent);
        Composite dialogArea = (Composite)this.getDialogArea();
        this.createErrorMessageText(dialogArea);
        boolean firstControl = true;
        for (UserField field : this.fields) {
            Control control = this.createDynamicControl(dialogArea, field);
            if (firstControl && control != null) {
                firstControl = false;
                control.setFocus();
                if (control instanceof Text) {
                    ((Text)control).selectAll();
                }
            }
            if (!(control instanceof Button)) continue;
            this.enableChildControls(field.getId(), this.getBoolean(field.getValue()));
        }
        return superContents;
    }

    protected Control createDynamicControl(Composite parent, UserField field) {
        Text control = null;
        if (!this.isSupportField(field)) {
            return null;
        }
        Class<?> type = field.getType();
        if (String.class.equals(type)) {
            control = this.createStringTypeControl(parent, field);
        } else if (char[].class.equals(type) || Character[].class.equals(type)) {
            control = this.createCharacterTypeControl(parent, field);
        } else if (Boolean.TYPE.equals(type) || Boolean.class.equals(type)) {
            control = this.createBooleanTypeControl(parent, field);
        } else {
            throw new IllegalArgumentException("Unsupported user field type.");
        }
        Collection<UserField> children = field.getChildren();
        if (children != null) {
            Composite composite = this.createComposite(parent, (Layout)new GridLayout(), new GridData(1808));
            for (UserField childField : children) {
                this.createDynamicControl(composite, childField);
            }
        }
        return control;
    }

    protected boolean isSupportField(UserField field) {
        Collection<Object> supports = field.getSupports();
        if (supports != null && !supports.contains("eclipse")) {
            this.logger.warn("{} is not supported in {}", (Object)field, (Object)this);
            return false;
        }
        return true;
    }

    public int getCompositeStyle() {
        return 0;
    }

    public int getTextStyle() {
        return 2052;
    }

    public int getPasswordTextStyle() {
        return this.getTextStyle() | 0x400000;
    }

    public int getLabelStyle() {
        return 64;
    }

    public int getCheckButtonStyle() {
        return 0x1000020;
    }

    protected Text createStringTypeControl(Composite parent, final UserField field) {
        Composite composite = this.createComposite(parent, (Layout)new GridLayout(2, false), new GridData(1808));
        this.createLabel(composite, new GridData(128), field.getMessage(), field.canModify());
        final Text text = this.createText(composite, new GridData(1808), field.getValue(), field.canModify(), field.getValidator());
        final ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text modifiedText = (Text)e.widget;
                field.setValue(modifiedText.getText());
            }
        };
        text.addModifyListener(modifyListener);
        text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                text.removeModifyListener(modifyListener);
                text.removeDisposeListener((DisposeListener)this);
            }
        });
        this.controlMap.put(field.getId(), (Control)text);
        return text;
    }

    protected Text createCharacterTypeControl(Composite parent, final UserField field) {
        Composite composite = this.createComposite(parent, (Layout)new GridLayout(2, false), new GridData(1808));
        this.createLabel(composite, new GridData(128), field.getMessage(), field.canModify());
        final Text text = this.createPasswordText(composite, new GridData(1808), field.getValue(), field.canModify(), field.getValidator());
        final ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text modifiedText = (Text)e.widget;
                field.setValue(modifiedText.getText().toCharArray());
            }
        };
        text.addModifyListener(modifyListener);
        text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                text.removeModifyListener(modifyListener);
                text.removeDisposeListener((DisposeListener)this);
            }
        });
        this.controlMap.put(field.getId(), (Control)text);
        return text;
    }

    protected Button createBooleanTypeControl(Composite parent, final UserField field) {
        final Button button = this.createCheckButton(parent, new GridData(2), field.getId(), field.getMessage(), field.getValue(), field.canModify());
        final SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button modifiedButton = (Button)e.widget;
                field.setValue(modifiedButton.getSelection());
            }
        };
        button.addSelectionListener((SelectionListener)selectionAdapter);
        button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                button.removeSelectionListener((SelectionListener)selectionAdapter);
                button.removeDisposeListener((DisposeListener)this);
            }
        });
        this.controlMap.put(field.getId(), (Control)button);
        return button;
    }

    private Composite createComposite(Composite parent, Layout layout, Object layoutData) {
        Composite composite = new Composite(parent, this.getCompositeStyle()){

            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                Control[] controlArray = this.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String controlId;
                    UserField userField;
                    Control children = controlArray[n2];
                    if (!DynamicDialog.this.controlMap.containsValue(children) || (userField = DynamicDialog.this.getModel(DynamicDialog.this.fields, controlId = (String)DynamicDialog.this.getKeyByValue(DynamicDialog.this.controlMap, children))) != null && userField.canModify()) {
                        children.setEnabled(enabled);
                    }
                    ++n2;
                }
            }
        };
        composite.setLayout(layout);
        composite.setLayoutData(layoutData);
        return composite;
    }

    private Label createLabel(Composite parent, Object layoutData, String msg, boolean enabled) {
        Label label = new Label(parent, this.getLabelStyle());
        label.setLayoutData(layoutData);
        label.setText(msg);
        label.setEnabled(enabled);
        return label;
    }

    private Text createText(Composite parent, Object layoutData, Object defaultText, boolean enabled, InputValidator validator) {
        final Text text = new Text(parent, this.getTextStyle());
        text.setLayoutData(layoutData);
        final ModifyListener textModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DynamicDialog.this.validateInput();
            }
        };
        text.addModifyListener(textModifyListener);
        text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                text.removeModifyListener(textModifyListener);
                text.removeDisposeListener((DisposeListener)this);
            }
        });
        if (defaultText instanceof String) {
            text.setText((String)defaultText);
        } else {
            text.setText("");
        }
        text.setEnabled(enabled);
        return text;
    }

    private Text createPasswordText(Composite parent, Object layoutData, Object defaultText, boolean enabled, InputValidator validator) {
        final Text text = new Text(parent, this.getPasswordTextStyle());
        text.setLayoutData(layoutData);
        final ModifyListener textModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DynamicDialog.this.validateInput();
            }
        };
        text.addModifyListener(textModifyListener);
        text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                text.removeModifyListener(textModifyListener);
                text.removeDisposeListener((DisposeListener)this);
            }
        });
        if (defaultText instanceof char[]) {
            text.setText(new String((char[])defaultText));
        } else if (defaultText instanceof Character[]) {
            text.setText(Arrays.toString((Object[])((Character[])defaultText)));
        } else {
            text.setText("");
        }
        text.setEnabled(enabled);
        return text;
    }

    private Button createCheckButton(Composite parent, Object layoutData, final String id, String msg, Object value, boolean enabled) {
        final Button button = new Button(parent, this.getCheckButtonStyle());
        button.setLayoutData(layoutData);
        final SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DynamicDialog.this.enableChildControls(id, ((Button)e.widget).getSelection());
            }
        };
        button.addSelectionListener((SelectionListener)selectionAdapter);
        button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                button.removeSelectionListener((SelectionListener)selectionAdapter);
                button.removeDisposeListener((DisposeListener)this);
            }
        });
        button.setText(msg);
        button.setEnabled(enabled);
        button.setSelection(this.getBoolean(value));
        return button;
    }

    private <T, E> T getKeyByValue(Map<T, E> map, E value) {
        Assert.notNull(map);
        Assert.notNull(value);
        for (Map.Entry<T, E> entry : map.entrySet()) {
            if (!value.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    private boolean getBoolean(Object obj) {
        return obj == null ? true : Boolean.parseBoolean(String.valueOf(obj));
    }

    private void enableChildControls(String id, boolean enabled) {
        Collection<UserField> childIds = null;
        for (UserField field : this.fields) {
            childIds = this.getChildModelById(field, id);
            if (!CollectionUtil.isEmpty(childIds)) break;
        }
        if (!CollectionUtil.isEmpty(childIds)) {
            for (UserField childId : childIds) {
                if (!childId.canModify() && enabled) continue;
                Control control = this.controlMap.get(childId.getId());
                if (!(control instanceof Composite)) {
                    control = control.getParent();
                }
                control.setEnabled(enabled);
            }
        }
    }

    private UserField getModel(Collection<UserField> fields, String id) {
        for (UserField field : fields) {
            UserField result;
            if (field.getId().equals(id)) {
                return field;
            }
            if (CollectionUtil.isEmpty(field.getChildren()) || (result = this.getModel(field.getChildren(), id)) == null) continue;
            return result;
        }
        return null;
    }

    private Collection<UserField> getChildModelById(UserField field, String id) {
        Assert.notNull(id);
        Collection<UserField> children = field.getChildren();
        if (CollectionUtil.isEmpty(field.getChildren())) {
            return null;
        }
        if (id.equals(field.getId())) {
            return children;
        }
        for (UserField child : children) {
            Collection<UserField> childResult = this.getChildModelById(child, child.getId());
            if (CollectionUtil.isEmpty(childResult)) continue;
            return childResult;
        }
        return null;
    }
}

