/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.ide.shell;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.StringArrayOptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.ncli.config.ConfigConstant;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.ide.messages.TizenCLIMessages;
import org.tizen.ncli.ide.shell.AbstractCLI;
import org.tizen.ncli.ide.shell.CleanCLI;
import org.tizen.ncli.ide.shell.PackageCLI;
import org.tizen.ncli.subcommands.build.buildnative.BuildNativeCLICommand;
import org.tizen.ncli.subcommands.build.buildnative.BuildNativeCommand;
import org.tizen.ncli.subcommands.build.buildnative.BuildNativeData;
import org.tizen.ncli.subcommands.build.buildnative.BuildNativeOption;
import org.tizen.sbilib.for_cli.sbiplugin.SBIRootstrapData;
import org.tizen.sbilib.for_cli.sbiplugin.SBIRootstrapManager;

@TizenSubCommand(name="build-multiple", usage="Build multiple Tizen native projects.")
public class BuildMultipleCLI
extends AbstractCLI {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Option(name="-a", aliases={"--arch"}, metaVar="{x86|x86_64|arm|aarch64|all}", handler=StringArrayOptionHandler.class, usage="Specify the architecture types separated by space. (x86 is default)")
    private String[] architecture;
    @Option(name="-c", aliases={"--compiler"}, metaVar="{gcc|llvm}", usage="Specify the compiler to build. (llvm is default)")
    private String compiler;
    @Option(name="-C", aliases={"--configuration"}, metaVar="{Debug|Release}", usage="Specify the build configuration. (Debug is default)")
    private String configuration;
    @Option(name="-V", aliases={"--version-change"}, usage="Specify if version update is required")
    private boolean isBuildVd;
    private int buildType = 1;
    private static final String TPK = "tpk";
    private int result = 0;

    @Override
    public int execute() {
        this.log.trace("Execute BuildMultipleCLI...");
        if (this.isBuildVd) {
            this.buildType = 2;
        }
        String string = this.configuration = this.configuration == null ? "Debug" : this.configuration;
        if (this.architecture == null || this.architecture.length == 0) {
            this.architecture = new String[]{"x86"};
        } else {
            for (String arch : this.architecture) {
                if ("all".compareToIgnoreCase(arch) != 0) continue;
                this.architecture = new String[]{"x86", "arm", "aarch64", "x86_64"};
                break;
            }
        }
        CleanCLI cleanCLI = new CleanCLI();
        cleanCLI.workingDir = this.getRealWorkingPath();
        cleanCLI.execute();
        ArrayList<File> files = new ArrayList<File>();
        List sbiRootstrapData = SBIRootstrapManager.getRootstrapDataList((String)(InstallPathConfig.getSDKPath() + File.separator + BuildNativeOption.SBI_HOME_PATH));
        String platformName = this.getPlatformName();
        for (int i = 0; i < this.architecture.length; ++i) {
            if (!this.checkIfRootstrapExists(platformName, this.architecture[i], sbiRootstrapData)) {
                this.progressLog.info("Rootstrap not found for architecture : " + this.architecture[i]);
                this.result += 2;
                continue;
            }
            BuildNativeCLICommand command = new BuildNativeCLICommand();
            command.setWorkingDir(this.getRealWorkingPath());
            command.setOutputPath(null);
            command.setBuildScriptPath(null);
            command.setRootstrap(null);
            command.setRequiredOptions(new String[]{this.architecture[i], this.compiler, this.configuration});
            command.setPredefineOption(null);
            command.setJobsForParallelBuild(0);
            command.setFrameworkList(null);
            command.setExtraOption(null);
            command.setBuildType(this.buildType);
            BuildNativeCommand.setStripInfo(null);
            BuildNativeData data = (BuildNativeData)command.runCommand();
            if (data != null) {
                ++this.result;
                this.progressLog.info("Output path : {} (binary:{})", (Object)data.getOutputPath(), (Object)data.getSbiExecName());
                PackageCLI packageCLI = new PackageCLI();
                packageCLI.setBuildType(this.buildType);
                packageCLI.setType(TPK);
                packageCLI.workingDir = new File(this.getRealWorkingPath().toString() + File.separator + this.configuration);
                packageCLI.setArchitecture(this.architecture[i]);
                if (packageCLI.execute() == 0) {
                    ++this.result;
                }
            }
            String tpkFilePath = this.getTpkPath(this.getRealWorkingPath().getAbsolutePath(), this.architecture[i]);
            if (tpkFilePath.isEmpty()) continue;
            files.add(new File(tpkFilePath));
        }
        if (!files.isEmpty()) {
            this.zip(files, this.getRealWorkingPath().getAbsolutePath() + File.separator + this.configuration + File.separator + ((File)files.get(0)).getName().replace("-" + this.architecture[0] + "." + TPK, ".zip"));
        }
        if (this.result == this.architecture.length * 2) {
            return 0;
        }
        return -1;
    }

    private String getTpkPath(String projectPath, String arch) {
        arch = ConfigConstant.map.get(arch);
        File[] filesList = new File(projectPath + File.separator + this.configuration + File.separator + arch).listFiles();
        for (int i = 0; i < filesList.length; ++i) {
            if (!TPK.equals(FilenameUtils.getExtension((String)filesList[i].getAbsolutePath()))) continue;
            return filesList[i].getAbsolutePath();
        }
        this.log.info("tpk file not found");
        return "";
    }

    public void zip(List<File> files, String filename) {
        File zipfile = new File(filename);
        byte[] buf = new byte[1024];
        try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipfile));){
            for (int i = 0; i < files.size(); ++i) {
                try (FileInputStream in = new FileInputStream(files.get(i));){
                    int len;
                    out.putNextEntry(new ZipEntry(files.get(i).getName()));
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    continue;
                }
            }
        }
        catch (IOException e) {
            this.log.error(e.getMessage());
        }
    }

    public boolean checkIfRootstrapExists(String platform, String arch, List<SBIRootstrapData> sbiRootstrapData) {
        return sbiRootstrapData != null && SBIRootstrapManager.getRootstrap(sbiRootstrapData, (String)platform, (String)ConfigConstant.map.get(arch)) != null;
    }

    private String getPlatformName() {
        Properties prop = BuildNativeCommand.getProp(this.getRealWorkingPath().toString());
        if (prop == null) {
            this.log.trace(TizenCLIMessages.INVALID_ARGS);
            throw new UnexpectedException(2, TizenCLIMessages.INVALID_ARGS);
        }
        String profile = prop.getProperty("profile");
        int indx = profile.lastIndexOf("-");
        if (indx == -1) {
            return "";
        }
        String profileName = profile.substring(0, indx);
        profileName = profileName.substring(0, 1).toUpperCase() + profileName.substring(1);
        String profileVersion = profile.substring(indx + 1);
        return profileName + " " + profileVersion;
    }
}

