/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.packages;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.tizen.common.Factory;
import org.tizen.common.FactoryWithArgument;
import org.tizen.common.builder.Resource;
import org.tizen.common.builder.ResourceLayer;
import org.tizen.common.core.command.Command;
import org.tizen.common.core.command.ExecutionContext;
import org.tizen.common.core.command.Executor;
import org.tizen.common.core.command.Policy;
import org.tizen.common.core.command.Prompter;
import org.tizen.common.core.command.policy.PolicyRegistry;
import org.tizen.common.core.command.prompter.NopPrompter;
import org.tizen.common.core.command.zip.ZipCommand;
import org.tizen.common.file.FileHandler;
import org.tizen.common.file.Filter;
import org.tizen.common.file.IResource;
import org.tizen.common.file.SimpleFileFilter;
import org.tizen.common.file.StandardFileHandler;
import org.tizen.common.file.VirtualFileHandler;
import org.tizen.common.file.filter.WildCardFilterFactory;
import org.tizen.common.util.CollectionUtil;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.ncli.config.Configuration;
import org.tizen.ncli.ide.messages.TizenCLIMessages;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.packages.PackageCLICommandData;
import org.tizen.ncli.subcommands.packages.PackageWebMultiCommand;
import org.tizen.ncli.subcommands.packages.WebProject;
import org.tizen.ncli.subcommands.sign.SignCLICommand;
import org.tizen.ncli.util.DirectoryUtil;
import org.w3c.dom.Document;

public class PackageCLICommand
extends AbstractSubCommand<PackageCLICommandData> {
    protected FileHandler fileHandler = new StandardFileHandler();
    protected String projectPath;
    protected String projectName;
    protected String outputPath = null;
    protected static final String TIZEN_WEB_CONFIG_FILE = "config.xml";
    protected static final String SIGNATURE_FILE = "signature1.xml";
    protected static final String AUTHOR_SIGNATURE_FILE = "author-signature.xml";
    protected static final String BUILD_RESULT_DIR = ".buildResult";
    protected PackageCLICommandData data = new PackageCLICommandData();
    protected SimpleFileFilter filter = new SimpleFileFilter(true);
    protected FactoryWithArgument<Filter, String> filterFactory = new WildCardFilterFactory();
    protected static final String RESOURCE_LAYER_START = "start";
    private String profilesPath;
    private String profileName;
    private Configuration config = new Configuration();
    private String configPath;
    private Document configDoc;
    private List<String> refPaths = null;
    private boolean isWebWidget = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected PackageCLICommandData call() {
        String authorFileName;
        SignCLICommand signCmd;
        block19: {
            this.log.debug("Base project directory: {}", (Object)this.projectPath);
            this.configPath = this.findAndGetFileName(this.workingDir, TIZEN_WEB_CONFIG_FILE);
            if (this.configPath == null) {
                this.configPath = this.findAndGetFileName(new File(this.projectPath), TIZEN_WEB_CONFIG_FILE);
            }
            if (this.configPath == null) {
                this.progressLog.error(String.format("Not found tizen web project in %s", this.projectPath));
                return null;
            }
            try {
                this.configDoc = WebProject.getDocument(this.configPath);
                if (this.configDoc == null) {
                    this.progressLog.error("Error config file is not exist");
                    return null;
                }
                this.projectName = WebProject.getProjectName(this.configDoc);
                if (this.projectName == null) {
                    this.progressLog.error("Error occurred during getting project name from config file");
                    return null;
                }
            }
            catch (Exception e) {
                this.progressLog.error("Error occurred during getting project config file", (Object)e.getMessage());
                return null;
            }
            if (this.refPaths != null && !this.refPaths.isEmpty()) {
                PackageWebMultiCommand cmd = new PackageWebMultiCommand();
                cmd.setWorkingDir(this.workingDir);
                cmd.setProfileName(this.profileName);
                cmd.setReferencePaths(this.refPaths);
                cmd.setOutputPath(this.outputPath);
                return (PackageCLICommandData)cmd.runCommand();
            }
            signCmd = new SignCLICommand();
            signCmd.setWorkingDir(this.workingDir);
            if (this.profileName != null && !this.profileName.isEmpty()) {
                this.profilesPath = this.config.getValue("profiles.path");
                if (this.profilesPath == null) {
                    this.profilesPath = this.config.getValue("default.profiles.path");
                }
                if (this.profilesPath != null && !this.profilesPath.isEmpty()) {
                    signCmd.setProfileName(this.profileName);
                    break block19;
                } else {
                    this.log.error(String.format("The path of '%s' does not exist. Update 'tizen cli-config -g %s='valid path'.", "profiles.path", "profiles.path"));
                    this.progressLog.error(String.format("The path of '%s' does not exist. Update 'tizen cli-config -g %s='valid path'.", "profiles.path", "profiles.path"));
                    return null;
                }
            }
            signCmd.setUseDefaultCertificate(true);
        }
        signCmd.runCommand();
        String fileName = this.findAndGetFileName(this.workingDir, SIGNATURE_FILE);
        if (fileName == null) {
            this.progressLog.info("Warning: Not found tizen signature file");
        }
        if ((authorFileName = this.findAndGetFileName(this.workingDir, AUTHOR_SIGNATURE_FILE)) == null) {
            this.progressLog.info("Warning: Not found tizen author signature file");
        }
        String[] excludes = this.getDefaultExcludes();
        this.log.debug("Excludes File Pattern: {}", (Object)CollectionUtil.toString((Object)excludes));
        this.progressLog.info("Excludes File Pattern: {}", (Object)CollectionUtil.toString((Object)excludes));
        ResourceLayer startLayer = new ResourceLayer(RESOURCE_LAYER_START, (FileHandler)new VirtualFileHandler());
        Resource[] resources = null;
        try {
            resources = this.getResources(this.workingDir.getAbsolutePath(), startLayer, null, excludes);
        }
        catch (IOException e) {
            this.log.error("Error occurred during reading resource", (Object)e.getMessage());
            return null;
        }
        if (!DirectoryUtil.createMissingDirectory(this.outputPath)) {
            return null;
        }
        File outputFile = new File(this.outputPath + File.separator + this.projectName + "." + "wgt");
        this.data.setWgtPath(outputFile.getAbsolutePath());
        this.log.debug("Widget path: {}", (Object)outputFile.getAbsolutePath());
        try {
            if (outputFile.exists() && !outputFile.delete()) {
                this.log.error("Unable to delete");
            }
        }
        catch (Exception e) {
            this.log.error("Error occurred during delete", (Object)e.getMessage());
            return null;
        }
        this.zipFiles(outputFile.getAbsolutePath(), this.workingDir.getAbsolutePath(), resources);
        return this.data;
    }

    private boolean validateProfilesPath() {
        boolean result = false;
        if (this.profilesPath != null) {
            File profiles = new File(this.profilesPath);
            if (profiles.exists()) {
                result = true;
            } else {
                this.progressLog.info(NLS.bind((String)TizenCLIMessages.SIGN_NO_PROFILES, (Object)this.profilesPath));
            }
        } else {
            this.progressLog.info(TizenCLIMessages.SIGN_NO_CONFIG_PROFILES);
        }
        return result;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setProfileName(String profile) {
        this.profileName = profile;
    }

    public void setReferencePaths(List<String> refPaths) {
        this.refPaths = refPaths;
    }

    public List<String> getReferencePaths() {
        return this.refPaths;
    }

    private String findAndGetFileName(File baseDir, String fileName) {
        File[] filesAndDirs = baseDir.listFiles();
        if (null == filesAndDirs) {
            return null;
        }
        for (File file : filesAndDirs) {
            String name = file.getName();
            if (!name.equals(fileName) || !file.isFile()) continue;
            return file.getAbsolutePath();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource[] getResources(String baseDir, ResourceLayer resourceLayer, String[] includes, String[] excludes) throws IOException {
        List files = FileUtil.findFiles((File)new File(baseDir), (String)".*", (boolean)true);
        ArrayList<Resource> resources = new ArrayList<Resource>();
        FileHandler fh = resourceLayer.getFileHandler();
        this.setIncludes(includes);
        this.setExcludes(excludes);
        for (File file : files) {
            String filePath = file.getPath();
            if (!FilenameUtil.equals((String)filePath, (String)baseDir) && !this.filter.accept(baseDir, FilenameUtil.getRelativePath((String)baseDir, (String)filePath))) {
                this.log.debug("Ignore File: {}", (Object)filePath);
                this.progressLog.info("Ignore File: {}", (Object)filePath);
                continue;
            }
            Resource resource = new Resource(resourceLayer, filePath);
            String dir = null;
            dir = file.isFile() ? file.getParent() : filePath;
            if (!fh.is(dir, FileHandler.Attribute.EXISTS)) {
                fh.makeDirectory(dir, true);
            }
            FileInputStream is = null;
            try {
                is = new FileInputStream(file);
                resource.setContents((InputStream)is);
                resources.add(resource);
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{is});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{is});
        }
        return resources.toArray(new Resource[resources.size()]);
    }

    public void setIncludes(String[] includes) {
        this.filter.clearIncludes();
        if (null != includes) {
            for (String include : includes) {
                this.filter.addIncludes(new Filter[]{(Filter)this.filterFactory.create((Object)include)});
            }
        }
    }

    public void setExcludes(String[] excludes) {
        this.filter.clearExcludes();
        if (null != excludes) {
            for (String exclude : excludes) {
                this.filter.addExcludes(new Filter[]{(Filter)this.filterFactory.create((Object)exclude)});
            }
        }
    }

    private void zipFiles(String wgtPath, String baseDir, Resource[] resources) {
        ZipCommand command = new ZipCommand(baseDir, (IResource[])resources, wgtPath);
        Executor executor = new Executor((Factory)new Factory<ExecutionContext>(){

            public ExecutionContext create() {
                return new ExecutionContext(new PolicyRegistry(new Policy[0]), (Prompter)new NopPrompter(), PackageCLICommand.this.fileHandler);
            }
        });
        executor.execute(new Command[]{command});
    }

    protected boolean exists(String path) throws IOException {
        return this.fileHandler.is(path, FileHandler.Attribute.EXISTS);
    }

    protected boolean isValidRoot(String path) throws IOException {
        String projectFilePath = FilenameUtil.addTailingPath((String)path, (String)".project");
        return this.fileHandler.is(projectFilePath, FileHandler.Attribute.EXISTS);
    }

    protected String[] getDefaultExcludes() {
        return new String[]{".manifest.tmp", ".delta.lst"};
    }

    protected void zipFiles(String wgtPath, String baseDir) {
        this.zipFiles(wgtPath, baseDir, null);
    }

    public void setProjectPath(String projectPath) {
        this.projectPath = projectPath;
    }
}

