/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.packages;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.tizen.common.core.command.Command;
import org.tizen.common.core.command.file.DirectoryCopyHandlingCommand;
import org.tizen.common.core.command.zip.ZipCommand;
import org.tizen.common.util.CollectionUtil;
import org.tizen.ncli.config.Configuration;
import org.tizen.ncli.core.CommandLineExecutor;
import org.tizen.ncli.core.ConsolePrompter;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.packages.PackageCLICommandData;
import org.tizen.ncli.subcommands.packages.WebProject;
import org.tizen.ncli.subcommands.sign.SignCLICommand;
import org.tizen.ncli.util.DirectoryUtil;
import org.w3c.dom.Document;

public class PackageWebMultiCommand
extends AbstractSubCommand<PackageCLICommandData> {
    private Configuration config;
    private String profileName = null;
    protected String targetDirPath = null;
    protected String projectName;
    protected ArrayList<String> referencePaths;
    protected List<String> refs;
    protected String outputPath = null;
    protected static final String TIZEN_WEB_CONFIG_FILE = "config.xml";
    protected static final String SIGNATURE_FILE = "signature1.xml";
    protected static final String AUTHOR_SIGNATURE_FILE = "author-signature.xml";
    protected PackageCLICommandData data = new PackageCLICommandData();
    private String profilesPath;
    private String targetConfigPath;
    private Document configDoc;

    public PackageWebMultiCommand() {
        this.config = new Configuration();
    }

    @Override
    protected PackageCLICommandData call() {
        File tempDir;
        if (!this.setInputs()) {
            return null;
        }
        if (!WebProject.isWebUIProject(this.configDoc)) {
            this.progressLog.error("This project is not webUI project");
            return null;
        }
        try {
            tempDir = DirectoryUtil.createTempDirectory();
        }
        catch (IOException e) {
            this.log.error("Error occurred during create Temp dir", (Object)e.getMessage());
            return null;
        }
        String fileName = this.findAndGetFileName(this.workingDir, SIGNATURE_FILE);
        try {
            File sig;
            if (fileName != null && !(sig = new File(fileName)).delete()) {
                this.log.error("Unable to delete");
            }
        }
        catch (Exception e) {
            this.log.error("Error occurred during create Temp dir", (Object)e.getMessage());
            return null;
        }
        String authorFileName = this.findAndGetFileName(this.workingDir, AUTHOR_SIGNATURE_FILE);
        if (authorFileName != null) {
            File asig = new File(authorFileName);
            asig.delete();
        }
        if (!this.makeStructure(tempDir)) {
            this.log.error("Error occurred during get contents");
            return null;
        }
        try {
            this.sign(tempDir);
        }
        catch (Exception e) {
            this.log.error("Error occurred during sign contents", (Object)e.getMessage());
            return null;
        }
        File outputFile = new File(this.outputPath);
        if (outputFile.isDirectory()) {
            outputFile = new File(this.outputPath + File.separator + this.projectName + "." + "wgt");
        }
        this.data.setWgtPath(outputFile.getAbsolutePath());
        this.log.debug("Widget path: {}", (Object)outputFile.getAbsolutePath());
        if (outputFile.isFile()) {
            outputFile.delete();
        }
        try {
            this.zipFiles(tempDir.toString(), outputFile.getAbsolutePath());
        }
        catch (Exception e) {
            this.log.error("Error occurred during create wgt file", (Object)e.getMessage());
            return null;
        }
        DirectoryUtil.deleteDirectory(tempDir, true);
        return this.data;
    }

    private boolean setInputs() {
        try {
            this.targetDirPath = this.workingDir.getCanonicalPath();
        }
        catch (IOException e) {
            this.log.error("Error occurred during setting working directory", (Object)e.getMessage());
            return false;
        }
        this.log.debug("Base project directory: {}", (Object)this.targetDirPath);
        this.targetConfigPath = this.workingDir.toString() + File.separator + TIZEN_WEB_CONFIG_FILE;
        File targetConfigFile = new File(this.targetConfigPath);
        if (!targetConfigFile.exists()) {
            this.progressLog.error("Error config file " + this.targetConfigPath + " is not exist");
            return false;
        }
        if (!this.validateReferencePaths()) {
            this.progressLog.error("Web Widget App project's reference path must be web widget");
            return false;
        }
        try {
            this.configDoc = WebProject.getDocument(this.targetConfigPath);
            if (this.configDoc == null) {
                this.progressLog.error("Error Can't parse config.xml file ");
                return false;
            }
            this.projectName = WebProject.getProjectName(this.configDoc);
        }
        catch (Exception e) {
            this.progressLog.error("Error Can't parse cofnig.xml file", (Object)e.getMessage());
            return false;
        }
        if (!this.checkSingleConfig(this.configDoc)) {
            this.progressLog.error("Error config.xml file format is invalid");
            return false;
        }
        return true;
    }

    public boolean checkSingleConfig(Document doc) {
        String[] appIdList = WebProject.getTizenApplicationIdList(doc);
        if (appIdList.length != 1) {
            return false;
        }
        String[] widgetIdList = WebProject.getTizenAppWidgetIdList(doc);
        if (widgetIdList.length > 1) {
            return false;
        }
        String name = WebProject.getProjectName(doc);
        return name != null && name.length() != 0;
    }

    public void setProfileName(String profile) {
        this.profileName = profile;
    }

    public void setReferencePaths(List<String> refs) {
        this.refs = refs;
    }

    public void setOutputPath(String path) {
        this.outputPath = path;
    }

    public String getWidgetProjectName(Document doc) {
        String widgetId = WebProject.getTizenAppWidgetId(doc);
        if (widgetId == null) {
            return null;
        }
        return widgetId.split("[.]")[2];
    }

    public boolean validateReferencePaths() {
        if (this.refs == null) {
            return true;
        }
        ArrayList<String> refPathList = new ArrayList<String>();
        for (String realrefPath : this.refs) {
            File realrefDir = new File(realrefPath);
            if (realrefDir.exists() && realrefDir.isDirectory()) {
                File realrefConfig = new File(realrefPath + File.separator + TIZEN_WEB_CONFIG_FILE);
                if (realrefConfig.exists()) {
                    Document conf = WebProject.getDocument(realrefConfig.toString());
                    if (this.checkSingleConfig(conf)) {
                        if (WebProject.isWebWidgetProject(conf)) {
                            refPathList.add(realrefPath);
                            continue;
                        }
                        this.progressLog.error("Error: " + realrefDir.toString() + " is not web widget contents Directory");
                        return false;
                    }
                    this.progressLog.error("Error: " + realrefConfig.toString() + " is invalid format");
                    return false;
                }
                this.progressLog.error("Error: " + realrefConfig.toString() + " is not exist");
                return false;
            }
            this.progressLog.error("Error: " + realrefDir.toString() + "  must be web widget contents Directory");
            return false;
        }
        this.referencePaths = refPathList;
        return true;
    }

    private String findAndGetFileName(File baseDir, String fileName) {
        File[] filesAndDirs = baseDir.listFiles();
        if (null == filesAndDirs) {
            return null;
        }
        for (File file : filesAndDirs) {
            String name = file.getName();
            if (!name.equals(fileName) || !file.isFile()) continue;
            return file.getAbsolutePath();
        }
        return null;
    }

    private void sign(File targetDir) throws Exception {
        if (this.profileName != null && !this.profileName.isEmpty()) {
            this.profilesPath = this.config.getValue("profiles.path");
            if (this.profilesPath == null) {
                this.profilesPath = this.config.getValue("default.profiles.path");
            }
            SignCLICommand signCmd = new SignCLICommand();
            signCmd.setWorkingDir(targetDir);
            signCmd.setProfileName(this.profileName);
            signCmd.runCommand();
        }
    }

    private boolean makeStructure(File targetDir) {
        for (String refpath : this.referencePaths) {
            if (this.makeWidgetStructure(refpath, targetDir.toString())) continue;
            return false;
        }
        Object[] excludes = this.getDefaultExcludes();
        this.log.debug("Excludes File Pattern: {}", (Object)CollectionUtil.toString((Object)excludes));
        this.progressLog.info("Excludes File Pattern: {}", (Object)CollectionUtil.toString((Object)excludes));
        String[] excludeList = (String[])ArrayUtils.addAll((Object[])excludes, (Object[])new String[]{TIZEN_WEB_CONFIG_FILE});
        try {
            this.copyDir(this.targetDirPath, targetDir.toString(), excludeList);
        }
        catch (Exception e) {
            this.log.error("Error occurred during copy widget contents", (Object)e.getMessage());
            return false;
        }
        try {
            WebProject.genWidgetConfig(this.configDoc, targetDir.toString());
        }
        catch (Exception e) {
            this.log.error("Error occurred during generate config.xml file", (Object)e.getMessage());
            return false;
        }
        return true;
    }

    private boolean makeWidgetStructure(String srcDir, String targetDir) {
        String widgetPath;
        String confPath = srcDir + File.separator + TIZEN_WEB_CONFIG_FILE;
        Document conf = WebProject.getDocument(confPath);
        if (conf == null) {
            return false;
        }
        String widgetName = this.getWidgetProjectName(conf);
        if (widgetName == null) {
            return false;
        }
        try {
            widgetPath = targetDir + File.separator + "widget" + File.separator + widgetName;
            File widgetDir = new File(widgetPath);
            if (!widgetDir.exists()) {
                widgetDir.mkdirs();
            }
        }
        catch (Exception e) {
            this.log.error("Error occurred during generate widget Dir", (Object)e.getMessage());
            return false;
        }
        Object[] excludes = this.getDefaultExcludes();
        this.log.debug("Excludes File Pattern: {}", (Object)CollectionUtil.toString((Object)excludes));
        this.progressLog.info("Excludes File Pattern: {}", (Object)CollectionUtil.toString((Object)excludes));
        String[] excludeList = (String[])ArrayUtils.addAll((Object[])excludes, (Object[])new String[]{TIZEN_WEB_CONFIG_FILE});
        String srcWidgetDir = srcDir + File.separator + "widget" + File.separator + widgetName;
        try {
            this.copyDir(srcWidgetDir, widgetPath, excludeList);
        }
        catch (Exception e) {
            this.log.error("Error occurred during copy widget contents", (Object)e.getMessage());
            return false;
        }
        CommandLineExecutor executor = new CommandLineExecutor(new ConsolePrompter(System.out, new InputStreamReader(System.in)));
        ArrayList<String> copySrcList = new ArrayList<String>();
        copySrcList.add(srcDir + File.separator + ".trust-anchor");
        ArrayList<String> copyDesList = new ArrayList<String>();
        copyDesList.add(targetDir + File.separator + ".trust-anchor");
        DirectoryCopyHandlingCommand dirCopyCmd = new DirectoryCopyHandlingCommand(copySrcList, copyDesList);
        executor.execute(new Command[]{dirCopyCmd});
        WebProject.addWidgetToApp(this.configDoc, conf);
        return true;
    }

    private void copyDir(String fromDir, String toDir, String[] excludes) throws Exception {
        CommandLineExecutor executor = new CommandLineExecutor(new ConsolePrompter(System.out, new InputStreamReader(System.in)));
        ArrayList<String> copySrcList = new ArrayList<String>();
        copySrcList.add(fromDir);
        ArrayList<String> copyDesList = new ArrayList<String>();
        copyDesList.add(toDir);
        DirectoryCopyHandlingCommand dirCopyCmd = new DirectoryCopyHandlingCommand(copySrcList, copyDesList);
        if (excludes != null) {
            dirCopyCmd.setExcludes(excludes);
        }
        executor.execute(new Command[]{dirCopyCmd});
        if (excludes != null) {
            for (int i = 0; i < excludes.length; ++i) {
                File excludeFile = new File(toDir + File.separator + excludes[i]);
                try {
                    if (!excludeFile.exists() || excludeFile.delete()) continue;
                    this.log.error("Unable to delete");
                    continue;
                }
                catch (Exception e) {
                    this.log.error("Error occurred during delete", (Object)e.getMessage());
                }
            }
        }
    }

    protected String[] getDefaultExcludes() {
        return new String[]{".manifest.tmp", ".delta.lst"};
    }

    protected void zipFiles(String baseDir, String wgtPath) throws Exception {
        ZipCommand zipCmd = new ZipCommand(baseDir, wgtPath);
        zipCmd.setExcludes(new String[]{".manifest.tmp"});
        CommandLineExecutor executor = new CommandLineExecutor(new ConsolePrompter(System.out, new InputStreamReader(System.in)));
        executor.execute(new Command[]{zipCmd});
    }
}

