/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.packages;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.slf4j.Logger;
import org.tizen.common.sign.preferences.SigningProfileContainer;
import org.tizen.common.util.IOUtil;
import org.tizen.nativecommon.build.RPKDefaultSigner;
import org.tizen.nativecommon.build.RPKSigner;
import org.tizen.ncli.config.Configuration;
import org.tizen.ncli.ide.messages.TizenCLIMessages;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.build.buildnative.BuildNativeOption;
import org.tizen.ncli.subcommands.packages.NativeProject;
import org.tizen.ncli.subcommands.packages.PackageData;
import org.tizen.ncli.subcommands.packages.ResourcePackageCLICommandData;
import org.tizen.rpklib.RPK;
import org.tizen.rpklib.core.sign.ISigner;
import org.tizen.rpklib.exception.RPKException;
import org.w3c.dom.Document;

public class ResourcePackageCLICommand
extends AbstractSubCommand<ResourcePackageCLICommandData> {
    private ResourcePackageCLICommandData data = new ResourcePackageCLICommandData();
    private Configuration config = new Configuration();
    private String profilesPath;
    private String profileName;
    private String outputPath;
    private String rpkPath = null;
    private List<String> refPaths = null;

    @Override
    protected ResourcePackageCLICommandData call() {
        String outputPath;
        if (this.data == null) {
            return null;
        }
        try {
            outputPath = this.workingDir.getCanonicalPath();
        }
        catch (IOException e1) {
            this.progressLog.error("Packaging error : Cannot find build output directory.");
            return null;
        }
        String projDir = this.data.getProjectDir();
        PackageData ssiData = ResourcePackageCLICommand.getEnv(this.workingDir.toString(), projDir, this.log);
        if (ssiData == null) {
            this.progressLog.error("Packaging error : Cannot get the project information from project file.");
            return null;
        }
        boolean result = this.doPackage(outputPath, ssiData.getPackageName(), ssiData.getPackageVersion(), this.profileName, ssiData.getProfileVersion());
        if (result) {
            this.data.rpkPath = this.genRpkPath(ssiData.getPackageName(), ssiData.getPackageVersion(), ssiData.getArchitecture());
            this.log.debug("Package path: {}", (Object)this.data.rpkPath);
            return this.data;
        }
        return null;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setProfileName(String profile) {
        this.profileName = profile;
    }

    public void setReferencePaths(List<String> refPaths) {
        this.refPaths = refPaths;
    }

    public List<String> getReferencePaths() {
        return this.refPaths;
    }

    private boolean setProfilesPath() {
        this.profilesPath = this.config.getValue("profiles.path");
        if (this.profilesPath == null) {
            this.profilesPath = this.config.getValue("default.profiles.path");
        }
        return this.profilesPath != null && !this.profilesPath.isEmpty();
    }

    public static PackageData getEnv(String workingDir, String projDir, Logger log) {
        PackageData data = new PackageData();
        try {
            data.setWorkingDir(projDir);
            File parentFile = projDir == null || projDir.isEmpty() ? new File(workingDir).getParentFile() : new File(projDir);
            if (parentFile == null || !parentFile.exists()) {
                log.error("Specify proper build configuration path");
                return null;
            }
            String projectPath = parentFile.getCanonicalPath();
            log.debug("Base project directory: {}", (Object)projectPath);
            data.setProjectPath(projectPath);
            String manifestPath = projectPath + File.separatorChar + "tizen-manifest.xml";
            data.setManifestFilePath(manifestPath);
            Document manifestDoc = null;
            try {
                manifestDoc = data.getManifestFilePath() != null ? NativeProject.getDocument(data.getManifestFilePath()) : null;
            }
            catch (Exception e) {
                log.error("Error occurred during getting project file", (Object)e.getMessage());
                return null;
            }
            String packageName = NativeProject.getPackageName(manifestDoc);
            data.setPackageName(packageName);
            String packageVersion = NativeProject.getVersion(manifestDoc);
            data.setPackageVersion(packageVersion);
            String artifactName = NativeProject.getArtifactName(manifestDoc);
            if (artifactName == null) {
                log.error("cannot get artifact name.");
                return null;
            }
            artifactName = artifactName.toLowerCase();
            data.setArtifactName(artifactName);
            return data;
        }
        catch (IOException e) {
            log.error("Error occurred during setting working directory", (Object)e.getMessage());
            return null;
        }
    }

    private String genRpkPath(String packageName, String packageVersion, String architecture) {
        String pkgArch = this.getPkgArchitecture(architecture);
        this.rpkPath = pkgArch == null || pkgArch.isEmpty() ? this.outputPath + File.separatorChar + packageName + "-" + packageVersion + ".rpk" : this.outputPath + File.separatorChar + packageName + "-" + packageVersion + "-" + pkgArch + ".rpk";
        return this.rpkPath;
    }

    private String getPkgArchitecture(String architecture) {
        for (String arch : BuildNativeOption.ARCHGROUP_ARM) {
            if (!arch.equals(architecture)) continue;
            return BuildNativeOption.ARCHGROUP_ARM[0];
        }
        return architecture;
    }

    public void setProjectPath(String projDir) {
        this.data.setProjectDir(projDir);
    }

    public boolean doPackage(String workingProjectConfigurationPath, String packageName, String packageVersion, String profileName, String profileVer) {
        RPK rpk = RPK.getInstance();
        rpk.setOutputStream((OutputStream)System.out);
        rpk.setErrorStream((OutputStream)System.out);
        String packageDir = workingProjectConfigurationPath + File.separator + "Package";
        try {
            RPKDefaultSigner signer = null;
            boolean isSign = this.setProfilesPath();
            if ((profileName == null || profileName.isEmpty()) && isSign) {
                profileName = this.getActiveProfileName();
            }
            if (profileName != null && !profileName.isEmpty()) {
                if (!isSign) {
                    this.log.error(String.format("The path of '%s' does not exist. Update 'tizen cli-config -g %s='valid path'.", "profiles.path", "profiles.path"));
                    this.progressLog.error(String.format("The path of '%s' does not exist. Update 'tizen cli-config -g %s='valid path'.", "profiles.path", "profiles.path"));
                    return false;
                }
                signer = new RPKSigner(null);
            } else {
                this.progressLog.warn(TizenCLIMessages.SIGN_DEFAULT_PROFILE_WARN);
                signer = new RPKDefaultSigner();
            }
            rpk.packaging(workingProjectConfigurationPath, packageDir, packageName, packageVersion, isSign, (ISigner)signer, this.profilesPath, profileName);
        }
        catch (RPKException e) {
            this.log.error(e.getMessage());
            this.progressLog.error(e.getMessage());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getActiveProfileName() {
        String string;
        SigningProfileContainer container = new SigningProfileContainer();
        InputStream in = null;
        try {
            in = new FileInputStream(this.profilesPath);
            in = new BufferedInputStream(in);
            container.readActiveProfileXML(in);
            string = container.getActiveProfileName();
        }
        catch (FileNotFoundException e) {
            try {
                this.log.error("Exception occurred.", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{in});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{in});
            return null;
        }
        IOUtil.tryClose((Object[])new Object[]{in});
        return string;
    }
}

