/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sbilib.lib;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.tizen.sbilib.lib.Platform;

public class PathUtil {
    public static final String PARENT_RELATIVE_PATH = "..";
    public static final String TEMP_DIR_NAME = "temp";
    public static final String ASTERISK = "*";
    public static final String EXTENSION_SEPERATOR = ".";
    private static final String LINUX_ROOT_PATH = "/";
    private static final String LINUX_DIRECTORY_SEPERATOR = "/";
    private static final String WINDOWS_DRIVE_SEPERATOR = ":";
    private static final String WINDOWS_DIRECTORY_SEPERATOR = "\\";
    private static final String ENV_VAR_LOCAL_APP_DATA = "localappdata";
    public static final String XML_EXTENSION = "xml";

    public static String getHomePath() {
        return System.getProperty("user.home");
    }

    public static String getLocalAppData() {
        if (Platform.isLinux()) {
            return null;
        }
        return System.getenv(ENV_VAR_LOCAL_APP_DATA);
    }

    public static String addPath(String ... path_components) {
        if (path_components.length <= 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer(path_components[0]);
        for (int i = 1; i < path_components.length; ++i) {
            sb.append(File.separator + path_components[i]);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAllTextFromFile(String filePath, boolean carrageReturn) throws IOException {
        StringBuffer txt = new StringBuffer();
        FileInputStream is = null;
        BufferedReader in = null;
        try {
            String strLicense;
            is = new FileInputStream(filePath);
            in = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
            while ((strLicense = in.readLine()) != null) {
                txt.append(strLicense);
                if (!carrageReturn) continue;
                txt.append("\n");
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return txt.toString();
    }

    public static String getRootDrive(String filePath) {
        if (Platform.isWindows() && filePath.indexOf(WINDOWS_DRIVE_SEPERATOR) == 1) {
            return filePath.substring(0, 2);
        }
        return null;
    }

    public static String getFileName(String filePath) {
        File file = new File(filePath);
        return file.getName();
    }

    public static String getExtension(String filePath) {
        String fileName = PathUtil.getFileName(filePath);
        int lastIndex = fileName.lastIndexOf(EXTENSION_SEPERATOR);
        if (lastIndex < 0) {
            return null;
        }
        return fileName.substring(lastIndex + 1);
    }

    public static String getParentDirectory(String filePath) {
        File file = new File(filePath);
        return file.getParent();
    }

    public static String getCurrentPath() {
        return System.getProperty("user.dir");
    }

    public static String getCorrectPath(String filePath) {
        if (Platform.isWindows() && filePath != null && filePath.length() >= 2 && filePath.startsWith("/") && filePath.charAt(2) == '/') {
            String correctPath = null;
            correctPath = filePath.substring(1);
            correctPath = correctPath.replaceFirst("/", ":\\");
            correctPath = correctPath.replaceAll("/", WINDOWS_DIRECTORY_SEPERATOR);
            return correctPath;
        }
        return filePath;
    }

    public static boolean existParentDirectory(String path) {
        if (path == null || path.isEmpty()) {
            return false;
        }
        return PathUtil.existParentDirectory(new File(path));
    }

    public static boolean existParentDirectory(File filePath) {
        if (filePath == null) {
            return false;
        }
        return filePath.getParentFile() != null;
    }

    public static boolean existFileInPath(String path, String fileName) {
        if (path == null || path.isEmpty()) {
            return false;
        }
        return PathUtil.existFileInPath(new File(path), fileName);
    }

    public static boolean existFileInPath(File filePath, String fileName) {
        if (filePath == null || !filePath.exists()) {
            return false;
        }
        if (fileName == null || fileName.isEmpty()) {
            return false;
        }
        File searchDir = null;
        searchDir = filePath.isFile() ? filePath.getParentFile() : filePath;
        if (searchDir == null) {
            return false;
        }
        for (File f : searchDir.listFiles()) {
            if (!f.getName().equals(fileName)) continue;
            return true;
        }
        return false;
    }

    public static boolean existsFile(String filePath) {
        if (filePath == null || filePath.isEmpty()) {
            return false;
        }
        File file = new File(filePath);
        return file.exists();
    }
}

