/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sbilib;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.tizen.sbilib.core.SBISystem;
import org.tizen.sbilib.exception.SBIException;
import org.tizen.sbilib.ide.DebugOption;
import org.tizen.sbilib.ide.Plugin;
import org.tizen.sbilib.ide.PluginManager;
import org.tizen.sbilib.ide.SBIConstants;
import org.tizen.sbilib.ide.Toolchain;
import org.tizen.sbilib.ide.ToolchainAction;
import org.tizen.sbilib.lib.CommandRunner;
import org.tizen.sbilib.lib.Log;
import org.tizen.sbilib.lib.PathUtil;

public class SBI {
    public static Log log = SBI.createLog();
    private SBISystem sbiRunner = new SBISystem();
    private static SBI sbi = null;
    private Process shellProcess = null;

    static Log createLog() {
        String logPath = PathUtil.addPath(SBIConstants.getSBIHomePath(), "sbi.log");
        return Log.createLog(logPath);
    }

    private SBI() {
    }

    public boolean create(String rId, String cId, String tId) {
        log.info(String.format("Create target. rootstrap_id=%s, toolchain_id=%s, target_id=%s", rId, cId, tId));
        PluginManager pm = PluginManager.getInstance();
        return pm.createTarget(rId, cId, tId);
    }

    public boolean create(String tId) throws SBIException {
        PluginManager pm = PluginManager.getInstance();
        String rId = pm.getRootstrapIdByTargetId(tId);
        String cId = pm.getToolchainIdByTargetId(tId);
        return this.create(rId, cId, tId);
    }

    public boolean select() {
        return false;
    }

    public boolean remove(String tId) throws SBIException {
        PluginManager pm = PluginManager.getInstance();
        return pm.removeTarget(tId);
    }

    public List<String> list(PLUGIN plugin) throws SBIException {
        PluginManager pm = PluginManager.getInstance();
        if (PLUGIN.ROOTSTRAP == plugin) {
            return this.getPluginList(pm.getRootstrapList());
        }
        if (PLUGIN.TOOLCHAIN == plugin) {
            return this.getPluginList(pm.getToolchainList());
        }
        if (PLUGIN.TARGET == plugin) {
            return this.getPluginList(pm.getTargetList());
        }
        return Collections.emptyList();
    }

    public Properties show(String id) throws SBIException {
        PluginManager pm = PluginManager.getInstance();
        return pm.getPluginInfo(id);
    }

    public Process build(String tId, String option, String cliprojpath, String clisdkpath, String cliunitprojpath, String cliappid, String workingDir) throws SBIException {
        this.shellProcess = this.sbiRunner.build(tId, option, cliprojpath, clisdkpath, cliunitprojpath, cliappid, workingDir);
        return this.shellProcess;
    }

    public Process makeClean(String targetId, String option, String workingDir) {
        this.shellProcess = this.sbiRunner.build(targetId, option, null, null, null, null, workingDir);
        return this.shellProcess;
    }

    public Process debug(String targetId, String option, String rootPath, String password, String gdbOptions, String workingDir) {
        DebugOption dOption = new DebugOption();
        dOption.setRootPath(rootPath);
        dOption.setPassword(password);
        dOption.setGdbOptions(gdbOptions);
        return this.debug(targetId, option, dOption, workingDir);
    }

    public ArrayList<String> getDebugCommand(String targetId, String options, DebugOption dOptions) {
        return this.sbiRunner.debugCommand(targetId, options, dOptions);
    }

    public Process debug(String targetId, String options, DebugOption dOptions, String workingDir) {
        return this.sbiRunner.debug(targetId, options, dOptions, workingDir);
    }

    public Process kill(String targetId, String option) {
        this.shellProcess = this.sbiRunner.kill(targetId, option);
        return this.shellProcess;
    }

    public Process getCurrentProcess() {
        return CommandRunner.getCurrentProcess();
    }

    public ToolchainAction getActionScript(String actionName, String tId) throws SBIException {
        this.sbiRunner.setPluginEnvironment(tId);
        Toolchain toolchain = PluginManager.getInstance().getToolchainByTargetId(tId);
        if (toolchain == null) {
            return null;
        }
        return toolchain.getActionByName(actionName);
    }

    private List<String> getPluginList(List<? extends Plugin> rList) {
        ArrayList<String> resultList = new ArrayList<String>();
        for (Plugin plugin : rList) {
            resultList.add(plugin.getFile().getName());
        }
        return resultList;
    }

    public void setOutputStream(OutputStream stream) {
        this.sbiRunner.setOutputStream(stream);
    }

    public void setErrorStream(OutputStream stream) {
        this.sbiRunner.setErrorStream(stream);
    }

    public static SBI getInstance() {
        if (sbi == null) {
            sbi = new SBI();
        }
        return sbi;
    }

    public static enum PLUGIN {
        ROOTSTRAP,
        TOOLCHAIN,
        TARGET;

    }
}

