/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model.ext;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IPositionConverter;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMember;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementVisitor;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.ext.ICElementHandle;
import org.eclipse.cdt.internal.core.model.ext.SourceRange;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

abstract class CElementHandle
implements ICElementHandle,
ISourceReference {
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final ICElement[] NO_CHILDREN = new ICElement[0];
    private ICElement fParent;
    private String fName;
    private int fType;
    private IRegion fRegion;
    private long fTimestamp;
    private int fIndex;

    public CElementHandle(ICElement parent, int type, String name) {
        this.fParent = parent;
        this.fType = type;
        if (name.length() > 0 && name.charAt(0) == '{') {
            this.fName = "";
            this.fIndex = name.hashCode();
        } else {
            this.fName = name;
        }
        this.fRegion = new Region(0, 0);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ICElement) {
            return CElement.equals(this, (ICElement)obj);
        }
        return false;
    }

    public int hashCode() {
        return CElement.hashCode(this);
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void setRangeOfID(IRegion region, long timestamp) {
        this.fRegion = region;
        this.fTimestamp = timestamp;
    }

    @Override
    public ISourceRange getSourceRange() throws CModelException {
        IPositionConverter converter;
        IRegion region = this.fRegion;
        ITranslationUnit tu = this.getTranslationUnit();
        if (tu != null && (converter = CCorePlugin.getPositionTrackerManager().findPositionConverter(tu, this.fTimestamp)) != null) {
            region = converter.historicToActual(region);
        }
        int startpos = region.getOffset();
        int length = region.getLength();
        return new SourceRange(startpos, length);
    }

    @Override
    public String getSource() throws CModelException {
        return null;
    }

    @Override
    public ITranslationUnit getTranslationUnit() {
        ICElement parent = this.fParent;
        do {
            if (!(parent instanceof ITranslationUnit)) continue;
            return (ITranslationUnit)parent;
        } while ((parent = parent.getParent()) != null);
        return null;
    }

    @Override
    public void accept(ICElementVisitor visitor) throws CoreException {
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public ICElement getAncestor(int ancestorType) {
        return null;
    }

    @Override
    public ICModel getCModel() {
        return this.fParent.getCModel();
    }

    @Override
    public ICProject getCProject() {
        return this.fParent.getCProject();
    }

    @Override
    public String getElementName() {
        return this.fName;
    }

    @Override
    public int getElementType() {
        return this.fType;
    }

    @Override
    public ICElement getParent() {
        return this.fParent;
    }

    @Override
    public IPath getPath() {
        return this.getTranslationUnit().getPath();
    }

    @Override
    public URI getLocationURI() {
        return this.getTranslationUnit().getLocationURI();
    }

    @Override
    public IResource getResource() {
        return this.getTranslationUnit().getResource();
    }

    @Override
    public IResource getUnderlyingResource() {
        return this.getResource();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean isStructureKnown() throws CModelException {
        return false;
    }

    public void copy(ICElement container, ICElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws CModelException {
    }

    public void delete(boolean force, IProgressMonitor monitor) throws CModelException {
    }

    public void move(ICElement container, ICElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws CModelException {
    }

    public void rename(String name, boolean replace, IProgressMonitor monitor) throws CModelException {
    }

    public void setTypeName(String type) throws CModelException {
    }

    public String getTypeName() {
        return "";
    }

    public ICElement[] getChildren() throws CModelException {
        return NO_CHILDREN;
    }

    public List<ICElement> getChildrenOfType(int type) throws CModelException {
        return Collections.emptyList();
    }

    public boolean hasChildren() {
        return false;
    }

    public String[] getExceptions() {
        return EMPTY_STRING_ARRAY;
    }

    public String getParameterInitializer(int pos) {
        return "";
    }

    public boolean isConst() {
        return false;
    }

    public boolean isVolatile() throws CModelException {
        return false;
    }

    public boolean isFriend() throws CModelException {
        return false;
    }

    public boolean isInline() throws CModelException {
        return false;
    }

    public boolean isOperator() throws CModelException {
        return false;
    }

    public boolean isPureVirtual() throws CModelException {
        return false;
    }

    public boolean isVirtual() throws CModelException {
        return false;
    }

    public boolean isMutable() throws CModelException {
        return false;
    }

    public String getInitializer() {
        return null;
    }

    public boolean isAbstract() throws CModelException {
        return false;
    }

    public ASTAccessVisibility getSuperClassAccess(String name) {
        return ASTAccessVisibility.PUBLIC;
    }

    public String[] getSuperClassesNames() {
        return EMPTY_STRING_ARRAY;
    }

    protected String[] extractParameterTypes(IFunction func) {
        IParameter[] params = func.getParameters();
        String[] parameterTypes = new String[params.length];
        int i = 0;
        while (i < params.length) {
            IParameter param = params[i];
            parameterTypes[i] = ASTTypeUtil.getType(param.getType(), false);
            ++i;
        }
        if (parameterTypes.length == 1 && parameterTypes[0].equals("void")) {
            return EMPTY_STRING_ARRAY;
        }
        return parameterTypes;
    }

    protected ASTAccessVisibility getVisibility(IBinding binding) {
        if (binding instanceof ICPPMember) {
            ICPPMember member = (ICPPMember)binding;
            switch (member.getVisibility()) {
                case 3: {
                    return ASTAccessVisibility.PRIVATE;
                }
                case 2: {
                    return ASTAccessVisibility.PROTECTED;
                }
                case 1: {
                    return ASTAccessVisibility.PUBLIC;
                }
            }
        }
        return ASTAccessVisibility.PUBLIC;
    }

    @Override
    public String getHandleIdentifier() {
        ICElement cModelElement = this.mapToModelElement();
        if (cModelElement != null) {
            return cModelElement.getHandleIdentifier();
        }
        return null;
    }

    private ICElement mapToModelElement() {
        try {
            ISourceRange range = this.getSourceRange();
            return this.getTranslationUnit().getElementAtOffset(range.getIdStartPos());
        }
        catch (CModelException exc) {
            return null;
        }
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public int getIndex() {
        return this.fIndex;
    }
}

