/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.po;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.tizen.nativecommon.po.INativeLocaleMessages;
import org.tizen.nativecommon.po.model.MsgEntry;
import org.tizen.nativecommon.po.model.POFile;
import org.tizen.nativecommon.rm.model.TizenLocale;

public class NativeLocaleMessageHandler
implements INativeLocaleMessages {
    public static final String FOLDER_PATH = "/res/po";
    private IProject project;
    private Map<String, POFile> poFileMap = new HashMap<String, POFile>();

    public NativeLocaleMessageHandler(IProject project) {
        this.project = project;
    }

    public void init() {
        IPath poDirPath = this.project.getLocation().append(FOLDER_PATH);
        File poDir = poDirPath.toFile();
        if (!poDir.exists()) {
            return;
        }
        File[] fileArray = poDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                File localeFile = fileArray[n2];
                String poFileName = localeFile.getName();
                String languageCode = this.getCodeFromFileName(poFileName);
                POFile poFile = new POFile(localeFile);
                try {
                    poFile.open();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    break block4;
                }
                this.poFileMap.put(languageCode, poFile);
            }
            ++n2;
        }
    }

    private String getCodeFromFileName(String name) {
        return name.substring(0, name.length() - 3);
    }

    @Override
    public String getMsgString(String msgId, TizenLocale locale) {
        POFile file = this.poFileMap.get(locale.getValue());
        if (file == null) {
            return null;
        }
        return file.getMsgValue(msgId);
    }

    @Override
    public String[] getMsgIds(TizenLocale locale) {
        if (locale == null) {
            for (String key : this.poFileMap.keySet()) {
                if (!this.containLocale(key)) continue;
                locale = TizenLocale.valueOf(key);
                break;
            }
        }
        if (locale == null) {
            return null;
        }
        POFile file = this.poFileMap.get(locale.getValue());
        if (file == null) {
            return null;
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (MsgEntry entry : file.getMsgEntries()) {
            keys.add(entry.getMsgId());
        }
        return keys.toArray(new String[0]);
    }

    @Override
    public Map<String, String> getMsgMap(TizenLocale locale) {
        POFile file = this.poFileMap.get(locale.getValue());
        if (file == null) {
            return null;
        }
        HashMap<String, String> entryMap = new HashMap<String, String>();
        for (MsgEntry entry : file.getMsgEntries()) {
            entryMap.put(entry.getMsgId(), entry.getMsgStr());
        }
        return entryMap;
    }

    @Override
    public String[] getLocales() {
        ArrayList<String> locales = new ArrayList<String>();
        for (String key : this.poFileMap.keySet()) {
            if (!this.containLocale(key)) continue;
            TizenLocale locale = TizenLocale.valueOf(key);
            locales.add(locale.getName());
        }
        return locales.toArray(new String[0]);
    }

    private boolean containLocale(String key) {
        TizenLocale[] tizenLocaleArray = TizenLocale.values();
        int n = tizenLocaleArray.length;
        int n2 = 0;
        while (n2 < n) {
            TizenLocale l = tizenLocaleArray[n2];
            if (l.getValue().equals(key)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public String[] getLocaleCodes() {
        ArrayList<String> localeCodes = new ArrayList<String>();
        for (String key : this.poFileMap.keySet()) {
            if (!this.containLocale(key)) continue;
            localeCodes.add(key);
        }
        return localeCodes.toArray(new String[0]);
    }

    public void putLocaleData(String locale, POFile poFile) {
        if (!this.poFileMap.containsKey(locale)) {
            this.poFileMap.put(locale, poFile);
        }
    }

    public POFile getPOFile(String locale) {
        return this.poFileMap.get(locale);
    }

    public void removeLocale(String locale) {
        this.poFileMap.remove(locale);
    }
}

