/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.po.editor;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiEditorInput;
import org.tizen.nativecommon.po.editor.POConstants;
import org.tizen.nativecommon.po.editor.POEditorInstances;
import org.tizen.nativecommon.po.editor.POEditorPage;

public class POEditor
extends FormEditor {
    private POEditorPage mPage;
    private IPath mLocalePath;
    private IProject mProject;
    private IFile selectedFile;
    private IResourceChangeListener editorCloser = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            if (!(event.getResource() instanceof IProject)) {
                return;
            }
            final IProject closingProject = (IProject)event.getResource();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage[] iWorkbenchPageArray = POEditor.this.getSite().getWorkbenchWindow().getPages();
                    int n = iWorkbenchPageArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IWorkbenchPage page = iWorkbenchPageArray[n2];
                        MultiEditorInput editorInput = (MultiEditorInput)POEditor.this.getEditorInput();
                        if (POEditor.this.mProject.equals((Object)closingProject)) {
                            page.closeEditor(page.findEditor((IEditorInput)editorInput), true);
                        }
                        ++n2;
                    }
                }
            });
        }
    };

    public void dispose() {
        super.dispose();
        POEditorInstances.remove(this.mProject);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.editorCloser);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.editorCloser, 6);
        String[] ids = new String[]{POConstants.EDITOR_ID};
        this.selectedFile = ((IFileEditorInput)input).getFile();
        this.mProject = this.selectedFile.getProject();
        this.mLocalePath = this.selectedFile.getParent().getLocation();
        POEditorInstances.put(this.mProject, this);
        ArrayList<Object> inputs = new ArrayList<Object>();
        this.setPartName(String.valueOf(this.mProject.getName()) + " Localization");
        File[] fileArray = this.mLocalePath.toFile().listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFile fInput;
            File poFile = fileArray[n2];
            if (poFile.getName().endsWith(".po") && (fInput = (IFile)this.mProject.findMember(new Path("/res/po").append(poFile.getName()))) != null) {
                FileEditorInput newInput = new FileEditorInput(fInput);
                inputs.add(newInput);
            }
            ++n2;
        }
        if (inputs.isEmpty()) {
            inputs.add(input);
        }
        MultiEditorInput newInput = new MultiEditorInput(ids, inputs.toArray(new IEditorInput[inputs.size()]));
        super.init(site, (IEditorInput)newInput);
    }

    public void showLanguage(String langId) {
        this.mPage.showLanguage(langId);
    }

    public IProject getProject() {
        return this.mProject;
    }

    protected void addPages() {
        this.mPage = new POEditorPage(this, POConstants.EDITOR_ID, this.mProject.getName(), this.mLocalePath, this.mProject, this.selectedFile);
        try {
            this.addPage((IFormPage)this.mPage);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        this.mPage.doSave(monitor);
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isDirty() {
        return this.mPage.isDirty();
    }
}

