/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.po.editor;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.osgi.framework.Bundle;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.nativecommon.po.NativeLocaleMessageHandler;
import org.tizen.nativecommon.po.NativeLocaleMessageManager;
import org.tizen.nativecommon.po.editor.ComboSelectionDialog;
import org.tizen.nativecommon.po.editor.FlagImageManager;
import org.tizen.nativecommon.po.editor.Languages;
import org.tizen.nativecommon.po.editor.Messages;
import org.tizen.nativecommon.po.editor.TableViewerFocusHandler;
import org.tizen.nativecommon.po.editor.TableViewerKeyBoardSupporter;
import org.tizen.nativecommon.po.model.Language;
import org.tizen.nativecommon.po.model.LanguageParser;
import org.tizen.nativecommon.po.model.MsgEntry;
import org.tizen.nativecommon.po.model.POFile;

public class POEditorPage
extends FormPage {
    private Composite visibilityComp;
    private Composite tableComp;
    private TableViewer fTable;
    private TableItem selectedItem;
    private Button allButton;
    private IProject project;
    private FormPage fPage;
    private Color grayColor;
    private Color blackColor;
    private Font italicFont;
    private Font boldFont;
    private Font defaultFont;
    private ImageHyperlink addKeyLink;
    private int selectedColumn;
    private int selectedRow;
    private FormEditor editor;
    private String prevStringKey;
    private String prevStringValue;
    private IFile selectedFile;
    private IPath localePath;
    private Languages languageMgr;
    private NativeLocaleMessageHandler poHandler;
    private TableViewerFocusHandler fFocusHandler;
    private boolean mDirty;
    private boolean addingStringkey;
    private List<String> initColumns = new ArrayList<String>();
    private List<Language> availableLangs = new ArrayList<Language>();
    private List<Button> langBtns = new ArrayList<Button>();
    private boolean allSelected = false;
    private static final int KEYSIZE = 220;
    ControlAdapter controlAdapter = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            POEditorPage.this.resizeAllItemsSame();
        }
    };
    SelectionListener listener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public void widgetSelected(SelectionEvent event) {
            if (!(event.getSource() instanceof Button)) {
                return;
            }
            Button bt = (Button)event.getSource();
            boolean selection = bt.getSelection();
            Table table = POEditorPage.this.fTable.getTable();
            String text = bt.getText();
            POEditorPage.this.restoreIfFocusingStatus();
            if (selection) {
                TableColumn[] columns = table.getColumns();
                ArrayList<String> list = new ArrayList<String>();
                TableColumn[] tableColumnArray = columns;
                int n = columns.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn column = tableColumnArray[n2];
                    list.add(column.getText());
                    ++n2;
                }
                list.add(text);
                POEditorPage.this.redrawTable(list.toArray(new String[0]), false);
            } else {
                POEditorPage.this.allButton.setSelection(false);
                TableColumn[] columns = table.getColumns();
                ArrayList<String> list = new ArrayList<String>();
                TableColumn[] tableColumnArray = columns;
                int n = columns.length;
                int n3 = 0;
                while (n3 < n) {
                    TableColumn column = tableColumnArray[n3];
                    if (!column.getText().equals(text)) {
                        list.add(column.getText());
                    }
                    ++n3;
                }
                POEditorPage.this.redrawTable(list.toArray(new String[0]), false);
            }
        }
    };
    SelectionListener alllistener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }

        public void widgetSelected(SelectionEvent event) {
            if (!(event.getSource() instanceof Button)) {
                return;
            }
            Button bt = (Button)event.getSource();
            boolean selection = bt.getSelection();
            if (selection) {
                for (Button b : POEditorPage.this.langBtns) {
                    b.setSelection(true);
                }
                ArrayList<String> list = new ArrayList<String>();
                list.add(Messages.POPage_KeyHeader);
                for (Language l : POEditorPage.this.availableLangs) {
                    list.add(l.getLang());
                }
                POEditorPage.this.redrawTable(list.toArray(new String[0]), false);
            } else {
                for (Button b : POEditorPage.this.langBtns) {
                    b.setSelection(false);
                }
                ArrayList<String> list = new ArrayList<String>();
                list.add(Messages.POPage_KeyHeader);
                POEditorPage.this.redrawTable(list.toArray(new String[0]), false);
            }
        }
    };

    public POEditorPage(FormEditor editor, String id, String title, IPath localePath, IProject project, IFile selectedFile) {
        super(editor, id, project.getName());
        this.setContentDescription(title);
        this.setPartName(Messages.POPage_PartName);
        this.editor = editor;
        this.localePath = localePath;
        this.selectedFile = selectedFile;
        this.project = project;
        this.fPage = this;
        this.poHandler = NativeLocaleMessageManager.getLocaleMessageHandler(project);
        this.fFocusHandler = new TableViewerFocusHandler();
        this.initData();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new ResourceChangeListener(), 1);
    }

    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm scrolledForm = managedForm.getForm();
        scrolledForm.setText(Messages.POPage_FormTitle);
        Composite body = scrolledForm.getBody();
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        body.setLayout((Layout)layout);
        this.setFontAndColor();
        this.createVisibilitySection(scrolledForm, Messages.POPage_VisibilityTitle);
        this.createTableSection(scrolledForm, Messages.POPage_StrTitle);
        if (this.availableLangs.isEmpty()) {
            SWTUtil.asyncExec((Display)this.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    POEditorPage.this.addLang();
                    try {
                        POEditorPage.this.project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e1) {
                        e1.printStackTrace();
                    }
                }
            });
        }
    }

    private void setFontAndColor() {
        Shell sh = this.getSite().getShell();
        Display dy = sh.getDisplay();
        FontData fd = this.getSite().getShell().getFont().getFontData()[0];
        this.blackColor = dy.getSystemColor(2);
        this.grayColor = dy.getSystemColor(15);
        this.defaultFont = new Font((Device)dy, fd.getName(), fd.getHeight(), 0);
        this.italicFont = new Font((Device)dy, fd.getName(), fd.getHeight(), 3);
        this.boldFont = new Font((Device)dy, fd.getName(), fd.getHeight(), 1);
    }

    private void createVisibilitySection(final ScrolledForm form, String title) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Section visiblitySection = toolkit.createSection(form.getBody(), 450);
        GridData gd = new GridData(770);
        gd.horizontalSpan = 2;
        visiblitySection.setLayoutData((Object)gd);
        visiblitySection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                form.reflow(true);
            }
        });
        visiblitySection.setText(title);
        visiblitySection.setDescription(Messages.POPage_VisibilityDesc);
        this.createLanguageButton(visiblitySection);
        this.visibilityComp = this.getManagedForm().getToolkit().createComposite((Composite)visiblitySection);
        GridLayout layout = new GridLayout();
        layout.numColumns = 5;
        gd = new GridData(768);
        this.visibilityComp.setLayoutData((Object)gd);
        this.visibilityComp.setLayout((Layout)layout);
        this.addLanguageButton();
        visiblitySection.setClient((Control)this.visibilityComp);
    }

    private void createLanguageButton(Section section) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Composite toolbar = new Composite((Composite)section, 0);
        RowLayout layout = new RowLayout(256);
        toolbar.setLayout((Layout)layout);
        section.setTextClient((Control)toolbar);
        ImageHyperlink addLanguageLink = new ImageHyperlink(toolbar, 0);
        toolkit.adapt((Control)addLanguageLink, true, true);
        addLanguageLink.setImage(this.getLangAddIcon());
        addLanguageLink.setToolTipText(Messages.POPage_Tooltip_AddLang);
        addLanguageLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                POEditorPage.this.restoreIfFocusingStatus();
                POEditorPage.this.addLang();
                try {
                    POEditorPage.this.project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e1) {
                    e1.printStackTrace();
                }
            }
        });
        addLanguageLink.setBackground(section.getTitleBarGradientBackground());
        ImageHyperlink removeLanguageLink = new ImageHyperlink(toolbar, 0);
        toolkit.adapt((Control)removeLanguageLink, true, true);
        removeLanguageLink.setImage(this.getLangRemoveIcon());
        removeLanguageLink.setToolTipText(Messages.POPage_Tooltip_RemoveLang);
        removeLanguageLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                POEditorPage.this.restoreIfFocusingStatus();
                POEditorPage.this.removeLang();
                try {
                    POEditorPage.this.project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e1) {
                    e1.printStackTrace();
                }
            }
        });
        removeLanguageLink.setBackground(section.getTitleBarGradientBackground());
    }

    private void createTableSection(ScrolledForm form, String title) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Section section = toolkit.createSection(form.getBody(), 256);
        section.setActiveToggleColor(toolkit.getHyperlinkGroup().getActiveForeground());
        section.setLayoutData((Object)new GridData(2));
        toolkit.createCompositeSeparator((Composite)section);
        this.createTableButton(section);
        this.tableComp = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.tableComp.setLayout((Layout)layout);
        this.createTable(this.tableComp, this.initColumns.toArray(new String[0]), false);
        section.setText(title);
        section.setDescription(Messages.POPage_StrDesc);
        this.tableComp.addControlListener((ControlListener)this.controlAdapter);
        section.setClient((Control)this.tableComp);
        section.setLayoutData((Object)new GridData(1808));
    }

    private void createTableButton(Section section) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Composite toolbar = new Composite((Composite)section, 0);
        RowLayout layout = new RowLayout(256);
        toolbar.setLayout((Layout)layout);
        section.setTextClient((Control)toolbar);
        this.addKeyLink = new ImageHyperlink(toolbar, 0);
        toolkit.adapt((Control)this.addKeyLink, true, true);
        this.addKeyLink.setImage(this.getStrKeyAddIcon());
        this.addKeyLink.setToolTipText(Messages.POPage_Tooltip_AddKey);
        this.addKeyLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                POEditorPage.this.restoreIfFocusingStatus();
                POEditorPage.this.addStringKey();
                POEditorPage.this.addingStringkey = true;
            }
        });
        this.addKeyLink.setBackground(section.getTitleBarGradientBackground());
        this.addKeyLink.setEnabled(!this.availableLangs.isEmpty());
    }

    private void addStringKey() {
        this.redrawTable(null, true);
    }

    private void createTable(Composite parent, final String[] columns, boolean isAddedNewKey) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Table table = toolkit.createTable(parent, 67588);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        gd.widthHint = 100;
        table.setLayoutData((Object)gd);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Point p = new Point(event.x, event.y);
                ViewerCell cell = POEditorPage.this.fTable.getCell(p);
                if (cell == null) {
                    POEditorPage.this.restoreIfFocusingStatus();
                } else {
                    POEditorPage.this.getPOfile(columns[cell.getColumnIndex()]);
                    POEditorPage.this.fTable.getTable().getSelectionIndex();
                    if (cell.getForeground().equals((Object)POEditorPage.this.grayColor)) {
                        cell.setText("");
                    }
                }
            }
        });
        this.setTableMenu(table);
        this.setColumnSize(table, columns);
        TableData newData = null;
        if (columns.length > 1) {
            POFile pofile = this.getPOfile(columns[1]);
            if (isAddedNewKey) {
                newData = this.addNewStringKey(table);
            }
            this.setLanguageTableItems(table, pofile.getMsgEntries(), columns);
        }
        this.fTable = new TableViewer(table);
        this.fTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        toolkit.paintBordersFor(this.tableComp);
        this.setCellEditors();
        this.setKeyboardSupporter();
        this.saveColumnValues();
        if (isAddedNewKey) {
            this.fTable.editElement((Object)newData, 0);
        }
    }

    private void setTableMenu(final Table table) {
        Menu menu = new Menu((Decorations)this.getSite().getShell(), 8);
        table.setMenu(menu);
        MenuItem item = new MenuItem(menu, 8);
        item.setText(Messages.POPage_RemoveKey);
        item.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                int index = table.getSelectionIndex();
                String msgId = table.getItem(index).getText(0);
                String[] stringArray = POEditorPage.this.poHandler.getLocaleCodes();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String locale = stringArray[n2];
                    POFile file = POEditorPage.this.poHandler.getPOFile(locale);
                    List<MsgEntry> list = file.getMsgEntries();
                    int i = 0;
                    while (i < list.size()) {
                        if (list.get(i).getMsgId().equals(msgId)) break;
                        ++i;
                    }
                    list.remove(i);
                    ++n2;
                }
                POEditorPage.this.redrawTable(null, false);
                POEditorPage.this.enableSaveAction();
                POEditorPage.this.fTable.getTable().setFocus();
            }
        });
    }

    private void setColumnSize(Table table, String[] columns) {
        int[] size = this.getColumnSize(table, columns.length);
        int i = 0;
        while (i < columns.length) {
            TableColumn column = new TableColumn(table, 16384);
            Image image = FlagImageManager.getImage(columns[i]);
            column.setImage(image);
            column.setText(columns[i]);
            if (i == 0) {
                column.setWidth(size[0]);
            } else {
                column.setWidth(size[1]);
            }
            ++i;
        }
    }

    private TableData addNewStringKey(Table table) {
        TableItem addItem = new TableItem(table, 0x1000000);
        TableData newData = new TableData(0, false);
        addItem.setData((Object)newData);
        return newData;
    }

    private void removeStringKey() {
        Table table = this.fTable.getTable();
        int index = table.getSelectionIndex();
        String msgId = table.getItem(index).getText(0);
        String[] stringArray = this.poHandler.getLocaleCodes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String locale = stringArray[n2];
            POFile file = this.poHandler.getPOFile(locale);
            List<MsgEntry> list = file.getMsgEntries();
            int i = 0;
            while (i < list.size()) {
                if (list.get(i).getMsgId().equals(msgId)) break;
                ++i;
            }
            list.remove(i);
            ++n2;
        }
        this.redrawTable(null, false);
    }

    private void setLanguageTableItems(Table table, List<MsgEntry> entries, String[] columns) {
        int i = 0;
        while (i < entries.size()) {
            TableItem item = new TableItem(table, 0);
            String id = entries.get(i).getMsgId();
            int j = 0;
            while (j < columns.length) {
                if (j == 0) {
                    item.setText(j, id);
                } else {
                    POFile file = this.getPOfile(columns[j]);
                    if (file == null) {
                        item.setText(j, "");
                    } else {
                        String value = file.getMsgValue(id);
                        if (value.isEmpty()) {
                            item.setForeground(j, this.grayColor);
                            item.setText(j, id);
                        } else {
                            item.setText(j, value);
                        }
                    }
                }
                ++j;
            }
            TableData td = new TableData(i, false);
            item.setData((Object)td);
            ++i;
        }
    }

    private void redrawTable(String[] columnString, boolean isAddedNewKey) {
        ArrayList<String> list = new ArrayList<String>();
        if (columnString == null) {
            TableColumn[] columns;
            TableColumn[] tableColumnArray = columns = this.fTable.getTable().getColumns();
            int n = columns.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                list.add(column.getText());
                ++n2;
            }
            this.fTable.getTable().dispose();
            this.createTable(this.tableComp, list.toArray(new String[0]), isAddedNewKey);
            this.addKeyLink.setEnabled(list.size() > 1);
        } else {
            this.fTable.getTable().dispose();
            this.createTable(this.tableComp, columnString, isAddedNewKey);
            this.addKeyLink.setEnabled(columnString.length > 1);
        }
        this.saveColumnValues();
        this.tableComp.layout(true, true);
    }

    private int[] getColumnSize(Table table, int columnSize) {
        Rectangle area = this.tableComp.getClientArea();
        Point size = table.computeSize(-1, -1);
        ScrollBar vBar = table.getVerticalBar();
        int width = area.width - table.computeTrim((int)0, (int)0, (int)0, (int)0).width - vBar.getSize().x;
        if (size.y > area.height + table.getHeaderHeight()) {
            Point vBarSize = vBar.getSize();
            width -= vBarSize.x;
        }
        if (columnSize == 1) {
            int[] nArray = new int[2];
            nArray[0] = width;
            return nArray;
        }
        int otherSize = width / columnSize;
        int keySize = 220;
        if (otherSize > 220) {
            keySize = otherSize;
        } else {
            otherSize = (width - 220) / (columnSize - 1);
        }
        return new int[]{keySize, otherSize};
    }

    private void setCellEditors() {
        CellEditor[] editors = new CellEditor[this.fTable.getTable().getColumnCount()];
        String[] columnProperties = new String[this.fTable.getTable().getColumnCount()];
        int i = 0;
        while (i < editors.length) {
            columnProperties[i] = this.fTable.getTable().getColumn(i).getText();
            editors[i] = new TextCellEditor((Composite)this.fTable.getTable());
            editors[i].addListener(new ICellEditorListener(){

                public void applyEditorValue() {
                }

                public void cancelEditor() {
                }

                public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                    POEditorPage.this.enableSaveAction();
                }
            });
            ++i;
        }
        this.fTable.setCellModifier((ICellModifier)new TabbedCellModifier());
        this.fTable.setCellEditors(editors);
        this.fTable.setColumnProperties(columnProperties);
    }

    private void setKeyboardSupporter() {
        TableViewerKeyBoardSupporter supporter = new TableViewerKeyBoardSupporter(this.tableComp, this.fTable, this.fFocusHandler);
        supporter.startSupport();
    }

    private boolean validateStringKey(String msgId) {
        boolean validation = true;
        for (Language lang : this.availableLangs) {
            String langId = lang.getId();
            POFile file = this.poHandler.getPOFile(langId);
            if (!file.existsMsg(msgId)) continue;
            validation = false;
            break;
        }
        return validation;
    }

    private void addNewStringKey(String msgId, String msgValue) {
        for (Language lang : this.availableLangs) {
            String langId = lang.getId();
            POFile file = this.poHandler.getPOFile(langId);
            MsgEntry newEntry = new MsgEntry();
            newEntry.setMsgId(msgId);
            newEntry.setMsgStr("");
            file.addMsgEntryFirst(newEntry);
        }
    }

    private POFile getPOfile(String langName) {
        Language lang = this.languageMgr.getLangByName(langName);
        if (lang == null) {
            return null;
        }
        String langId = lang.getId();
        return this.poHandler.getPOFile(langId);
    }

    private void removeLanguageButton(Language[] removeLang) {
        TableColumn[] columns;
        ArrayList<String> list = new ArrayList<String>();
        TableColumn[] tableColumnArray = columns = this.fTable.getTable().getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            list.add(column.getText());
            ++n2;
        }
        ArrayList<Button> remainBtList = new ArrayList<Button>();
        ArrayList<Button> removeBtList = new ArrayList<Button>();
        Language[] languageArray = removeLang;
        int n3 = removeLang.length;
        int n4 = 0;
        while (n4 < n3) {
            Language lang = languageArray[n4];
            for (Button bt : this.langBtns) {
                if (!bt.getText().equals(lang.getLang())) continue;
                removeBtList.add(bt);
                list.remove(lang.getLang());
            }
            ++n4;
        }
        for (Button bt : removeBtList) {
            bt.dispose();
        }
        for (Button bt : this.langBtns) {
            if (bt.isDisposed()) continue;
            remainBtList.add(bt);
        }
        this.langBtns.clear();
        if (remainBtList.isEmpty()) {
            this.allButton.dispose();
            this.allButton = null;
        } else {
            this.langBtns.addAll(remainBtList);
        }
        this.redrawTable(list.toArray(new String[0]), false);
    }

    private void addNewLanguageButton(Language[] newLang) {
        TableColumn[] columns;
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        GridData gd = new GridData(768);
        ArrayList<String> list = new ArrayList<String>();
        if (this.allButton == null) {
            this.allButton = toolkit.createButton(this.visibilityComp, Messages.POPage_SelectAll, 32);
            this.allButton.setLayoutData((Object)gd);
            this.allButton.addSelectionListener(this.alllistener);
        }
        TableColumn[] tableColumnArray = columns = this.fTable.getTable().getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            list.add(column.getText());
            ++n2;
        }
        ArrayList<String> checkedList = new ArrayList<String>();
        for (Button bt : this.langBtns) {
            if (bt.getSelection()) {
                checkedList.add(bt.getText());
            }
            bt.dispose();
        }
        Language[] languageArray = newLang;
        int n3 = newLang.length;
        int n4 = 0;
        while (n4 < n3) {
            Language lang = languageArray[n4];
            checkedList.add(lang.getLang());
            list.add(lang.getLang());
            ++n4;
        }
        this.langBtns.clear();
        for (Language lang : this.availableLangs) {
            boolean checked = false;
            for (String s : checkedList) {
                if (!lang.getLang().equals(s)) continue;
                checked = true;
            }
            Button button = toolkit.createButton(this.visibilityComp, lang.getLang(), 32);
            Image image = FlagImageManager.getImage(lang.getLang());
            button.setImage(image);
            button.setSelection(checked);
            button.setLayoutData((Object)gd);
            button.addSelectionListener(this.listener);
            this.langBtns.add(button);
        }
        this.redrawTable(list.toArray(new String[0]), false);
    }

    private void addLanguageButton() {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        GridData gd = new GridData(768);
        if (!this.availableLangs.isEmpty()) {
            this.allButton = toolkit.createButton(this.visibilityComp, Messages.POPage_SelectAll, 32);
            this.allButton.setLayoutData((Object)gd);
            this.allButton.addSelectionListener(this.alllistener);
            if (this.allSelected) {
                this.allButton.setSelection(true);
                this.allSelected = false;
            }
        }
        this.langBtns.clear();
        for (Language lang : this.availableLangs) {
            boolean checked = false;
            for (String column : this.initColumns) {
                if (!lang.getLang().equals(column)) continue;
                checked = true;
            }
            Button button = toolkit.createButton(this.visibilityComp, lang.getLang(), 32);
            Image image = FlagImageManager.getImage(lang.getLang());
            button.setImage(image);
            button.setSelection(checked);
            button.setLayoutData((Object)gd);
            button.addSelectionListener(this.listener);
            this.langBtns.add(button);
        }
    }

    private void setInitColumn() {
        this.initColumns.add(Messages.POPage_KeyHeader);
        if (this.selectedFile.getName().equals("all.po")) {
            this.allSelected = true;
            for (Language lang : this.availableLangs) {
                if (lang == null) continue;
                this.initColumns.add(lang.getLang());
            }
        } else {
            String poFileName = this.selectedFile.getName();
            String languageId = this.getCodeFromFileName(poFileName);
            Language lang = this.languageMgr.getLangById(languageId);
            if (lang != null) {
                this.initColumns.add(lang.getLang());
            }
        }
    }

    private void setLanguageManager() {
        this.languageMgr = LanguageParser.process();
    }

    private void setPOFileMap() {
        FlagImageManager.process(this.languageMgr.getLangTable());
        File poFileDir = new File(this.localePath.toOSString());
        if (!poFileDir.exists()) {
            return;
        }
        File[] fileArray = poFileDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                File localeFile = fileArray[n2];
                String poFileName = localeFile.getName();
                String languageId = this.getCodeFromFileName(poFileName);
                if (this.languageMgr.contain(languageId)) {
                    this.availableLangs.add(this.languageMgr.getLangTable().get(languageId));
                    POFile poFile = new POFile(localeFile);
                    try {
                        poFile.open();
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                        break block5;
                    }
                    this.poHandler.putLocaleData(languageId, poFile);
                }
            }
            ++n2;
        }
        this.sortLanguageList(this.availableLangs);
    }

    private void sortLanguageList(List<Language> list) {
        Collections.sort(list, new Comparator<Language>(){

            @Override
            public int compare(Language lang1, Language lang2) {
                return lang1.getId().compareToIgnoreCase(lang2.getId());
            }
        });
    }

    private void initData() {
        this.setLanguageManager();
        this.setPOFileMap();
        this.setInitColumn();
    }

    private String getCodeFromFileName(String name) {
        return name.substring(0, name.length() - 3);
    }

    private void enableSaveAction() {
        this.setDirty(true);
        this.editor.editorDirtyStateChanged();
    }

    private void disableSaveAction() {
        this.setDirty(false);
        this.editor.editorDirtyStateChanged();
    }

    public void doSave(IProgressMonitor monitor) {
        String[] stringArray = this.poHandler.getLocaleCodes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String locale = stringArray[n2];
            POFile file = this.poHandler.getPOFile(locale);
            try {
                file.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        IFolder folder = this.project.getFolder("/res/po");
        try {
            folder.refreshLocal(2, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.disableSaveAction();
    }

    private void removeLang() {
        ArrayList<Language> langList = new ArrayList<Language>();
        Map<String, Language> langMap = this.languageMgr.getLangTable();
        for (Language l : this.availableLangs) {
            langList.add(l);
        }
        this.sortLanguageList(langList);
        Shell parentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        List<String> langIDs = null;
        ComboSelectionDialog dialog = new ComboSelectionDialog(parentShell, langList, null, Messages.POFileEditorPage_23);
        if (dialog.open() == 0) {
            langIDs = dialog.getValue();
            ArrayList<Language> removeLang = new ArrayList<Language>();
            for (String langID : langIDs) {
                Language l = langMap.get(langID);
                IPath filepath = this.project.getLocation().append("res").append("po").append(String.valueOf(langID) + ".po");
                File file = new File(filepath.toOSString());
                if (!file.delete()) {
                    return;
                }
                removeLang.add(l);
                this.availableLangs.remove(l);
                this.poHandler.removeLocale(langID);
            }
            this.removeLanguageButton(removeLang.toArray(new Language[0]));
            this.visibilityComp.layout(true, true);
            this.getManagedForm().reflow(true);
            this.addKeyLink.setEnabled(!this.availableLangs.isEmpty());
        }
    }

    private void addLang() {
        ArrayList newLang;
        ArrayList<Language> langList = new ArrayList<Language>();
        Map<String, Language> langMap = this.languageMgr.getLangTable();
        HashMap<String, Language> langMap2 = new HashMap<String, Language>();
        langMap2.putAll(langMap);
        for (Language l : this.availableLangs) {
            if (!langMap.containsKey(l.getId())) continue;
            langMap2.remove(l.getId());
        }
        for (String s : langMap2.keySet()) {
            langList.add((Language)langMap2.get(s));
        }
        this.sortLanguageList(langList);
        Shell parentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ComboSelectionDialog dialog = new ComboSelectionDialog(parentShell, langList, this.availableLangs, Messages.POFileEditorPage_26);
        if (dialog.open() == 0) {
            final List<String> langIDs = dialog.getValue();
            final String baseLang = dialog.getBaseLang();
            newLang = new ArrayList();
            ProgressMonitorDialog progressMonitor = new ProgressMonitorDialog(this.getSite().getShell());
            try {
                progressMonitor.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        int size = langIDs.size();
                        monitor.beginTask(Messages.POPage_Progress_CreatePO, size);
                        for (String langID : langIDs) {
                            monitor.subTask(String.format(Messages.POPage_Progress_CreatePO2, langID));
                            Language l = POEditorPage.this.languageMgr.getLangTable().get(langID);
                            POEditorPage.this.availableLangs.add(l);
                            newLang.add(l);
                            IPath filepath = POEditorPage.this.project.getLocation().append("res").append("po").append(String.valueOf(langID) + ".po");
                            File file = new File(filepath.toOSString());
                            try {
                                file.createNewFile();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                monitor.worked(1);
                                continue;
                            }
                            POFile newPO = new POFile(file);
                            if (baseLang != null) {
                                String baseLangId = POEditorPage.this.languageMgr.getLangByName(baseLang).getId();
                                POFile basefile = POEditorPage.this.poHandler.getPOFile(baseLangId);
                                List<MsgEntry> entries = basefile.getMsgEntries();
                                for (MsgEntry e : entries) {
                                    MsgEntry newe = new MsgEntry();
                                    newe.setMsgId(e.getMsgId());
                                    newe.setMsgStr(e.getMsgStr());
                                    newPO.addMsgEntry(newe);
                                }
                            }
                            POEditorPage.this.poHandler.putLocaleData(langID, newPO);
                            try {
                                newPO.save();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            monitor.worked(1);
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            return;
        }
        this.sortLanguageList(this.availableLangs);
        this.addNewLanguageButton(newLang.toArray(new Language[0]));
        this.visibilityComp.layout(true, true);
        this.getManagedForm().reflow(true);
        this.addKeyLink.setEnabled(!this.availableLangs.isEmpty());
    }

    public void showLanguage(String langID) {
        TableColumn[] columns;
        Map<String, Language> langMap = this.languageMgr.getLangTable();
        Language language = langMap.get(langID);
        if (!this.availableLangs.contains(language)) {
            return;
        }
        String langName = language.getLang();
        for (Button bt : this.langBtns) {
            if (!bt.getText().equals(langName)) continue;
            if (bt.getSelection()) {
                return;
            }
            bt.setSelection(true);
        }
        ArrayList<String> list = new ArrayList<String>();
        TableColumn[] tableColumnArray = columns = this.fTable.getTable().getColumns();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            list.add(column.getText());
            ++n2;
        }
        list.add(langName);
        for (Button bt : this.langBtns) {
            if (!bt.getText().equals(langName)) continue;
            bt.setSelection(true);
        }
        this.redrawTable(list.toArray(new String[0]), false);
    }

    private Image getIcon(String path) {
        Bundle bundle = Platform.getBundle((String)"org.tizen.nativecommon");
        URL filePath = bundle.getEntry(path);
        try {
            filePath = FileLocator.toFileURL((URL)filePath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Path tempFileName = new Path(filePath.getPath());
        Image icon = new Image((Device)Display.getCurrent(), tempFileName.toOSString());
        return icon;
    }

    private Image getLangAddIcon() {
        return this.getIcon("/icons/localization/language_add.png");
    }

    private Image getLangRemoveIcon() {
        return this.getIcon("/icons/localization/language_delete.png");
    }

    private Image getStrKeyAddIcon() {
        return this.getIcon("/icons/localization/string_add.png");
    }

    private Image getStrKeyRemoveIcon() {
        return this.getIcon("/icons/localization/string_delete.png");
    }

    public void setDirty(boolean dirty) {
        this.mDirty = dirty;
    }

    public boolean isDirty() {
        if (this.fTable != null && !this.isColumnFocused()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    while (Display.getDefault().readAndDispatch()) {
                    }
                    POEditorPage.this.setColumnFocusing(true);
                    POEditorPage.this.fTable.getTable().setFocus();
                }
            });
        }
        return this.mDirty;
    }

    private boolean isColumnFocused() {
        return this.fFocusHandler.isColumnFocused();
    }

    private void setColumnFocusing(boolean value) {
        this.fFocusHandler.setColumnFocusing(value);
    }

    private void restoreIfFocusingStatus() {
        this.fFocusHandler.restoreIfFocusingStatus(this.tableComp.getClientArea(), this.fTable.getTable());
    }

    private void saveColumnValues() {
        this.fFocusHandler.saveColumnValues(this.fTable.getTable());
    }

    private void resizeAllItemsSame() {
        this.fFocusHandler.resizeAllItemsSame(this.tableComp.getClientArea(), this.fTable.getTable());
    }

    private void focusSelectedItem(int selectedColumn) {
        this.fFocusHandler.focusSelectedItem(this.tableComp.getClientArea(), this.fTable.getTable(), selectedColumn);
    }

    private class ResourceChangeListener
    implements IResourceChangeListener {
        private ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta rootDelta = event.getDelta();
            IResourceDelta poDelta = rootDelta.findMember(POEditorPage.this.project.getFullPath().append("/res/po"));
            if (poDelta == null) {
                return;
            }
            IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) {
                    switch (delta.getKind()) {
                        case 2: {
                            IResource res = delta.getResource();
                            final ArrayList removeLang = new ArrayList();
                            if (res.getType() != 1 || !"po".equalsIgnoreCase(res.getFileExtension())) break;
                            Map<String, Language> langMap = POEditorPage.this.languageMgr.getLangTable();
                            String filename = res.getLocation().lastSegment();
                            final String langId = filename.replace(".po", "");
                            final Language l = langMap.get(langId);
                            if (!POEditorPage.this.availableLangs.contains(l)) break;
                            Display.getDefault().asyncExec(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    1 var1_1 = this;
                                    synchronized (var1_1) {
                                        removeLang.add(l);
                                        POEditorPage.this.availableLangs.remove(l);
                                        POEditorPage.this.poHandler.removeLocale(langId);
                                        POEditorPage.this.removeLanguageButton(removeLang.toArray(new Language[0]));
                                        POEditorPage.this.visibilityComp.layout(true, true);
                                        POEditorPage.this.getManagedForm().reflow(true);
                                        POEditorPage.this.addKeyLink.setEnabled(!POEditorPage.this.availableLangs.isEmpty());
                                    }
                                }
                            });
                        }
                    }
                    return true;
                }
            };
            try {
                poDelta.accept(visitor);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    class TabbedCellModifier
    implements ICellModifier {
        TabbedCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            POEditorPage.this.selectedColumn = this.getIndexFromProperty(property);
            POEditorPage.this.selectedRow = ((TableData)element).rowID;
            if (POEditorPage.this.selectedColumn < 0 || POEditorPage.this.selectedRow < 0) {
                return false;
            }
            POEditorPage.this.restoreIfFocusingStatus();
            POEditorPage.this.selectedItem = POEditorPage.this.fTable.getTable().getItem(POEditorPage.this.selectedRow);
            POEditorPage.this.prevStringKey = POEditorPage.this.selectedItem.getText();
            POEditorPage.this.prevStringValue = POEditorPage.this.selectedItem.getText(POEditorPage.this.selectedColumn);
            POEditorPage.this.focusSelectedItem(POEditorPage.this.selectedColumn);
            POEditorPage.this.tableComp.layout(true, true);
            return true;
        }

        public Object getValue(Object element, String property) {
            return POEditorPage.this.selectedItem.getText(POEditorPage.this.selectedColumn);
        }

        public void modify(Object element, String property, Object value) {
            if (POEditorPage.this.selectedColumn != this.getIndexFromProperty(property) || POEditorPage.this.selectedItem != (TableItem)element) {
                return;
            }
            String changedValue = (String)value;
            boolean isNewStringCell = POEditorPage.this.selectedColumn == 0 && POEditorPage.this.selectedRow == 0 && POEditorPage.this.addingStringkey;
            boolean isStringKeyColumn = POEditorPage.this.selectedColumn == 0;
            boolean isChangedValue = StringUtil.isEmpty((CharSequence)changedValue);
            if (isNewStringCell) {
                if (!changedValue.isEmpty()) {
                    if (!POEditorPage.this.validateStringKey(changedValue)) {
                        DialogUtil.openErrorDialog((String)String.format(Messages.POPage_Error_KeyExists, changedValue));
                    } else {
                        POEditorPage.this.addNewStringKey(changedValue, "");
                        POEditorPage.this.enableSaveAction();
                    }
                }
                POEditorPage.this.redrawTable(null, false);
            } else if (isStringKeyColumn) {
                if (!POEditorPage.this.prevStringKey.equals(changedValue)) {
                    if (!POEditorPage.this.validateStringKey(changedValue)) {
                        DialogUtil.openErrorDialog((String)String.format(Messages.POPage_Error_KeyExists, changedValue));
                    } else {
                        for (Language lang : POEditorPage.this.availableLangs) {
                            POFile file = POEditorPage.this.poHandler.getPOFile(lang.getId());
                            List<MsgEntry> entries = file.getMsgEntries();
                            for (MsgEntry entry : entries) {
                                if (!entry.getMsgId().equals(POEditorPage.this.prevStringKey)) continue;
                                entry.setMsgId(changedValue);
                            }
                        }
                        POEditorPage.this.enableSaveAction();
                        POEditorPage.this.selectedItem.setText(changedValue);
                    }
                }
                POEditorPage.this.tableComp.layout(true, true);
            } else if (isChangedValue) {
                String msgId;
                changedValue = msgId = POEditorPage.this.selectedItem.getText(0);
                POEditorPage.this.selectedItem.setForeground(POEditorPage.this.selectedColumn, POEditorPage.this.grayColor);
                this.modifyTableColumnText(msgId, changedValue);
                POEditorPage.this.disableSaveAction();
            } else if (!POEditorPage.this.prevStringValue.equals(changedValue)) {
                String msgId = POEditorPage.this.selectedItem.getText(0);
                POEditorPage.this.selectedItem.setForeground(POEditorPage.this.selectedColumn, POEditorPage.this.blackColor);
                this.modifyTableColumnText(msgId, changedValue);
            }
            POEditorPage.this.addingStringkey = false;
        }

        public void modifyTableColumnText(String msgId, String changedValue) {
            String header = POEditorPage.this.fTable.getTable().getColumns()[POEditorPage.this.selectedColumn].getText();
            String langId = POEditorPage.this.languageMgr.getLangByName(header).getId();
            POFile file = POEditorPage.this.poHandler.getPOFile(langId);
            List<MsgEntry> entries = file.getMsgEntries();
            for (MsgEntry entry : entries) {
                if (!entry.getMsgId().equals(msgId)) continue;
                entry.setMsgStr(changedValue);
            }
            POEditorPage.this.selectedItem.setText(POEditorPage.this.selectedColumn, changedValue);
            POEditorPage.this.enableSaveAction();
        }

        private int getIndexFromProperty(String property) {
            List<String> columns = POEditorPage.this.fFocusHandler.getColumnValues();
            if (columns.isEmpty()) {
                POEditorPage.this.saveColumnValues();
            }
            int i = 0;
            boolean found = false;
            for (String s : columns) {
                if (s.equals(property)) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (found) {
                return i;
            }
            return -1;
        }
    }

    static class TableData {
        int rowID;
        boolean emptyErr;
        Int sameMsgIDErr;
        int errCount;

        TableData(int rowID, boolean emptyErr) {
            this.rowID = rowID;
            this.emptyErr = false;
            this.setSameErr(0);
            this.errCount = -1;
        }

        private void setSameErr(int err) {
            this.sameMsgIDErr = new Int(err);
        }

        static class Int {
            int value;

            Int(int value) {
                this.value = value;
            }
        }
    }
}

