/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.build.makefile;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariableManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedOutputNameProvider;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.macros.FileContextData;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator2;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.tizen.common.ITizenProject;
import org.tizen.common.ITizenWebProject;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.build.CommonConfigurationManager;
import org.tizen.nativecommon.build.PlatformChangingManager;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativecommon.build.exception.SBIException;
import org.tizen.nativecommon.ui.sa.pages.TizenSAProperty;
import org.tizen.nativecore.build.NativeCoreConfigurationManager;
import org.tizen.nativecore.build.makefile.NativeMakeFileManipulator;
import org.tizen.nativecore.build.makefile.POBuildProvider;
import org.tizen.nativecore.util.PackageUtil;

public class NativeCoreNinjaFileGenerator
implements IManagedBuilderMakefileGenerator2 {
    private IProject project;
    private IPath topBuildDir;
    private IPath projectDir;
    private IConfiguration config;
    private IProgressMonitor monitor;
    private ICSourceEntry[] srcEntries;
    private Collection<IContainer> subdirList;
    private final Vector<String> SubNinjaFiles = new Vector();
    private final Vector<String> ObjFiles = new Vector();
    private final Vector<String> ResFiles = new Vector();
    public static final String DIR_SA_REPORT = "SA_Report";
    public static final String DIR_COV_REPORT = "Coverage_Report";
    private static final IPath DOT_SLASH_PATH = new Path("./");
    private static final IPath DOT_DOT_SLASH_PATH = new Path("../");
    boolean isOSWindows = System.getProperty("os.name").startsWith("Windows");
    private final int WIN_MAX_CMD_LEN = 30000;
    private static final String REQ_NINJA_VER = "1.5";
    private static final String NINJA_RULE_FILE = "rules.ninja";
    private static final String NINJA_BUILD_FILE = "build.ninja";
    private static final String PREBUILD_SCRIPT = "prebuild.sh";
    private static final String POSTBUILD_SCRIPT = "postbuild.sh";
    private static final String SUBNINJA_BUILD_FILE = "subdir.ninja";
    private static final String NINJA_TARGET_FILE = "target.ninja";
    private static final String COMP_DB_FILE = "compile_commands.json";
    private static final String NINJA_RULE_FILE_TEMPLATE = String.valueOf(InstallPathConfig.getEclipsePath()) + "/Templates/native/ninja/rules.ninja";
    private TOOLCHAIN CURR_TOOLCHAIN = null;
    private static final String C_FILE_EXT = "c";
    private static final String EMPTY_STRING = "";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String buildRuleFmt = "build %s: build_%s %s %s\n%s";
    private static final String buildToolVarFmt = "%s%stool = %s\n";
    private static final String buildFlagVarFmt = "%s%sflags = %s\n";
    private static final String buildVarFmt = "%s%stool = %s\n%s%sflags = %s\n\n";
    private static final String compDBFmt = "  { \"directory\": \"%s\",\n    \"command\": \"%s %s \\\"%s\\\"\",\n    \"file\": \"%s\" },\n";
    private static final List<String> C_SRC_EXTS = Arrays.asList("c");
    private static final List<String> CPP_SRC_EXTS = Arrays.asList("cpp", "CPP", "C", "cc", "cp", "c++", "cxx");
    private boolean isUsingLlvm = false;
    private boolean needPchFile = false;
    private boolean hasPrebuildStep = false;
    private boolean hasPostbuildStep = false;
    private boolean isPrePostbuildStep = false;
    private IPath buildDirPath = null;
    private String buildDir = "";
    private String projectName = "";
    private String pchInFile = "";
    private String pchOutFile = "";

    private void init_helper(IProject project, IConfiguration cfg, IProgressMonitor monitor) {
        this.project = project;
        this.config = cfg;
        this.monitor = monitor;
        this.srcEntries = this.config.getSourceEntries();
        this.topBuildDir = project.getFolder(this.config.getName()).getFullPath();
        this.projectDir = new Path(project.getLocationURI().getPath());
    }

    public void initialize(int kind, IConfiguration cfg, IBuilder builder, IProgressMonitor monitor) {
        this.init_helper(cfg.getOwner().getProject(), cfg, monitor);
    }

    public void initialize(IProject project, IManagedBuildInfo info, IProgressMonitor monitor) {
        this.init_helper(project, info.getDefaultConfiguration(), monitor);
    }

    public void generateDependencies() throws CoreException {
    }

    public void regenerateDependencies(boolean force) throws CoreException {
    }

    public MultiStatus generateMakefiles(IResourceDelta delta) throws CoreException {
        IFolder folder;
        if (this.checkHeadlessBuild()) {
            return this.regenerateMakefiles();
        }
        boolean genFragMakeFiles = false;
        genFragMakeFiles |= this.changingPlatformAndCleaningIfItNeeded();
        this.checkCancel();
        this.checkCancel();
        if (!(genFragMakeFiles |= this.resetRpathOption()) && !(genFragMakeFiles |= !(folder = this.project.getFolder(this.config.getName())).exists())) {
            ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(this, this.config);
            delta.accept((IResourceDeltaVisitor)visitor);
            this.checkCancel();
            genFragMakeFiles = visitor.isResourceChanged();
        }
        if (genFragMakeFiles) {
            return this.generateAllMakefiles();
        }
        this.populateBuildTargetMakeFile();
        return this.getStatus(0, new String());
    }

    public MultiStatus regenerateMakefiles() throws CoreException {
        if (this.checkHeadlessBuild()) {
            if (this.existsMakefile()) {
                return this.getStatus(0, new String());
            }
            String targetId = NativeCoreConfigurationManager.getBuildTargetName((IConfiguration)this.config);
            NativeCoreConfigurationManager.changeToolchain(this.config, targetId);
        }
        this.changingPlatformAndCleaningIfItNeeded();
        this.resetRpathOption();
        return this.generateAllMakefiles();
    }

    private void addReferencedProjectOptions() {
        HashSet<IProject> referencedProjectsSet = new HashSet<IProject>(Arrays.asList(PackageUtil.getRefLibProjects(this.project)));
        CommonConfigurationManager.addReferencedProjectOptions((IProject)this.project, referencedProjectsSet);
    }

    public MultiStatus generateAllMakefiles() throws CoreException {
        ResourceProxyVisitor visitor = new ResourceProxyVisitor(this, this.config);
        this.project.accept((IResourceProxyVisitor)visitor, 0);
        this.checkCancel();
        if (this.getSubdirList().isEmpty()) {
            return this.getStatus(0, new String("No buildable source in folder"));
        }
        this.addReferencedProjectOptions();
        this.topBuildDir = this.createDirectory(this.config.getName());
        this.checkCancel();
        this.buildDirPath = this.getBuildWorkingDir();
        if (this.buildDirPath == null) {
            return this.getStatus(0, new String("No buildable source in folder"));
        }
        this.projectName = this.project.getName();
        this.buildDir = this.getTopBuildDir().toOSString();
        this.isUsingLlvm = this.isUsingLLVMToolchain();
        this.hasPrebuildStep = !this.config.getPrebuildStep().trim().isEmpty();
        boolean bl = this.hasPostbuildStep = !this.config.getPostbuildStep().trim().isEmpty();
        if (this.isUsingLlvm) {
            this.createDirectory(DIR_SA_REPORT);
        }
        NativeMakeFileManipulator.replaceBuildEnvExpressionToMakeFile(this.config);
        this.needPchFile = this.existsPCHSrc();
        if (this.needPchFile) {
            String pchExtension = this.isUsingLlvm ? "pch" : "gch";
            this.pchOutFile = "./pch/tizenx.h." + pchExtension;
            this.pchInFile = "../inc/tizenx.h";
        }
        NinjaBuildDB ninjaDB = new NinjaBuildDB();
        for (IResource iResource : this.getSubdirList()) {
            try {
                IContainer subdir = (IContainer)iResource;
                ninjaDB.put(subdir, true);
                ninjaDB.writeToNinjaFile(subdir);
            }
            catch (CoreException coreException) {}
            this.checkCancel();
        }
        ninjaDB.UpdateCompDbAndClear();
        ninjaDB.writeCompDBFile();
        this.checkCancel();
        this.populateTopMakefile();
        this.checkCancel();
        this.populateBuildTargetMakeFile();
        this.createDirectory("res");
        return this.getStatus(0, new String());
    }

    public IFile getNinjaFile(IContainer subdir, String filename) throws CoreException {
        IPath moduleOutputPath = this.buildDirPath;
        if (subdir != null) {
            moduleOutputPath = moduleOutputPath.append(subdir.getProjectRelativePath());
        }
        IPath moduleOutputDir = this.createDirectory(moduleOutputPath.toString());
        IFile ninjaFile = this.createFile(moduleOutputDir.append(filename));
        return ninjaFile;
    }

    public IFile getNinjaFile(String filename) throws CoreException {
        return this.getNinjaFile(null, filename);
    }

    public IFile getNinjaFile(IContainer subdir) throws CoreException {
        return this.getNinjaFile(subdir, this.getSubNinjafileName());
    }

    public void populateNinjafile(IFile ninjaFile, StringBuffer data) throws CoreException {
        StringBuffer makeBuf = new StringBuffer();
        if (ninjaFile.getFileExtension().equals("ninja")) {
            makeBuf.append(this.addDefaultHeader());
        }
        makeBuf.append(data);
        this.saveFile(makeBuf, ninjaFile);
    }

    private void populateBuildTargetMakeFile() throws CoreException {
        String miscToolOptions;
        boolean addClangSATargets;
        StringBuffer makeBuf = new StringBuffer();
        ITool tool = this.config.calculateTargetTool();
        if (tool == null) {
            IResourceInfo rcInfo = this.config.getResourceInfo(this.topBuildDir, false);
            tool = ((IFolderInfo)rcInfo).getToolFromInputExtension("o");
        }
        makeBuf.append(String.format("build main_build: phony %s", this.getArtifactName()));
        if (this.ResFiles.size() > 0) {
            makeBuf.append(" res");
        }
        if ((addClangSATargets = this.isUsingLLVMToolchain()) && TizenSAProperty.getWithRunOption((IProject)this.project)) {
            makeBuf.append(" sa");
        }
        makeBuf.append("\n");
        makeBuf.append(String.format("build all: phony %s\n", this.hasPostbuildStep ? "post-build" : "main_build"));
        makeBuf.append(String.format("default all\n", new Object[0]));
        TizenProjectDescription desc = org.tizen.common.util.ProjectUtil.getTizenProjectDescription((IProject)this.project);
        String projectVersion = desc.getVersion();
        String[] Version2 = projectVersion.split("[.]");
        String Edge_CC_Options = "-w";
        if (Version2.length == 2) {
            if (Integer.parseInt(Version2[0]) > 2) {
                Edge_CC_Options = "-deps";
            } else if (Integer.parseInt(Version2[0]) == 2 && Integer.parseInt(Version2[1]) > 3) {
                Edge_CC_Options = "-deps";
            }
        } else if (Version2.length == 3) {
            if (Integer.parseInt(Version2[0]) > 2) {
                Edge_CC_Options = "-deps";
            } else if (Integer.parseInt(Version2[0]) == 2 && Integer.parseInt(Version2[1]) > 3) {
                Edge_CC_Options = "-deps";
            } else if (Integer.parseInt(Version2[0]) == 2 && Integer.parseInt(Version2[1]) >= 3 && Integer.parseInt(Version2[1]) >= 1) {
                Edge_CC_Options = "-deps";
            }
        }
        makeBuf.append(String.format("edje-cc-options = " + Edge_CC_Options + "\n", new Object[0]));
        String APICheckerOptions = CommonConfigurationManager.getAPICheckerOptions();
        if (!APICheckerOptions.isEmpty()) {
            makeBuf.append(String.format("apichecker-options = " + APICheckerOptions + "\n", new Object[0]));
            String APICheckerMiscOptions = CommonConfigurationManager.getAPICheckerMiscOptions();
            if (!APICheckerMiscOptions.isEmpty()) {
                makeBuf.append(String.format("apichecker-misc-options = " + APICheckerMiscOptions + "\n", new Object[0]));
            }
        }
        if (!(miscToolOptions = CommonConfigurationManager.getMiscToolOptions()).isEmpty()) {
            makeBuf.append(String.format("otherflags = " + miscToolOptions + "\n", new Object[0]));
        }
        makeBuf.append(String.format("binaryName = " + this.projectName.toLowerCase() + "\n", new Object[0]));
        IPath buildTargetfilePath = this.getTopBuildDir().append(NINJA_TARGET_FILE);
        IFile buildTargetfileHandle = this.createFile(buildTargetfilePath);
        this.saveFile(makeBuf, buildTargetfileHandle);
    }

    private StringBuffer addRuleForTarget() {
        ITool tool = this.config.calculateTargetTool();
        StringBuffer buf = new StringBuffer();
        if (tool == null) {
            IResourceInfo rcInfo = this.config.getResourceInfo(this.topBuildDir, false);
            tool = ((IFolderInfo)rcInfo).getToolFromInputExtension("o");
        }
        if (tool == null) {
            return buf;
        }
        String cmd = tool.getToolCommand();
        StringBuffer flagsBuf = new StringBuffer();
        String buildTargetExt = this.config.getArtifactExtension();
        String[] stringArray = this.config.getUserObjects(buildTargetExt);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String obj = stringArray[n2];
            flagsBuf.append(" " + obj);
            ++n2;
        }
        stringArray = this.config.getLibs(buildTargetExt);
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String lib = stringArray[n2];
            flagsBuf.append(" " + lib);
            ++n2;
        }
        try {
            stringArray = tool.getToolCommandFlags(null, null);
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                String flg = stringArray[n2];
                flagsBuf.append(" " + flg);
                ++n2;
            }
        }
        catch (BuildException buildException) {}
        NinjaToolData outTool = new NinjaToolData("target", cmd, flagsBuf.toString());
        String inObjFiles = this.joinArrayString(this.ObjFiles.toString(), " ");
        NinjaFileData outFile = new NinjaFileData("target", inObjFiles, this.getArtifactName());
        buf.append(outTool.toString(EMPTY_STRING));
        buf.append(outFile.toBuildRuleEntry(outTool, EMPTY_STRING));
        buf.append("\n");
        return buf;
    }

    private StringBuffer addRuleForPchFile() {
        StringBuffer buf = new StringBuffer();
        if (!this.needPchFile) {
            return buf;
        }
        IResourceInfo rcInfo = this.config.getResourceInfo(this.topBuildDir, false);
        ITool tool = ((IFolderInfo)rcInfo).getToolFromInputExtension(C_FILE_EXT);
        if (tool == null) {
            return buf;
        }
        String cmd = tool.getToolCommand();
        StringBuffer flagsBuf = new StringBuffer();
        try {
            String[] stringArray = tool.getToolCommandFlags(null, null);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String flg = stringArray[n2];
                flagsBuf.append(" " + flg);
                ++n2;
            }
        }
        catch (BuildException buildException) {}
        NinjaToolData outTool = new NinjaToolData("pch", cmd, flagsBuf.toString());
        NinjaFileData outFile = new NinjaFileData("pch", this.pchInFile, this.pchOutFile);
        buf.append("\npchInc = -Ipch");
        buf.append(outTool.toString(EMPTY_STRING));
        buf.append(outFile.toBuildRuleEntry(outTool, EMPTY_STRING));
        return buf;
    }

    private void CreateScriptFile(String FilePath, String content) {
        File file;
        File scriptFile = new File(content);
        if (scriptFile.exists() && this.isOSWindows) {
            content = content.replace("\\", "/");
        }
        if ((file = new File(FilePath)).exists()) {
            file.delete();
        }
        try {
            file.createNewFile();
            file.setExecutable(true);
            FileWriter fw = new FileWriter(file.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(content);
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private StringBuffer addPrePostBuildSteps() {
        String FilePath;
        StringBuffer buf = new StringBuffer();
        this.isPrePostbuildStep = true;
        if (this.hasPrebuildStep) {
            String prebuildStep = this.expandBuildSteps(this.config.getPrebuildStep());
            IPath preBuildScriptFile = this.getTopBuildDir().append(PREBUILD_SCRIPT);
            FilePath = preBuildScriptFile.makeAbsolute().toOSString();
            this.CreateScriptFile(FilePath, prebuildStep);
            buf.append(String.format("prebuildcmd = %s\n", FilePath));
        }
        if (this.hasPostbuildStep) {
            String postbuildStep = this.expandBuildSteps(this.config.getPostbuildStep());
            IPath postBuildScriptFile = this.getTopBuildDir().append(POSTBUILD_SCRIPT);
            FilePath = postBuildScriptFile.makeAbsolute().toOSString();
            this.CreateScriptFile(FilePath, postbuildStep);
            buf.append(String.format("postbuildcmd = %s\n", FilePath));
        }
        this.isPrePostbuildStep = false;
        return buf;
    }

    private void populateTopMakefile() throws CoreException {
        StringBuffer makeBuf = new StringBuffer();
        makeBuf.append(this.addDefaultHeader());
        makeBuf.append("ninja_required_version = ").append(REQ_NINJA_VER).append("\n");
        makeBuf.append("include ").append(NINJA_RULE_FILE).append("\n");
        makeBuf.append("include ").append(NINJA_TARGET_FILE).append("\n");
        makeBuf.append("\n");
        makeBuf.append("shell = ").append(this.isOSWindows ? "cmd /c" : EMPTY_STRING).append("\n");
        if (this.isOSWindows) {
            SmartBuildInterface sbi = SmartBuildInterface.getInstance();
            String msysBinPath = sbi.getMsysBinPath();
            makeBuf.append(String.format("bashshell = %s%s%s\n", msysBinPath, File.separator, "sh.exe"));
        }
        makeBuf.append("builddir = ").append(this.getTopBuildDir().toOSString()).append("\n");
        if (this.isUsingLlvm) {
            makeBuf.append("sareportdir = ").append(this.getSaReportDir().toOSString()).append("\n");
            makeBuf.append("sa_checkers = ").append(this.getSaCheckers()).append("\n");
            makeBuf.append("coveragedir = ").append(this.getCovReportDir().toOSString()).append("\n");
        }
        makeBuf.append("\n");
        for (String fn : this.SubNinjaFiles) {
            makeBuf.append("subninja ").append(fn).append("\n");
        }
        makeBuf.append("\n");
        makeBuf.append(this.addPrePostBuildSteps());
        makeBuf.append(this.addRuleForPchFile());
        makeBuf.append(this.addRuleForTarget());
        IPath makefilePath = this.getTopBuildDir().append(this.getMakefileName());
        IFile makefileHandle = this.createFile(makefilePath);
        this.saveFile(makeBuf, makefileHandle);
        String ninjaRulefilePath = this.getTopBuildDir().append(NINJA_RULE_FILE).toString();
        String ninjaRuleTemplatePath = NINJA_RULE_FILE_TEMPLATE;
        try {
            this.copyFile(ninjaRuleTemplatePath, ninjaRulefilePath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean existsPCHSrc() {
        IFile file = this.project.getFolder("inc").getFile("tizenx.h");
        return file.exists();
    }

    public String expandEnvVariables(String inStr) {
        if ((inStr = inStr.replaceAll("\\{", "\\(").replaceAll("\\}", "\\)")).indexOf("$(") >= 0) {
            IEnvironmentVariable[] vars;
            ICConfigurationDescription cfgDes = ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)this.config);
            IEnvironmentVariableManager mngr = CCorePlugin.getDefault().getBuildEnvironmentManager();
            IEnvironmentVariable[] iEnvironmentVariableArray = vars = mngr.getVariables(cfgDes, true);
            int n = vars.length;
            int n2 = 0;
            while (n2 < n) {
                IEnvironmentVariable var = iEnvironmentVariableArray[n2];
                inStr = inStr.replace(String.format("$(%s)", var.getName()), var.getValue());
                ++n2;
            }
        }
        return inStr;
    }

    private boolean checkHeadlessBuild() {
        IEnvironmentVariable[] vars;
        boolean result = false;
        ICConfigurationDescription cfgDes = ManagedBuildManager.getDescriptionForConfiguration((IConfiguration)this.config);
        IEnvironmentVariableManager mngr = CCorePlugin.getDefault().getBuildEnvironmentManager();
        IEnvironmentVariable[] iEnvironmentVariableArray = vars = mngr.getVariables(cfgDes, true);
        int n = vars.length;
        int n2 = 0;
        while (n2 < n) {
            IEnvironmentVariable var = iEnvironmentVariableArray[n2];
            if (var.getName().equals("CLI") && var.getValue().equals("true")) {
                result = true;
            }
            ++n2;
        }
        return result;
    }

    private boolean existsMakefile() throws CoreException {
        IPath configDir = this.createDirectory(this.config.getName());
        IPath makefilePath = configDir.append(this.getMakefileName());
        IFile makeFile = this.project.getFile(makefilePath.removeFirstSegments(1));
        return makeFile.exists();
    }

    private MultiStatus getStatus(int kind, String msg) {
        return new MultiStatus(ManagedBuilderCorePlugin.getUniqueIdentifier(), kind, msg, null);
    }

    private boolean changingPlatformAndCleaningIfItNeeded() {
        if (!PlatformChangingManager.isBuiltReferencedProject((IProject)this.project)) {
            return false;
        }
        IProject rootProj = PlatformChangingManager.getReferencingProject((IProject)this.project);
        if (rootProj == null || ProjectUtil.getTizenProjectType((IProject)rootProj) == null) {
            return false;
        }
        if (!CommonConfigurationManager.equalsArch((IProject)rootProj, (IProject)this.project)) {
            this.config.setRebuildState(true);
            if (PlatformChangingManager.cleanGeneratedRebuildResources((IProject)this.project) && PlatformChangingManager.changeOnlyArch((IProject)rootProj, (IProject)this.project)) {
                this.init_helper(this.project, this.config, this.monitor);
                return true;
            }
        }
        return false;
    }

    private boolean addRpathOption(IProject[] rootPrjs, ITizenProject[] rootWebPrjs) {
        ITizenProject p;
        boolean added = false;
        List frameworkOp = NativeCoreConfigurationManager.getFrameworkLflags(this.config);
        String originProjectLibPath = NativeCoreConfigurationManager.getProjectLibRpathOption(this.project);
        if (!originProjectLibPath.isEmpty() && originProjectLibPath != null && !((ArrayList)frameworkOp).contains(originProjectLibPath)) {
            added = ((ArrayList)frameworkOp).add(originProjectLibPath);
        }
        ITizenProject[] iTizenProjectArray = rootWebPrjs;
        int n = rootWebPrjs.length;
        int n2 = 0;
        while (n2 < n) {
            String appInstPath;
            String rpathOp;
            p = iTizenProjectArray[n2];
            String appId = p.getPackageId();
            if (appId != null && !appId.isEmpty() && !((ArrayList)frameworkOp).contains(rpathOp = NativeCoreConfigurationManager.getRpathOption(this.config, appInstPath = NativeCoreConfigurationManager.getAppInstPath(this.config, appId)))) {
                added = ((ArrayList)frameworkOp).add(rpathOp);
            }
            ++n2;
        }
        iTizenProjectArray = rootPrjs;
        n = rootPrjs.length;
        n2 = 0;
        while (n2 < n) {
            p = iTizenProjectArray[n2];
            String rpathOp = NativeCoreConfigurationManager.getProjectLibRpathOption((IProject)p);
            if (!rpathOp.isEmpty() && rpathOp != null && !((ArrayList)frameworkOp).contains(rpathOp)) {
                added = ((ArrayList)frameworkOp).add(rpathOp);
            }
            ++n2;
        }
        if (added) {
            NativeCoreConfigurationManager.setFrameworkLflags(this.config, frameworkOp);
        }
        return added;
    }

    private boolean clearRpathOption(IProject[] rootPrjs) {
        boolean cleared = false;
        ArrayList<String> rpathOps = new ArrayList<String>();
        IProject[] iProjectArray = rootPrjs;
        int n = rootPrjs.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            String op = NativeCoreConfigurationManager.getProjectLibRpathOption(p);
            rpathOps.add(op);
            ++n2;
        }
        String originProjectLibPath = NativeCoreConfigurationManager.getProjectLibRpathOption(this.project);
        String originToolLibPath = NativeCoreConfigurationManager.getToolLibRpathOption(this.project);
        String oldRpathFormat = String.format("%s %s", originProjectLibPath, originToolLibPath);
        List frameworkOp = NativeCoreConfigurationManager.getFrameworkLflags(this.config);
        ArrayList frameworkOp_clone = new ArrayList(frameworkOp);
        for (String op : frameworkOp_clone) {
            if (!op.startsWith("-Xlinker -rpath=") || op.equals(originProjectLibPath) || op.equals(originToolLibPath) || op.endsWith(oldRpathFormat) || rpathOps.contains(op)) continue;
            cleared = ((ArrayList)frameworkOp).remove(op);
        }
        if (cleared) {
            NativeCoreConfigurationManager.setFrameworkLflags(this.config, frameworkOp);
        }
        return cleared;
    }

    private boolean resetRpathOption() {
        IProject[] rootPrjs = this.project.getReferencingProjects();
        ArrayList<ITizenProject> webList = new ArrayList<ITizenProject>();
        ArrayList<IProject> nativeList = new ArrayList<IProject>();
        IProject[] iProjectArray = rootPrjs;
        int n = rootPrjs.length;
        int n2 = 0;
        while (n2 < n) {
            IProject prj = iProjectArray[n2];
            if (org.tizen.common.util.ProjectUtil.isTizenNativeProject((IProject)prj)) {
                nativeList.add(prj);
            } else if (org.tizen.common.util.ProjectUtil.isTizenWebProject((IProject)prj)) {
                ITizenProject info = org.tizen.common.util.ProjectUtil.getTizenProject((IProject)prj, ITizenWebProject.class);
                webList.add(info);
            }
            ++n2;
        }
        IProject[] rootNativePrjs = nativeList.toArray(new IProject[0]);
        ITizenProject[] rootWebPrjs = webList.toArray(new ITizenProject[0]);
        boolean needsClean = false;
        if (this.clearRpathOption(rootNativePrjs)) {
            needsClean = true;
        }
        if (this.addRpathOption(rootNativePrjs, rootWebPrjs)) {
            needsClean = true;
        }
        if (needsClean) {
            PlatformChangingManager.cleanGeneratedRebuildResources((IProject)this.project);
        }
        return needsClean;
    }

    private boolean isSource(IPath path) {
        return !CDataUtil.isExcluded((IPath)path, (ICSourceEntry[])this.srcEntries);
    }

    private Collection<IContainer> getSubdirList() {
        if (this.subdirList == null) {
            this.subdirList = new LinkedHashSet<IContainer>();
        }
        return this.subdirList;
    }

    private void appendBuildSubdirectory(IResource resource) {
        IContainer container = resource.getParent();
        if (!this.getSubdirList().contains(container)) {
            this.getSubdirList().add(container);
        }
    }

    private String getArtifactName() {
        String buildTargetExt = this.config.getArtifactExtension();
        String target = this.config.getOutputPrefix(buildTargetExt);
        target = String.valueOf(target) + this.config.getArtifactName();
        if (!buildTargetExt.isEmpty()) {
            target = String.valueOf(target) + "." + buildTargetExt;
        }
        return this.expandBuildSteps(target);
    }

    private void checkCancel() {
        if (this.monitor != null && this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private TOOLCHAIN getCurrToolchain() {
        TOOLCHAIN result = TOOLCHAIN.GCC;
        SmartBuildInterface sbi = SmartBuildInterface.getInstance();
        String targetID = NativeCoreConfigurationManager.getBuildTargetName((IConfiguration)this.config);
        String toolchainID = sbi.getToolchainIDFromTargetID(targetID);
        try {
            String toolchainName = sbi.getToolchianNameFromToolchainID(toolchainID);
            if (toolchainName != null && toolchainName.contains("LLVM")) {
                result = toolchainName.equals("LLVM-3.6") ? TOOLCHAIN.LLVM36 : TOOLCHAIN.LLVM34;
            }
        }
        catch (SBIException e) {
            e.printStackTrace();
        }
        return result;
    }

    private boolean isUsingLLVMToolchain() {
        if (this.CURR_TOOLCHAIN == null) {
            this.CURR_TOOLCHAIN = this.getCurrToolchain();
        }
        return this.CURR_TOOLCHAIN == TOOLCHAIN.LLVM36 || this.CURR_TOOLCHAIN == TOOLCHAIN.LLVM34;
    }

    private void outputCommentLine(StringBuffer buffer) {
        int i = 0;
        while (i < 80) {
            buffer.append("#");
            ++i;
        }
        buffer.append(NEWLINE);
    }

    private StringBuffer addDefaultHeader() {
        StringBuffer buffer = new StringBuffer();
        this.outputCommentLine(buffer);
        buffer.append(String.format("# Automatically-generated file. Do not edit!\n", new Object[0]));
        this.outputCommentLine(buffer);
        buffer.append(NEWLINE);
        return buffer;
    }

    private IPath getPathForResource(IResource resource) {
        return new Path(resource.getLocationURI().getPath());
    }

    private IPath getRelativePathForResource(IPath path) {
        if (this.projectDir.isPrefixOf(path)) {
            path = DOT_DOT_SLASH_PATH.append(path.makeRelativeTo(this.projectDir));
        }
        return path;
    }

    private ITool getToolFromResource(IResource resource) {
        IResourceInfo rcInfo = this.config.getResourceInfo(resource.getProjectRelativePath(), false);
        if (rcInfo instanceof IFileInfo) {
            IFileInfo fi = (IFileInfo)rcInfo;
            ITool[] tools = fi.getToolsToInvoke();
            if (tools != null && tools.length > 0) {
                return tools[0];
            }
        } else {
            IFolderInfo foInfo = (IFolderInfo)rcInfo;
            return foInfo.getToolFromInputExtension(resource.getFileExtension());
        }
        return null;
    }

    public String escapeWhitespacesInPath(String path) {
        String[] segments = (path = path.replace(":", "$:")).split("\\s");
        if (segments.length > 1) {
            StringBuffer escapedPath = new StringBuffer();
            int index = 0;
            while (index < segments.length) {
                escapedPath.append(segments[index]);
                if (index + 1 < segments.length) {
                    escapedPath.append("$ ");
                }
                ++index;
            }
            return escapedPath.toString().trim();
        }
        return path;
    }

    public boolean containsSpecialCharacters(String path) {
        return path.matches(".*(\\s|[\\{\\}\\(\\)\\$\\@%=;]).*");
    }

    private IPath resolvePercent(IPath outPath, IPath sourceLocation) {
        String fileName = sourceLocation.removeFileExtension().lastSegment();
        String outName = outPath.toOSString().replaceAll("%", fileName);
        IPath result = Path.fromOSString((String)outName);
        return DOT_SLASH_PATH.isPrefixOf(outPath) ? DOT_SLASH_PATH.append(result) : result;
    }

    private IPath calculateOutputsForSource(ITool tool, IPath relativePath, IResource resource, IPath sourceLocation) {
        IOutputType[] outTypes;
        String inExt = sourceLocation.getFileExtension();
        String outPrefix = tool != null ? tool.getOutputPrefix() : EMPTY_STRING;
        String outExt = tool != null ? tool.getOutputExtension(inExt) : EMPTY_STRING;
        IOutputType[] iOutputTypeArray = outTypes = tool != null ? tool.getOutputTypes() : null;
        if (outTypes == null || outTypes.length == 0) {
            IPath outPath = relativePath.append(String.valueOf(outPrefix) + "%");
            outPath = outPath.addFileExtension(outExt);
            return this.resolvePercent(outPath, sourceLocation);
        }
        IOutputType[] iOutputTypeArray2 = outTypes;
        int n = outTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IOutputType type = iOutputTypeArray2[n2];
            boolean primaryOutput = type == tool.getPrimaryOutputType();
            String outputPrefix = type.getOutputPrefix();
            try {
                outputPrefix = ManagedBuildManager.getBuildMacroProvider().resolveValue(outputPrefix, EMPTY_STRING, " ", 3, (Object)this.config);
            }
            catch (BuildMacroException e) {
                e.printStackTrace();
            }
            boolean multOfType = type.getMultipleOfType();
            IOption option = tool.getOptionBySuperClassId(type.getOptionId());
            IManagedOutputNameProvider nameProvider = type.getNameProvider();
            String[] outputNames = type.getOutputNames();
            if (option != null) {
                try {
                    int j;
                    List<String> outputList = new ArrayList<String>();
                    int optType = option.getValueType();
                    if (optType == 2) {
                        outputList.add(String.valueOf(outputPrefix) + option.getStringValue());
                    } else if (optType == 3 || optType == 6 || optType == 7 || optType == 8 || optType == 9 || optType == 10 || optType == 11) {
                        outputList = (List)option.getValue();
                        ((Tool)tool).filterValues(optType, outputList);
                        if (outputPrefix.length() > 0) {
                            j = 0;
                            while (j < outputList.size()) {
                                outputList.set(j, String.valueOf(outputPrefix) + (String)outputList.get(j));
                                ++j;
                            }
                        }
                    }
                    j = 0;
                    while (j < outputList.size()) {
                        String outputName = this.resolveValueInfileContext((String)outputList.get(j), sourceLocation, option, tool);
                        IPath outPath = Path.fromOSString((String)outputName);
                        if (outPath.segmentCount() == 1) {
                            outPath = relativePath.append((String)outputList.get(j));
                        }
                        if (primaryOutput) {
                            return this.resolvePercent(outPath, sourceLocation);
                        }
                        ++j;
                    }
                }
                catch (BuildException ex) {
                    ex.printStackTrace();
                }
            } else if (nameProvider != null) {
                IPath[] inPaths = new IPath[]{sourceLocation};
                if (nameProvider instanceof POBuildProvider) {
                    ((POBuildProvider)nameProvider).setProject(this.project);
                }
                IPath[] outPaths = nameProvider.getOutputNames(tool, inPaths);
                int j = 0;
                while (j < outPaths.length) {
                    IPath outPath = outPaths[j];
                    if (outPath.segmentCount() == 1) {
                        outPath = relativePath.append(outPath.toString());
                    }
                    if (primaryOutput) {
                        return this.resolvePercent(outPath, sourceLocation);
                    }
                    ++j;
                }
            } else if (outputNames != null) {
                int j = 0;
                while (j < outputNames.length) {
                    String outputName = this.resolveValueInfileContext(outputNames[j], sourceLocation, option, tool);
                    IPath outPath = Path.fromOSString((String)outputName);
                    if (outPath.segmentCount() == 1) {
                        outPath = relativePath.append(outPath.toString());
                    }
                    if (primaryOutput) {
                        return this.resolvePercent(outPath, sourceLocation);
                    }
                    ++j;
                }
            } else if (!multOfType) {
                String namePattern = type.getNamePattern();
                IPath namePatternPath = null;
                if (namePattern == null || namePattern.length() == 0) {
                    namePattern = String.valueOf(outputPrefix) + "%";
                    if (outExt != null && outExt.length() > 0) {
                        namePattern = String.valueOf(namePattern) + "." + outExt;
                    }
                    namePatternPath = relativePath.append(namePattern);
                } else {
                    if (outputPrefix.length() > 0) {
                        namePattern = String.valueOf(outputPrefix) + namePattern;
                    }
                    if ((namePatternPath = Path.fromOSString((String)namePattern)).segmentCount() == 1) {
                        namePatternPath = relativePath.append(namePatternPath);
                    }
                }
                if (primaryOutput) {
                    return this.resolvePercent(namePatternPath, sourceLocation);
                }
            }
            ++n2;
        }
        return null;
    }

    private String resolveValueInfileContext(String inStr, IPath sourceLocation, IOption option, ITool tool) {
        try {
            String resolved = ManagedBuildManager.getBuildMacroProvider().resolveValue(inStr, EMPTY_STRING, " ", 1, (Object)new FileContextData(sourceLocation, null, option, (IBuildObject)tool));
            resolved = resolved.trim();
            if (resolved.length() > 0) {
                return resolved;
            }
        }
        catch (BuildMacroException e) {
            e.printStackTrace();
        }
        return inStr;
    }

    private String expandBuildSteps(String buildStep) {
        try {
            buildStep = ManagedBuildManager.getBuildMacroProvider().resolveValue(buildStep, EMPTY_STRING, " ", 3, (Object)this.config);
        }
        catch (BuildMacroException e) {
            e.printStackTrace();
        }
        return this.expandEnvVariables(buildStep).trim();
    }

    public boolean isGeneratedResource(IResource resource) {
        String[] configNames;
        IPath path = resource.getProjectRelativePath();
        IPath saPath = this.getSaReportDir();
        String[] stringArray = configNames = ManagedBuildManager.getBuildInfo((IResource)this.project).getConfigurationNames();
        int n = configNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Path root = new Path(name);
            if (root.isPrefixOf(path) || root.isPrefixOf(saPath)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public IPath getBuildWorkingDir() {
        if (this.topBuildDir != null) {
            return this.topBuildDir.removeFirstSegments(1);
        }
        return null;
    }

    private IPath getSaReportDir() {
        return this.getPathForResource((IResource)this.project).append(DIR_SA_REPORT);
    }

    private IPath getCovReportDir() {
        return this.getPathForResource((IResource)this.project).append(DIR_COV_REPORT);
    }

    private String getSaCheckers() {
        return TizenSAProperty.getSaCheckers((IProject)this.project);
    }

    public IPath getTopBuildDir() {
        return this.getPathForResource((IResource)this.project).append(this.getBuildWorkingDir());
    }

    public String getMakefileName() {
        return new String(NINJA_BUILD_FILE);
    }

    public String getSubNinjafileName() {
        return new String(SUBNINJA_BUILD_FILE);
    }

    private IPath createDirectory(String dirName) throws CoreException {
        IFolder parent;
        IFolder folder = this.project.getFolder(dirName);
        if (folder.exists()) {
            return folder.getFullPath();
        }
        IPath parentPath = new Path(dirName).removeLastSegments(1);
        if (!parentPath.isEmpty() && !(parent = this.project.getFolder(parentPath)).exists()) {
            this.createDirectory(parentPath.toString());
        }
        try {
            folder.create(true, true, null);
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                folder.refreshLocal(0, null);
            }
            throw e;
        }
        if (!folder.isDerived()) {
            folder.setDerived(true, this.monitor);
        }
        return folder.getFullPath();
    }

    private IFile createFile(IPath makefilePath) throws CoreException {
        IWorkspaceRoot root = CCorePlugin.getWorkspace().getRoot();
        IFile newFile = root.getFileForLocation(makefilePath);
        if (newFile == null) {
            newFile = root.getFile(makefilePath);
        }
        ByteArrayInputStream contents = new ByteArrayInputStream(new byte[0]);
        try {
            newFile.create((InputStream)contents, false, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
            if (!newFile.isDerived()) {
                newFile.setDerived(true, this.monitor);
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                newFile.refreshLocal(0, null);
            }
            throw e;
        }
        return newFile;
    }

    private void saveFile(StringBuffer buffer, IFile file) throws CoreException {
        ByteArrayInputStream stream = new ByteArrayInputStream(buffer.toString().getBytes());
        file.setContents((InputStream)stream, true, false, null);
    }

    private void copyFile(String from, String to) throws IOException {
        FileInputStream input = null;
        OutputStream output = null;
        try {
            int bytesRead;
            input = new FileInputStream(from);
            output = new FileOutputStream(to);
            byte[] buf = new byte[1024];
            while ((bytesRead = ((InputStream)input).read(buf)) > 0) {
                output.write(buf, 0, bytesRead);
            }
        }
        finally {
            if (input != null) {
                ((InputStream)input).close();
            }
            if (output != null) {
                output.close();
            }
        }
    }

    private String joinArrayString(String arrayStr, String delim) {
        return arrayStr.replaceAll("[\\[\\]]", EMPTY_STRING).replaceAll(", ", delim);
    }

    class NinjaBuildDB {
        private final HashMap<NinjaToolData, ArrayList<NinjaFileData>> ninjaDB = new HashMap();
        private final StringBuffer CompDbBuffer = new StringBuffer();

        NinjaBuildDB() {
        }

        public void UpdateCompDbAndClear() {
            this.CompDbBuffer.append(this.toCompDBEntries());
            this.ninjaDB.clear();
        }

        public void put(ITool tool, IPath inFile, IPath outFile) {
            NinjaToolData key = new NinjaToolData(tool, inFile, outFile);
            NinjaFileData value = new NinjaFileData(inFile, outFile);
            ArrayList<NinjaFileData> valueList = this.ninjaDB.get(key);
            if (valueList == null) {
                valueList = new ArrayList();
                valueList.add(value);
                this.ninjaDB.put(key, valueList);
            } else {
                valueList.add(value);
            }
        }

        public void put(IContainer module, boolean clearOldData) throws CoreException {
            if (clearOldData) {
                this.UpdateCompDbAndClear();
            }
            IResource[] iResourceArray = module.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITool tool;
                IResource resource = iResourceArray[n2];
                if (resource.getType() == 1 && NativeCoreNinjaFileGenerator.this.isSource(resource.getProjectRelativePath()) && (tool = NativeCoreNinjaFileGenerator.this.getToolFromResource(resource)) != null) {
                    IPath inputFile = NativeCoreNinjaFileGenerator.this.getPathForResource(resource);
                    IPath moduleRelativePath = module.getProjectRelativePath();
                    IPath outputFile = NativeCoreNinjaFileGenerator.this.calculateOutputsForSource(tool, moduleRelativePath, resource, inputFile);
                    if (outputFile == null) {
                        String outputFileName = inputFile.removeFileExtension().lastSegment();
                        outputFile = moduleRelativePath.append(outputFileName);
                        if (tool != null) {
                            String outExt = tool.getOutputExtension(inputFile.getFileExtension());
                            outputFile = outputFile.addFileExtension(outExt);
                        }
                    }
                    inputFile = NativeCoreNinjaFileGenerator.this.getRelativePathForResource(inputFile);
                    outputFile = NativeCoreNinjaFileGenerator.this.getRelativePathForResource(outputFile);
                    this.put(tool, inputFile, outputFile);
                }
                ++n2;
            }
        }

        public StringBuffer toCompDBEntries() {
            StringBuffer buf = new StringBuffer();
            for (Map.Entry<NinjaToolData, ArrayList<NinjaFileData>> entry : this.ninjaDB.entrySet()) {
                NinjaToolData tool = entry.getKey();
                for (NinjaFileData data : entry.getValue()) {
                    buf.append(data.toCompDbEntry(tool));
                }
            }
            return buf;
        }

        public StringBuffer toStringBuffer() {
            StringBuffer buf = new StringBuffer();
            Vector<String> ruleList = new Vector<String>();
            Vector<String> toolList = new Vector<String>();
            for (Map.Entry<NinjaToolData, ArrayList<NinjaFileData>> entry : this.ninjaDB.entrySet()) {
                String buildVars = NativeCoreNinjaFileGenerator.EMPTY_STRING;
                NinjaToolData tool = entry.getKey();
                if (toolList.contains(tool.toToolString(NativeCoreNinjaFileGenerator.EMPTY_STRING))) {
                    buildVars = tool.toFlagString("  ");
                } else if (ruleList.contains(tool.rule)) {
                    buildVars = tool.toString("  ");
                } else {
                    ruleList.add(tool.rule);
                    toolList.add(tool.toToolString(NativeCoreNinjaFileGenerator.EMPTY_STRING));
                    buf.append("\n");
                    buf.append(tool.toString(NativeCoreNinjaFileGenerator.EMPTY_STRING));
                }
                for (NinjaFileData data : entry.getValue()) {
                    buf.append(data.toBuildRuleEntry(tool, buildVars));
                }
            }
            return buf;
        }

        public void writeToNinjaFile(IContainer subdir) throws CoreException {
            IFile subNinjaFile = NativeCoreNinjaFileGenerator.this.getNinjaFile(subdir);
            NativeCoreNinjaFileGenerator.this.populateNinjafile(subNinjaFile, this.toStringBuffer());
            NativeCoreNinjaFileGenerator.this.SubNinjaFiles.add(DOT_DOT_SLASH_PATH.append(subNinjaFile.getProjectRelativePath()).toString());
        }

        public void writeCompDBFile() throws CoreException {
            StringBuffer compDb = new StringBuffer();
            compDb.append("[\n").append(this.CompDbBuffer).append("]\n");
            IFile compDBFile = NativeCoreNinjaFileGenerator.this.getNinjaFile(NativeCoreNinjaFileGenerator.COMP_DB_FILE);
            NativeCoreNinjaFileGenerator.this.populateNinjafile(compDBFile, compDb);
        }
    }

    class NinjaFileData {
        String inExt;
        String inFile;
        String outFile;

        NinjaFileData(IPath inputFile, IPath outputFile) {
            this.inExt = inputFile.getFileExtension();
            this.inFile = inputFile.toString();
            if (inputFile.isAbsolute()) {
                this.inFile = this.inFile.replace(" ", "$ ");
            }
            this.outFile = outputFile.toString();
        }

        NinjaFileData(String ext, String inputFile, String outputFile) {
            this.inExt = ext;
            this.inFile = inputFile;
            this.outFile = outputFile;
        }

        public String escapeForCompDB(String inStr) {
            return inStr.replace("\"", "\\\"");
        }

        public StringBuffer toCompDbEntry(NinjaToolData tool) {
            StringBuffer buf = new StringBuffer();
            buf.append(String.format(NativeCoreNinjaFileGenerator.compDBFmt, this.escapeForCompDB(NativeCoreNinjaFileGenerator.this.buildDir), tool.cmd, this.escapeForCompDB(tool.flags), this.inFile, this.inFile));
            return buf;
        }

        public StringBuffer toBuildRuleEntry(NinjaToolData tool, String buildVars) {
            String in = this.escapeWhitespacesInPath(this.inFile);
            String out = this.escapeWhitespacesInPath(this.outFile);
            String rule = tool.getNinjaBuildRule(in.length());
            StringBuffer buf = new StringBuffer();
            String deps = NativeCoreNinjaFileGenerator.EMPTY_STRING;
            if (NativeCoreNinjaFileGenerator.this.hasPrebuildStep) {
                deps = String.valueOf(deps) + " || pre-build";
            }
            buf.append(String.format(NativeCoreNinjaFileGenerator.buildRuleFmt, out, rule, in, deps, buildVars));
            if (this.isSourceFile()) {
                if (NativeCoreNinjaFileGenerator.this.needPchFile) {
                    deps = String.valueOf(String.format(" | %s", NativeCoreNinjaFileGenerator.this.pchOutFile)) + deps;
                }
                if (NativeCoreNinjaFileGenerator.this.isUsingLlvm) {
                    String astFile = String.valueOf(out) + ".ast";
                    String apicheckerFile = String.valueOf(out) + ".txt";
                    if (NativeCoreNinjaFileGenerator.this.CURR_TOOLCHAIN == TOOLCHAIN.LLVM36) {
                        String extFnDep = "|| externalFnMap.txt";
                        String saFile = "$sareportdir/" + out + ".xml";
                        String coverageFile = "$coveragedir/" + out + ".cov";
                        buf.append(String.format(NativeCoreNinjaFileGenerator.buildRuleFmt, astFile, String.valueOf(rule) + "_fast_ast", in, deps, buildVars));
                        buf.append(String.format(NativeCoreNinjaFileGenerator.buildRuleFmt, saFile, String.valueOf(rule) + "_fast_sa", astFile, extFnDep, NativeCoreNinjaFileGenerator.EMPTY_STRING));
                        buf.append(String.format(NativeCoreNinjaFileGenerator.buildRuleFmt, apicheckerFile, String.valueOf(rule) + "_api", in, deps, buildVars));
                        buf.append(String.format(NativeCoreNinjaFileGenerator.buildRuleFmt, coverageFile, "cov", in, deps, buildVars));
                    } else if (NativeCoreNinjaFileGenerator.this.CURR_TOOLCHAIN == TOOLCHAIN.LLVM34) {
                        String extFnDep = "| extfn";
                        String fnFile = String.valueOf(out) + ".fn";
                        String saFile = String.valueOf(out) + ".sa";
                        String coverageFile = "$coveragedir/" + out + ".cov";
                        buf.append(String.format(NativeCoreNinjaFileGenerator.buildRuleFmt, astFile, String.valueOf(rule) + "_ast", in, deps, buildVars));
                        buf.append(String.format(NativeCoreNinjaFileGenerator.buildRuleFmt, fnFile, String.valueOf(rule) + "_fn", astFile, NativeCoreNinjaFileGenerator.EMPTY_STRING, NativeCoreNinjaFileGenerator.EMPTY_STRING));
                        buf.append(String.format(NativeCoreNinjaFileGenerator.buildRuleFmt, saFile, String.valueOf(rule) + "_sa", in, extFnDep, buildVars));
                        buf.append(String.format(NativeCoreNinjaFileGenerator.buildRuleFmt, apicheckerFile, String.valueOf(rule) + "_api", in, deps, buildVars));
                        buf.append(String.format(NativeCoreNinjaFileGenerator.buildRuleFmt, coverageFile, "cov", in, deps, buildVars));
                    }
                }
                NativeCoreNinjaFileGenerator.this.ObjFiles.add(out);
            } else if (this.inExt.equals("target")) {
                if (NativeCoreNinjaFileGenerator.this.isUsingLlvm) {
                    List<String> inList = Arrays.asList(in.split(" "));
                    String astList = String.valueOf(NativeCoreNinjaFileGenerator.this.joinArrayString(inList.toString(), ".ast ")) + ".ast";
                    String apicheckerList = String.valueOf(NativeCoreNinjaFileGenerator.this.joinArrayString(inList.toString(), ".txt ")) + ".txt";
                    buf.append(String.format("build ast: phony %s\n", astList));
                    if (NativeCoreNinjaFileGenerator.this.CURR_TOOLCHAIN == TOOLCHAIN.LLVM36) {
                        String xmlList = "$sareportdir/" + NativeCoreNinjaFileGenerator.this.joinArrayString(inList.toString(), ".xml \\$sareportdir/") + ".xml";
                        String coverageList = "$coveragedir/" + NativeCoreNinjaFileGenerator.this.joinArrayString(inList.toString(), ".cov \\$coveragedir/") + ".cov";
                        buf.append(String.format("build externalFnMap.txt: fast_ext_fn %s\n", astList));
                        buf.append(String.format("build sa: phony %s\n", xmlList));
                        buf.append(String.format("build apichecker: unusedapi_rule %s\n", apicheckerList));
                        buf.append(String.format("build cov: cov_report %s\n", coverageList));
                    } else if (NativeCoreNinjaFileGenerator.this.CURR_TOOLCHAIN == TOOLCHAIN.LLVM34) {
                        String fnList = String.valueOf(NativeCoreNinjaFileGenerator.this.joinArrayString(inList.toString(), ".fn ")) + ".fn";
                        String saList = String.valueOf(NativeCoreNinjaFileGenerator.this.joinArrayString(inList.toString(), ".sa ")) + ".sa";
                        String coverageList = "$coveragedir/" + NativeCoreNinjaFileGenerator.this.joinArrayString(inList.toString(), ".cov \\$coveragedir/") + ".cov";
                        buf.append(String.format("build fn: phony %s\n", fnList));
                        buf.append(String.format("build extfn: ext_fn %s | clean_sa ast\n", fnList));
                        buf.append(String.format("build sa: phony %s\n", saList));
                        buf.append(String.format("build apichecker: unusedapi_rule %s\n", apicheckerList));
                        buf.append(String.format("build coverage: cov_report %s\n", coverageList));
                    }
                }
                if (NativeCoreNinjaFileGenerator.this.ResFiles.size() > 0) {
                    buf.append(String.format("build res: phony %s\n", NativeCoreNinjaFileGenerator.this.joinArrayString(NativeCoreNinjaFileGenerator.this.ResFiles.toString(), " ")));
                }
            } else {
                NativeCoreNinjaFileGenerator.this.ResFiles.add(out);
            }
            return buf;
        }

        public boolean isSourceFile() {
            return C_SRC_EXTS.contains(this.inExt) || CPP_SRC_EXTS.contains(this.inExt);
        }

        public String escapeWhitespacesInPath(String path) {
            path = path.replace(":", "$:");
            return path;
        }
    }

    class NinjaToolData {
        String rule = "";
        String cmd = "";
        String flags = "";
        String expFlags = null;

        NinjaToolData(String inExt, String toolCmd, String toolFlags) {
            this.rule = this.getRule(inExt);
            this.cmd = toolCmd;
            this.flags = toolFlags;
            this.expFlags = null;
        }

        String getToolFlags(ITool tool, String[] flags) {
            IManagedCommandLineInfo cmdLInfo;
            String toolFlags = NativeCoreNinjaFileGenerator.EMPTY_STRING;
            IManagedCommandLineGenerator gen = tool.getCommandLineGenerator();
            if (gen != null && (cmdLInfo = gen.generateCommandLineInfo(tool, NativeCoreNinjaFileGenerator.EMPTY_STRING, flags, NativeCoreNinjaFileGenerator.EMPTY_STRING, NativeCoreNinjaFileGenerator.EMPTY_STRING, NativeCoreNinjaFileGenerator.EMPTY_STRING, EMPTY_STRING_ARRAY, tool.getCommandLinePattern())) != null) {
                toolFlags = cmdLInfo.getCommandLine();
            }
            return toolFlags;
        }

        NinjaToolData(ITool tool, IPath inFile, IPath outFile) {
            this.rule = this.getRule(inFile.getFileExtension());
            this.cmd = tool.getToolCommand();
            try {
                Object[] cmdFlags = tool.getToolCommandFlags(inFile, outFile);
                this.flags = this.getToolFlags(tool, (String[])cmdFlags);
                if (this.flags.isEmpty()) {
                    this.flags = Arrays.toString(cmdFlags);
                }
            }
            catch (BuildException buildException) {
                this.flags = NativeCoreNinjaFileGenerator.EMPTY_STRING;
            }
            this.expFlags = null;
        }

        public String getRule(String ext) {
            if (CPP_SRC_EXTS.contains(ext)) {
                return "cpp";
            }
            if (C_SRC_EXTS.contains(ext)) {
                return NativeCoreNinjaFileGenerator.C_FILE_EXT;
            }
            return ext;
        }

        public String toToolString(String indent) {
            return String.format(NativeCoreNinjaFileGenerator.buildToolVarFmt, indent, this.rule, this.cmd);
        }

        public String toRuleString(String indent) {
            return String.format(NativeCoreNinjaFileGenerator.buildToolVarFmt, indent, this.rule, NativeCoreNinjaFileGenerator.EMPTY_STRING);
        }

        public String toFlagString(String indent) {
            return String.format(NativeCoreNinjaFileGenerator.buildFlagVarFmt, indent, this.rule, this.getExpandedBuildFlags());
        }

        public String toString(String indent) {
            return String.format(NativeCoreNinjaFileGenerator.buildVarFmt, indent, this.rule, this.cmd, indent, this.rule, this.getExpandedBuildFlags());
        }

        public int hashCode() {
            return this.rule.hashCode() ^ this.cmd.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof NinjaToolData) {
                NinjaToolData other = (NinjaToolData)o;
                return this.rule.equals(other.rule) && this.cmd.equals(other.cmd) && this.flags.equals(other.flags);
            }
            return false;
        }

        public String getExpandedBuildFlags() {
            if (this.expFlags == null) {
                this.expFlags = NativeCoreNinjaFileGenerator.this.expandEnvVariables(NativeCoreNinjaFileGenerator.this.joinArrayString(this.flags, " "));
            }
            return this.expFlags;
        }

        public String getNinjaBuildRule(int cmdLenWithoutFlags) {
            boolean isLongCmd = NativeCoreNinjaFileGenerator.this.isOSWindows ? this.flags.length() + cmdLenWithoutFlags > 30000 : false;
            return isLongCmd ? "long_" + this.rule : this.rule;
        }
    }

    protected class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private boolean isChanged;
        private final IConfiguration config;
        private final NativeCoreNinjaFileGenerator generator;

        public ResourceDeltaVisitor(NativeCoreNinjaFileGenerator generator, IManagedBuildInfo info) {
            this.generator = generator;
            this.config = info.getDefaultConfiguration();
            this.isChanged = false;
        }

        public ResourceDeltaVisitor(NativeCoreNinjaFileGenerator generator, IConfiguration cfg) {
            this.generator = generator;
            this.config = cfg;
            this.isChanged = false;
        }

        public boolean isResourceChanged() {
            return this.isChanged;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (this.generator == null) {
                return false;
            }
            IResource resource = delta.getResource();
            if (!NativeCoreNinjaFileGenerator.this.isSource(resource.getProjectRelativePath())) {
                if (resource.getType() == 4) {
                    IResourceDelta[] children = delta.getAffectedChildren();
                    if (children == null || children.length == 0) {
                        return false;
                    }
                } else if (resource.getType() == 1) {
                    if ((delta.getKind() == 4 || delta.getKind() == 2) && resource.getFileExtension().equals("ninja")) {
                        this.isChanged = true;
                    }
                    return false;
                }
                return true;
            }
            switch (resource.getType()) {
                default: {
                    return true;
                }
                case 1: {
                    if (!(delta.getKind() != 1 && delta.getKind() != 2 || this.generator.isGeneratedResource(resource))) {
                        IFolderInfo fo = null;
                        IResourceInfo rcInfo = this.config.getResourceInfo(resource.getProjectRelativePath(), false);
                        if (rcInfo instanceof IFolderInfo) {
                            fo = (IFolderInfo)rcInfo;
                        }
                        String ext = resource.getFileExtension();
                        if (fo == null || fo.buildsFileType(ext)) {
                            this.isChanged = true;
                        }
                    }
                    return false;
                }
                case 2: 
            }
            return !this.generator.isGeneratedResource(resource);
        }
    }

    protected class ResourceProxyVisitor
    implements IResourceProxyVisitor {
        private final NativeCoreNinjaFileGenerator generator;
        private final IConfiguration config;

        public ResourceProxyVisitor(NativeCoreNinjaFileGenerator generator, IManagedBuildInfo info) {
            this.generator = generator;
            this.config = info.getDefaultConfiguration();
        }

        public ResourceProxyVisitor(NativeCoreNinjaFileGenerator generator, IConfiguration cfg) {
            this.generator = generator;
            this.config = cfg;
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            if (this.generator == null) {
                return false;
            }
            IResource resource = proxy.requestResource();
            if (!NativeCoreNinjaFileGenerator.this.isSource(resource.getProjectRelativePath())) {
                return false;
            }
            switch (proxy.getType()) {
                default: {
                    return true;
                }
                case 1: {
                    IResourceInfo rcInfo = this.config.getResourceInfo(resource.getProjectRelativePath(), false);
                    if (!(rcInfo instanceof IFolderInfo) || ((IFolderInfo)rcInfo).buildsFileType(resource.getFileExtension())) {
                        this.generator.appendBuildSubdirectory(resource);
                    }
                    return false;
                }
                case 2: 
            }
            return !this.generator.isGeneratedResource(resource);
        }
    }

    private static enum TOOLCHAIN {
        GCC,
        LLVM34,
        LLVM35,
        LLVM36;

    }
}

