/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.launch.ui.shortcut;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.internal.ui.launch.CApplicationLaunchShortcut;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.gom.launch.GomLaunchData;
import org.tizen.common.gom.launch.IGomSmartLaunchShortcut;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.ViewUtil;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.launch.LaunchUtils;
import org.tizen.nativecommon.launch.TizenLaunchConfiguration;
import org.tizen.nativecommon.launch.TizenLaunchMessages;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.util.ArrayUtil;

public class TizenLaunchShortcut
extends CApplicationLaunchShortcut
implements IGomSmartLaunchShortcut {
    private final Logger logger = LoggerFactory.getLogger(TizenLaunchShortcut.class);
    public static final String GDBINIT = ".gdbinit";

    public void launch(IEditorPart editor, String mode) {
        this.searchAndLaunch(new Object[]{editor.getEditorInput()}, mode);
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            this.searchAndLaunch(((IStructuredSelection)selection).toArray(), mode);
        }
    }

    protected void searchAndLaunch(Object[] elements, String mode) {
        if (ArrayUtil.isEmpty((Object[])elements)) {
            MessageDialog.openError((Shell)SWTUtil.getShell(), (String)TizenLaunchMessages.LAUNCH_ERROR, (String)TizenLaunchMessages.PROJECT_NOT_SELECTED);
            return;
        }
        IBinary bin = null;
        if (elements.length == 1 && elements[0] instanceof IBinary) {
            bin = (IBinary)elements[0];
        } else {
            ArrayList<IBinary> results = new ArrayList<IBinary>();
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(SWTUtil.getShell());
            BinarySearcher runnable = new BinarySearcher(elements, results);
            try {
                dialog.run(false, true, (IRunnableWithProgress)runnable);
            }
            catch (InterruptedException interruptedException) {
                MessageDialog.openError((Shell)SWTUtil.getShell(), (String)TizenLaunchMessages.LAUNCH_ERROR, (String)"Interrupted");
                return;
            }
            catch (InvocationTargetException invocationTargetException) {
                MessageDialog.openError((Shell)SWTUtil.getShell(), (String)TizenLaunchMessages.LAUNCH_ERROR, (String)"InvocationTarget");
                return;
            }
            int count = results.size();
            if (count > 1) {
                bin = this.chooseBinary(results, mode);
                if (bin == null) {
                    MessageDialog.openError((Shell)SWTUtil.getShell(), (String)TizenLaunchMessages.LAUNCH_ERROR, (String)TizenLaunchMessages.NO_SELECT_BINARY);
                }
            } else if (count == 1) {
                bin = (IBinary)results.get(0);
            }
        }
        this.launch(bin, mode);
    }

    protected ILaunchConfiguration findLaunchConfiguration(IBinary bin, String mode) {
        IDevice device = LaunchUtils.getCurrentDeployDevice();
        if (device == null) {
            MessageDialog.openError((Shell)SWTUtil.getShell(), (String)TizenLaunchMessages.LAUNCH_ERROR, (String)TizenLaunchMessages.NO_TARGET);
            return null;
        }
        if (bin == null) {
            Object[] obj;
            ISelection selection;
            IWorkbenchWindow workbenchWindow = ViewUtil.getWorkbenchWindow();
            if (workbenchWindow != null && workbenchWindow.getSelectionService() != null && (selection = workbenchWindow.getSelectionService().getSelection()) instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).toArray()).length == 1) {
                IProject project = (IProject)obj[0];
                return this.createConfiguration(project);
            }
            MessageDialog.openError((Shell)SWTUtil.getShell(), (String)TizenLaunchMessages.LAUNCH_ERROR, (String)TizenLaunchMessages.PROJECT_NOT_FOUND);
            return null;
        }
        ILaunchConfiguration configuration = null;
        ILaunchConfigurationType configType = this.getCLaunchConfigType();
        List candidateConfigs = Collections.emptyList();
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            candidateConfigs = new ArrayList(configs.length);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                String config_device_id = config.getAttribute("org.tizen.common.launch.device.id", "");
                String device_id = LaunchUtils.getDeviceId(device);
                IPath programPath = CDebugUtils.getProgramPath((ILaunchConfiguration)config);
                String projectName = CDebugUtils.getProjectName((ILaunchConfiguration)config);
                IPath name = bin.getResource().getProjectRelativePath();
                if (programPath != null && programPath.equals((Object)name) && projectName != null && projectName.equals(bin.getCProject().getProject().getName()) && config_device_id.equals(device_id)) {
                    candidateConfigs.add(config);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            CDebugUIPlugin.log((Throwable)e);
        }
        int candidateCount = candidateConfigs.size();
        configuration = candidateCount < 1 ? this.createConfiguration(bin, mode) : (candidateCount == 1 ? (ILaunchConfiguration)candidateConfigs.get(0) : (ILaunchConfiguration)candidateConfigs.get(0));
        return configuration;
    }

    protected void setStopAtMain(ILaunchConfigurationWorkingCopy configuration, IProject proj) {
        LaunchUtils.setStopAtMain(configuration, proj);
    }

    private ILaunchConfiguration createConfiguration(IBinary bin, String mode) {
        ILaunchConfiguration config = null;
        try {
            String projectName = bin.getResource().getProjectRelativePath().toString();
            ILaunchConfigurationType configType = this.getCLaunchConfigType();
            IDevice device = LaunchUtils.getCurrentDeployDevice();
            IProject project = bin.getCProject().getProject();
            String configName = ProjectUtil.getLaunchConfigurationName(project);
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.getLaunchManager().generateLaunchConfigurationName(configName));
            TizenLaunchConfiguration tc = new TizenLaunchConfiguration(wc, device);
            tc.setDefaults();
            String gdbInitPath = this.getGDBInitPath(project);
            wc.setAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, gdbInitPath);
            wc.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", projectName);
            wc.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", bin.getCProject().getElementName());
            wc.setMappedResources(new IResource[]{bin.getResource().getProject()});
            wc.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", "");
            wc.setAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", "org.tizen.nativecommon.launch.TizenDebugger");
            this.setStopAtMain(wc, project);
            ICProjectDescription projDes = CCorePlugin.getDefault().getProjectDescription(bin.getCProject().getProject());
            if (projDes != null) {
                String buildConfigID = projDes.getActiveConfiguration().getId();
                wc.setAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", buildConfigID);
                String buildConfigName = projDes.getActiveConfiguration().getName();
                wc.setAttribute("org.tizen.nativeapp.launch.PROJECT_BUILD_CONFIG_NAME_ATTR", buildConfigName);
                LaunchUtils.setDeviceToLaunchConfiguration(wc, device);
            }
            config = wc.doSave();
        }
        catch (CoreException ce) {
            CDebugUIPlugin.log((Throwable)ce);
        }
        return config;
    }

    private ILaunchConfiguration createConfiguration(IProject prj) {
        ILaunchConfiguration config = this.createConfiguration(prj, ProjectUtil.getLaunchConfigurationName(prj));
        return config;
    }

    protected ILaunchConfiguration createConfiguration(GomLaunchData data) {
        ILaunchConfiguration config = this.createConfiguration(data.getProject(), data.getLaunchConfigurationName());
        return config;
    }

    private ILaunchConfiguration createConfiguration(IProject prj, String configName) {
        ILaunchConfiguration config = null;
        IDevice device = LaunchUtils.getCurrentDeployDevice();
        try {
            String projectName = prj.getName();
            ILaunchConfigurationType configType = this.getCLaunchConfigType();
            IProject project = prj;
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.getLaunchManager().generateLaunchConfigurationName(configName));
            TizenLaunchConfiguration tc = new TizenLaunchConfiguration(wc, device);
            tc.setDefaults();
            String gdbInitPath = this.getGDBInitPath(project);
            String programName = String.valueOf(ProjectUtil.getDefaultConfiguration(prj).getName()) + File.separatorChar + ProjectUtil.getBinaryName(prj);
            wc.setAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, gdbInitPath);
            wc.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", programName);
            wc.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", projectName);
            wc.setMappedResources(new IResource[]{prj});
            wc.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", "");
            wc.setAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", "org.tizen.nativecommon.launch.TizenDebugger");
            this.setStopAtMain(wc, project);
            ICProjectDescription projDes = CCorePlugin.getDefault().getProjectDescription(prj);
            if (projDes != null) {
                String buildConfigID = projDes.getActiveConfiguration().getId();
                wc.setAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", buildConfigID);
                String buildConfigName = projDes.getActiveConfiguration().getName();
                wc.setAttribute("org.tizen.nativeapp.launch.PROJECT_BUILD_CONFIG_NAME_ATTR", buildConfigName);
                LaunchUtils.setDeviceToLaunchConfiguration(wc, device);
            }
            config = wc.doSave();
        }
        catch (CoreException ce) {
            CDebugUIPlugin.log((Throwable)ce);
        }
        return config;
    }

    public ILaunchConfigurationType getCLaunchConfigType() {
        return this.getLaunchManager().getLaunchConfigurationType("org.tizen.nativecommon.launch.TizenLaunchConfigurationType");
    }

    public void smartLaunch(final GomLaunchData data) {
        IProject project = data.getProject();
        String buildConfiguration = data.getBuildConfiguration();
        if (buildConfiguration != null) {
            ManagedBuildManager.getBuildInfo((IResource)project).setDefaultConfiguration(data.getBuildConfiguration());
        }
        final ILaunchConfiguration configuration = this.createConfiguration(data);
        SWTUtil.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                DebugUITools.launch((ILaunchConfiguration)configuration, (String)data.getMode());
            }
        });
    }

    private String getGDBInitPath(IProject project) {
        IConfiguration config = ProjectUtil.getDefaultConfiguration(project);
        String path = String.valueOf(project.getLocation().toOSString()) + File.separatorChar + config.getName() + File.separatorChar + GDBINIT;
        return path;
    }

    class BinarySearcher
    implements IRunnableWithProgress {
        Object[] elements;
        List<IBinary> results;

        public BinarySearcher(Object[] elements, List<IBinary> results) {
            this.elements = elements;
            this.results = results;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            int nElements = this.elements.length;
            monitor.beginTask("Looking for executables", nElements);
            try {
                SubProgressMonitor sub = new SubProgressMonitor(monitor, 1);
                int i = 0;
                while (i < nElements) {
                    ICProject cproject;
                    IResource r;
                    if (this.elements[i] instanceof IAdaptable && (r = (IResource)((IAdaptable)this.elements[i]).getAdapter(IResource.class)) != null && (cproject = CoreModel.getDefault().create(r.getProject())) != null) {
                        try {
                            IBinary[] bins = cproject.getBinaryContainer().getBinaries();
                            IConfiguration config = ManagedBuildManager.getBuildInfo((IResource)r.getProject()).getDefaultConfiguration();
                            String activeBuildConfiguration = config.toString();
                            IBinary[] iBinaryArray = bins;
                            int n = bins.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String parentDirName;
                                IBinary bin = iBinaryArray[n2];
                                if ((bin.isExecutable() || bin.isSharedLib()) && (parentDirName = bin.getPath().removeLastSegments(1).lastSegment()).equals(activeBuildConfiguration)) {
                                    this.results.add(bin);
                                }
                                ++n2;
                            }
                        }
                        catch (CModelException e) {
                            TizenLaunchShortcut.this.logger.error("Failed to get binaries", (Throwable)e);
                        }
                    }
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    sub.done();
                    ++i;
                }
            }
            finally {
                monitor.done();
            }
        }
    }
}

