/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.po;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.tizen.nativecommon.po.INativeLocaleMessages;
import org.tizen.nativecommon.po.NativeLocaleMessageHandler;
import org.tizen.nativecommon.po.ResourceChangeListener;

public class NativeLocaleMessageManager {
    private static Map<IProject, NativeLocaleMessageHandler> poHandlerMap = new HashMap<IProject, NativeLocaleMessageHandler>();
    private static boolean registResourceChangeListener = false;

    public static void registResourceChangeListener() {
        if (!registResourceChangeListener) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new ResourceChangeListener(), 4);
            registResourceChangeListener = true;
        }
    }

    public static INativeLocaleMessages getLocaleMessages(IProject project) {
        NativeLocaleMessageManager.registResourceChangeListener();
        if (poHandlerMap.get(project) == null) {
            NativeLocaleMessageHandler handler = new NativeLocaleMessageHandler(project);
            handler.init();
            poHandlerMap.put(project, handler);
        }
        return poHandlerMap.get(project);
    }

    public static NativeLocaleMessageHandler getLocaleMessageHandler(IProject project) {
        NativeLocaleMessageManager.registResourceChangeListener();
        if (poHandlerMap.get(project) == null) {
            NativeLocaleMessageHandler handler = new NativeLocaleMessageHandler(project);
            handler.init();
            poHandlerMap.put(project, handler);
        }
        return poHandlerMap.get(project);
    }

    public static void removePOHandler(IProject project) {
        poHandlerMap.remove(project);
    }
}

