/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.cview;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IIncludeReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.corext.util.Strings;
import org.eclipse.cdt.internal.ui.cview.IncludeReferenceProxy;
import org.eclipse.cdt.internal.ui.language.settings.providers.LanguageSettingsImages;
import org.eclipse.cdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.cdt.internal.ui.viewsupport.CElementImageProvider;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.cdt.ui.CElementImageDescriptor;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class CViewLabelProvider
extends AppearanceAwareLabelProvider {
    public CViewLabelProvider(long textFlags, int imageFlags) {
        super(textFlags, imageFlags);
    }

    @Override
    public String getText(Object element) {
        ITranslationUnit unit;
        ICElement parent;
        if (element instanceof IncludeReferenceProxy) {
            IIncludeReference ref = ((IncludeReferenceProxy)((Object)element)).getReference();
            IPath uriPathLocation = ref.getPath().makeAbsolute();
            IContainer[] containers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(URIUtil.toURI((IPath)uriPathLocation));
            if (containers.length > 0) {
                IPath p;
                ICProject prj = ref.getCProject();
                if (prj != null) {
                    int i = 0;
                    while (i < containers.length) {
                        IContainer container = containers[i];
                        IProject project = container.getProject();
                        if (project != null && project.equals((Object)prj.getProject())) {
                            return container.getFullPath().makeRelative().toString();
                        }
                        ++i;
                    }
                }
                p = (p = containers[0].getFullPath()).isRoot() ? uriPathLocation : p.makeRelative();
                return this.decorateText(p.toString(), element);
            }
        } else if (element instanceof IIncludeReference) {
            IIncludeReference ref = (IIncludeReference)element;
            ICElement parent2 = ref.getParent();
            if (parent2 instanceof IIncludeReference) {
                IPath p = ref.getPath();
                IPath parentLocation = ((IIncludeReference)parent2).getPath();
                if (parentLocation.isPrefixOf(p)) {
                    p = p.setDevice(null);
                    p = p.removeFirstSegments(parentLocation.segmentCount());
                }
                return this.decorateText(p.toString(), element);
            }
        } else if (element instanceof ITranslationUnit && (parent = (unit = (ITranslationUnit)element).getParent()) instanceof IIncludeReference) {
            IPath p = unit.getPath();
            IPath parentLocation = ((IIncludeReference)parent).getPath();
            if (parentLocation.isPrefixOf(p)) {
                p = p.setDevice(null);
                p = p.removeFirstSegments(parentLocation.segmentCount());
            }
            return this.decorateText(p.toString(), element);
        }
        return super.getText(element);
    }

    @Override
    public StyledString getStyledText(Object element) {
        return Strings.markLTR(new StyledString(this.getText(element)));
    }

    @Override
    public Image getImage(Object element) {
        String imageKey = null;
        if (element instanceof IncludeReferenceProxy) {
            IIncludeReference reference = ((IncludeReferenceProxy)((Object)element)).getReference();
            IPath path = reference.getPath();
            ICProject cproject = reference.getCProject();
            IProject project = cproject != null ? cproject.getProject() : null;
            IContainer[] iContainerArray = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(URIUtil.toURI((IPath)path.makeAbsolute()));
            int n = iContainerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContainer containerInclude = iContainerArray[n2];
                IProject projectInclude = containerInclude.getProject();
                boolean isProjectRelative = projectInclude != null && projectInclude.equals((Object)project);
                imageKey = LanguageSettingsImages.getImageKey(1, 8, isProjectRelative);
                if (isProjectRelative) break;
                ++n2;
            }
            if (imageKey == null) {
                imageKey = "icons/tobj16/hfolder_obj.png";
            }
        } else if (element instanceof IIncludeReference) {
            imageKey = "icons/tobj16/cfolder_obj.png";
        }
        if (imageKey != null) {
            Object desc = CDTSharedImages.getImageDescriptor(imageKey);
            desc = new CElementImageDescriptor((ImageDescriptor)desc, 0, CElementImageProvider.SMALL_SIZE);
            return CUIPlugin.getImageDescriptorRegistry().get((ImageDescriptor)desc);
        }
        return super.getImage(element);
    }
}

