/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sbilib.core;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.tizen.sbilib.SBI;
import org.tizen.sbilib.core.ActionRunner;
import org.tizen.sbilib.lib.Log;
import org.tizen.sbilib.model.DebugOption;
import org.tizen.sbilib.model.plugin.PluginEnvironmentVariable;
import org.tizen.sbilib.model.plugin.PluginManager;
import org.tizen.sbilib.model.plugin.Target;
import org.tizen.sbilib.model.plugin.Toolchain;
import org.tizen.sbilib.model.plugin.ToolchainAction;

public class SBISystem {
    private final String ENV_OPTION = "option";
    private final String ENV_CLI_PROJECT_PATH = "cliprojpath";
    private final String ENV_CLI_SDK_PATH = "clisdkpath";
    private final String ENV_CLI_UNIT_PROJECT_PATH = "cliunitprojpath";
    private final String ENV_CLI_APP_ID = "cliappid";
    private final String ENV_CLI_ROOT_PATH = "rootpath";
    private final String ENV_CLI_PASSWORD = "passwd";
    private final String ENV_CLI_GDB_OPTIONS = "gdb-options";
    private final String ENV_CLI_SYSROOT = "sysroot";
    private OutputStream outputStream = null;
    private OutputStream errorStream = null;
    Log log = SBI.log;

    public Process build(String tId, String option, String cliprojpath, String clisdkpath, String cliunitprojpath, String cliappid, String workingDir) {
        this.print("Building...");
        PluginManager pManager = PluginManager.getInstance();
        this.initBuildEnvironment(tId, option, cliprojpath, clisdkpath, cliunitprojpath, cliappid);
        Toolchain buildToolchain = pManager.getToolchainByTargetId(tId);
        if (buildToolchain == null) {
            this.log.error("Cannot find toolchain from target id => " + tId);
            return null;
        }
        return this.executeScript(buildToolchain, buildToolchain.getMakeAction(), workingDir);
    }

    public Process debug(String tId, String option, DebugOption dOption, String workingDir) {
        this.print("Debugging...");
        PluginManager pManager = PluginManager.getInstance();
        this.initDebugEnvironment(tId, option, dOption);
        Toolchain buildToolchain = pManager.getToolchainByTargetId(tId);
        if (buildToolchain == null) {
            this.log.error("Cannot find toolchain from target id => " + tId);
            return null;
        }
        return this.executeScript(buildToolchain, buildToolchain.getDebugAction(), workingDir, false);
    }

    public ArrayList<String> debugCommand(String tId, String option, DebugOption dOption) {
        this.log.log(String.format("Get debugCommand(%s, %s, %s, %s)", tId, option, dOption));
        PluginManager pManager = PluginManager.getInstance();
        this.initDebugEnvironment(tId, option, dOption);
        Toolchain buildToolchain = pManager.getToolchainByTargetId(tId);
        if (buildToolchain == null) {
            this.log.error("Cannot find toolchain from target id => " + tId);
            return null;
        }
        ActionRunner aRunner = new ActionRunner(buildToolchain);
        if (this.outputStream != null) {
            aRunner.setOutputStream(this.outputStream);
        }
        if (this.errorStream != null) {
            aRunner.setErrorStream(this.errorStream);
        }
        return aRunner.getCommand();
    }

    public Process kill(String tId, String option) {
        this.print("Kill...");
        PluginManager pManager = PluginManager.getInstance();
        this.initBuildEnvironment(tId, option, null, null, null, null);
        Toolchain buildToolchain = pManager.getToolchainByTargetId(tId);
        if (buildToolchain == null) {
            this.log.error("Cannot find toolchain from target id => " + tId);
            return null;
        }
        return this.executeScript(buildToolchain, buildToolchain.getKillAction(), null);
    }

    private void initBuildEnvironment(String tId, String option, String cliprojpath, String clisdkpath, String cliunitprojpath, String cliappid) {
        this.setPluginEnvironment(tId);
        PluginEnvironmentVariable.setEnvVar("option", option);
        PluginEnvironmentVariable.setEnvVar("cliprojpath", cliprojpath);
        PluginEnvironmentVariable.setEnvVar("clisdkpath", clisdkpath);
        PluginEnvironmentVariable.setEnvVar("cliunitprojpath", cliunitprojpath);
        PluginEnvironmentVariable.setEnvVar("cliappid", cliappid);
    }

    private void initDebugEnvironment(String tId, String option, DebugOption dOption) {
        this.setPluginEnvironment(tId);
        PluginEnvironmentVariable.setEnvVar("option", option);
        PluginEnvironmentVariable.setEnvVar("rootpath", dOption.getRootPath());
        PluginEnvironmentVariable.setEnvVar("passwd", dOption.getPassword());
        PluginEnvironmentVariable.setEnvVar("gdb-options", dOption.getGdbOptions());
        PluginEnvironmentVariable.setEnvVar("sysroot", dOption.getSysroot());
    }

    public void setPluginEnvironment(String tId) {
        Target t = PluginManager.getInstance().getTarget(tId);
        if (t == null) {
            this.log.error("Cannot find target => " + tId);
            return;
        }
        PluginEnvironmentVariable.setEnvVar("TOOLCHAIN", t.getToolchainId());
        PluginEnvironmentVariable.setEnvVar("ROOTSTRAP", t.getRootstrapId());
    }

    private Process executeScript(Toolchain toolchain, ToolchainAction tAction, String workingDir) {
        return this.executeScript(toolchain, tAction, workingDir, false);
    }

    private Process executeScript(Toolchain toolchain, ToolchainAction tAction, String workingDir, boolean seperate) {
        ActionRunner aRunner = new ActionRunner(toolchain, tAction);
        if (this.outputStream != null) {
            aRunner.setOutputStream(this.outputStream);
        }
        if (this.errorStream != null) {
            aRunner.setErrorStream(this.errorStream);
        }
        return aRunner.execute(workingDir, seperate);
    }

    private void clear() {
        PluginEnvironmentVariable.clear();
    }

    public void setOutputStream(OutputStream output) {
        this.outputStream = output;
    }

    public void setErrorStream(OutputStream error) {
        this.errorStream = error;
    }

    private void print(String message) {
        if (this.outputStream != null) {
            try {
                this.outputStream.write(message.getBytes());
            }
            catch (IOException e) {
                this.log.exception(e);
            }
        }
    }
}

