/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.util.Assert;
import org.tizen.common.util.ProjectUtil;
import org.tizen.nativecore.ext.manifest.Account;
import org.tizen.nativecore.ext.manifest.AppControl;
import org.tizen.nativecore.ext.manifest.BackgroundCategory;
import org.tizen.nativecore.ext.manifest.Category;
import org.tizen.nativecore.ext.manifest.DataControl;
import org.tizen.nativecore.ext.manifest.IApplication;
import org.tizen.nativecore.ext.manifest.Icon;
import org.tizen.nativecore.ext.manifest.Manifest;
import org.tizen.nativecore.ext.manifest.Metadata;
import org.tizen.nativecore.ext.manifest.ServiceApplication;
import org.tizen.nativecore.ext.manifest.Shortcut;
import org.tizen.nativecore.ext.manifest.TizenSplashScreen;
import org.tizen.nativecore.ext.manifest.UiApplication;
import org.tizen.nativecore.ext.manifest.WatchApplication;
import org.tizen.nativecore.ext.manifest.WidgetApplication;
import org.tizen.nativecore.misc.IdePlugin;
import org.tizen.nativecore.misc.core.LocaledValue;
import org.tizen.nativecore.misc.editor.ISectionTableEvent;
import org.tizen.nativecore.misc.editor.Messages;
import org.tizen.nativecore.misc.editor.TizenFormPage;
import org.tizen.nativecore.misc.editor.UiAttrIconWithCheck;
import org.tizen.nativecore.misc.editor.UiSectionTable;
import org.tizen.nativecore.misc.editor.dlg.UiAppControlScreenDialog;
import org.tizen.nativecore.misc.editor.dlg.UiDataControlDlg;
import org.tizen.nativecore.misc.editor.dlg.UiNewAccountDialog;
import org.tizen.nativecore.misc.editor.dlg.UiNewMetaDataDialog;
import org.tizen.nativecore.misc.editor.dlg.UiNewMultiResolutionIconChooserDialog;
import org.tizen.nativecore.misc.editor.dlg.UiNewShortCutDialog;
import org.tizen.nativecore.misc.editor.dlg.UiNewSplashScreenDialog;
import org.tizen.nativecore.misc.utils.Constants;
import org.tizen.nativecore.misc.utils.IApplicationUtil;

public class CoreAdvancedPage
extends TizenFormPage {
    public static final String[] SCREEN_PHYSICALS = new String[]{"Normal_480x800", "Normal_720x1280", "Normal_800x1280", "Normal_1080x1920", "Normal_1600x2560", "Large_480x800", "Large_720x1280", "Large_800x1280", "Large_1080x1920", "Large_1600x2560"};
    public static final String APP_LAUNCH_PRIVILAGE = "http://tizen.org/privilege/application.launch";
    private List<String> presetOperations = new ArrayList<String>(Arrays.asList("http://tizen.org/appcontrol/operation/main", "http://tizen.org/appcontrol/operation/default", "http://tizen.org/appcontrol/operation/edit", "http://tizen.org/appcontrol/operation/view", "http://tizen.org/appcontrol/operation/pick", "http://tizen.org/appcontrol/operation/create_content", "http://tizen.org/appcontrol/operation/call", "http://tizen.org/appcontrol/operation/send", "http://tizen.org/appcontrol/operation/send_text", "http://tizen.org/appcontrol/operation/share", "http://tizen.org/appcontrol/operation/multi_share", "http://tizen.org/appcontrol/operation/share_text", "http://tizen.org/appcontrol/operation/dial", "http://tizen.org/appcontrol/operation/search", "http://tizen.org/appcontrol/operation/download", "http://tizen.org/appcontrol/operation/print", "http://tizen.org/appcontrol/operation/compose"));
    private static final String[] PRESET_MIMETYPES = new String[]{"application/xhtml+xml", "application/smil", "application/msword", "application/vnd.ms-word", "application/pdf", "application/sdp", "application/ram", "application/rss+xml", "application/rdf+xml", "application/atom+xml", "application/vnd.rn-realmedia", "application/vnd.ms-excel", "application/x-msexcel", "application/vnd.ms-powerpoint", "application/x-mspowerpoint", "application/x-smaf", "application/vnd.smaf", "application/x-shockwave-flash", "application/x-java-archive", "application/x-pkcs12", "application/x-x509-ca-cert", "application/xml", "text/xml", "audio/basic", "audio/mpeg", "audio/mp3", "audio/x-mpeg", "audio/x-mp3", "audio/AMR", "audio/amr", "audio/AMR-WB", "audio/amr-wb", "audio/midi", "audio/x-midi", "audio/3gpp", "audio/mp4", "audio/vnd.rn-realaudio", "audio/x-pn-realaudio", "audio/x-wav", "audio/wav", "audio/x-ms-wma", "audio/wma", "audio/x-xmf", "audio/xmf, audio/mobile-xmf", "image/gif", "image/jpeg", "image/pjpeg", "image/tiff", "image/png", "image/bmp", "image/x-bmp", "image/svg+xml", "image/vnd.wap.wbmp", "message/rfc822", "text/html", "text/plain", "text/vnd.wap.wml", "text/vnd.sun.j2me.app-descriptor", "text/calendar", "text/x-vcalendar", "text/vcard", "text/x-vcard", "text/x-iMelody", "audio/iMelody", "audio/x-iMelody", "text/x-vnote", "video/mp4", "video/3gpp", "video/x-msvideo", "video/avi", "video/mp4", "video/mp4v-es", "video/mpeg", "video/vnd.rn-realvideo", "video/x-ms-wmv", "video/x-ms-asf"};
    public static final String[] SUPPORT_SIZES = new String[]{"1x1", "2x1", "2x2", "4x1", "4x2", "4x3", "4x4"};
    public static String[] BG_CATEGORY_TYPES = new String[]{"media", "download", "location", "background-network", "sensor", "iot-communication"};
    public static List<BackgroundCategory> bgDefaultCategoryList = null;
    private UiAttrIconWithCheck fSize11;
    private UiAttrIconWithCheck fSize21;
    private UiAttrIconWithCheck fSize22;
    private UiAttrIconWithCheck fSize41;
    private UiAttrIconWithCheck fSize42;
    private UiAttrIconWithCheck fSize43;
    private UiAttrIconWithCheck fSize44;
    private Combo fNoDisplayCombo;
    private Combo fTaskManageCombo;
    private Combo fAutoRestartCombo;
    private Combo fOnBootCombo;
    private Combo fHwAccelerationCombo;
    private Combo fLaunchModeCombo;
    private Combo fSplashScreenDisplay;
    private UiSectionTable fMetaTable;
    private UiSectionTable fDataControlTable;
    private UiSectionTable fAccountTable;
    private UiSectionTable fAppControlTable;
    private UiSectionTable fBgCategoryTable;
    private UiSectionTable fShortcutTable;
    private UiSectionTable fSplashTable;
    private UiSectionTable fIconTable;
    private Button fRemoveBtn;
    private Button fambientSupportCheck;
    private CoreAdvancedPage fpage = this;
    private String imagePath;
    private Text fUpdatePeriod;
    private Text fMaxInstance;
    Label maxInstanceLabel;
    private Button plus;
    private Button minus;
    private Label updatePeriodLabel;
    private boolean updatePeriodChangeFlag;
    private boolean updateMaxInstanceChangeFlag;
    private static final int UPDATE_PERIOD_MIN_VALUE = 0;
    private static final int UPDATE_PERIOD_MAX_VALUE = 864000;
    private static final int SELECTABLE_INTERVAL = 1800;
    private static final int LENGTH_UPDATE_PERIOD_MAX_VALUE = 6;
    private FormToolkit toolkit;
    private VerifyListener verifyListener = new VerifyListener(){

        public void verifyText(VerifyEvent event) {
            if (CoreAdvancedPage.this.updatePeriodChangeFlag || CoreAdvancedPage.this.updateMaxInstanceChangeFlag) {
                return;
            }
            String text = event.text;
            char[] chars = new char[text.length()];
            text.getChars(0, chars.length, chars, 0);
            int i = 0;
            while (i < chars.length) {
                if ('0' > chars[i] || chars[i] > '9') {
                    event.doit = false;
                    return;
                }
                ++i;
            }
        }
    };
    private ModifyListener updatePeriodModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
            if (CoreAdvancedPage.this.updatePeriodChangeFlag) {
                return;
            }
            if (event.widget == CoreAdvancedPage.this.fUpdatePeriod) {
                CoreAdvancedPage.this.setDirty(true);
                return;
            }
        }
    };
    private FocusListener updatePeriodFocusListener = new FocusListener(){

        public void focusLost(FocusEvent event) {
            if (event.widget == CoreAdvancedPage.this.fUpdatePeriod) {
                CoreAdvancedPage.this.updatePeriodText();
            }
        }

        public void focusGained(FocusEvent event) {
        }
    };
    private ModifyListener maxInstanceModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
            if (CoreAdvancedPage.this.updateMaxInstanceChangeFlag) {
                return;
            }
            if (event.widget == CoreAdvancedPage.this.fMaxInstance) {
                CoreAdvancedPage.this.setDirty(true);
                return;
            }
        }
    };
    private FocusListener maxInstanceFocusListener = new FocusListener(){

        public void focusLost(FocusEvent event) {
            if (event.widget == CoreAdvancedPage.this.fMaxInstance) {
                CoreAdvancedPage.this.updateMaxInstance();
            }
        }

        public void focusGained(FocusEvent event) {
        }
    };
    private static String[] metaDataColumn = new String[]{"Key", "Value"};
    private static int[] metaDataColumnWidth = new int[]{213, 426};
    private static String[] dataControlColumns = new String[]{"Provider ID", "Type", "Accessibility"};
    private int[] dataControlColumnsWidth = new int[]{213, 212, 213};
    private static String[] accountColumns = new String[]{"Display name", "Multiple account", "Provider ID", "Icon", "Small icon"};
    private static int[] accountColumnsWidth = new int[]{127, 147, 120, 120, 120};
    private static String[] appColumns = new String[]{"Operation", "Uri", "Mime"};
    private static int[] appColumnsWidth = new int[]{212, 212, 212};
    private static String[] bgCategory = new String[]{"Category type"};
    private static int[] bgCategoryWidth = new int[]{127};
    private static String[] shortcutColumns = new String[]{"Icon", "Key", "Data"};
    private static int[] shortcutColumnsWidth = new int[]{212, 212, 212};
    private static String[] splashColumns = new String[]{"Resource", "Type", "DPI", "Orientation", "Indicator Display", "Operation"};
    private static int[] splashColumnsWidth = new int[]{105, 105, 105, 105, 105, 108};
    private static String[] iconColumns = new String[]{"Language", "DPI", "Icon"};
    private static int[] iconColumnsWidth = new int[]{212, 212, 212};
    private SelectionListener selectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            Manifest manifest = CoreAdvancedPage.this.getEditor().getCoreManifest();
            if (manifest != null) {
                IApplication app = manifest.getDefaultApp();
                if (app instanceof UiApplication) {
                    UiApplication uiApp = (UiApplication)app;
                    if (e.widget == CoreAdvancedPage.this.fSplashScreenDisplay) {
                        if (CoreAdvancedPage.this.fSplashScreenDisplay.getSelectionIndex() == 1) {
                            uiApp.setSplashScreenDisplay("false");
                            CoreAdvancedPage.this.fSplashTable.setEnabled(false);
                        } else {
                            CoreAdvancedPage.this.fSplashTable.setEnabled(true);
                            uiApp.setSplashScreenDisplay("true");
                        }
                        CoreAdvancedPage.this.fSplashScreenDisplay.getParent().getParent().getParent().layout();
                        CoreAdvancedPage.this.setDirty(true);
                        return;
                    }
                    if (e.widget == CoreAdvancedPage.this.fNoDisplayCombo) {
                        uiApp.setNodisplay(CoreAdvancedPage.this.fNoDisplayCombo.getText());
                        CoreAdvancedPage.this.fNoDisplayCombo.getParent().getParent().getParent().layout();
                        CoreAdvancedPage.this.setDirty(true);
                        return;
                    }
                    if (e.widget == CoreAdvancedPage.this.fTaskManageCombo) {
                        uiApp.setTaskmanage(CoreAdvancedPage.this.fTaskManageCombo.getText());
                        CoreAdvancedPage.this.fTaskManageCombo.getParent().getParent().getParent().layout();
                        CoreAdvancedPage.this.setDirty(true);
                        return;
                    }
                    if (e.widget == CoreAdvancedPage.this.fHwAccelerationCombo) {
                        uiApp.setHw_acceleration(CoreAdvancedPage.this.fHwAccelerationCombo.getText());
                        CoreAdvancedPage.this.fHwAccelerationCombo.getParent().getParent().getParent().layout();
                        CoreAdvancedPage.this.setDirty(true);
                        return;
                    }
                    if (e.widget == CoreAdvancedPage.this.fLaunchModeCombo) {
                        uiApp.setLaunch_mode(CoreAdvancedPage.this.fLaunchModeCombo.getText());
                        CoreAdvancedPage.this.fLaunchModeCombo.getParent().getParent().getParent().layout();
                        CoreAdvancedPage.this.setDirty(true);
                        return;
                    }
                } else if (app instanceof ServiceApplication) {
                    ServiceApplication servApp = (ServiceApplication)app;
                    if (e.widget == CoreAdvancedPage.this.fTaskManageCombo) {
                        servApp.setTaskmanage(CoreAdvancedPage.this.fTaskManageCombo.getText());
                        CoreAdvancedPage.this.fTaskManageCombo.getParent().getParent().getParent().layout();
                        CoreAdvancedPage.this.setDirty(true);
                        return;
                    }
                    if (e.widget == CoreAdvancedPage.this.fAutoRestartCombo) {
                        servApp.setAuto_restart(CoreAdvancedPage.this.fAutoRestartCombo.getText());
                        CoreAdvancedPage.this.fAutoRestartCombo.getParent().getParent().getParent().layout();
                        CoreAdvancedPage.this.setDirty(true);
                        return;
                    }
                    if (e.widget == CoreAdvancedPage.this.fOnBootCombo) {
                        servApp.setOn_boot(CoreAdvancedPage.this.fOnBootCombo.getText());
                        CoreAdvancedPage.this.fOnBootCombo.getParent().getParent().getParent().layout();
                        CoreAdvancedPage.this.setDirty(true);
                        return;
                    }
                } else if (app instanceof WatchApplication) {
                    WatchApplication watchApp = (WatchApplication)app;
                    if (e.widget == CoreAdvancedPage.this.fambientSupportCheck) {
                        watchApp.setAmbientSupport(String.valueOf(CoreAdvancedPage.this.fambientSupportCheck.getSelection()));
                        CoreAdvancedPage.this.setDirty(true);
                        return;
                    }
                    if (e.widget == CoreAdvancedPage.this.fHwAccelerationCombo) {
                        watchApp.setHw_acceleration(CoreAdvancedPage.this.fHwAccelerationCombo.getText());
                        CoreAdvancedPage.this.fHwAccelerationCombo.getParent().getParent().layout();
                        CoreAdvancedPage.this.setDirty(true);
                        return;
                    }
                } else if (app instanceof WidgetApplication) {
                    WidgetApplication widgetApp = (WidgetApplication)app;
                    if (e.widget == CoreAdvancedPage.this.fHwAccelerationCombo) {
                        widgetApp.setHw_acceleration(CoreAdvancedPage.this.fHwAccelerationCombo.getText());
                        CoreAdvancedPage.this.fHwAccelerationCombo.getParent().getParent().layout();
                        CoreAdvancedPage.this.setDirty(true);
                        return;
                    }
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }
    };

    private void updatePeriodText() {
        IApplication app;
        String value = this.fUpdatePeriod.getText();
        this.updatePeriodChangeFlag = true;
        int intValue = 0;
        if (!value.isEmpty()) {
            if (value.length() > 6) {
                intValue = 864000;
            } else {
                intValue = Integer.parseInt(value);
                if (intValue > 864000) {
                    intValue = 864000;
                } else if (intValue % 1800 != 0) {
                    intValue = intValue / 1800 * 1800;
                }
            }
        } else {
            intValue = 0;
        }
        this.fUpdatePeriod.setText(String.valueOf(intValue));
        String dayHourMinFormatValue = this.computeInDayHourMinFormat(intValue);
        this.updatePeriodLabel.setText(dayHourMinFormatValue);
        Manifest manifest = this.getEditor().getCoreManifest();
        if (manifest != null && (app = manifest.getDefaultApp()) instanceof WidgetApplication) {
            WidgetApplication widgetApp = (WidgetApplication)app;
            widgetApp.setUpdate_period(this.fUpdatePeriod.getText());
        }
        this.updatePeriodChangeFlag = false;
    }

    private void updateMaxInstance() {
        IApplication app;
        String value = this.fMaxInstance.getText();
        this.updateMaxInstanceChangeFlag = true;
        int intValue = 0;
        if (!value.isEmpty()) {
            intValue = Integer.parseInt(value);
        }
        this.fMaxInstance.setText(String.valueOf(intValue));
        Manifest manifest = this.getEditor().getCoreManifest();
        if (manifest != null && (app = manifest.getDefaultApp()) instanceof WidgetApplication) {
            WidgetApplication widgetApp = (WidgetApplication)app;
            widgetApp.setMax_Instance(this.fMaxInstance.getText());
        }
        this.updateMaxInstanceChangeFlag = false;
    }

    public CoreAdvancedPage(FormEditor editor) {
        super(editor, Messages.AdvancedPage_label, Messages.AdvancedPage_label);
    }

    private Font getBoldFont(Control label, int fontSize) {
        FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)label.getFont()).setStyle(1);
        Font boldFont = boldDescriptor.createFont((Device)label.getDisplay());
        FontData[] fD = boldFont.getFontData();
        if (fontSize != 0) {
            fD[0].setHeight(fontSize);
        }
        return new Font(null, fD[0]);
    }

    private Font getNormalFont(Control label, int fontSize) {
        FontDescriptor fontDescriptor = FontDescriptor.createFrom((Font)label.getFont());
        Font boldFont = fontDescriptor.createFont((Device)label.getDisplay());
        FontData[] fD = boldFont.getFontData();
        if (fontSize != 0) {
            fD[0].setHeight(fontSize);
        }
        return new Font(null, fD[0]);
    }

    protected void createFormContent(IManagedForm managedForm) {
        FormToolkit tk;
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = true;
        gridData.widthHint = 600;
        ScrolledForm scrolledForm = managedForm.getForm();
        this.toolkit = tk = managedForm.getToolkit();
        Composite body = scrolledForm.getBody();
        body.setLayout((Layout)new GridLayout());
        GridData clientGD = new GridData(0x1000000, 0, true, true, 0, 0);
        clientGD.widthHint = 640;
        Composite client = tk.createComposite(body);
        client.setLayout((Layout)new GridLayout());
        client.setLayoutData((Object)clientGD);
        tk.decorateFormHeading(scrolledForm.getForm());
        GridData titleGridData = new GridData();
        titleGridData.horizontalAlignment = 1;
        titleGridData.grabExcessHorizontalSpace = true;
        Composite titleComposite = tk.createComposite(client);
        titleComposite.setLayout((Layout)new GridLayout(2, false));
        titleComposite.setLayoutData((Object)titleGridData);
        GridData iconImageGD = new GridData();
        iconImageGD.widthHint = 70;
        Label iconImage = new Label(titleComposite, 0x2000000);
        this.imagePath = IdePlugin.getDefault().getResourceLocationURL("icons/editor/title_advanced.png").getFile();
        iconImage.setImage(new Image(null, new ImageData(this.imagePath)));
        iconImage.setBackground(new Color(null, 255, 255, 255));
        iconImage.setLayoutData((Object)iconImageGD);
        Label titleText = new Label(titleComposite, 0x2000000);
        titleText.setText(Messages.AdvancedPage_label);
        titleText.setAlignment(0x1000000);
        titleText.setFont(this.getBoldFont((Control)titleText, 13));
        titleText.setBackground(new Color(null, 255, 255, 255));
        Label separator = new Label(client, 258);
        separator.setLayoutData((Object)new GridData(768));
        separator.setBackground(new Color(null, 255, 255, 255));
        this.fillBody(client, this.toolkit);
        this.update(this.getEditor().getCoreManifest());
        this.setDirty(false);
    }

    private String updatedVersion(String version, String sep, int width) {
        String[] split = Pattern.compile(sep, 16).split(version);
        StringBuilder sb = new StringBuilder();
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sb.append(String.format("%" + width + 's', s));
            ++n2;
        }
        return sb.toString();
    }

    private int compareVersion(String ver1, String ver2) {
        int result = -1;
        String s1 = this.updatedVersion(ver1, ".", 2);
        String s2 = this.updatedVersion(ver2, ".", 2);
        result = s1.compareTo(s2);
        return result;
    }

    protected Composite getGridComposite(Composite parent) {
        Composite gridComposite = new Composite(parent, 0);
        gridComposite.setLayout((Layout)new GridLayout());
        gridComposite.setLayoutData((Object)new GridData(768));
        gridComposite.setBackground(new Color(null, 255, 255, 255));
        return gridComposite;
    }

    protected void fillBody(Composite parent, FormToolkit toolkit) {
        IApplication app = this.getEditor().getCoreManifest().getDefaultApp();
        Composite pageBody = toolkit.createComposite(parent);
        GridLayout gd = new GridLayout();
        gd.verticalSpacing = 40;
        pageBody.setLayout((Layout)gd);
        pageBody.setLayoutData((Object)new GridData(768));
        Composite gridComposite = this.getGridComposite(pageBody);
        this.createMetaDataSection(toolkit, gridComposite);
        String apiVersion = this.getEditor().getCoreManifest().getApiVersion();
        if (app instanceof UiApplication) {
            gridComposite = this.getGridComposite(pageBody);
            this.createDataControlSection(toolkit, gridComposite);
            if (!app.getCategory_map().containsKey(Category.CATEGORY_PRESETS[0])) {
                gridComposite = this.getGridComposite(pageBody);
                this.createOptionSection(toolkit, gridComposite);
                if (this.compareVersion(apiVersion, "3.0") >= 0 && this.fSplashScreenDisplay != null && this.fSplashScreenDisplay.getSelectionIndex() == 0) {
                    gridComposite = this.getGridComposite(pageBody);
                    this.createSplashSection(toolkit, gridComposite);
                    gridComposite = this.getGridComposite(pageBody);
                    this.createMultiResolutionIconSection(toolkit, gridComposite);
                }
            }
            gridComposite = this.getGridComposite(pageBody);
            this.createAppControlSection(toolkit, gridComposite);
            if (this.getEditor().getCoreManifest().getProfile().getName().equals("mobile")) {
                gridComposite = this.getGridComposite(pageBody);
                this.createAccountSection(toolkit, gridComposite);
            }
            if (this.compareVersion(apiVersion, "2.4") >= 0) {
                gridComposite = this.getGridComposite(pageBody);
                this.createBgCategorySection(toolkit, gridComposite);
                gridComposite = this.getGridComposite(pageBody);
                this.createShortcutSection(toolkit, gridComposite);
            }
        }
        if (app instanceof ServiceApplication) {
            gridComposite = this.getGridComposite(pageBody);
            this.createDataControlSection(toolkit, gridComposite);
            gridComposite = this.getGridComposite(pageBody);
            this.createOptionSection(toolkit, gridComposite);
            gridComposite = this.getGridComposite(pageBody);
            this.createAppControlSection(toolkit, gridComposite);
            if (this.compareVersion(apiVersion, "2.4") >= 0) {
                gridComposite = this.getGridComposite(pageBody);
                this.createBgCategorySection(toolkit, gridComposite);
            }
        }
        if (app instanceof WidgetApplication) {
            gridComposite = this.getGridComposite(pageBody);
            this.createWidgetSection(toolkit, gridComposite);
            gridComposite = this.getGridComposite(pageBody);
            this.createWidgetAttributeSection(toolkit, gridComposite);
        }
        if (app instanceof WatchApplication) {
            gridComposite = this.getGridComposite(pageBody);
            this.createWatchAttributeSection(toolkit, gridComposite);
        }
    }

    protected void updateRemoveButtonStatus() {
        IStructuredSelection sel = (IStructuredSelection)this.fAppControlTable.getTable().getSelection();
        AppControl cap = (AppControl)sel.getFirstElement();
        if (cap == null) {
            this.fRemoveBtn.setEnabled(false);
        } else {
            this.fRemoveBtn.setEnabled(true);
        }
    }

    private void createAccountSection(final FormToolkit toolkit, Composite parent) {
        this.fAccountTable = new UiSectionTable();
        this.fAccountTable.createSection(toolkit, parent, Messages.AccountPage_label, Messages.AccountPage_desc, accountColumns, accountColumnsWidth, new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener arg0) {
            }

            public boolean isLabelProperty(Object arg0, String arg1) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener arg0) {
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof Account) {
                    if (columnIndex == 0) {
                        return ((Account)element).getDefaultLabel();
                    }
                    if (columnIndex == 1) {
                        return ((Account)element).getMultipleAccountSupport();
                    }
                    if (columnIndex == 2) {
                        return ((Account)element).getProviderid();
                    }
                    if (columnIndex == 3) {
                        return ((Account)element).getIcon().getFileName();
                    }
                    if (columnIndex == 4) {
                        return ((Account)element).getIconSmall().getFileName();
                    }
                }
                return null;
            }

            public Image getColumnImage(Object arg0, int arg1) {
                return null;
            }
        });
        this.fAccountTable.setEventHandler(new ISectionTableEvent(){

            @Override
            public void onRemove() {
                IStructuredSelection sel = (IStructuredSelection)CoreAdvancedPage.this.fAccountTable.getTable().getSelection();
                Account acc = (Account)sel.getFirstElement();
                if (acc != null) {
                    CoreAdvancedPage.this.getEditor().getCoreManifest().getAccounts().remove(acc);
                    CoreAdvancedPage.this.fAccountTable.getTable().remove((Object)acc);
                    CoreAdvancedPage.this.setDirty(true);
                }
            }

            @Override
            public void onEdit() {
                IStructuredSelection sel = (IStructuredSelection)CoreAdvancedPage.this.fAccountTable.getTable().getSelection();
                Account acc = (Account)sel.getFirstElement();
                if (acc != null) {
                    UiNewAccountDialog dlg = new UiNewAccountDialog(toolkit, CoreAdvancedPage.this.fpage);
                    dlg.setAccount(acc);
                    if (dlg.open() == 0) {
                        CoreAdvancedPage.this.fAccountTable.getTable().update((Object)acc, null);
                        CoreAdvancedPage.this.setDirty(true);
                    }
                }
            }

            @Override
            public void onAdd() {
                Account data;
                UiNewAccountDialog dlg = new UiNewAccountDialog(toolkit, CoreAdvancedPage.this.fpage);
                if (dlg.open() == 0 && (data = dlg.getAccount()) != null) {
                    data.setAppid(CoreAdvancedPage.this.getEditor().getCoreManifest().getDefaultApp().getAppid());
                    if (this.valid(data)) {
                        CoreAdvancedPage.this.getEditor().getCoreManifest().getAccounts().add(data);
                        CoreAdvancedPage.this.setDirty(true);
                        CoreAdvancedPage.this.fAccountTable.getTable().add((Object)data);
                    }
                }
            }

            private boolean valid(Account data) {
                if (data.getIcon().getFileName() == null || data.getIcon().getFileName().length() <= 0) {
                    return false;
                }
                return data.getIconSmall().getFileName() != null && data.getIconSmall().getFileName().length() > 0;
            }
        });
    }

    private void createDataControlSection(FormToolkit toolkit, Composite parent) {
        this.fDataControlTable = new UiSectionTable();
        this.fDataControlTable.createSection(toolkit, parent, "Data Control", Messages.AdvancedPage_DataControlDesc, dataControlColumns, this.dataControlColumnsWidth, new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof DataControl) {
                    if (columnIndex == 0) {
                        return ((DataControl)element).getProviderid();
                    }
                    if (columnIndex == 1) {
                        return ((DataControl)element).getType();
                    }
                    if (columnIndex == 2) {
                        return ((DataControl)element).getAccess();
                    }
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        });
        this.fDataControlTable.setEventHandler(new ISectionTableEvent(){

            @Override
            public void onRemove() {
                IStructuredSelection sel = (IStructuredSelection)CoreAdvancedPage.this.fDataControlTable.getTable().getSelection();
                DataControl d = (DataControl)sel.getFirstElement();
                if (d != null) {
                    IApplication app = CoreAdvancedPage.this.getEditor().getCoreManifest().getDefaultApp();
                    if (app instanceof UiApplication) {
                        UiApplication uiApp = (UiApplication)app;
                        uiApp.getDataControlList().remove(d);
                    }
                    if (app instanceof ServiceApplication) {
                        ServiceApplication serviceApp = (ServiceApplication)app;
                        serviceApp.getDataControlList().remove(d);
                    }
                    CoreAdvancedPage.this.fDataControlTable.getTable().remove((Object)d);
                    CoreAdvancedPage.this.setDirty(true);
                }
            }

            @Override
            public void onEdit() {
                IStructuredSelection sel = (IStructuredSelection)CoreAdvancedPage.this.fDataControlTable.getTable().getSelection();
                DataControl d = (DataControl)sel.getFirstElement();
                if (d != null) {
                    UiDataControlDlg dlg = new UiDataControlDlg(CoreAdvancedPage.this.getEditor().getCoreManifest().getDefaultApp().getExec());
                    dlg.setInput(d);
                    if (dlg.open() == 0) {
                        CoreAdvancedPage.this.fDataControlTable.getTable().update((Object)d, null);
                        CoreAdvancedPage.this.setDirty(true);
                    }
                }
            }

            @Override
            public void onAdd() {
                UiDataControlDlg dlg = new UiDataControlDlg(CoreAdvancedPage.this.getEditor().getCoreManifest().getDefaultApp().getExec());
                if (dlg.open() == 0) {
                    DataControl data = dlg.getDataControl();
                    IApplication app = CoreAdvancedPage.this.getEditor().getCoreManifest().getDefaultApp();
                    if (app instanceof UiApplication) {
                        UiApplication uiApp = (UiApplication)app;
                        uiApp.getDataControlList().add(data);
                    }
                    if (app instanceof ServiceApplication) {
                        ServiceApplication serviceApp = (ServiceApplication)app;
                        serviceApp.getDataControlList().add(data);
                    }
                    CoreAdvancedPage.this.setDirty(true);
                    CoreAdvancedPage.this.fDataControlTable.getTable().add((Object)data);
                }
            }
        });
    }

    private void createMetaDataSection(FormToolkit toolkit, Composite parent) {
        this.fMetaTable = new UiSectionTable();
        ITableLabelProvider labelProvider = new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof Metadata) {
                    Metadata m = (Metadata)element;
                    if (columnIndex == 0) {
                        return m.getKey();
                    }
                    return m.getValue();
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        };
        this.fMetaTable.createSection(toolkit, parent, "Meta Data", "You can add user-defined key-value pairs to the application.", metaDataColumn, metaDataColumnWidth, labelProvider);
        this.fMetaTable.setEventHandler(new ISectionTableEvent(){

            @Override
            public void onRemove() {
                List<Metadata> data;
                IStructuredSelection sel = (IStructuredSelection)CoreAdvancedPage.this.fMetaTable.getTable().getSelection();
                Metadata m = (Metadata)sel.getFirstElement();
                if (m != null && (data = CoreAdvancedPage.this.getEditor().getCoreManifest().getDefaultApp().getMetadataList()) != null) {
                    data.remove(m);
                    CoreAdvancedPage.this.fMetaTable.getTable().remove((Object)m);
                    CoreAdvancedPage.this.setDirty(true);
                }
            }

            @Override
            public void onEdit() {
                UiNewMetaDataDialog dlg;
                IStructuredSelection sel = (IStructuredSelection)CoreAdvancedPage.this.fMetaTable.getTable().getSelection();
                Metadata m = (Metadata)sel.getFirstElement();
                if (m == null) {
                    return;
                }
                List<Metadata> metas = CoreAdvancedPage.this.getEditor().getCoreManifest().getDefaultApp().getMetadataList();
                if (metas != null && (dlg = new UiNewMetaDataDialog(Display.getDefault().getActiveShell(), metas, m)).open() == 0) {
                    CoreAdvancedPage.this.fMetaTable.getTable().update((Object)m, null);
                    CoreAdvancedPage.this.setDirty(true);
                }
            }

            @Override
            public void onAdd() {
                Metadata m;
                UiNewMetaDataDialog dlg;
                List<Metadata> metas = CoreAdvancedPage.this.getEditor().getCoreManifest().getDefaultApp().getMetadataList();
                if (metas != null && (dlg = new UiNewMetaDataDialog(Display.getDefault().getActiveShell(), metas, null)).open() == 0 && (m = dlg.getMetaData()) != null) {
                    metas.add(m);
                    CoreAdvancedPage.this.fMetaTable.getTable().add((Object)m);
                    CoreAdvancedPage.this.setDirty(true);
                }
            }
        });
    }

    private Combo createLabelComboBox(Composite parent, String labelText, GridData gd, String[] comboVals) {
        Composite data1 = new Composite(parent, 4);
        data1.setLayout((Layout)new GridLayout());
        data1.setLayoutData((Object)new GridData(4));
        Composite data2 = new Composite(data1, 4);
        data2.setLayout((Layout)new GridLayout(2, false));
        data2.setLayoutData((Object)new GridData(131076));
        data1.setBackground(new Color(null, 255, 255, 255));
        data2.setBackground(new Color(null, 255, 255, 255));
        Label label = new Label(data2, 0);
        label.setText(labelText);
        label.setBackground(new Color(null, 255, 255, 255));
        label.setFont(this.getNormalFont((Control)label, 10));
        label.setLayoutData((Object)gd);
        Combo combo = new Combo(data2, 2316);
        combo.setToolTipText(labelText);
        combo.setItems(comboVals);
        combo.select(0);
        combo.addSelectionListener(this.selectionListener);
        return combo;
    }

    private void createOptionSection(FormToolkit tk, Composite parent) {
        Group group = new Group(parent, 4);
        group.setText(Messages.AdvancedPage_misc_title);
        group.setFont(this.getBoldFont((Control)group, 10));
        group.setBackground(new Color(null, 255, 255, 255));
        group.setForeground(new Color(null, 0, 138, 238));
        group.setLayout((Layout)new GridLayout(2, true));
        GridData data = new GridData(4, 4, true, false);
        group.setLayoutData((Object)data);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = 160;
        this.fTaskManageCombo = this.createLabelComboBox((Composite)group, Messages.AdvancedPage_TaskManage_label, gd, Constants.BOOLEAN_WITH_EMPTY);
        if (this.getEditor().getCoreManifest().getDefaultApp() instanceof UiApplication) {
            this.fNoDisplayCombo = this.createLabelComboBox((Composite)group, Messages.AdvancedPage_NoDisplay_label, gd, Constants.BOOLEAN_WITH_EMPTY);
            this.fHwAccelerationCombo = this.createLabelComboBox((Composite)group, Messages.AdvancedPage_HwAccel_label, gd, Constants.HW_ACCELERATION_VALUES);
            this.fLaunchModeCombo = this.createLabelComboBox((Composite)group, Messages.AdvancedPage_launch_mode, gd, Constants.LAUNCH_MODE_VALUES);
            if (this.getEditor().getCoreManifest().getApiVersion().equalsIgnoreCase("3.0")) {
                this.fSplashScreenDisplay = this.createLabelComboBox((Composite)group, "Display Splash Screen", gd, Constants.BOOLEAN_VALUES);
            }
        }
        if (this.getEditor().getCoreManifest().getDefaultApp() instanceof ServiceApplication) {
            this.fAutoRestartCombo = this.createLabelComboBox((Composite)group, Messages.AdvancedPage_AutoRestart_label, gd, Constants.BOOLEAN_WITH_EMPTY);
            this.fOnBootCombo = this.createLabelComboBox((Composite)group, Messages.AdvancedPage_Onboot_label, gd, Constants.BOOLEAN_WITH_EMPTY);
        }
    }

    public void update(Manifest manifest) {
        IApplication app = manifest.getDefaultApp();
        if (app instanceof UiApplication) {
            UiApplication uiApp = (UiApplication)app;
            if (this.fNoDisplayCombo != null) {
                if (!uiApp.getNodisplay().isEmpty()) {
                    this.fNoDisplayCombo.setText(uiApp.getNodisplay());
                } else {
                    this.fNoDisplayCombo.select(0);
                }
            }
            if (this.fTaskManageCombo != null) {
                if (!uiApp.getTaskmanage().isEmpty()) {
                    this.fTaskManageCombo.setText(uiApp.getTaskmanage());
                } else {
                    this.fTaskManageCombo.select(0);
                }
            }
            if (this.fMetaTable != null) {
                this.fMetaTable.getTable().setInput((Object)uiApp.getMetadataList().toArray());
            }
            if (this.fDataControlTable != null) {
                this.fDataControlTable.getTable().setInput((Object)uiApp.getDataControlList().toArray());
            }
            if (this.fAccountTable != null) {
                this.fAccountTable.getTable().setInput((Object)manifest.getAccounts().toArray());
            }
            if (this.fAppControlTable != null) {
                this.fAppControlTable.getTable().setInput((Object)uiApp.getAppServiceList().toArray());
            }
            if (this.fHwAccelerationCombo != null) {
                if (!uiApp.getHw_acceleration().isEmpty()) {
                    this.fHwAccelerationCombo.setText(uiApp.getHw_acceleration());
                } else {
                    this.fHwAccelerationCombo.select(0);
                }
            }
            if (this.fBgCategoryTable != null) {
                this.fBgCategoryTable.getTable().setInput((Object)uiApp.getBgCategoryList().toArray());
            }
            if (this.fLaunchModeCombo != null) {
                if (!uiApp.getLaunch_mode().isEmpty()) {
                    this.fLaunchModeCombo.setText(uiApp.getLaunch_mode());
                } else {
                    this.fLaunchModeCombo.select(0);
                }
            }
            if (this.fShortcutTable != null) {
                this.fShortcutTable.getTable().setInput((Object)manifest.getShortCutList().toArray());
            }
            if (this.fSplashTable != null && uiApp.getSplashScreenDisplay() != null) {
                this.fSplashTable.getTable().setInput((Object)uiApp.getSplashScreenList().toArray());
                if (uiApp.getSplashScreenDisplay().equalsIgnoreCase("true")) {
                    this.fSplashScreenDisplay.select(0);
                } else {
                    this.fSplashScreenDisplay.select(1);
                }
            }
            if (this.fIconTable != null) {
                this.fIconTable.getTable().setInput((Object)uiApp.getIcons().toArray());
            }
        } else if (app instanceof ServiceApplication) {
            ServiceApplication servApp = (ServiceApplication)app;
            if (this.fTaskManageCombo != null) {
                if (!servApp.getTaskmanage().isEmpty()) {
                    this.fTaskManageCombo.setText(servApp.getTaskmanage());
                } else {
                    this.fTaskManageCombo.select(0);
                }
            }
            if (this.fAutoRestartCombo != null) {
                this.fAutoRestartCombo.setText(servApp.getAuto_restart());
            }
            if (this.fOnBootCombo != null) {
                this.fOnBootCombo.setText(servApp.getOn_boot());
            }
            if (this.fMetaTable != null) {
                this.fMetaTable.getTable().setInput((Object)servApp.getMetadataList().toArray());
            }
            if (this.fDataControlTable != null) {
                this.fDataControlTable.getTable().setInput((Object)servApp.getDataControlList().toArray());
            }
            if (this.fAppControlTable != null) {
                this.fAppControlTable.getTable().setInput((Object)servApp.getAppServiceList().toArray());
            }
            if (this.fBgCategoryTable != null) {
                this.fBgCategoryTable.getTable().setInput((Object)servApp.getBgCategoryList().toArray());
            }
        } else if (app instanceof WatchApplication) {
            WatchApplication watchApp = (WatchApplication)app;
            if (this.fMetaTable != null) {
                this.fMetaTable.getTable().setInput((Object)watchApp.getMetadataList().toArray());
            }
            if (this.fAccountTable != null) {
                this.fAccountTable.getTable().setInput((Object)manifest.getAccounts().toArray());
            }
            if (this.fambientSupportCheck != null) {
                this.fambientSupportCheck.setSelection(Boolean.parseBoolean(watchApp.getAmbientSupport()));
            }
            if (this.fHwAccelerationCombo != null) {
                if (!watchApp.getHw_acceleration().isEmpty()) {
                    this.fHwAccelerationCombo.setText(watchApp.getHw_acceleration());
                } else {
                    this.fHwAccelerationCombo.select(0);
                }
            }
        } else if (app instanceof WidgetApplication) {
            String profile;
            String apiversion;
            WidgetApplication widgetApp = (WidgetApplication)app;
            if (this.fMetaTable != null) {
                this.fMetaTable.getTable().setInput((Object)widgetApp.getMetadataList().toArray());
            }
            if (widgetApp.getSupportSizesMap().size() > 0) {
                if (this.fSize11 != null) {
                    this.fSize11.updateUI(widgetApp.getSupportSizesMap().get(SUPPORT_SIZES[0]));
                }
                if (this.fSize21 != null) {
                    this.fSize21.updateUI(widgetApp.getSupportSizesMap().get(SUPPORT_SIZES[1]));
                }
                if (this.fSize22 != null) {
                    this.fSize22.updateUI(widgetApp.getSupportSizesMap().get(SUPPORT_SIZES[2]));
                }
                if (this.fSize41 != null) {
                    this.fSize41.updateUI(widgetApp.getSupportSizesMap().get(SUPPORT_SIZES[3]));
                }
                if (this.fSize42 != null) {
                    this.fSize42.updateUI(widgetApp.getSupportSizesMap().get(SUPPORT_SIZES[4]));
                }
                if (this.fSize43 != null) {
                    this.fSize43.updateUI(widgetApp.getSupportSizesMap().get(SUPPORT_SIZES[5]));
                }
                if (this.fSize44 != null) {
                    this.fSize44.updateUI(widgetApp.getSupportSizesMap().get(SUPPORT_SIZES[6]));
                }
            }
            if (this.fHwAccelerationCombo != null) {
                if (!widgetApp.getHw_acceleration().isEmpty()) {
                    this.fHwAccelerationCombo.setText(widgetApp.getHw_acceleration());
                } else {
                    this.fHwAccelerationCombo.select(0);
                }
            }
            if (this.fUpdatePeriod != null) {
                String value = widgetApp.getUpdate_period();
                this.updatePeriodChangeFlag = true;
                int intValue = 0;
                if (value.isEmpty() || !value.matches("^[0-9]*$")) {
                    intValue = 0;
                } else if (value.length() > 6) {
                    intValue = 864000;
                } else {
                    intValue = Integer.parseInt(value);
                    if (intValue > 864000) {
                        intValue = 864000;
                    } else if (intValue % 1800 != 0) {
                        intValue = intValue / 1800 * 1800;
                    }
                }
                this.fUpdatePeriod.setText(String.valueOf(intValue));
                widgetApp.setUpdate_period(String.valueOf(intValue));
                this.updatePeriodLabel.setText(this.computeInDayHourMinFormat(intValue));
                this.updatePeriodChangeFlag = false;
            }
            if (this.isMaxInstanceSupported(apiversion = manifest.getApiVersion(), profile = manifest.getProfile().getName())) {
                if (this.fMaxInstance != null) {
                    String value = widgetApp.getMax_Instance();
                    this.updateMaxInstanceChangeFlag = true;
                    int intValue = 0;
                    intValue = value == null || value.isEmpty() || !value.matches("^[0-9]*$") ? 0 : Integer.parseInt(value);
                    this.fMaxInstance.setText(String.valueOf(intValue));
                    widgetApp.setMax_Instance(String.valueOf(intValue));
                    this.fMaxInstance.setVisible(true);
                    this.maxInstanceLabel.setVisible(true);
                    this.updateMaxInstanceChangeFlag = false;
                }
            } else if (this.fMaxInstance != null && this.maxInstanceLabel != null) {
                this.fMaxInstance.setVisible(false);
                this.maxInstanceLabel.setVisible(false);
                widgetApp.setMax_Instance("0");
            }
        }
    }

    private void createWidgetSection(FormToolkit toolkit, Composite left) {
        Composite widgetSection = new Composite(left, 0);
        widgetSection.setLayout((Layout)new GridLayout());
        widgetSection.setLayoutData((Object)new GridData(4, 0, true, false));
        widgetSection.setBackground(new Color(null, 255, 255, 255));
        Label label = new Label(widgetSection, 0);
        label.setText(Messages.AdvancedPage_widget_desc);
        label.setBackground(new Color(null, 255, 255, 255));
        label.setFont(this.getBoldFont((Control)label, 10));
        label.setBackground(new Color(null, 255, 255, 255));
        label.setForeground(new Color(null, 0, 138, 238));
        label = new Label(widgetSection, 0);
        label.setText(Messages.AdvancedPage_support_sizes_text);
        label.setBackground(new Color(null, 255, 255, 255));
        Composite table = new Composite(widgetSection, 0);
        table.setLayout((Layout)new GridLayout());
        table.setLayoutData((Object)new GridData(4, 0, true, false));
        table.setBackground(new Color(null, 255, 255, 255));
        Group group = new Group(table, 0);
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        group.setBackground(new Color(null, 255, 255, 255));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        if (this.getEditor().getCoreManifest().getProfile().getName().equals("wearable")) {
            this.fSize22 = new UiAttrIconWithCheck(this);
            this.fSize22.createUi((Composite)group, toolkit, SUPPORT_SIZES[2], false);
        } else {
            this.fSize21 = new UiAttrIconWithCheck(this);
            this.fSize21.createUi((Composite)group, toolkit, SUPPORT_SIZES[1], false);
            this.fSize22 = new UiAttrIconWithCheck(this);
            this.fSize22.createUi((Composite)group, toolkit, SUPPORT_SIZES[2], false);
            this.fSize41 = new UiAttrIconWithCheck(this);
            this.fSize41.createUi((Composite)group, toolkit, SUPPORT_SIZES[3], false);
            this.fSize42 = new UiAttrIconWithCheck(this);
            this.fSize42.createUi((Composite)group, toolkit, SUPPORT_SIZES[4], false);
            this.fSize43 = new UiAttrIconWithCheck(this);
            this.fSize43.createUi((Composite)group, toolkit, SUPPORT_SIZES[5], false);
            this.fSize44 = new UiAttrIconWithCheck(this);
            this.fSize44.createUi((Composite)group, toolkit, SUPPORT_SIZES[6], false);
        }
    }

    private void createWatchAttributeSection(FormToolkit toolkit, Composite left) {
        Group group = new Group(left, 4);
        group.setText(Messages.AdvancedPage_misc_title);
        group.setFont(this.getBoldFont((Control)group, 10));
        group.setBackground(new Color(null, 255, 255, 255));
        group.setForeground(new Color(null, 0, 138, 238));
        GridLayout gL = new GridLayout();
        group.setLayout((Layout)gL);
        GridData data = new GridData(4, 4, true, false);
        group.setLayoutData((Object)data);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = 400;
        this.fambientSupportCheck = new Button((Composite)group, 96);
        this.fambientSupportCheck.setText(Messages.AdvancedPage_ambient_support);
        this.fambientSupportCheck.setFont(this.getNormalFont((Control)this.fambientSupportCheck, 10));
        this.fambientSupportCheck.setLayoutData((Object)gd);
        this.fambientSupportCheck.addSelectionListener(this.selectionListener);
        this.fambientSupportCheck.setBackground(new Color(null, 255, 255, 255));
        Composite hwAccessComposite = new Composite((Composite)group, 4);
        hwAccessComposite.setLayout((Layout)new GridLayout(2, false));
        hwAccessComposite.setLayoutData((Object)new GridData(131076));
        hwAccessComposite.setBackground(new Color(null, 255, 255, 255));
        Label label = new Label(hwAccessComposite, 16384);
        label.setText(Messages.AdvancedPage_HwAccel_label);
        label.setFont(this.getNormalFont((Control)label, 10));
        label.setBackground(new Color(null, 255, 255, 255));
        label.setLayoutData((Object)gd);
        this.fHwAccelerationCombo = new Combo(hwAccessComposite, 2316);
        this.fHwAccelerationCombo.setToolTipText(Messages.AdvancedPage_HwAccel_label);
        this.fHwAccelerationCombo.setItems(Constants.HW_ACCELERATION_VALUES);
        this.fHwAccelerationCombo.select(0);
        this.fHwAccelerationCombo.addSelectionListener(this.selectionListener);
    }

    boolean isMaxInstanceSupported(String apiversion, String profile) {
        if (profile.equals("mobile") && this.compareVersion(apiversion, "3.0") >= 0) {
            return true;
        }
        return profile.equals("wearable") && this.compareVersion(apiversion, "2.3.2") >= 0;
    }

    private void createWidgetAttributeSection(FormToolkit toolkit, Composite left) {
        Group group = new Group(left, 4);
        group.setText(Messages.AdvancedPage_misc_title);
        group.setFont(this.getBoldFont((Control)group, 10));
        group.setBackground(new Color(null, 255, 255, 255));
        group.setForeground(new Color(null, 0, 138, 238));
        GridLayout gL = new GridLayout();
        group.setLayout((Layout)gL);
        GridData data = new GridData(4, 4, true, false);
        group.setLayoutData((Object)data);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = 400;
        GridData textGridLayout = new GridData(4, 0x1000000, true, false);
        textGridLayout.widthHint = 89;
        Composite hwAccessComposite = new Composite((Composite)group, 4);
        hwAccessComposite.setLayout((Layout)new GridLayout(2, false));
        hwAccessComposite.setLayoutData((Object)new GridData(131076));
        hwAccessComposite.setBackground(new Color(null, 255, 255, 255));
        Label label = new Label(hwAccessComposite, 0);
        label.setText(Messages.AdvancedPage_HwAccel_label);
        label.setBackground(new Color(null, 255, 255, 255));
        label.setLayoutData((Object)gd);
        this.fHwAccelerationCombo = new Combo(hwAccessComposite, 2316);
        this.fHwAccelerationCombo.setToolTipText(Messages.AdvancedPage_HwAccel_label);
        this.fHwAccelerationCombo.setItems(Constants.HW_ACCELERATION_VALUES);
        this.fHwAccelerationCombo.select(0);
        this.fHwAccelerationCombo.addSelectionListener(this.selectionListener);
        Composite updatePeriodComposite = new Composite((Composite)group, 0);
        updatePeriodComposite.setBackground(new Color(null, 255, 255, 255));
        gL = new GridLayout(5, false);
        updatePeriodComposite.setLayout((Layout)gL);
        label = new Label(updatePeriodComposite, 0);
        label.setText(Messages.AdvancedPage_update_period_label);
        label.setBackground(new Color(null, 255, 255, 255));
        label.setToolTipText(Messages.AdvancedPage_update_period_tooltip);
        label.setLayoutData((Object)gd);
        this.fUpdatePeriod = new Text(updatePeriodComposite, 2048);
        this.fUpdatePeriod.setLayoutData((Object)textGridLayout);
        this.fUpdatePeriod.addVerifyListener(this.verifyListener);
        this.fUpdatePeriod.addModifyListener(this.updatePeriodModifyListener);
        this.fUpdatePeriod.addFocusListener(this.updatePeriodFocusListener);
        this.fUpdatePeriod.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 262144 && event.widget == CoreAdvancedPage.this.fUpdatePeriod) {
                    CoreAdvancedPage.this.updatePeriodText();
                }
            }
        });
        ImageData imageData = null;
        this.plus = new Button(updatePeriodComposite, 8);
        imageData = new ImageData(IdePlugin.getDefault().getResourceLocationURL("icons/editor/plus.png").getFile());
        this.plus.setImage(new Image(null, imageData));
        this.plus.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent arg0) {
            }

            public void mouseDown(MouseEvent event) {
                CoreAdvancedPage.this.incrementUpdatePeriod();
            }

            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
        this.minus = new Button(updatePeriodComposite, 8);
        imageData = new ImageData(IdePlugin.getDefault().getResourceLocationURL("icons/editor/minus.png").getFile());
        this.minus.setImage(new Image(null, imageData));
        this.minus.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent arg0) {
            }

            public void mouseDown(MouseEvent event) {
                CoreAdvancedPage.this.decrementUpdatePeriod();
            }

            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
        this.updatePeriodLabel = new Label(updatePeriodComposite, 0);
        this.updatePeriodLabel.setBackground(new Color(null, 255, 255, 255));
        GridData labelGridData = new GridData(16384, 0x1000000, false, false);
        labelGridData.widthHint = 150;
        this.updatePeriodLabel.setLayoutData((Object)labelGridData);
        String apiVersion = this.getEditor().getCoreManifest().getApiVersion();
        String profile = this.getEditor().getCoreManifest().getProfile().getName();
        Composite maxInstanceComposite = new Composite((Composite)group, 0);
        maxInstanceComposite.setLayout((Layout)new GridLayout(2, false));
        maxInstanceComposite.setBackground(new Color(null, 255, 255, 255));
        this.maxInstanceLabel = new Label(maxInstanceComposite, 0);
        this.maxInstanceLabel.setText(Messages.AdvancedPage_max_instance_label);
        this.maxInstanceLabel.setBackground(new Color(null, 255, 255, 255));
        this.maxInstanceLabel.setLayoutData((Object)gd);
        this.maxInstanceLabel.setToolTipText(Messages.AdvancedPage_max_instance_tooltip);
        this.fMaxInstance = new Text(maxInstanceComposite, 2048);
        this.fMaxInstance.setLayoutData((Object)textGridLayout);
        this.fMaxInstance.addVerifyListener(this.verifyListener);
        this.fMaxInstance.addModifyListener(this.maxInstanceModifyListener);
        this.fMaxInstance.addFocusListener(this.maxInstanceFocusListener);
        this.fMaxInstance.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (event.detail == 4 && event.widget == CoreAdvancedPage.this.fMaxInstance) {
                    CoreAdvancedPage.this.updateMaxInstance();
                    CoreAdvancedPage.this.fMaxInstance.setEnabled(false);
                    CoreAdvancedPage.this.fMaxInstance.setEnabled(true);
                }
            }
        });
        this.fMaxInstance.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 262144 && event.widget == CoreAdvancedPage.this.fMaxInstance) {
                    CoreAdvancedPage.this.updateMaxInstance();
                }
            }
        });
        if (this.isMaxInstanceSupported(apiVersion, profile)) {
            this.fMaxInstance.setVisible(true);
            this.maxInstanceLabel.setVisible(true);
        } else {
            this.fMaxInstance.setVisible(true);
            this.maxInstanceLabel.setVisible(true);
        }
    }

    private void createAppControlSection(final FormToolkit toolkit, Composite parent) {
        this.fAppControlTable = new UiSectionTable();
        this.fAppControlTable.createSection(toolkit, parent, Messages.AppControlPage_label, Messages.AppControlPage_SectionDesc, appColumns, appColumnsWidth, new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener arg0) {
            }

            public boolean isLabelProperty(Object arg0, String arg1) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener arg0) {
            }

            public String getColumnText(Object element, int columnIndex) {
                String value = null;
                AppControl appcontrol = (AppControl)element;
                switch (columnIndex) {
                    case 0: {
                        List<String> list = appcontrol.getOperations();
                        if (list == null || list.isEmpty()) {
                            return null;
                        }
                        value = list.get(0);
                        break;
                    }
                    case 1: {
                        List<String> list = appcontrol.getUri();
                        if (list == null || list.isEmpty()) {
                            return null;
                        }
                        value = list.get(0);
                        break;
                    }
                    case 2: {
                        List<String> list = appcontrol.getMime();
                        if (list == null || list.isEmpty()) {
                            return null;
                        }
                        value = list.get(0);
                    }
                }
                return value;
            }

            public Image getColumnImage(Object arg0, int arg1) {
                return null;
            }
        });
        this.fAppControlTable.setEventHandler(new ISectionTableEvent(){

            @Override
            public void onRemove() {
                IStructuredSelection sel = (IStructuredSelection)CoreAdvancedPage.this.fAppControlTable.getTable().getSelection();
                AppControl app = (AppControl)sel.getFirstElement();
                if (app != null) {
                    CoreAdvancedPage.this.getEditor().getCoreManifest().getDefaultApp().getAppServiceList().remove(app);
                    CoreAdvancedPage.this.fAppControlTable.getTable().remove((Object)app);
                    CoreAdvancedPage.this.setDirty(true);
                }
            }

            @Override
            public void onEdit() {
                UiAppControlScreenDialog dlg = new UiAppControlScreenDialog(toolkit, CoreAdvancedPage.this.presetOperations.toArray(new String[0]), PRESET_MIMETYPES);
                if (dlg.open() == 0) {
                    IStructuredSelection sel = (IStructuredSelection)CoreAdvancedPage.this.fAppControlTable.getTable().getSelection();
                    AppControl app = (AppControl)sel.getFirstElement();
                    if (app != null) {
                        CoreAdvancedPage.this.getEditor().getCoreManifest().getDefaultApp().getAppServiceList().remove(app);
                        CoreAdvancedPage.this.fAppControlTable.getTable().remove((Object)app);
                    }
                    AppControl created = new AppControl();
                    created.addAppServiceItem(AppControl.CATEGORIES.operation, dlg.getOperation());
                    created.addAppServiceItem(AppControl.CATEGORIES.uri, dlg.getUri());
                    created.addAppServiceItem(AppControl.CATEGORIES.mime, dlg.getMime());
                    created.addOperation(dlg.getOperation());
                    created.addUri(dlg.getUri());
                    created.addMime(dlg.getMime());
                    CoreAdvancedPage.this.getEditor().getCoreManifest().getDefaultApp().getAppServiceList().add(created);
                    CoreAdvancedPage.this.setDirty(true);
                    CoreAdvancedPage.this.fAppControlTable.getTable().add((Object)created);
                }
            }

            @Override
            public void onAdd() {
                UiAppControlScreenDialog dlg = new UiAppControlScreenDialog(toolkit, CoreAdvancedPage.this.presetOperations.toArray(new String[0]), PRESET_MIMETYPES);
                if (dlg.open() == 0) {
                    AppControl created = new AppControl();
                    created.addAppServiceItem(AppControl.CATEGORIES.operation, dlg.getOperation());
                    created.addAppServiceItem(AppControl.CATEGORIES.uri, dlg.getUri());
                    created.addAppServiceItem(AppControl.CATEGORIES.mime, dlg.getMime());
                    created.addOperation(dlg.getOperation());
                    created.addUri(dlg.getUri());
                    created.addMime(dlg.getMime());
                    CoreAdvancedPage.this.getEditor().getCoreManifest().getDefaultApp().getAppServiceList().add(created);
                    CoreAdvancedPage.this.setDirty(true);
                    CoreAdvancedPage.this.fAppControlTable.getTable().add((Object)created);
                }
            }
        });
        IProject project = this.getEditor().getProject();
        TizenProjectDescription tizenDesc = ProjectUtil.getTizenProjectDescription((IProject)project);
        if (Constants.generateVersionInt(tizenDesc.getVersion()) >= 2004) {
            this.presetOperations.add("http://tizen.org/appcontrol/operation/launch_on_event");
        }
        if (this.getEditor().getCoreManifest().getDefaultApp().getAppServiceList() != null) {
            this.fAppControlTable.getTable().setInput((Object)this.getEditor().getCoreManifest().getDefaultApp().getAppServiceList().toArray());
        }
    }

    private void BgCategoryAdd(boolean isEdit) {
        List<BackgroundCategory> categories = this.getEditor().getCoreManifest().getDefaultApp().getBgCategoryList();
        if (categories != null) {
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    return ((BackgroundCategory)element).getValue();
                }
            });
            dialog.setTitle(Messages.AdvancedPage_background_title);
            dialog.setMessage("Category types");
            dialog.setElements(IApplicationUtil.getUnusedCategory(categories).toArray());
            if (dialog.open() == 0) {
                BackgroundCategory category;
                if (isEdit) {
                    this.BgCategoryRemove();
                }
                if ((category = (BackgroundCategory)dialog.getFirstResult()) != null) {
                    categories.add(category);
                    this.fBgCategoryTable.getTable().add((Object)category);
                    this.setDirty(true);
                }
            }
        }
    }

    private void BgCategoryRemove() {
        List<BackgroundCategory> categories;
        IStructuredSelection sel = (IStructuredSelection)this.fBgCategoryTable.getTable().getSelection();
        BackgroundCategory category = (BackgroundCategory)sel.getFirstElement();
        if (category != null && (categories = this.getEditor().getCoreManifest().getDefaultApp().getBgCategoryList()) != null) {
            categories.remove(category);
            this.fBgCategoryTable.getTable().remove((Object)category);
            this.setDirty(true);
        }
    }

    private void createBgCategorySection(FormToolkit toolkit, Composite parent) {
        bgDefaultCategoryList = new ArrayList<BackgroundCategory>();
        String[] stringArray = BG_CATEGORY_TYPES;
        int n = BG_CATEGORY_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            bgDefaultCategoryList.add(new BackgroundCategory(s));
            ++n2;
        }
        this.fBgCategoryTable = new UiSectionTable();
        ITableLabelProvider labelProvider = new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof BackgroundCategory) {
                    BackgroundCategory category = (BackgroundCategory)element;
                    return category.getValue();
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        };
        this.fBgCategoryTable.createSection(toolkit, parent, Messages.AdvancedPage_background_title, Messages.AdvancedPage_background_desc, bgCategory, bgCategoryWidth, labelProvider);
        this.fBgCategoryTable.setEventHandler(new ISectionTableEvent(){

            @Override
            public void onRemove() {
                CoreAdvancedPage.this.BgCategoryRemove();
            }

            @Override
            public void onEdit() {
                CoreAdvancedPage.this.BgCategoryAdd(true);
            }

            @Override
            public void onAdd() {
                CoreAdvancedPage.this.BgCategoryAdd(false);
            }
        });
    }

    private void incrementUpdatePeriod() {
        IApplication app;
        String value = this.fUpdatePeriod.getText();
        int intValue = 0;
        if (!value.isEmpty()) {
            intValue = Integer.parseInt(value);
            if ((intValue += 1800) > 864000) {
                intValue = 864000;
            }
        } else {
            intValue = 0;
        }
        this.fUpdatePeriod.setText(String.valueOf(intValue));
        this.updatePeriodLabel.setText(this.computeInDayHourMinFormat(intValue));
        Manifest manifest = this.getEditor().getCoreManifest();
        if (manifest != null && (app = manifest.getDefaultApp()) instanceof WidgetApplication) {
            WidgetApplication widgetApp = (WidgetApplication)app;
            widgetApp.setUpdate_period(this.fUpdatePeriod.getText());
        }
    }

    private void decrementUpdatePeriod() {
        IApplication app;
        String value = this.fUpdatePeriod.getText();
        int intValue = 0;
        if (!value.isEmpty()) {
            intValue = Integer.parseInt(value);
            if ((intValue -= 1800) < 0) {
                intValue = 0;
            }
        } else {
            intValue = 0;
        }
        this.fUpdatePeriod.setText(String.valueOf(intValue));
        this.updatePeriodLabel.setText(this.computeInDayHourMinFormat(intValue));
        Manifest manifest = this.getEditor().getCoreManifest();
        if (manifest != null && (app = manifest.getDefaultApp()) instanceof WidgetApplication) {
            WidgetApplication widgetApp = (WidgetApplication)app;
            widgetApp.setUpdate_period(this.fUpdatePeriod.getText());
        }
    }

    private String computeInDayHourMinFormat(int seconds) {
        int mins = 0;
        int hours = 0;
        int days = 0;
        mins = seconds / 60;
        seconds %= 60;
        hours = mins / 60;
        mins %= 60;
        days = hours / 24;
        String daysString = "";
        String hoursString = "";
        String minsString = "";
        daysString = days < 10 ? "0" + days : String.valueOf(days);
        hoursString = hours < 10 ? "0" + hours : String.valueOf(hours %= 24);
        minsString = mins < 10 ? "0" + mins : String.valueOf(mins);
        return "( " + daysString + ":" + hoursString + ":" + minsString + " dd:hh:mm )";
    }

    private void createShortcutSection(final FormToolkit toolkit, Composite parent) {
        this.fShortcutTable = new UiSectionTable();
        this.fShortcutTable.createSection(toolkit, parent, Messages.AdvancedPage_shortcut, Messages.AdvancedPage_shortcut_desc, shortcutColumns, shortcutColumnsWidth, new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener arg0) {
            }

            public boolean isLabelProperty(Object arg0, String arg1) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener arg0) {
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof Shortcut) {
                    if (columnIndex == 0) {
                        return ((Shortcut)element).getDefaultIcon().getFileName();
                    }
                    if (columnIndex == 1) {
                        return ((Shortcut)element).getExtraKey();
                    }
                    if (columnIndex == 2) {
                        return ((Shortcut)element).getExtraData();
                    }
                }
                return null;
            }

            public Image getColumnImage(Object arg0, int arg1) {
                return null;
            }
        });
        this.fShortcutTable.setEventHandler(new ISectionTableEvent(){

            @Override
            public void onRemove() {
                IStructuredSelection sel = (IStructuredSelection)CoreAdvancedPage.this.fShortcutTable.getTable().getSelection();
                Shortcut shortcut = (Shortcut)sel.getFirstElement();
                if (shortcut != null) {
                    CoreAdvancedPage.this.getEditor().getCoreManifest().getShortCutList().remove(shortcut);
                    CoreAdvancedPage.this.fShortcutTable.getTable().remove((Object)shortcut);
                    CoreAdvancedPage.this.setDirty(true);
                }
            }

            @Override
            public void onEdit() {
                IStructuredSelection sel = (IStructuredSelection)CoreAdvancedPage.this.fShortcutTable.getTable().getSelection();
                Shortcut shortcut = (Shortcut)sel.getFirstElement();
                if (shortcut != null) {
                    UiNewShortCutDialog dlg = new UiNewShortCutDialog(toolkit, CoreAdvancedPage.this.fpage);
                    dlg.setShortcut(shortcut);
                    if (dlg.open() == 0) {
                        CoreAdvancedPage.this.fShortcutTable.getTable().update((Object)shortcut, null);
                        CoreAdvancedPage.this.setDirty(true);
                    }
                }
            }

            @Override
            public void onAdd() {
                Shortcut data;
                UiNewShortCutDialog dlg = new UiNewShortCutDialog(toolkit, CoreAdvancedPage.this.fpage);
                if (dlg.open() == 0 && (data = dlg.getShortcut()) != null && this.valid(data)) {
                    CoreAdvancedPage.this.getEditor().getCoreManifest().getShortCutList().add(data);
                    CoreAdvancedPage.this.setDirty(true);
                    CoreAdvancedPage.this.fShortcutTable.getTable().add((Object)data);
                }
            }

            private boolean valid(Shortcut data) {
                return data.getDefaultIcon() != null && data.getDefaultIcon().getFileName() != null && data.getDefaultIcon().getFileName().length() > 0;
            }
        });
    }

    private void createSplashSection(final FormToolkit toolkit, Composite parent) {
        this.fSplashTable = new UiSectionTable();
        this.fSplashTable.createSection(toolkit, parent, Messages.AdvancedPage_splash_screen, Messages.AdvancedPage_splash_screen_desc, splashColumns, splashColumnsWidth, new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener arg0) {
            }

            public boolean isLabelProperty(Object arg0, String arg1) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener arg0) {
            }

            public String getColumnText(Object element, int columnIndex) {
                String value = null;
                if (element instanceof TizenSplashScreen) {
                    switch (columnIndex) {
                        case 0: {
                            value = ((TizenSplashScreen)element).getSrc().getFileName();
                            break;
                        }
                        case 1: {
                            value = ((TizenSplashScreen)element).getType();
                            break;
                        }
                        case 2: {
                            value = ((TizenSplashScreen)element).getDpi();
                            break;
                        }
                        case 3: {
                            value = ((TizenSplashScreen)element).getOrientation();
                            break;
                        }
                        case 4: {
                            value = Constants.BOOLEAN_VALUES[1];
                            if (!((TizenSplashScreen)element).getIndicator()) break;
                            value = Constants.BOOLEAN_VALUES[0];
                            break;
                        }
                        case 5: {
                            value = ((TizenSplashScreen)element).getOperation();
                        }
                    }
                }
                return value;
            }

            public Image getColumnImage(Object arg0, int arg1) {
                return null;
            }
        });
        this.fSplashTable.setEventHandler(new ISectionTableEvent(){

            @Override
            public void onRemove() {
                IStructuredSelection sel = (IStructuredSelection)CoreAdvancedPage.this.fSplashTable.getTable().getSelection();
                TizenSplashScreen sscreen = (TizenSplashScreen)sel.getFirstElement();
                if (sscreen != null) {
                    UiApplication app = (UiApplication)CoreAdvancedPage.this.getEditor().getCoreManifest().getDefaultApp();
                    app.getSplashScreenList().remove(sscreen);
                    CoreAdvancedPage.this.fSplashTable.getTable().remove((Object)sscreen);
                    CoreAdvancedPage.this.setDirty(true);
                }
            }

            @Override
            public void onEdit() {
                IStructuredSelection sel = (IStructuredSelection)CoreAdvancedPage.this.fSplashTable.getTable().getSelection();
                TizenSplashScreen sscreen = (TizenSplashScreen)sel.getFirstElement();
                if (sscreen != null) {
                    UiNewSplashScreenDialog dlg = new UiNewSplashScreenDialog(toolkit, CoreAdvancedPage.this.fpage);
                    dlg.setSplashScreen(sscreen);
                    if (dlg.open() == 0) {
                        CoreAdvancedPage.this.fSplashTable.getTable().update((Object)sscreen, null);
                        CoreAdvancedPage.this.setDirty(true);
                    }
                }
            }

            @Override
            public void onAdd() {
                TizenSplashScreen data;
                UiNewSplashScreenDialog dlg = new UiNewSplashScreenDialog(toolkit, CoreAdvancedPage.this.fpage);
                if (dlg.open() == 0 && (data = dlg.getSplashScreen()) != null) {
                    Assert.isTrue((boolean)this.valid(data));
                    UiApplication app = (UiApplication)CoreAdvancedPage.this.getEditor().getCoreManifest().getDefaultApp();
                    app.getSplashScreenList().add(data);
                    CoreAdvancedPage.this.setDirty(true);
                    CoreAdvancedPage.this.fSplashTable.getTable().add((Object)data);
                }
            }

            private boolean valid(TizenSplashScreen data) {
                if (data.getSrc() == null || data.getSrc().getFileName() == null || data.getSrc().getFileName().length() <= 0) {
                    return false;
                }
                return data.getType() != null && data.getOrientation() != null;
            }
        });
    }

    private void createMultiResolutionIconSection(final FormToolkit toolkit, Composite parent) {
        this.fIconTable = new UiSectionTable();
        this.fIconTable.createSection(toolkit, parent, Messages.AdvancedPage_icons, Messages.AdvancedPage_icons_desc, iconColumns, iconColumnsWidth, new ITableLabelProvider(){

            public void addListener(ILabelProviderListener arg0) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object arg0, String arg1) {
                return false;
            }

            public void removeListener(ILabelProviderListener arg0) {
            }

            public Image getColumnImage(Object arg0, int arg1) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                String value = null;
                if (element instanceof LocaledValue) {
                    switch (columnIndex) {
                        case 0: {
                            value = ((LocaledValue)element).getLocale();
                            break;
                        }
                        case 1: {
                            value = ((LocaledValue)element).getDpi();
                            break;
                        }
                        case 2: {
                            value = ((LocaledValue)element).getValue();
                        }
                    }
                }
                return value;
            }
        });
        this.fIconTable.setEventHandler(new ISectionTableEvent(){

            @Override
            public void onAdd() {
                Icon data;
                LocaledValue lv;
                UiNewMultiResolutionIconChooserDialog dlg = new UiNewMultiResolutionIconChooserDialog(toolkit, CoreAdvancedPage.this.fpage);
                if (dlg.open() == 0 && (lv = new LocaledValue((data = dlg.getIcon()).getLang(), data.getValue(), data.getDpi())) != null) {
                    UiApplication app = (UiApplication)CoreAdvancedPage.this.getEditor().getCoreManifest().getDefaultApp();
                    if (data.getLang().equalsIgnoreCase("") && data.getDpi().equalsIgnoreCase("")) {
                        app.setDefaultIcon(data);
                    } else {
                        app.getIcons().add(lv);
                        CoreAdvancedPage.this.fIconTable.getTable().add((Object)lv);
                    }
                    CoreAdvancedPage.this.setDirty(true);
                }
                if (!dlg.getDeleteList().isEmpty()) {
                    TableItem[] tableItem;
                    TableItem[] tableItemArray = tableItem = CoreAdvancedPage.this.fIconTable.getTable().getTable().getItems();
                    int n = tableItem.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem icon = tableItemArray[n2];
                        for (String str : dlg.getDeleteList()) {
                            if (!str.equals(((LocaledValue)icon.getData()).getValue())) continue;
                            LocaledValue localedValue = (LocaledValue)icon.getData();
                            CoreAdvancedPage.this.fIconTable.getTable().remove((Object)localedValue);
                        }
                        ++n2;
                    }
                    CoreAdvancedPage.this.setDirty(true);
                }
            }

            @Override
            public void onEdit() {
                IStructuredSelection sel = (IStructuredSelection)CoreAdvancedPage.this.fIconTable.getTable().getSelection();
                LocaledValue icons = (LocaledValue)sel.getFirstElement();
                if (icons != null) {
                    Icon icon = new Icon();
                    icon.setValue(icons.getValue());
                    icon.setDpi(icons.getDpi());
                    icon.setLang(icons.getLocale());
                    UiNewMultiResolutionIconChooserDialog dlg = new UiNewMultiResolutionIconChooserDialog(toolkit, CoreAdvancedPage.this.fpage);
                    dlg.setIcon(icon);
                    if (dlg.open() == 0) {
                        icon = dlg.getIcon();
                        icons.setDpi(icon.getDpi());
                        icons.setLocale(icon.getLang());
                        icons.setValue(icon.getValue());
                        CoreAdvancedPage.this.fIconTable.getTable().update((Object)icons, null);
                        CoreAdvancedPage.this.setDirty(true);
                    }
                }
            }

            @Override
            public void onRemove() {
                IStructuredSelection sel = (IStructuredSelection)CoreAdvancedPage.this.fIconTable.getTable().getSelection();
                LocaledValue icons = (LocaledValue)sel.getFirstElement();
                if (icons != null) {
                    UiApplication app = (UiApplication)CoreAdvancedPage.this.getEditor().getCoreManifest().getDefaultApp();
                    app.getIcons().remove(icons);
                    CoreAdvancedPage.this.fIconTable.getTable().remove((Object)icons);
                    CoreAdvancedPage.this.setDirty(true);
                }
            }
        });
    }
}

