/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sbilib.for_cli;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.tizen.core.gputil.MacroUtil;
import org.tizen.core.gputil.MarkupUtil;
import org.tizen.core.gputil.OSChecker;
import org.tizen.sbilib.for_cli.SBIExecuteEnv;
import org.tizen.sbilib.for_cli.SBIExecuteParam;

public class SBIExecute {
    private static final String SHELL_LINUX_PATH_NAME = "PATH";
    private static final String SHELL_WIN_PATH_NAME = "Path";
    public String execute;
    public String curDir;
    public int order;
    public boolean necessary = false;
    public boolean linux = false;
    public List<SBIExecuteParam> params = new ArrayList<SBIExecuteParam>();
    public List<SBIExecuteEnv> envs = new ArrayList<SBIExecuteEnv>();
    public List<String> echos = new ArrayList<String>();
    private Map<String, String> macros = null;

    public SBIExecute(String execute) {
        this.execute = execute;
        this.order = 0;
    }

    public SBIExecute(String execute, String curDir, int order, String[] attrs) {
        this.execute = execute;
        this.curDir = curDir;
        this.order = order;
        if (attrs != null) {
            for (String attr : attrs) {
                if (attr.equals("necessary")) {
                    this.necessary = true;
                    continue;
                }
                if (!attr.equals("linux")) continue;
                this.linux = true;
            }
        }
    }

    public String getExec() {
        return this.execute;
    }

    public String getCurDir() {
        return this.curDir;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean isNecessary() {
        return this.necessary;
    }

    public boolean isLinux() {
        return this.linux;
    }

    public void addEnv(String name, String value) {
        this.envs.add(new SBIExecuteEnv(name, value, null, null, null));
    }

    public void addEnv(String name, String value, String separator, String[] attrs, String require) {
        this.envs.add(new SBIExecuteEnv(name, value, separator, attrs, require));
    }

    public void addParam(String name, String[] param, String require) {
        this.params.add(new SBIExecuteParam(name, param, require));
    }

    public List<SBIExecuteParam> getParams() {
        return this.params;
    }

    public void addEcho(String text) {
        this.echos.add(text);
    }

    public List<String> getEchos() {
        return this.echos;
    }

    public void setMacros(Map<String, String> macros) {
        this.macros = macros;
    }

    public void applyAllEnvs(Map<String, String> target, String script) {
        for (SBIExecuteEnv env : this.envs) {
            String require = env.getRequire();
            if (require != null && !require.isEmpty()) {
                require = MacroUtil.processMacro((String)require, this.macros);
                require = script == null ? MarkupUtil.processDefaultMarkup((String)require) : MarkupUtil.processDefaultMarkup2((String)require, (MarkupUtil.Runner[])new MarkupUtil.Runner[]{MarkupUtil.getJavaScriptMarkupRunner((String)script)});
                if (require == null || require.trim().isEmpty()) continue;
            }
            String name = env.getName();
            String value = env.getValue();
            if (value == null || value.isEmpty()) continue;
            value = MacroUtil.processMacro((String)value, this.macros);
            value = script == null ? MarkupUtil.processDefaultMarkup((String)value) : MarkupUtil.processDefaultMarkup2((String)value, (MarkupUtil.Runner[])new MarkupUtil.Runner[]{MarkupUtil.getJavaScriptMarkupRunner((String)script)});
            int addmode = 0;
            if (name.startsWith("+")) {
                name = name.substring(1);
                addmode = 1;
            } else if (name.endsWith("+")) {
                name = name.substring(0, env.getName().length() - 1);
                addmode = 2;
            }
            if (OSChecker.isWindows() && name.equalsIgnoreCase(SHELL_WIN_PATH_NAME)) {
                name = SHELL_WIN_PATH_NAME;
            }
            String curVal = null;
            String sep = null;
            if (addmode != 0) {
                curVal = target.get(name);
                if (curVal == null || curVal.isEmpty()) {
                    curVal = System.getenv(name);
                }
                if ((sep = env.getSeparator()) != null && !sep.isEmpty()) {
                    sep = MacroUtil.processMacro((String)sep, this.macros);
                    sep = MarkupUtil.processDefaultMarkup((String)sep);
                }
            }
            if (addmode == 1) {
                if (curVal != null && !curVal.isEmpty()) {
                    value = sep != null ? value + sep + curVal : value + curVal;
                }
            } else if (addmode == 2 && curVal != null && !curVal.isEmpty()) {
                value = sep != null ? curVal + sep + value : curVal + value;
            }
            if (env.attrs != null) {
                for (String attr : env.attrs) {
                    if (attr.equals("executable")) {
                        if (!OSChecker.isWindows()) continue;
                        value = "\"" + value + "\"";
                        continue;
                    }
                    if (attr.equals("linuxsep")) {
                        value = value.replace('\\', '/');
                        continue;
                    }
                    if (!attr.equals("windowssep")) continue;
                    value = value.replace('/', '\\');
                }
            }
            target.put(name, value);
        }
    }

    public String[] getFullCommand() {
        if (this.execute == null || this.execute.trim().isEmpty()) {
            return null;
        }
        ArrayList<String> cmd = new ArrayList<String>();
        String bin = MacroUtil.processMacro((String)this.execute, this.macros);
        if (bin == null || bin.isEmpty()) {
            return null;
        }
        if (OSChecker.isWindows()) {
            bin = bin.replace("\"", "");
            if (!this.linux) {
                bin = new File(bin).getName();
            }
        }
        cmd.add(bin);
        for (int i = 0; i < this.params.size(); ++i) {
            String[] param = this.params.get(i).getFullParam(this.macros);
            if (param == null) continue;
            for (String p : param) {
                cmd.add(p);
            }
        }
        return cmd.toArray(new String[cmd.size()]);
    }

    public String getFullCommandStr() {
        String[] cmd = this.getFullCommand();
        return cmd.toString();
    }
}

