/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sbilib.for_cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.core.gputil.IOUtil;
import org.tizen.core.gputil.MacroUtil;
import org.tizen.core.gputil.MarkupUtil;
import org.tizen.core.gputil.OSChecker;
import org.tizen.core.gputil.VersionUtil;
import org.tizen.core.gputil.XMLUtil;
import org.tizen.sbilib.for_cli.RootstrapData;
import org.tizen.sbilib.for_cli.RootstrapManager;
import org.tizen.sbilib.for_cli.SBIAction;
import org.tizen.sbilib.for_cli.SBIExecute;
import org.tizen.sbilib.for_cli.SbiData;
import org.tizen.sbilib.for_cli.ToolchainData;
import org.tizen.sbilib.for_cli.ToolchainManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SBIProcess {
    protected final Logger logger = LoggerFactory.getLogger(SBIProcess.class);
    private static final String SHELL_COMMAND_LINUX = "/bin/sh";
    private static final String SHELL_COMMAND_MINGW = "sh";
    private static final String SHELL_COMMAND_LINUX_PARAM = "-c";
    private static final String SHELL_COMMAND_WINDOW = "cmd";
    private static final String SHELL_COMMAND_WINDOW_PARAM = "/c";
    private static final String SHELL_WIN_PATH_NAME = "Path";
    private static final int CMDLINEMAX = 65535;
    private boolean validate = false;
    private String sdkPath;
    private ToolchainData toolchain;
    private RootstrapData rootstrap;
    private Map<String, String> macros = new HashMap<String, String>();
    private Map<String, SBIAction> actions = new HashMap<String, SBIAction>();
    private String script;

    public static void setEnv(Map<String, String> env, String key, String value, Map<String, String> macros) {
        if (value != null) {
            value = MacroUtil.processMacro((String)value, macros);
            env.put(key, value);
        }
    }

    public static void setEnv(Map<String, String> env, String key, String value) {
        if (value != null) {
            value = MacroUtil.processMacro((String)value, env);
            env.put(key, value);
        }
    }

    public static List<RootstrapData> loadRootstrapList(String sbiHomePath) {
        return RootstrapManager.getRootstrapDataList(sbiHomePath);
    }

    public static RootstrapData findRootstrap(List<RootstrapData> rootstrapList, String rootstrapName) {
        RootstrapData rootstrap = RootstrapManager.getRootstrap(rootstrapList, rootstrapName);
        return rootstrap;
    }

    public static RootstrapData findRootstrap(List<RootstrapData> rootstrapList, String profileName, String profileVersion, String arch) {
        String platformName = profileName + " " + profileVersion;
        RootstrapData rootstrap = RootstrapManager.getRootstrap(rootstrapList, platformName, arch);
        return rootstrap;
    }

    public static List<ToolchainData> loadToolchainList(String sbiHomePath) {
        return ToolchainManager.getToolchainDataList(sbiHomePath);
    }

    public static ToolchainData findToolchain(List<ToolchainData> toolchainList, String toolchainName, String arch, String projType) {
        ToolchainData toolchain = ToolchainManager.getToolchain(toolchainList, toolchainName, arch, new String("org.tizen.nativecore.buildArtefactType." + projType));
        return toolchain;
    }

    public static ToolchainData findLatestToolchain(List<ToolchainData> toolchainList, String toolchainName, String arch, String projType) {
        ToolchainData toolchain = ToolchainManager.getLatestToolchain(toolchainList, toolchainName, arch, new String("org.tizen.nativecore.buildArtefactType." + projType));
        return toolchain;
    }

    public static Map<String, List<String>> getRootstrapParam(String rootStrapPath) {
        Document doc = null;
        doc = XMLUtil.readXML((File)new File(rootStrapPath));
        if (doc == null) {
            return null;
        }
        String xpath = "/PackageInfo/DevPackage";
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath expr = xpathFactory.newXPath();
        Object nodeset = null;
        try {
            nodeset = expr.evaluate(xpath, doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return null;
        }
        ArrayList<String> arg1 = new ArrayList<String>();
        ArrayList<String> arg2 = new ArrayList<String>();
        ArrayList<String> arg3 = new ArrayList<String>();
        if (nodeset instanceof NodeList) {
            NodeList nodes = (NodeList)nodeset;
            int size = nodes.getLength();
            for (int i = 0; i < size; ++i) {
                Node node = nodes.item(i);
                if (!(node instanceof Element)) continue;
                List itemElems = XMLUtil.getElementsByTag((Element)((Element)node), (String)"include_path");
                for (Element elm : itemElems) {
                    arg1.add(elm.getTextContent());
                }
                itemElems = XMLUtil.getElementsByTag((Element)((Element)node), (String)"library_path");
                for (Element elm : itemElems) {
                    arg2.add(elm.getTextContent());
                }
                itemElems = XMLUtil.getElementsByTag((Element)((Element)node), (String)"library");
                for (Element elm : itemElems) {
                    String txt = elm.getTextContent();
                    arg3.add(txt.substring(3, txt.length() - 3));
                }
            }
        }
        HashMap<String, List<String>> prop = new HashMap<String, List<String>>();
        if (!arg1.isEmpty()) {
            prop.put("include_path", arg1);
        }
        if (arg2.isEmpty()) {
            arg2.add("/usr/lib");
        }
        prop.put("library_path", arg2);
        if (!arg3.isEmpty()) {
            prop.put("library", arg3);
        }
        return prop;
    }

    public ToolchainData getToolchainData() {
        return this.toolchain;
    }

    public void setToolchainData(ToolchainData toolchain) {
        this.toolchain = toolchain;
    }

    public RootstrapData getRootstrapData() {
        return this.rootstrap;
    }

    public void setRootstrapData(RootstrapData rootstrap) {
        this.rootstrap = rootstrap;
    }

    public boolean isValidate() {
        return this.validate;
    }

    public boolean analisysBuildScript(File sbiBuildConfFile, SbiData data, String requireVersion) {
        String version;
        Document sbiDoc = XMLUtil.readXML((File)sbiBuildConfFile);
        if (sbiDoc == null) {
            this.validate = false;
            return false;
        }
        if (requireVersion != null && !requireVersion.isEmpty() && VersionUtil.compareVersion((String)(version = XMLUtil.getDOMValue((Document)sbiDoc, (String)"/sbi/@version")), (String)requireVersion) < 0) {
            this.validate = false;
            return false;
        }
        String sbiHomePath = data.getSbiHomePath();
        if (OSChecker.isWindows()) {
            sbiHomePath = sbiHomePath.replace('\\', '/').replace(" ", "\\ ");
        }
        Map<String, List<String>> rootstrapParam = null;
        NodeList inputNodes = XMLUtil.getDOMNodes((Document)sbiDoc, (String)"/sbi/macros/input");
        for (int i = 0; i < inputNodes.getLength(); ++i) {
            String method;
            Element elem;
            String name;
            Node inputNode = inputNodes.item(i);
            if (inputNode == null || !(inputNode instanceof Element) || (name = (elem = (Element)inputNode).getAttribute("name")) == null || (method = elem.getAttribute("method")) == null || method.isEmpty()) continue;
            String value = null;
            if (method.equals("sysvar")) {
                Object tool;
                String[] values;
                String source = elem.getAttribute("source");
                String value0 = elem.getAttribute("value");
                if (source.equals("OS")) {
                    if (value0.equals("dir.separator")) {
                        value = File.separator;
                    } else if (value0.equals("path.separator")) {
                        value = File.pathSeparator;
                    } else if (value0.equals("os.name")) {
                        value = System.getProperty("os.name");
                    } else if (value0.equals("os.name.windows")) {
                        value = System.getProperty("os.name");
                        if (!value.toLowerCase().startsWith("windows")) {
                            value = null;
                        }
                    } else if (value0.equals("os.name.linux")) {
                        value = System.getProperty("os.name");
                        if (!value.toLowerCase().startsWith("linux")) {
                            value = null;
                        }
                    } else if (value0.equals("os.name.mac") && !(value = System.getProperty("os.name")).toLowerCase().startsWith("mac")) {
                        value = null;
                    }
                } else if (source.equals("SDK")) {
                    if (value0.equals("sdk.path")) {
                        value = this.sdkPath;
                    } else if (value0.equals("sbi.path")) {
                        value = sbiHomePath;
                    }
                } else if (source.equals("TOOLCHAIN")) {
                    values = value0.split(":");
                    if (values[0].equals("tool")) {
                        tool = this.toolchain.getTool(values[1]);
                        if (tool != null) {
                            value = ((ToolchainData.ToolData)tool).path;
                        }
                    } else if (values[0].equals("property")) {
                        value = this.toolchain.getProperty(values[1]);
                    }
                } else if (source.equals("ROOTSTRAP")) {
                    values = value0.split(":");
                    if (values[0].equals("tool")) {
                        tool = this.rootstrap.getTool(values[1]);
                        if (tool != null) {
                            value = ((RootstrapData.ToolData)tool).path;
                        }
                    } else if (values[0].equals("property")) {
                        value = this.rootstrap.getProperty(values[1]);
                    } else if (values[0].equals("devpackage")) {
                        String path;
                        if (rootstrapParam == null && (path = this.rootstrap.getProperty("DEV_PACKAGE_CONFIG_PATH")) != null) {
                            rootstrapParam = SBIProcess.getRootstrapParam(path.replace("#{SBI_HOME}", sbiHomePath));
                        }
                        if (rootstrapParam != null) {
                            String sur;
                            String pr;
                            List lst = (List)rootstrapParam.get(values[1]);
                            String sep = elem.getAttribute("separator");
                            if (sep != null && !sep.isEmpty() && !(sep = MacroUtil.processMacro((String)sep, this.macros)).isEmpty()) {
                                sep = MarkupUtil.processDefaultMarkup((String)sep);
                            }
                            if ((pr = elem.getAttribute("prefix")) != null && !pr.isEmpty() && !(pr = MacroUtil.processMacro((String)pr, this.macros)).isEmpty()) {
                                pr = MarkupUtil.processDefaultMarkup((String)pr);
                            }
                            if ((sur = elem.getAttribute("surfix")) != null && !sur.isEmpty() && !(sur = MacroUtil.processMacro((String)sur, this.macros)).isEmpty()) {
                                sur = MarkupUtil.processDefaultMarkup((String)sur);
                            }
                            if (lst != null) {
                                value = "";
                                for (String val : lst) {
                                    if (!value.isEmpty() && sep != null && !sep.isEmpty()) {
                                        value = value + sep;
                                    }
                                    value = value + pr + val + sur;
                                }
                            }
                        }
                    }
                } else if (source.equals("PROJECT") && !value0.equals("build.options")) {
                    if (value0.equals("project.path")) {
                        value = data.getWorkingDir();
                    } else if (value0.equals("build.config")) {
                        value = data.getSbiConfig();
                    } else if (value0.equals("build.arch")) {
                        value = data.getSbiArchitecture();
                    } else if (value0.equals("app.id")) {
                        value = data.getSbiAppId();
                    } else if (value0.equals("app.type")) {
                        value = data.getSbiType();
                    }
                }
            } else if (!method.equals("xpath") && method.equals("user")) {
                value = elem.getAttribute("value");
            }
            if (value == null) continue;
            this.macros.put(name, value);
        }
        NodeList actionNodes = XMLUtil.getDOMNodes((Document)sbiDoc, (String)"/sbi/action");
        for (int i = 0; i < actionNodes.getLength(); ++i) {
            Node action = actionNodes.item(i);
            if (action == null || !(action instanceof Element)) continue;
            SBIAction act = new SBIAction();
            act.setName(((Element)action).getAttribute("name"));
            act.setCurDir(((Element)action).getAttribute("curdir"));
            NodeList execList = XMLUtil.getDOMNodes((Element)((Element)action), (String)"execute");
            for (int j = 0; j < execList.getLength(); ++j) {
                Node execNode = execList.item(j);
                if (execNode == null || !(execNode instanceof Element)) continue;
                String execPath = ((Element)execNode).getAttribute("exec");
                String curdir = ((Element)execNode).getAttribute("curdir");
                String orderStr = ((Element)execNode).getAttribute("order");
                String attr = ((Element)execNode).getAttribute("attr");
                int order = 0;
                if (orderStr != null && !orderStr.isEmpty()) {
                    order = Integer.valueOf(orderStr);
                }
                String[] attrs = null;
                if (attr != null && !attr.isEmpty()) {
                    attrs = attr.split(",");
                }
                SBIExecute exec = new SBIExecute(execPath, curdir, order, attrs);
                NodeList paramList = XMLUtil.getDOMNodes((Element)((Element)execNode), (String)"param");
                for (int k = 0; k < paramList.getLength(); ++k) {
                    Node paramNode = paramList.item(k);
                    if (!(paramNode instanceof Element)) continue;
                    Element elem = (Element)paramNode;
                    String name = elem.getAttribute("name");
                    String inputs = elem.getAttribute("inputs");
                    String[] values = inputs.split(",");
                    String require = elem.getAttribute("require");
                    exec.addParam(name, values, require);
                }
                NodeList envList = XMLUtil.getDOMNodes((Element)((Element)execNode), (String)"env");
                for (int k = 0; k < envList.getLength(); ++k) {
                    String[] inputList;
                    String inputs;
                    Node envNode = envList.item(k);
                    if (!(envNode instanceof Element)) continue;
                    Element elem = (Element)envNode;
                    String type = elem.getAttribute("type");
                    if (type == null || type.isEmpty()) {
                        String name = elem.getAttribute("name");
                        String value = elem.getAttribute("value");
                        String envAttrs = elem.getAttribute("attr");
                        String separator = elem.getAttribute("separator");
                        String require = elem.getAttribute("require");
                        String value2 = null;
                        if (name == null) continue;
                        String[] attrList = null;
                        if (envAttrs != null) {
                            attrList = envAttrs.split(",");
                        }
                        exec.addEnv(name, value2 != null ? value2 : value, separator, attrList, require);
                        continue;
                    }
                    if (!type.equals("batch") || (inputs = elem.getAttribute("inputs")) == null) continue;
                    for (String input : inputList = inputs.split(",")) {
                        exec.addEnv(input, this.macros.get(input));
                    }
                }
                NodeList echoList = XMLUtil.getDOMNodes((Element)((Element)execNode), (String)"echo");
                for (int k = 0; k < echoList.getLength(); ++k) {
                    Node echoNode = echoList.item(k);
                    if (!(echoNode instanceof Element)) continue;
                    Element elem = (Element)echoNode;
                    String text = elem.getAttribute("text");
                    exec.addEcho(text);
                }
                act.addExec(exec);
            }
            act.setMacros(this.macros);
            this.actions.put(act.name, act);
        }
        NodeList scriptNodes = XMLUtil.getDOMNodes((Document)sbiDoc, (String)"/sbi/script");
        for (int i = 0; i < scriptNodes.getLength(); ++i) {
            Node script = scriptNodes.item(i);
            if (script == null || !(script instanceof Element)) continue;
            String scriptText = script.getTextContent();
            this.addScript(scriptText);
        }
        this.validate = true;
        return true;
    }

    public boolean analisysBuildScript(File sbiBuildConfFile, SbiData data) {
        return this.analisysBuildScript(sbiBuildConfFile, data, null);
    }

    public Map<String, String> getMacros() {
        return this.macros;
    }

    public SBIAction getAction(String actionName) {
        return this.actions.get(actionName);
    }

    public void addScript(String script) {
        this.script = this.script == null ? script : this.script + " " + script;
    }

    public String getScript() {
        return this.script;
    }

    public static String[] getCommand(String[] commands, boolean isLinux) {
        String[] fullCommand;
        if (OSChecker.isWindows()) {
            if (isLinux) {
                fullCommand = new String[6 + commands.length];
                fullCommand[0] = SHELL_COMMAND_WINDOW;
                fullCommand[1] = SHELL_COMMAND_WINDOW_PARAM;
                fullCommand[2] = "\"";
                fullCommand[3] = SHELL_COMMAND_MINGW;
                fullCommand[4] = SHELL_COMMAND_LINUX_PARAM;
                System.arraycopy(commands, 0, fullCommand, 5, commands.length);
                int idx = 5 + commands.length;
                fullCommand[idx] = "\"";
            } else {
                fullCommand = new String[2 + commands.length];
                fullCommand[0] = SHELL_COMMAND_WINDOW;
                fullCommand[1] = SHELL_COMMAND_WINDOW_PARAM;
                System.arraycopy(commands, 0, fullCommand, 2, commands.length);
            }
        } else {
            fullCommand = new String[2 + commands.length];
            fullCommand[0] = SHELL_COMMAND_LINUX;
            fullCommand[1] = SHELL_COMMAND_LINUX_PARAM;
            System.arraycopy(commands, 0, fullCommand, 2, commands.length);
        }
        return fullCommand;
    }

    public static String[] getMinGWCommand(String command) {
        return new String[]{SHELL_COMMAND_WINDOW, SHELL_COMMAND_WINDOW_PARAM, SHELL_COMMAND_MINGW, SHELL_COMMAND_LINUX_PARAM, "\"" + command + "\""};
    }

    public static String[] getCommand(String command) {
        if (OSChecker.isWindows()) {
            return new String[]{SHELL_COMMAND_WINDOW, SHELL_COMMAND_WINDOW_PARAM, command};
        }
        return new String[]{SHELL_COMMAND_LINUX, SHELL_COMMAND_LINUX_PARAM, command};
    }

    public SBIProcess() {
        this.sdkPath = null;
    }

    public SBIProcess(String sdkPath) {
        this.sdkPath = sdkPath;
    }

    public void setSdkPath(String sdkPath) {
        this.sdkPath = sdkPath;
    }

    public ProcessBuilder genProcessBuilder(ProcessBuilder pb) {
        if (pb == null) {
            pb = new ProcessBuilder(new String[0]);
        }
        if (OSChecker.isWindows()) {
            if (this.logger != null) {
                this.logger.info("Generate ProcessBuilder for Windows (" + this.sdkPath + ")");
            }
            if (this.sdkPath != null) {
                String curEnv = System.getenv(SHELL_WIN_PATH_NAME);
                pb.environment().put(SHELL_WIN_PATH_NAME, curEnv);
            }
        }
        return pb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static int executeProcess(ProcessBuilder pb, String[] cmds, Logger logger) {
        String sbiTrace = "[SBI] command : ";
        for (String c : cmds) {
            sbiTrace = sbiTrace + c + " ";
        }
        logger.info(sbiTrace);
        pb.command(cmds);
        pb.redirectErrorStream(true);
        Process proc = null;
        BufferedReader input = null;
        try {
            proc = pb.start();
            input = new BufferedReader(new InputStreamReader(proc.getInputStream()), 65535);
            if (logger != null) {
                String line = null;
                while ((line = input.readLine()) != null) {
                    logger.info(line);
                }
            }
            proc.waitFor();
        }
        catch (IOException e) {
            if (logger != null) {
                logger.error("IOException occurred:", (Throwable)e);
            }
            int n = -1;
            IOUtil.tryClose((Object[])new Object[]{input});
            if (proc != null) {
                proc.destroy();
            }
            return n;
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
            int n = -1;
            {
                catch (Throwable throwable) {
                    IOUtil.tryClose((Object[])new Object[]{input});
                    if (proc != null) {
                        proc.destroy();
                    }
                    throw throwable;
                }
            }
            IOUtil.tryClose((Object[])new Object[]{input});
            if (proc != null) {
                proc.destroy();
            }
            return n;
        }
        IOUtil.tryClose((Object[])new Object[]{input});
        if (proc != null) {
            proc.destroy();
        }
        return proc.exitValue();
    }

    public int procAction(String actionName, String projPath, ProcessBuilder pb, Logger logger) {
        String actCurDir;
        int result = 0;
        SBIAction act = this.actions.get(actionName);
        if (act == null) {
            return -1;
        }
        if (pb == null) {
            pb = this.genProcessBuilder(pb);
        }
        if ((actCurDir = MacroUtil.processMacro((String)act.getCurDir(), this.macros)) == null || actCurDir.isEmpty()) {
            actCurDir = projPath;
        }
        int cmdCount = act.getExecCount();
        for (int i = 0; i < cmdCount; ++i) {
            String[] cmds;
            SBIExecute exec = act.getExec(i);
            if (exec == null || (cmds = exec.getFullCommand()) == null && exec.isNecessary()) continue;
            List<String> echos = exec.getEchos();
            for (String echo : echos) {
                if (echo == null || echo.isEmpty()) continue;
                echo = MacroUtil.processMacro((String)echo, this.macros);
                echo = this.getScript() == null ? MarkupUtil.processDefaultMarkup((String)echo) : MarkupUtil.processDefaultMarkup2((String)echo, (MarkupUtil.Runner[])new MarkupUtil.Runner[]{MarkupUtil.getJavaScriptMarkupRunner((String)this.getScript())});
                logger.info("[SBI] " + echo);
            }
            exec.applyAllEnvs(pb.environment(), this.getScript());
            if (cmds == null) continue;
            String[] fullCmd = SBIProcess.getCommand(cmds, exec.isLinux());
            String curDir = exec.getCurDir();
            if (curDir != null && !curDir.isEmpty()) {
                if ((curDir = MacroUtil.processMacro((String)curDir, this.macros)) != null && !curDir.isEmpty()) {
                    pb.directory(new File(curDir));
                }
            } else if (actCurDir != null && !actCurDir.isEmpty()) {
                pb.directory(new File(actCurDir));
            }
            if ((result = SBIProcess.executeProcess(pb, fullCmd, logger)) != 0 && exec.isNecessary()) break;
        }
        return result;
    }
}

