/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.editor.dlg;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.tizen.nativecore.ext.manifest.Account;

public class AccountCapabilityEditingSupport
extends EditingSupport {
    private CellEditor editor;
    private final ColumnViewer viewer;
    private String capability = "";
    private final String[] capabilityList;

    public AccountCapabilityEditingSupport(ColumnViewer viewer, String[] list) {
        super(viewer);
        this.viewer = viewer;
        this.capabilityList = list;
        if (viewer instanceof TableViewer) {
            this.editor = new ComboBoxCellEditor((Composite)((TableViewer)viewer).getTable(), this.capabilityList, 4){

                protected Object doGetValue() {
                    String comboBoxString = ((CCombo)this.getControl()).getText();
                    if (!comboBoxString.isEmpty()) {
                        AccountCapabilityEditingSupport.this.capability = comboBoxString;
                    }
                    return AccountCapabilityEditingSupport.this.capability;
                }
            };
        }
    }

    protected CellEditor getCellEditor(Object element) {
        return this.editor;
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    protected Object getValue(Object element) {
        if (!(element instanceof Account.AccountCapability)) {
            return null;
        }
        Account.AccountCapability capability = (Account.AccountCapability)element;
        String name = capability.getCapabilities();
        int index = 0;
        while (index < this.capabilityList.length) {
            if (name.equals(this.capabilityList[index])) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    protected void setValue(Object element, Object value) {
        if (!(element instanceof Account.AccountCapability)) {
            return;
        }
        Account.AccountCapability capability = (Account.AccountCapability)element;
        capability.setCapabilities((String)value);
        this.viewer.update(element, null);
    }
}

