/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.ext.manifest;

import java.util.ArrayList;
import java.util.List;
import org.tizen.nativecore.ext.manifest.CustomAttribute;
import org.tizen.nativecore.ext.manifest.CustomElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Feature {
    public static final String ELEMENT = "feature";
    private static final String ATTR_KEY = "Key";
    private static final String ATTR_TYPE = "Type";
    private static final String ATTR_HIDDEN = "Hidden";
    private static final String ATTR_DESC = "Desc";
    private static final String ATTR_DEFAULT = "Default";
    private static final String ELEMENT_DESC = "Description";
    private static final String ELEMENT_OPTION = "Option";
    private FEATURE_TYPE fType;
    private String fDesc;
    private boolean fIsHidden;
    private String fDefaultValue;
    private List<Option> fOptions = new ArrayList<Option>();
    private List<CustomAttribute> customAttrList = new ArrayList<CustomAttribute>();
    private List<CustomElement> customElementList = new ArrayList<CustomElement>();
    private String name;
    private String value;

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        Feature feature2;
        return obj instanceof Feature && this.name.equals((feature2 = (Feature)obj).getKey());
    }

    public FEATURE_TYPE getType() {
        return this.fType;
    }

    public String getKey() {
        return this.name;
    }

    public String getDesc() {
        return this.fDesc;
    }

    public String getDefaultValue() {
        return this.fDefaultValue;
    }

    public void setfDefaultValue(String fDefaultValue) {
        this.fDefaultValue = fDefaultValue;
    }

    public List<Option> getOptions() {
        return this.fOptions;
    }

    public boolean isHidden() {
        return this.fIsHidden;
    }

    public String getValue() {
        return this.value;
    }

    public Feature(String name) {
        this.name = name;
    }

    public Feature() {
    }

    public Feature(String key, String value) {
        this.name = key;
        this.value = value;
    }

    public Feature(String key, FEATURE_TYPE type) {
        this.name = key;
        this.fType = type;
    }

    public Feature(Node node) {
        NamedNodeMap nmap = node.getAttributes();
        this.name = nmap.getNamedItem(ATTR_KEY).getNodeValue();
        try {
            Node nItem = nmap.getNamedItem(ATTR_TYPE);
            this.fType = nItem != null ? FEATURE_TYPE.valueOf(nItem.getNodeValue()) : FEATURE_TYPE.FT_BOOL;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.fType = FEATURE_TYPE.FT_BOOL;
        }
        Node nHidden = nmap.getNamedItem(ATTR_HIDDEN);
        this.fIsHidden = nHidden != null && nHidden.getNodeValue().equals(Boolean.TRUE.toString());
        this.fDefaultValue = "true";
        Node child = node.getFirstChild();
        while (child != null) {
            String nodename = child.getNodeName();
            if (nodename.equals(ELEMENT_DESC)) {
                this.fDesc = child.getFirstChild().getNodeValue();
            } else if (nodename.equals(ELEMENT_OPTION)) {
                String v = child.getFirstChild().getNodeValue();
                Option o = new Option(v);
                if (child.hasAttributes()) {
                    Node nNode = child.getAttributes().getNamedItem(ATTR_DEFAULT);
                    if (nNode != null) {
                        this.fDefaultValue = v;
                    }
                    if ((nNode = child.getAttributes().getNamedItem(ATTR_DESC)) != null) {
                        o.desc = nNode.getNodeValue();
                    }
                }
                this.fOptions.add(o);
            }
            child = child.getNextSibling();
        }
    }

    public void loadElement(Element element) {
        if (!element.getNodeName().equals(ELEMENT)) {
            return;
        }
        this.name = element.getAttribute("name");
        this.value = element.getTextContent();
        NamedNodeMap attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Node node = attrs.item(i);
            String attr = node.getNodeName();
            if (this.isCustomAttribute(attr)) {
                CustomAttribute custom = new CustomAttribute();
                custom.loadAttribute(attr, node.getNodeValue());
                this.getCustomAttrList().add(custom);
            }
            ++i;
        }
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                CustomElement custom = new CustomElement();
                custom.loadElement((Element)node);
                this.getCustomElementList().add(custom);
            }
            node = node.getNextSibling();
        }
    }

    public void generateElement(Document dom, Element parent) {
        Element element = dom.createElement(ELEMENT);
        if (this.value != null && this.value.length() > 0) {
            element.setTextContent(this.value);
        }
        if (this.name != null && this.name.length() > 0) {
            element.setAttribute("name", this.name);
        }
        for (CustomAttribute customAttribute : this.getCustomAttrList()) {
            customAttribute.generateAttribute(element);
        }
        for (CustomElement customElement : this.getCustomElementList()) {
            customElement.generateElement(dom, element);
        }
        parent.appendChild(element);
    }

    private boolean isCustomAttribute(String attr) {
        return !attr.equals("name");
    }

    public List<CustomElement> getCustomElementList() {
        return this.customElementList;
    }

    public List<CustomAttribute> getCustomAttrList() {
        return this.customAttrList;
    }

    public static enum FEATURE_TYPE {
        FT_BOOL,
        FT_CHECK,
        FT_COMBO,
        FT_COMBO_WRITABLE,
        FT_UNKNOWN;

    }

    public static class Option {
        String value;
        String desc;

        Option(String v) {
            this.value = v;
            this.desc = v;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }
}

