/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.build.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tizen.nativecommon.build.exception.SBIException;
import org.tizen.sbilib.ide.PluginManager;
import org.tizen.sbilib.ide.Rootstrap;
import org.tizen.sbilib.ide.Target;
import org.tizen.sbilib.ide.Toolchain;

public class SBIModel {
    private static boolean initialized;
    public static final String[][] ARCHITECTURES;
    public static final String[] BASE_ARCHITECTURES;

    static {
        ARCHITECTURES = new String[][]{{"X86", "x86", "i386", "ia32", "i486", "i586", "i686"}, {"ARMv7-a", "armv7-a", "armel", "armv7l"}, {"LLVM-Bitcode/X86(Experimental)", "LLVM-Bitcode/X86"}, {"LLVM-Bitcode/ARM(Experimental)", "LLVM-Bitcode/ARM"}};
        BASE_ARCHITECTURES = new String[]{"i386", "arm", "i386", "arm"};
        initialized = false;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static List<Target> getTargetList() {
        PluginManager pm = PluginManager.getInstance();
        return pm.getTargetList();
    }

    public static void addRootstrap(Rootstrap rootstrap) {
        SBIModel.addRootstrap(rootstrap, false);
    }

    public static void addRootstrap(Rootstrap rootstrap, boolean overwrite) {
        if (rootstrap == null) {
            return;
        }
        PluginManager pm = PluginManager.getInstance();
        if (pm.getRootstrapList().contains(rootstrap) && !overwrite) {
            return;
        }
        pm.addRootstrap(rootstrap);
    }

    public static boolean removeRootstrap(Rootstrap rootstrap) {
        PluginManager pm = PluginManager.getInstance();
        return pm.removeRootstrap(rootstrap);
    }

    public static void addTarget(String targetId, String targetName, String rootstrapId, String toolchainId) throws SBIException {
        PluginManager pm = PluginManager.getInstance();
        pm.createTarget(rootstrapId, toolchainId, targetId, targetName);
    }

    public static synchronized void removeTarget(Target target) {
        PluginManager pm = PluginManager.getInstance();
        pm.removeTarget(target);
    }

    public static Target getTargetById(String id) {
        PluginManager pm = PluginManager.getInstance();
        return pm.getTarget(id);
    }

    public static Target getTargetByName(String name) {
        PluginManager pm = PluginManager.getInstance();
        return pm.getTargetByName(name);
    }

    public static Rootstrap getRootstrapById(String id) {
        PluginManager pm = PluginManager.getInstance();
        return pm.getRootstrap(id);
    }

    public static boolean checkRootstrapById(String id) {
        PluginManager pm = PluginManager.getInstance();
        return pm.isAvailableRootstrapId(id);
    }

    public static Toolchain getToolchainById(String id) {
        PluginManager pm = PluginManager.getInstance();
        return pm.getToolchain(id);
    }

    public static boolean checkToolchainById(String id) {
        PluginManager pm = PluginManager.getInstance();
        return pm.isAvailableToolchainId(id);
    }

    public static List<String> getTargetIdList() throws SBIException {
        ArrayList<String> targetIdList = new ArrayList<String>();
        PluginManager pm = PluginManager.getInstance();
        for (Target t : pm.getTargetList()) {
            targetIdList.add(t.getId());
        }
        return targetIdList;
    }

    public static List<Rootstrap> getRootstrapList() {
        PluginManager pm = PluginManager.getInstance();
        return pm.getRootstrapList();
    }

    public static List<String> getRootstrapIdList() throws SBIException {
        ArrayList<String> rootstrapIdList = new ArrayList<String>();
        for (Rootstrap r : SBIModel.getRootstrapList()) {
            rootstrapIdList.add(r.getId());
        }
        return rootstrapIdList;
    }

    public static List<Toolchain> getToolchainList() {
        PluginManager pm = PluginManager.getInstance();
        return pm.getToolchainList();
    }

    public static List<String> getToolchainIdList() throws SBIException {
        ArrayList<String> toolchainIdList = new ArrayList<String>();
        for (Toolchain tc : SBIModel.getToolchainList()) {
            toolchainIdList.add(tc.getId());
        }
        return toolchainIdList;
    }

    public static synchronized void initialize() {
        SBIModel.initialize(null, null);
    }

    public static synchronized void initialize(IProgressMonitor monitor, String sdkInstalledPath) {
        if (initialized) {
            return;
        }
        if (monitor != null) {
            monitor.worked(10);
        }
        PluginManager.getInstance((String)sdkInstalledPath);
        if (monitor != null) {
            monitor.worked(90);
        }
        initialized = true;
    }

    public static synchronized void reinitialize() throws SBIException {
        PluginManager pm = PluginManager.getInstance();
        pm.reInit();
    }

    public static String getToolchainPropertyValue(String toolchainID, String key) {
        return SBIModel.getToolchainById(toolchainID).getPropertyValue(key);
    }

    public static String getRootstrapPropertyValue(String rootstrapID, String key) {
        return SBIModel.getRootstrapById(rootstrapID).getPropertyValue(key);
    }

    public static int getDisplayArchIndex(String dispArch) {
        int i = 0;
        while (i < ARCHITECTURES.length) {
            if (ARCHITECTURES[i][0].equals(dispArch)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String getDisplayArch(Rootstrap rs) {
        if (rs == null) {
            return "";
        }
        String[][] stringArray = ARCHITECTURES;
        int n = ARCHITECTURES.length;
        int n2 = 0;
        while (n2 < n) {
            String[] archGroup;
            String[] stringArray2 = archGroup = stringArray[n2];
            int n3 = archGroup.length;
            int n4 = 0;
            while (n4 < n3) {
                String archItem = stringArray2[n4];
                if (archItem.equalsIgnoreCase(rs.getArchitecture())) {
                    return archGroup[0];
                }
                ++n4;
            }
            ++n2;
        }
        return "";
    }

    public static String getDisplayArch(String rootstrapId) {
        Rootstrap rs = SBIModel.getRootstrapById(rootstrapId);
        return SBIModel.getDisplayArch(rs);
    }

    public static String getBaseArchName(String arch) {
        int i = 0;
        while (i < ARCHITECTURES.length) {
            String[] stringArray = ARCHITECTURES[i];
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String archItem = stringArray[n2];
                if (archItem.compareToIgnoreCase(arch) == 0) {
                    return BASE_ARCHITECTURES[i];
                }
                ++n2;
            }
            ++i;
        }
        return arch;
    }
}

