/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.cli.model;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.common.util.OSChecker;
import org.tizen.nativecore.cli.model.EDCFlagModel;
import org.tizen.nativecore.cli.model.ProjectDefFile;

public class ProjectDefFileWriter {
    private static final String DEF_NAME = "APPNAME";
    private static final String DEF_TYPE = "type";
    private static final String DEF_PROFILE = "profile";
    private static final String DEF_USER_SRCS = "USER_SRCS";
    private static final String DEF_USER_POS = "USER_POS";
    private static final String DEF_USER_EDCS = "USER_EDCS";
    private static final String DEF_USER_DEFS = "USER_DEFS";
    private static final String DEF_USER_UNDEFS = "USER_UNDEFS";
    private static final String DEF_USER_CPP_DEFS = "USER_CPP_DEFS";
    private static final String DEF_USER_CPP_UNDEFS = "USER_CPP_UNDEFS";
    private static final String DEF_USER_LIBS = "USER_LIBS";
    private static final String DEF_USER_OBJS = "USER_OBJS";
    private static final String DEF_USER_INC_DIRS = "USER_INC_DIRS";
    private static final String DEF_USER_C_INC_DIRS = "USER_C_INC_DIRS";
    private static final String DEF_USER_CPP_INC_DIRS = "USER_CPP_INC_DIRS";
    private static final String DEF_USER_INC_FILES = "USER_INC_FILES";
    private static final String DEF_USER_CPP_INC_FILES = "USER_CPP_INC_FILES";
    private static final String DEF_USER_LIB_DIRS = "USER_LIB_DIRS";
    private static final String DEF_USER_EDCS_IMAGE_DIRS = "USER_EDCS_IMAGE_DIRS";
    private static final String DEF_USER_EDCS_SOUND_DIRS = "USER_EDCS_SOUND_DIRS";
    private static final String DEF_USER_EDCS_FONT_DIRS = "USER_EDCS_FONT_DIRS";
    private static final String DEF_USER_EXT_EDC_KEYS = "USER_EXT_EDC_KEYS";
    private static final String DEF_USER_EXT_EDCS = "USER_EXT_%s_EDCS";
    private static final String DEF_USER_EXT_EDCS_IMAGE_DIRS = "USER_EXT_%s_EDCS_IMAGE_DIRS";
    private static final String DEF_USER_EXT_EDCS_SOUND_DIRS = "USER_EXT_%s_EDCS_SOUND_DIRS";
    private static final String DEF_USER_EXT_EDCS_FONT_DIRS = "USER_EXT_%s_EDCS_FONT_DIRS";
    private static final String DEF_USER_RES_INCLUDE = "USER_RES_INCLUDE";
    private static final String DEF_USER_RES_EXCLUDE = "USER_RES_EXCLUDE";
    private static final String WHITESPACE = " ";
    private ProjectDefFile projDef;

    public ProjectDefFileWriter(ProjectDefFile projDef) {
        this.projDef = projDef;
    }

    public void write(String filePath) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(filePath));
        out.newLine();
        this.writeProjectInfo(out);
        this.writeSources(out);
        this.writeDefines(out);
        this.writeUndefines(out);
        this.writeUserLibs(out);
        this.writeUserObjs(out);
        this.writeUserIncludes(out);
        this.writeUserLibPath(out);
        this.writeEdcResPath(out);
        this.writeEdcFlags(out);
        this.writeResourceFilter(out);
        out.close();
    }

    private void writeProjectInfo(BufferedWriter out) throws IOException {
        out.write("# Project Name");
        out.newLine();
        out.write(this.makeStatement(DEF_NAME, this.projDef.getAppName()));
        out.newLine();
        out.newLine();
        out.write("# Project Type");
        out.newLine();
        out.write(this.makeStatement(DEF_TYPE, this.projDef.getAppType()));
        out.newLine();
        out.newLine();
        out.write("# Project Profile");
        out.newLine();
        out.write(this.makeStatement(DEF_PROFILE, this.projDef.getAppProfile()));
        out.newLine();
        out.newLine();
    }

    private void writeSources(BufferedWriter out) throws IOException {
        ArrayList<String> userSources = new ArrayList<String>();
        userSources.addAll(this.projDef.getCFiles());
        userSources.addAll(this.projDef.getCppFiles());
        out.write("# C/CPP Sources");
        out.newLine();
        out.write(this.makeStatement(DEF_USER_SRCS, userSources));
        out.newLine();
        out.newLine();
        out.write("# EDC Sources");
        out.newLine();
        out.write(this.makeStatement(DEF_USER_EDCS, WHITESPACE));
        out.newLine();
        out.newLine();
        out.write("# PO Sources");
        out.newLine();
        out.write(this.makeStatement(DEF_USER_POS, this.projDef.getPoFiles()));
        out.newLine();
        out.newLine();
    }

    private void writeDefines(BufferedWriter out) throws IOException {
        out.write("# User Defines");
        out.newLine();
        out.write(this.makeStatement(DEF_USER_DEFS, this.projDef.getCDefines()));
        out.newLine();
        out.write(this.makeStatement(DEF_USER_CPP_DEFS, this.projDef.getCppDefines()));
        out.newLine();
        out.newLine();
    }

    private void writeUndefines(BufferedWriter out) throws IOException {
        out.write("# User Undefines");
        out.newLine();
        out.write(this.makeStatement(DEF_USER_UNDEFS, this.projDef.getCUndefines()));
        out.newLine();
        out.write(this.makeStatement(DEF_USER_CPP_UNDEFS, this.projDef.getCppUndefines()));
        out.newLine();
        out.newLine();
    }

    private void writeUserLibs(BufferedWriter out) throws IOException {
        out.write("# User Libraries");
        out.newLine();
        out.write(this.makeStatement(DEF_USER_LIBS, this.projDef.getUserLibs()));
        out.newLine();
        out.newLine();
    }

    private void writeUserObjs(BufferedWriter out) throws IOException {
        out.write("# User Objects");
        out.newLine();
        out.write(this.makeStatement(DEF_USER_OBJS, this.projDef.getRelativeUserObjs()));
        out.newLine();
        out.newLine();
    }

    private void writeUserIncludes(BufferedWriter out) throws IOException {
        out.write("# User Includes");
        out.newLine();
        out.write("## C Compiler");
        out.newLine();
        out.write(this.makeStatement(DEF_USER_C_INC_DIRS, this.projDef.getRelativeCIncPath()));
        out.newLine();
        out.write(this.makeStatement(DEF_USER_INC_FILES, this.projDef.getRelativeCIncFile()));
        out.newLine();
        out.write("## C++ Compiler");
        out.newLine();
        out.write(this.makeStatement(DEF_USER_CPP_INC_DIRS, this.projDef.getRelativeCppIncPath()));
        out.newLine();
        out.write(this.makeStatement(DEF_USER_CPP_INC_FILES, this.projDef.getRelativeCppIncFile()));
        out.newLine();
        out.newLine();
        String allIncludePaths = String.format("$(%s) $(%s)", DEF_USER_C_INC_DIRS, DEF_USER_CPP_INC_DIRS);
        out.write(this.makeStatement(DEF_USER_INC_DIRS, allIncludePaths));
        out.newLine();
        out.newLine();
    }

    private void writeUserLibPath(BufferedWriter out) throws IOException {
        out.write("# User Library Path");
        out.newLine();
        out.write(this.makeStatement(DEF_USER_LIB_DIRS, this.projDef.getRelativeLibPath()));
        out.newLine();
        out.newLine();
    }

    private void writeEdcResPath(BufferedWriter out) throws IOException {
        out.write("# EDC Resource Path");
        out.newLine();
        out.write(this.makeStatement(DEF_USER_EDCS_IMAGE_DIRS, this.projDef.getRelativeEdcIdPath()));
        out.newLine();
        out.write(this.makeStatement(DEF_USER_EDCS_SOUND_DIRS, this.projDef.getRelativeEdcSdPath()));
        out.newLine();
        out.write(this.makeStatement(DEF_USER_EDCS_FONT_DIRS, this.projDef.getRelativeEdcFdPath()));
        out.newLine();
        out.newLine();
    }

    private void writeEdcFlags(BufferedWriter out) throws IOException {
        out.write("# EDC Flags");
        out.newLine();
        String keyList = "";
        for (EDCFlagModel f : this.projDef.getEDCFlagList()) {
            keyList = String.valueOf(keyList) + f.getKey() + WHITESPACE;
        }
        out.write(this.makeStatement(DEF_USER_EXT_EDC_KEYS, keyList));
        out.newLine();
        out.newLine();
        for (EDCFlagModel f : this.projDef.getEDCFlagList()) {
            String key = f.getKey();
            out.write(this.makeStatement(String.format(DEF_USER_EXT_EDCS, key), f.getSources()));
            out.newLine();
            out.write(this.makeStatement(String.format(DEF_USER_EXT_EDCS_IMAGE_DIRS, key), f.getRelIDPath()));
            out.newLine();
            out.write(this.makeStatement(String.format(DEF_USER_EXT_EDCS_SOUND_DIRS, key), f.getRelSDPath()));
            out.newLine();
            out.write(this.makeStatement(String.format(DEF_USER_EXT_EDCS_FONT_DIRS, key), f.getRelFDPath()));
            out.newLine();
            out.newLine();
        }
    }

    private void writeResourceFilter(BufferedWriter out) throws IOException {
        out.write("# Resource Filter");
        out.newLine();
        out.write(this.makeStatement(DEF_USER_RES_INCLUDE, this.projDef.getPkgIncludeResouceList()));
        out.newLine();
        out.write(this.makeStatement(DEF_USER_RES_EXCLUDE, this.projDef.getPkgExcludeResouceList()));
        out.newLine();
        out.newLine();
    }

    private String makeStatement(String key, String value) {
        if (OSChecker.isWindows()) {
            value = this.convertLinuxPathFormat(value);
        }
        return String.valueOf(key) + " = " + value;
    }

    private String makeStatement(String key, List<String> value) {
        return this.makeStatement(key, value.toArray(new String[0]));
    }

    private String makeStatement(String key, String[] value) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = value;
        int n = value.length;
        int n2 = 0;
        while (n2 < n) {
            String val = stringArray[n2];
            if (OSChecker.isWindows()) {
                val = this.convertLinuxPathFormat(val);
            }
            sb.append(val);
            sb.append(WHITESPACE);
            ++n2;
        }
        return String.valueOf(key) + " = " + sb.toString();
    }

    private String convertLinuxPathFormat(String path) {
        return path.replace("\\", "/");
    }
}

