/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.build;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildDescription;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildResource;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.tizen.nativecommon.build.PlatformChangingManager;

public class RebuildResourcesManager {
    public static IBuildResource[] getRebuildResources(IProject proj) {
        int flags = 15;
        IBuildDescription des = PlatformChangingManager.getBuildDescription(proj, flags);
        ArrayList<IBuildResource> list = new ArrayList<IBuildResource>();
        if (des != null) {
            IBuildResource[] bRcs = des.getResources();
            int i = 0;
            while (i < bRcs.length) {
                IBuildResource buildRc = bRcs[i];
                IPath path = buildRc.getFullPath();
                if (path != null && (buildRc.needsRebuild() || buildRc.isRemoved()) && buildRc.getProducerIOType() != null && buildRc.isProjectResource()) {
                    list.add(buildRc);
                }
                ++i;
            }
        }
        return list.toArray(new IBuildResource[list.size()]);
    }

    public static IPath[] findIncludes(IProject proj, IPath filePath) throws CoreException {
        ICProject project = CoreModel.getDefault().create(proj);
        IIndex index = CCorePlugin.getIndexManager().getIndex(project, 1);
        ArrayList<IPath> list = new ArrayList<IPath>();
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
        IIndexFile[] files = index.getFiles(IndexLocationFactory.getWorkspaceIFL((IFile)file));
        if (files.length > 0) {
            IIndexInclude[] includes;
            IIndexInclude[] iIndexIncludeArray = includes = index.findIncludes(files[0], -1);
            int n = includes.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexInclude inc = iIndexIncludeArray[n2];
                if (inc.isResolved()) {
                    IPath path = IndexLocationFactory.getAbsolutePath((IIndexFileLocation)inc.getIncludesLocation());
                    list.add(path);
                }
                ++n2;
            }
        }
        return list.toArray(new IPath[list.size()]);
    }
}

