/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IContainerEntry;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.IMacroEntry;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.IPathEntryContainer;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.WriteAccessException;
import org.eclipse.cdt.core.settings.model.XmlStorageUtil;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionApplicability;
import org.eclipse.cdt.managedbuilder.core.IOptionPathConverter;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.internal.core.BuildSettingsUtil;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.cdt.managedbuilder.internal.core.Target;
import org.eclipse.cdt.managedbuilder.internal.macros.OptionContextData;
import org.eclipse.cdt.managedbuilder.internal.scannerconfig.ManagedBuildCPathEntryContainer;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGeneratorType;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ManagedBuildInfo
implements IManagedBuildInfo,
IScannerInfo {
    public static final IContainerEntry containerEntry = CoreModel.newContainerEntry((IPath)new Path("org.eclipse.cdt.managedbuilder.MANAGED_CONTAINER"));
    private volatile IManagedProject managedProject;
    private volatile ICProject cProject;
    private volatile boolean isDirty;
    private volatile boolean isValid = false;
    private volatile IResource owner;
    private volatile boolean rebuildNeeded;
    private volatile String version;
    private volatile IConfiguration selectedConfig;
    @Deprecated
    private List<ITarget> targetList;
    @Deprecated
    private Map<String, ITarget> targetMap;
    private volatile boolean isReadOnly = false;
    private volatile boolean bIsContainerInited = false;

    public ManagedBuildInfo(IResource owner) {
        this.owner = owner;
        this.cProject = CoreModel.getDefault().create(owner.getProject());
        this.isDirty = false;
        this.rebuildNeeded = true;
    }

    public ManagedBuildInfo(IResource owner, ICStorageElement element, boolean loadConfigs, String managedBuildRevision) {
        this(owner);
        ICStorageElement[] projNodes = element.getChildren();
        int projIndex = projNodes.length - 1;
        while (projIndex >= 0) {
            ManagedProject proj;
            if ("project".equals(projNodes[projIndex].getName()) && !(proj = new ManagedProject(this, projNodes[projIndex], loadConfigs, managedBuildRevision)).resolveReferences()) {
                proj.setValid(false);
            }
            --projIndex;
        }
        this.rebuildNeeded = false;
        this.version = managedBuildRevision;
    }

    @Override
    public void setManagedProject(IManagedProject managedProject) {
        this.managedProject = managedProject;
    }

    @Override
    public IManagedProject getManagedProject() {
        return this.managedProject;
    }

    @Override
    public boolean buildsFileType(String srcExt) {
        return this.getDefaultConfiguration().buildsFileType(srcExt);
    }

    @Override
    public String getBuildArtifactExtension() {
        String ext = new String();
        IConfiguration config = this.getDefaultConfiguration();
        if (config != null) {
            ext = config.getArtifactExtension();
        }
        return ext;
    }

    @Override
    public String getBuildArtifactName() {
        String name = new String();
        IConfiguration config = this.getDefaultConfiguration();
        if (config != null) {
            name = config.getArtifactName();
        }
        return name;
    }

    @Override
    public String getCleanCommand() {
        String command = new String();
        IConfiguration config = this.getDefaultConfiguration();
        if (config != null) {
            command = config.getCleanCommand();
        }
        return command;
    }

    @Override
    public String getConfigurationName() {
        IConfiguration config = this.getDefaultConfiguration();
        return config == null ? new String() : config.getName();
    }

    @Override
    public String[] getConfigurationNames() {
        ArrayList<String> configNames = new ArrayList<String>();
        IConfiguration[] configs = this.managedProject.getConfigurations();
        int i = 0;
        while (i < configs.length) {
            IConfiguration configuration = configs[i];
            configNames.add(configuration.getName());
            ++i;
        }
        configNames.trimToSize();
        return configNames.toArray(new String[configNames.size()]);
    }

    public ICProject getCProject() {
        return this.cProject;
    }

    @Override
    public IConfiguration getDefaultConfiguration() {
        IConfiguration[] cfgs;
        IConfiguration activeCfg = this.findExistingDefaultConfiguration(null);
        if (activeCfg == null && (cfgs = this.managedProject.getConfigurations()).length != 0) {
            activeCfg = cfgs[0];
        }
        return activeCfg;
    }

    private IConfiguration findExistingDefaultConfiguration(ICProjectDescription des) {
        if (des == null) {
            des = CoreModel.getDefault().getProjectDescription(this.getOwner().getProject(), false);
        }
        IConfiguration activeCfg = null;
        if (des != null) {
            ICConfigurationDescription cfgDes = des.getActiveConfiguration();
            activeCfg = this.managedProject.getConfiguration(cfgDes.getId());
        }
        return activeCfg;
    }

    public Map<String, String> getDefinedSymbols() {
        HashMap<String, String> symbols = this.getMacroPathEntries();
        return symbols;
    }

    @Override
    public IManagedDependencyGeneratorType getDependencyGenerator(String sourceExtension) {
        try {
            if (this.getDefaultConfiguration() != null) {
                ITool[] tools = this.getDefaultConfiguration().getFilteredTools();
                int index = 0;
                while (index < tools.length) {
                    if (tools[index].buildsFileType(sourceExtension)) {
                        return tools[index].getDependencyGeneratorForExtension(sourceExtension);
                    }
                    ++index;
                }
            }
        }
        catch (NullPointerException e) {
            return null;
        }
        return null;
    }

    private ITool[] getFilteredTools() {
        IConfiguration config = this.getDefaultConfiguration();
        return config.getFilteredTools();
    }

    @Override
    public String getFlagsForSource(String extension) {
        return this.getToolFlagsForSource(extension, null, null);
    }

    @Override
    public String getToolFlagsForSource(String extension, IPath inputLocation, IPath outputLocation) {
        ITool[] tools = this.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool != null && tool.buildsFileType(extension)) {
                try {
                    return tool.getToolCommandFlagsString(inputLocation, outputLocation);
                }
                catch (BuildException e) {
                    return null;
                }
            }
            ++index;
        }
        return null;
    }

    @Override
    public String getFlagsForConfiguration(String extension) {
        return this.getToolFlagsForConfiguration(extension, null, null);
    }

    @Override
    public String getToolFlagsForConfiguration(String extension, IPath inputLocation, IPath outputLocation) {
        String ext = extension == null ? new String() : extension;
        ITool[] tools = this.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool.producesFileType(ext)) {
                try {
                    return tool.getToolCommandFlagsString(inputLocation, outputLocation);
                }
                catch (BuildException e) {
                    return null;
                }
            }
            ++index;
        }
        return null;
    }

    private ArrayList<String> getIncludePathEntries() {
        ArrayList<String> paths = new ArrayList<String>();
        if (this.cProject != null) {
            try {
                IPathEntry[] entries = this.cProject.getResolvedPathEntries();
                int index = 0;
                while (index < entries.length) {
                    IIncludeEntry include;
                    int kind = entries[index].getEntryKind();
                    if (kind == 16 && (include = (IIncludeEntry)entries[index]).isSystemInclude()) {
                        IPath entryPath = include.getFullIncludePath();
                        paths.add(entryPath.toString());
                    }
                    ++index;
                }
            }
            catch (CModelException e) {
                paths.clear();
                return paths;
            }
        }
        return paths;
    }

    public String[] getIncludePaths() {
        ArrayList<String> paths = this.getIncludePathEntries();
        return paths.toArray(new String[paths.size()]);
    }

    @Override
    public String[] getLibsForConfiguration(String extension) {
        return this.getDefaultConfiguration().getLibs(extension);
    }

    private HashMap<String, String> getMacroPathEntries() {
        HashMap<String, String> macros = new HashMap<String, String>();
        if (this.cProject != null) {
            try {
                IPathEntry[] entries = this.cProject.getResolvedPathEntries();
                int index = 0;
                while (index < entries.length) {
                    if (entries[index].getEntryKind() == 64) {
                        IMacroEntry macro = (IMacroEntry)entries[index];
                        macros.put(macro.getMacroName(), macro.getMacroValue());
                    }
                    ++index;
                }
            }
            catch (CModelException e) {
                macros.clear();
                return macros;
            }
        }
        return macros;
    }

    @Override
    public String getBuildArguments() {
        IToolChain toolChain;
        IBuilder builder;
        if (this.getDefaultConfiguration() != null && (builder = (toolChain = this.getDefaultConfiguration().getToolChain()).getBuilder()) != null) {
            return builder.getArguments();
        }
        return new String("-k");
    }

    @Override
    public String getBuildCommand() {
        IToolChain toolChain;
        IBuilder builder;
        if (this.getDefaultConfiguration() != null && (builder = (toolChain = this.getDefaultConfiguration().getToolChain()).getBuilder()) != null) {
            return builder.getCommand();
        }
        return new String("make");
    }

    @Override
    public String getPrebuildStep() {
        String name = new String();
        IConfiguration config = this.getDefaultConfiguration();
        if (config != null) {
            name = config.getPrebuildStep();
        }
        return name;
    }

    @Override
    public String getPostbuildStep() {
        String name = new String();
        IConfiguration config = this.getDefaultConfiguration();
        if (config != null) {
            name = config.getPostbuildStep();
        }
        return name;
    }

    @Override
    public String getPreannouncebuildStep() {
        String name = new String();
        IConfiguration config = this.getDefaultConfiguration();
        if (config != null) {
            name = config.getPreannouncebuildStep();
        }
        return name;
    }

    @Override
    public String getPostannouncebuildStep() {
        String name = new String();
        IConfiguration config = this.getDefaultConfiguration();
        if (config != null) {
            name = config.getPostannouncebuildStep();
        }
        return name;
    }

    @Override
    public String getOutputExtension(String resourceExtension) {
        return this.getDefaultConfiguration().getOutputExtension(resourceExtension);
    }

    @Override
    public String getOutputFlag(String outputExt) {
        return this.getDefaultConfiguration().getOutputFlag(outputExt);
    }

    @Override
    public String getOutputPrefix(String outputExtension) {
        return this.getDefaultConfiguration().getOutputPrefix(outputExtension);
    }

    public IResource getOwner() {
        return this.owner;
    }

    @Override
    public String getToolForSource(String sourceExtension) {
        ITool[] tools = this.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool.buildsFileType(sourceExtension)) {
                return tool.getToolCommand();
            }
            ++index;
        }
        return null;
    }

    @Override
    public String getToolForConfiguration(String extension) {
        String ext = extension == null ? new String() : extension;
        ITool[] tools = this.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool.producesFileType(ext)) {
                return tool.getToolCommand();
            }
            ++index;
        }
        return null;
    }

    @Override
    public ITool getToolFromInputExtension(String sourceExtension) {
        IConfiguration config = this.getDefaultConfiguration();
        return config.getToolFromInputExtension(sourceExtension);
    }

    @Override
    public ITool getToolFromOutputExtension(String extension) {
        IConfiguration config = this.getDefaultConfiguration();
        return config.getToolFromOutputExtension(extension);
    }

    @Override
    public IManagedCommandLineInfo generateCommandLineInfo(String sourceExtension, String[] flags, String outputFlag, String outputPrefix, String outputName, String[] inputResources) {
        return this.generateToolCommandLineInfo(sourceExtension, flags, outputFlag, outputPrefix, outputName, inputResources, null, null);
    }

    @Override
    public IManagedCommandLineInfo generateToolCommandLineInfo(String sourceExtension, String[] flags, String outputFlag, String outputPrefix, String outputName, String[] inputResources, IPath inputLocation, IPath outputLocation) {
        return this.getDefaultConfiguration().generateToolCommandLineInfo(sourceExtension, flags, outputFlag, outputPrefix, outputName, inputResources, inputLocation, outputLocation);
    }

    @Override
    public String[] getUserObjectsForConfiguration(String extension) {
        return this.getDefaultConfiguration().getUserObjects(extension);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void initializePathEntries() {
        if (!this.isValid()) {
            return;
        }
        try {
            ManagedBuildCPathEntryContainer container = new ManagedBuildCPathEntryContainer(this.getOwner().getProject());
            CoreModel.setPathEntryContainer((ICProject[])new ICProject[]{this.cProject}, (IPathEntryContainer)container, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CModelException cModelException) {
            // empty catch block
        }
    }

    @Override
    public boolean isDirty() {
        if (this.isDirty) {
            return true;
        }
        if (this.managedProject != null) {
            return this.managedProject.isDirty();
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public boolean isHeaderFile(String ext) {
        IConfiguration config = this.getDefaultConfiguration();
        return config.isHeaderFile(ext);
    }

    public boolean isContainerInited() {
        return this.bIsContainerInited;
    }

    @Override
    public boolean needsRebuild() {
        if (this.rebuildNeeded) {
            return true;
        }
        if (this.getDefaultConfiguration() != null) {
            return this.getDefaultConfiguration().needsRebuild();
        }
        return false;
    }

    @Deprecated
    public void serializeLegacy(Document doc, Element element) {
        if (this.managedProject != null) {
            Element projElement = doc.createElement("project");
            element.appendChild(projElement);
            ((ManagedProject)this.managedProject).serialize(XmlStorageUtil.createCStorageTree((Element)projElement), true);
        } else {
            ListIterator<ITarget> iter = this.getTargets().listIterator();
            while (iter.hasNext()) {
                Target targ = (Target)iter.next();
                Element targetElement = doc.createElement("target");
                element.appendChild(targetElement);
                targ.serialize(doc, targetElement);
            }
        }
        this.setDirty(false);
    }

    @Override
    public void setDefaultConfiguration(IConfiguration configuration) {
        if (configuration == null || configuration.isExtensionElement()) {
            return;
        }
        ICProjectDescription des = null;
        try {
            des = BuildSettingsUtil.checkSynchBuildInfo(this.getOwner().getProject());
        }
        catch (CoreException e1) {
            ManagedBuilderCorePlugin.log(e1);
        }
        if (!configuration.equals(this.findExistingDefaultConfiguration(des))) {
            IProject project = this.owner.getProject();
            if (des == null) {
                des = CoreModel.getDefault().getProjectDescription(project);
            }
            if (des != null) {
                ICConfigurationDescription activeCfgDes = des.getConfigurationById(configuration.getId());
                if (activeCfgDes == null) {
                    try {
                        activeCfgDes = des.createConfiguration("org.eclipse.cdt.managedbuilder.core.configurationDataProvider", configuration.getConfigurationData());
                    }
                    catch (WriteAccessException writeAccessException) {
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                if (activeCfgDes != null) {
                    des.setActiveConfiguration(activeCfgDes);
                } else {
                    des = null;
                }
            }
        }
        if (des != null) {
            try {
                BuildSettingsUtil.checkApplyDescription(this.owner.getProject(), des);
            }
            catch (CoreException e) {
                ManagedBuilderCorePlugin.log(e);
            }
        }
    }

    @Override
    public boolean setDefaultConfiguration(String configName) {
        if (configName != null) {
            IConfiguration[] configs = this.managedProject.getConfigurations();
            int index = configs.length - 1;
            while (index >= 0) {
                IConfiguration config = configs[index];
                if (configName.equalsIgnoreCase(config.getName())) {
                    this.setDefaultConfiguration(config);
                    return true;
                }
                --index;
            }
        }
        return false;
    }

    @Override
    public void setDirty(boolean isDirty) {
        if (this.managedProject != null) {
            this.managedProject.setDirty(isDirty);
        }
        this.isDirty = isDirty;
    }

    @Override
    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        if (!readOnly && this.isReadOnly) {
            this.setDirty(true);
        }
        this.isReadOnly = readOnly;
    }

    @Override
    public void setRebuildState(boolean rebuild) {
        if (this.getDefaultConfiguration() != null) {
            this.getDefaultConfiguration().setRebuildState(rebuild);
        }
        this.rebuildNeeded = rebuild;
    }

    public void setVersion(String version) {
        this.updateRevision(version);
        if (version != null && !version.equals(this.version)) {
            this.version = version;
        }
    }

    public void setContainerInited(boolean bInited) {
        this.bIsContainerInited = bInited;
    }

    public String toString() {
        return "Managed build information for " + this.owner.getName();
    }

    public void updateOwner(IResource resource) {
        if (resource != null && !this.owner.equals((Object)resource)) {
            if (this.managedProject != null) {
                this.managedProject.updateOwner(resource);
            }
            this.cProject = CoreModel.getDefault().create(resource.getProject());
            this.setDirty(true);
            this.setRebuildState(true);
            this.owner = resource;
        }
    }

    @Override
    public IConfiguration getSelectedConfiguration() {
        return this.selectedConfig;
    }

    @Override
    public void setSelectedConfiguration(IConfiguration config) {
        this.selectedConfig = config;
    }

    @Override
    @Deprecated
    public void addTarget(ITarget target) {
        this.getTargetMap().put(target.getId(), target);
        this.getTargets().add(target);
        this.setDirty(true);
    }

    @Override
    @Deprecated
    public void removeTarget(String id) {
        this.getTargets().remove(this.getTarget(id));
        this.getTargetMap().remove(id);
        this.setDirty(true);
    }

    @Override
    @Deprecated
    public ITarget getTarget(String id) {
        return this.getTargetMap().get(id);
    }

    @Deprecated
    private Map<String, ITarget> getTargetMap() {
        if (this.targetMap == null) {
            this.targetMap = new HashMap<String, ITarget>();
        }
        return this.targetMap;
    }

    @Override
    @Deprecated
    public List<ITarget> getTargets() {
        if (this.targetList == null) {
            this.targetList = new ArrayList<ITarget>();
        }
        return this.targetList;
    }

    private String getCWD() {
        String cwd = "";
        IBuildEnvironmentVariable cwdvar = ManagedBuildManager.getEnvironmentVariableProvider().getVariable("CWD", this.getDefaultConfiguration(), false, true);
        if (cwdvar != null) {
            cwd = cwdvar.getValue().replace('\\', '/');
        }
        return cwd;
    }

    private List<String> processPath(List<String> list, String path, int context, Object obj) {
        String EMPTY = "";
        if (path != null) {
            if (context != 0) {
                try {
                    String[] paths = ManagedBuildManager.getBuildMacroProvider().resolveStringListValue(path, "", " ", context, obj);
                    if (paths != null) {
                        int i = 0;
                        while (i < paths.length) {
                            OptionContextData optionContext;
                            IBuildObject buildObject;
                            IOptionPathConverter optionPathConverter;
                            if (obj instanceof OptionContextData && (optionPathConverter = this.getPathConverter(buildObject = (optionContext = (OptionContextData)obj).getParent())) != null) {
                                IPath platformPath = optionPathConverter.convertToPlatformLocation(paths[i], null, null);
                                paths[i] = platformPath.toOSString();
                            }
                            list.add(this.checkPath(paths[i]));
                            ++i;
                        }
                    }
                }
                catch (BuildMacroException buildMacroException) {}
            } else {
                list.add(this.checkPath(path));
            }
        }
        return list;
    }

    private IOptionPathConverter getPathConverter(IBuildObject buildObject) {
        IOptionPathConverter converter = null;
        if (buildObject instanceof ITool) {
            ITool tool = (ITool)buildObject;
            converter = tool.getOptionPathConverter();
        }
        return converter;
    }

    private String checkPath(String p) {
        String cwd;
        String QUOTE = "\"";
        String EMPTY = "";
        if (p == null) {
            return "";
        }
        if (p.length() > 1 && p.startsWith("\"") && p.endsWith("\"")) {
            p = p.substring(1, p.length() - 1);
        }
        if (".".equals(p) && (cwd = this.getCWD()).length() > 0) {
            p = cwd;
        }
        if (!new Path(p).isAbsolute() && (cwd = this.getCWD()).length() > 0) {
            p = String.valueOf(cwd) + "/" + p;
        }
        return p;
    }

    public IPathEntry[] getManagedBuildValues() {
        ArrayList<IPathEntry> entries = new ArrayList<IPathEntry>();
        int i = 0;
        IPathEntry[] a = this.getManagedBuildValues(16);
        if (a != null) {
            i = 0;
            while (i < a.length) {
                entries.add(a[i]);
                ++i;
            }
        }
        if ((a = this.getManagedBuildValues(1)) != null) {
            i = 0;
            while (i < a.length) {
                entries.add(a[i]);
                ++i;
            }
        }
        if ((a = this.getManagedBuildValues(64)) != null) {
            i = 0;
            while (i < a.length) {
                entries.add(a[i]);
                ++i;
            }
        }
        return entries.toArray(new IPathEntry[entries.size()]);
    }

    public IPathEntry[] getManagedBuildBuiltIns() {
        ArrayList<IPathEntry> entries = new ArrayList<IPathEntry>();
        int i = 0;
        IPathEntry[] a = this.getManagedBuildBuiltIns(16);
        if (a != null) {
            i = 0;
            while (i < a.length) {
                entries.add(a[i]);
                ++i;
            }
        }
        if ((a = this.getManagedBuildBuiltIns(1)) != null) {
            i = 0;
            while (i < a.length) {
                entries.add(a[i]);
                ++i;
            }
        }
        if ((a = this.getManagedBuildBuiltIns(64)) != null) {
            i = 0;
            while (i < a.length) {
                entries.add(a[i]);
                ++i;
            }
        }
        return entries.toArray(new IPathEntry[entries.size()]);
    }

    public IPathEntry[] getManagedBuildValues(int entryType) {
        List<IPathEntry> entries = this.getOptionValues(entryType, false);
        if (entryType == 16) {
            IEnvironmentVariableProvider env = ManagedBuildManager.getEnvironmentVariableProvider();
            entries = this.addIncludes(entries, env.getBuildPaths(this.getDefaultConfiguration(), 1), (IPath)Path.EMPTY, 0, null);
        }
        return entries.toArray(new IPathEntry[entries.size()]);
    }

    public IPathEntry[] getManagedBuildBuiltIns(int entryType) {
        List<IPathEntry> entries = this.getOptionValues(entryType, true);
        return entries.toArray(new IPathEntry[entries.size()]);
    }

    private List<IPathEntry> getOptionValues(int entryType, boolean builtIns) {
        List<IPathEntry> entries = new ArrayList<IPathEntry>();
        IConfiguration cfg = this.getDefaultConfiguration();
        entries = this.readToolsOptions(entryType, entries, builtIns, cfg);
        return entries;
    }

    private List<IPathEntry> readToolsOptions(int entryType, List<IPathEntry> entries, boolean builtIns, IBuildObject obj) {
        ITool[] t = null;
        Path resPath = Path.EMPTY;
        if (entryType != 16 && entryType != 64) {
            return entries;
        }
        if (obj instanceof IResourceConfiguration) {
            resPath = new Path(((IResourceConfiguration)obj).getResourcePath()).removeFirstSegments(1);
            t = ((IResourceConfiguration)obj).getToolsToInvoke();
        } else if (obj instanceof IConfiguration) {
            t = ((IConfiguration)obj).getFilteredTools();
        } else {
            return entries;
        }
        if (t == null) {
            return entries;
        }
        int i = 0;
        while (i < t.length) {
            IOption[] op = t[i].getOptions();
            int j = 0;
            while (j < op.length) {
                IOptionApplicability applicabilityCalculator = op[j].getApplicabilityCalculator();
                if (applicabilityCalculator == null || applicabilityCalculator.isOptionUsedInCommandLine(obj, t[i], op[j])) {
                    try {
                        OptionContextData ocd;
                        if (entryType == 16 && op[j].getValueType() == 4) {
                            ocd = new OptionContextData(op[j], (IBuildObject)t[i]);
                            this.addIncludes(entries, builtIns ? op[j].getBuiltIns() : op[j].getIncludePaths(), (IPath)resPath, 2, ocd);
                        } else if (entryType == 1 && op[j].getValueType() == 6) {
                            ocd = new OptionContextData(op[j], (IBuildObject)t[i]);
                            this.addLibraries(entries, builtIns ? op[j].getBuiltIns() : op[j].getLibraries(), (IPath)resPath, 2, ocd);
                        } else if (entryType == 64 && op[j].getValueType() == 5) {
                            ocd = new OptionContextData(op[j], (IBuildObject)t[i]);
                            this.addSymbols(entries, builtIns ? op[j].getBuiltIns() : op[j].getDefinedSymbols(), (IPath)resPath, 2, ocd);
                        }
                    }
                    catch (BuildException buildException) {
                        // empty catch block
                    }
                }
                ++j;
            }
            ++i;
        }
        return entries;
    }

    protected List<IPathEntry> addIncludes(List<IPathEntry> entries, String[] values, IPath resPath, int context, Object obj) {
        return this.addPaths(entries, values, resPath, context, obj, 16);
    }

    protected List<IPathEntry> addPaths(List<IPathEntry> entries, String[] values, IPath resPath, int context, Object obj, int type) {
        if (values != null && values.length > 0) {
            ArrayList<String> list = new ArrayList<String>();
            int k = 0;
            while (k < values.length) {
                this.processPath(list, values[k], context, obj);
                ++k;
            }
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                IIncludeEntry entry = null;
                switch (type) {
                    case 16: {
                        entry = CoreModel.newIncludeEntry((IPath)resPath, (IPath)Path.EMPTY, (IPath)new Path((String)iter.next()), (boolean)true);
                        break;
                    }
                    case 1: {
                        entry = CoreModel.newLibraryEntry((IPath)resPath, (IPath)Path.EMPTY, (IPath)new Path((String)iter.next()), null, null, null, (boolean)true);
                    }
                }
                if (entry == null || entries.contains(entry)) continue;
                entries.add((IPathEntry)entry);
            }
        }
        return entries;
    }

    protected List<IPathEntry> addLibraries(List<IPathEntry> entries, String[] values, IPath resPath, int context, Object obj) {
        return this.addPaths(entries, values, resPath, context, obj, 1);
    }

    protected List<IPathEntry> addSymbols(List<IPathEntry> entries, String[] values, IPath resPath, int context, Object obj) {
        if (values == null) {
            return entries;
        }
        int i = 0;
        while (i < values.length) {
            try {
                String[] res = ManagedBuildManager.getBuildMacroProvider().resolveStringListValue(values[i], "", " ", context, obj);
                if (res != null) {
                    int k = 0;
                    while (k < res.length) {
                        this.createMacroEntry(entries, res[k], resPath);
                        ++k;
                    }
                }
            }
            catch (BuildMacroException buildMacroException) {
                // empty catch block
            }
            ++i;
        }
        return entries;
    }

    private List<IPathEntry> createMacroEntry(List<IPathEntry> entries, String val, IPath resPath) {
        if (val != null && val.length() != 0) {
            String[] tokens = val.split("=");
            String key = tokens[0].trim();
            String value = tokens.length > 1 ? tokens[1].trim() : new String();
            boolean add = true;
            ListIterator<IPathEntry> entryIter = entries.listIterator();
            while (entryIter.hasNext()) {
                IPathEntry entry = (IPathEntry)entryIter.next();
                if (entry.getEntryKind() != 64 || !((IMacroEntry)entry).getMacroName().equals(key) || !((IMacroEntry)entry).getMacroValue().equals(value)) continue;
                add = false;
                break;
            }
            if (add) {
                entries.add((IPathEntry)CoreModel.newMacroEntry((IPath)resPath, (String)key, (String)value));
            }
        }
        return entries;
    }

    public void updateRevision(String revision) {
        if (this.managedProject != null) {
            ((ManagedProject)this.managedProject).updateManagedBuildRevision(revision);
        }
    }
}

