/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.launch;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ITizenProject;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.rds.DeltaResourceInfo;
import org.tizen.common.rds.RdsDeployer;
import org.tizen.common.rds.RdsMessages;
import org.tizen.common.sdb.command.SdbCommand;
import org.tizen.common.sdb.command.message.CommandErrorType;
import org.tizen.common.sdb.command.message.PkgcmdErrorType;
import org.tizen.common.sdb.command.receiver.CommandOutputReceiver;
import org.tizen.common.sdb.command.receiver.PkgCmdReceiver;
import org.tizen.common.sign.model.DeltaListResource;
import org.tizen.common.sign.preferences.SigningProfile;
import org.tizen.common.sign.signer.SignatureGenerator;
import org.tizen.common.ui.view.console.ConsoleManager;
import org.tizen.common.ui.view.console.ITizenConsoleManager;
import org.tizen.common.util.Assert;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.ISdbCommandHelper;
import org.tizen.common.util.PluginUtil;
import org.tizen.nativecommon.IXMLStore;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.launch.IProjectLaunchCommand;
import org.tizen.nativecommon.launch.LaunchUtils;
import org.tizen.nativecommon.launch.TizenLaunchCommand;
import org.tizen.nativecommon.launch.TizenLaunchMessages;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.util.StringUtil;
import org.tizen.tpklib.TPK;

public class NativeRdsDeployer
extends RdsDeployer {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected static final String SIGNATURE_FILE_FOLDER = "/.sign";
    protected static final String SIGNATURE_TEMP_FILE = ".manifest.tmp";
    SdbCommand sdbCommand = null;

    public NativeRdsDeployer(IProject project, IDevice device, TizenLaunchCommand tizenCommand, ConsoleManager console, String pkgType, IProgressMonitor monitor) {
        super(project, device, (ISdbCommandHelper)tizenCommand, (ITizenConsoleManager)console, pkgType, monitor);
        this.sdbCommand = new SdbCommand(device, (ITizenConsoleManager)console, (CommandOutputReceiver)new PkgCmdReceiver((ITizenConsoleManager)console));
    }

    protected boolean preDeploy() throws CoreException {
        if (!super.preDeploy()) {
            return false;
        }
        if (!this.isInstalledApplication()) {
            this.logger.debug(RdsDeployer.makeRdsLog((String)RdsMessages.CANNOT_FIND_APPLICATION));
            return false;
        }
        return true;
    }

    protected void configureRM(List<DeltaResourceInfo> deltaInfoList) {
        for (DeltaResourceInfo info : deltaInfoList) {
            info.getName();
            IResource res = info.getResource();
            String[] stringArray = res.getFullPath().segments();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                if (segment.equals("res")) {
                    ProjectUtil.generateResMetaFile(this.project);
                    return;
                }
                ++n2;
            }
        }
    }

    protected void incrementalSign(List<DeltaResourceInfo> deltaList, IContainer workingFolder) throws CoreException, IOException {
        Assert.notNull((Object)workingFolder);
        SignatureGenerator generator = new SignatureGenerator();
        generator.setDevice(this.device);
        generator.setRDSMode(true);
        DeltaListResource deltaRes = new DeltaListResource(this.project, workingFolder);
        try {
            int deltaCount = deltaRes.createListResource(deltaList);
            if (deltaCount == 0) {
                return;
            }
            SigningProfile profile = generator.loadProfiles();
            IPath relativePath = workingFolder.getFullPath().makeRelativeTo(workingFolder.getWorkspace().getRoot().getFullPath());
            generator.sign(relativePath.toPortableString(), profile);
        }
        finally {
            deltaRes.removeListResource();
            workingFolder.refreshLocal(1, null);
        }
    }

    protected boolean isRunApplication(String pkgType) throws CoreException {
        String[] resultLine;
        String packageName = this.getPkgId();
        String command = String.format(TizenPlatformConstants.PKG_TOOL_RUNNING_CHECK_COMMAND, pkgType, packageName);
        try {
            this.sdbCommand.runCommand(command, (CommandErrorType)new PkgcmdErrorType());
        }
        catch (Exception e) {
            this.newCoreException(RdsDeployer.makeRdsLog((String)TizenLaunchMessages.CANNOT_RUNNING_CHECK), e);
        }
        String[] stringArray = resultLine = this.sdbCommand.getResultLineStrings();
        int n = resultLine.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.contains("is Running")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void killApplication(String pkgType) throws CoreException {
        String command = String.format(TizenPlatformConstants.PKG_TOOL_TERMINATE_COMMAND, pkgType, this.getPkgId());
        try {
            this.sdbCommand.runCommand(command, (CommandErrorType)new PkgcmdErrorType());
        }
        catch (Exception e) {
            LaunchUtils.newCoreException(RdsDeployer.makeRdsLog((String)TizenLaunchMessages.CANNOT_TERMINATE), e);
        }
    }

    protected boolean isInstalledApplication() {
        IProjectLaunchCommand manifest = ProjectUtil.getProjectManifest(this.project);
        String listCmd = manifest.getListCommand();
        String listCmdRet = manifest.getListCommandResult();
        try {
            this.sdbCommand.runCommand(listCmd);
        }
        catch (Exception e) {
            this.logger.error("Failed to find an old application", (Throwable)e);
            return false;
        }
        return this.sdbCommand.getEndLine() != null && this.sdbCommand.getEndLine().contains(listCmdRet);
    }

    protected void printInfo(String message) {
        if (this.console != null) {
            this.console.println(message);
        }
    }

    protected String getAppInstallPath() {
        return ProjectUtil.getAppTmpDirectory(this.project, this.device);
    }

    protected String getPkgId() {
        IProjectLaunchCommand projectManifest = ProjectUtil.getProjectManifest(this.project);
        return projectManifest.getPackageName();
    }

    protected boolean sign(List<DeltaResourceInfo> deltaInfoList) {
        try {
            IFolder signFolder = this.project.getFolder(".sign");
            if (!signFolder.isSynchronized(2)) {
                signFolder.refreshLocal(2, null);
            }
            this.incrementalSign(deltaInfoList, (IContainer)signFolder);
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        catch (IllegalStateException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    protected void mergeApplicationXML() throws Exception {
        IXMLStore rootStore = this.getIXmlStore();
        if (rootStore != null) {
            String outputPath = this.getRootPrjPath();
            rootStore.setProject(outputPath);
            rootStore.loadXml();
            String[] refPrjPaths = this.getRefPrjPaths();
            if (refPrjPaths != null) {
                String[] stringArray = this.getRefPrjPaths();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String refPath = stringArray[n2];
                    IXMLStore refStore = this.getIXmlStore();
                    if (refStore != null) {
                        refStore.setProject(refPath);
                        refStore.loadXml();
                        rootStore.mergeAppData(refStore);
                        rootStore.mergePrivData(refStore);
                    }
                    ++n2;
                }
            }
            FileUtil.createTextFile((String)"manifest_multi.xml", (String)"", (String)outputPath, null);
            rootStore.storeXml(new File(outputPath, "manifest_multi.xml"));
        }
    }

    protected IXMLStore getIXmlStore() throws Exception {
        IXMLStore store = null;
        try {
            store = (IXMLStore)PluginUtil.loadClass((String)"org.tizen.nativecommon.store", (String)"org.tizen.nativecpp.misc.core.NewAppXmlStore");
        }
        catch (CoreException e) {
            throw new Exception(e);
        }
        return store;
    }

    protected List<DeltaResourceInfo> getInterestDelta() {
        List<DeltaResourceInfo> deltaInfoList = null;
        ITizenProject tProject = org.tizen.common.util.ProjectUtil.getTizenProject((IProject)this.project);
        this.setInterestList(tProject.getTizenPkgInfoStore().getInterestList());
        try {
            this.project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            deltaInfoList = this.getDelta();
            if (deltaInfoList == null) {
                this.newCoreException(RdsMessages.CANNOT_FIND_DELTA, null);
            }
            deltaInfoList = this.getInterestDelta(deltaInfoList);
        }
        catch (CoreException coreException) {
            this.printInfo(RdsDeployer.makeRdsLog((String)RdsMessages.CANNOT_FIND_DELTA));
            return null;
        }
        return deltaInfoList;
    }

    public List<DeltaResourceInfo> getInterestDelta(List<DeltaResourceInfo> deltaInfoList) throws CoreException {
        ArrayList<DeltaResourceInfo> delta = new ArrayList<DeltaResourceInfo>();
        DeltaResourceInfo interestNode = null;
        String strRemotePath = "";
        String buildConf = ProjectUtil.getDefaultConfiguration(this.project).getName();
        String binFileName = ProjectUtil.getBinaryName(this.project);
        for (DeltaResourceInfo node : deltaInfoList) {
            String strProjectPath = this.project.getLocation().toString();
            String nodeProjectName = node.getProjectName();
            if (nodeProjectName != null && !this.project.getName().equals(nodeProjectName)) {
                strProjectPath = strProjectPath.replace(this.project.getName(), nodeProjectName);
            }
            interestNode = null;
            if (this.containsNode(node, this.ignoreList, strProjectPath) != null) continue;
            if ("delete" == node.getType()) {
                TPK tpk = TPK.getInstance();
                strRemotePath = tpk.getIncludePath(node.getResource().getProjectRelativePath().toString(), buildConf, binFileName);
                if (StringUtil.isEmpty((CharSequence)strRemotePath)) {
                    continue;
                }
            } else {
                interestNode = this.containsNode(node, this.interestList, strProjectPath);
                if (interestNode == null) continue;
                strRemotePath = this.getRemotePathOfDelta(interestNode, strProjectPath, node);
            }
            node.setRemotePath(strRemotePath);
            delta.add(node);
            this.getInterestDelta(node.getChildren());
        }
        return delta;
    }
}

