/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitDestructorName;
import org.eclipse.cdt.core.dom.ast.IASTImplicitName;
import org.eclipse.cdt.core.dom.ast.IASTImplicitNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTInitializerList;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeConstructorExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBasicType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTConstructorInitializer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTImplicitName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSimpleDeclSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.DestructorCallCollector;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalTypeId;

public class CPPASTSimpleTypeConstructorExpression
extends ASTNode
implements ICPPASTSimpleTypeConstructorExpression,
IASTImplicitNameOwner {
    private ICPPASTDeclSpecifier fDeclSpec;
    private IASTInitializer fInitializer;
    private ICPPEvaluation fEvaluation;
    private IASTImplicitDestructorName[] fImplicitDestructorNames;
    private IASTImplicitName[] fImplicitNames;

    public CPPASTSimpleTypeConstructorExpression() {
    }

    public CPPASTSimpleTypeConstructorExpression(ICPPASTDeclSpecifier declSpec, IASTInitializer init) {
        this.setDeclSpecifier(declSpec);
        this.setInitializer(init);
    }

    @Override
    public CPPASTSimpleTypeConstructorExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTSimpleTypeConstructorExpression copy(IASTNode.CopyStyle style) {
        CPPASTSimpleTypeConstructorExpression copy = new CPPASTSimpleTypeConstructorExpression();
        copy.setDeclSpecifier(this.fDeclSpec == null ? null : this.fDeclSpec.copy(style));
        copy.setInitializer(this.fInitializer == null ? null : this.fInitializer.copy(style));
        return this.copy(copy, style);
    }

    @Override
    public ICPPASTDeclSpecifier getDeclSpecifier() {
        return this.fDeclSpec;
    }

    @Override
    public IASTInitializer getInitializer() {
        return this.fInitializer;
    }

    @Override
    public void setDeclSpecifier(ICPPASTDeclSpecifier declSpec) {
        this.assertNotFrozen();
        this.fDeclSpec = declSpec;
        if (declSpec != null) {
            declSpec.setParent(this);
            declSpec.setPropertyInParent(TYPE_SPECIFIER);
        }
    }

    @Override
    public void setInitializer(IASTInitializer initializer) {
        this.assertNotFrozen();
        this.fInitializer = initializer;
        if (initializer != null) {
            initializer.setParent(this);
            initializer.setPropertyInParent(INITIALIZER);
        }
    }

    @Override
    public ICPPEvaluation getEvaluation() {
        if (this.fEvaluation == null) {
            IType type = CPPVisitor.createType(this.fDeclSpec);
            ICPPEvaluation[] args = null;
            if (this.fInitializer instanceof ICPPASTConstructorInitializer) {
                IASTInitializerClause[] a = ((ICPPASTConstructorInitializer)this.fInitializer).getArguments();
                args = new ICPPEvaluation[a.length];
                int i = 0;
                while (i < a.length) {
                    args[i] = ((ICPPASTInitializerClause)a[i]).getEvaluation();
                    ++i;
                }
                this.fEvaluation = new EvalTypeId(type, this, args);
            } else {
                this.fEvaluation = this.fInitializer instanceof ICPPASTInitializerList ? new EvalTypeId(type, this, ((ICPPASTInitializerList)this.fInitializer).getEvaluation()) : EvalFixed.INCOMPLETE;
            }
        }
        return this.fEvaluation;
    }

    @Override
    public IType getExpressionType() {
        return this.getEvaluation().getTypeOrFunctionSet(this);
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return this.getEvaluation().getValueCategory(this);
    }

    @Override
    public boolean isLValue() {
        return false;
    }

    @Override
    public IASTImplicitDestructorName[] getImplicitDestructorNames() {
        if (this.fImplicitDestructorNames == null) {
            this.fImplicitDestructorNames = DestructorCallCollector.getTemporariesDestructorCalls(this);
        }
        return this.fImplicitDestructorNames;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.fDeclSpec != null && !this.fDeclSpec.accept(action)) {
            return false;
        }
        if (action.shouldVisitImplicitNames) {
            IASTImplicitName[] iASTImplicitNameArray = this.getImplicitNames();
            int n = iASTImplicitNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTImplicitName implicitName = iASTImplicitNameArray[n2];
                if (!implicitName.accept(action)) {
                    return false;
                }
                ++n2;
            }
        }
        if (this.fInitializer != null && !this.fInitializer.accept(action)) {
            return false;
        }
        if (action.shouldVisitImplicitDestructorNames && !CPPASTSimpleTypeConstructorExpression.acceptByNodes((IASTNode[])this.getImplicitDestructorNames(), (ASTVisitor)action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    @Deprecated
    public int getSimpleType() {
        IType type = this.getExpressionType();
        if (type instanceof ICPPBasicType) {
            ICPPBasicType bt = (ICPPBasicType)type;
            IBasicType.Kind kind = bt.getKind();
            switch (kind) {
                case eBoolean: {
                    return 6;
                }
                case eChar: {
                    return 2;
                }
                case eDouble: {
                    return 5;
                }
                case eFloat: {
                    return 4;
                }
                case eInt: {
                    if (bt.isShort()) {
                        return 8;
                    }
                    if (bt.isLong()) {
                        return 9;
                    }
                    if (bt.isSigned()) {
                        return 10;
                    }
                    if (bt.isUnsigned()) {
                        return 11;
                    }
                    return 3;
                }
                case eVoid: {
                    return 1;
                }
                case eWChar: {
                    return 7;
                }
            }
        }
        return 0;
    }

    @Override
    @Deprecated
    public void setSimpleType(int value) {
        CPPASTSimpleDeclSpecifier declspec = new CPPASTSimpleDeclSpecifier();
        switch (value) {
            case 6: {
                declspec.setType(IBasicType.Kind.eBoolean);
                break;
            }
            case 2: {
                declspec.setType(IBasicType.Kind.eChar);
                break;
            }
            case 5: {
                declspec.setType(IBasicType.Kind.eDouble);
                break;
            }
            case 4: {
                declspec.setType(IBasicType.Kind.eFloat);
                break;
            }
            case 3: {
                declspec.setType(IBasicType.Kind.eInt);
                break;
            }
            case 9: {
                declspec.setType(IBasicType.Kind.eInt);
                declspec.setLong(true);
                break;
            }
            case 8: {
                declspec.setType(IBasicType.Kind.eInt);
                declspec.setShort(true);
                break;
            }
            case 10: {
                declspec.setType(IBasicType.Kind.eInt);
                declspec.setSigned(true);
                break;
            }
            case 11: {
                declspec.setType(IBasicType.Kind.eInt);
                declspec.setUnsigned(true);
                break;
            }
            case 1: {
                declspec.setType(IBasicType.Kind.eVoid);
                break;
            }
            case 7: {
                declspec.setType(IBasicType.Kind.eWChar);
                break;
            }
            default: {
                declspec.setType(IBasicType.Kind.eUnspecified);
            }
        }
        this.setDeclSpecifier(declspec);
    }

    @Override
    @Deprecated
    public IASTExpression getInitialValue() {
        if (this.fInitializer instanceof ICPPASTConstructorInitializer) {
            return ((ICPPASTConstructorInitializer)this.fInitializer).getExpression();
        }
        return null;
    }

    @Override
    @Deprecated
    public void setInitialValue(IASTExpression expression) {
        CPPASTConstructorInitializer init = new CPPASTConstructorInitializer();
        init.setExpression(expression);
        this.setInitializer(init);
    }

    @Override
    public IASTImplicitName[] getImplicitNames() {
        if (this.fImplicitNames == null) {
            ICPPFunction constructor;
            this.fImplicitNames = IASTImplicitName.EMPTY_NAME_ARRAY;
            ICPPEvaluation eval = this.getEvaluation();
            if (eval instanceof EvalTypeId && (constructor = ((EvalTypeId)eval).getConstructor(this)) != null) {
                CPPASTImplicitName name = new CPPASTImplicitName(constructor.getNameCharArray(), (IASTNode)this);
                name.setOffsetAndLength((ASTNode)((Object)this.fDeclSpec));
                name.setBinding(constructor);
                this.fImplicitNames = new IASTImplicitName[]{name};
            }
        }
        return this.fImplicitNames;
    }
}

