/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.togglefunction;

import org.eclipse.cdt.internal.ui.refactoring.changes.CreateFileChange;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.Messages;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.NotSupportedException;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.ToggleNodeHelper;
import org.eclipse.cdt.internal.ui.refactoring.togglefunction.ToggleRefactoringContext;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ToggleFileCreator {
    private static final String EMPTY_STRING = "";
    private final ToggleRefactoringContext context;
    private final String ending;

    public ToggleFileCreator(ToggleRefactoringContext context, String ending) {
        this.context = context;
        this.ending = ending;
    }

    public IFile createNewFile() {
        String filename = this.getNewFileName();
        Path path = new Path(String.valueOf(this.getPath()) + filename);
        try {
            CreateFileChange change = new CreateFileChange(filename, (IPath)path, EMPTY_STRING, this.context.getSelectionFile().getCharset());
            change.perform((IProgressMonitor)new NullProgressMonitor());
            return (IFile)change.getModifiedElement();
        }
        catch (CoreException coreException) {
            throw new NotSupportedException(NLS.bind((String)Messages.ToggleFileCreator_CanNotCreateNewFile, (Object)path.toString()));
        }
    }

    public boolean askUserForFileCreation(final ToggleRefactoringContext context) {
        if (context.isSettedDefaultAnswer()) {
            return context.getDefaultAnswer();
        }
        final boolean[] answer = new boolean[1];
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Shell shell = CUIPlugin.getDefault().getWorkbench().getWorkbenchWindows()[0].getShell();
                String functionName = context.getDeclaration() != null ? context.getDeclaration().getRawSignature() : context.getDefinition().getDeclarator().getRawSignature();
                answer[0] = MessageDialog.openQuestion((Shell)shell, (String)Messages.ToggleFileCreator_NewImplFile, (String)NLS.bind((String)Messages.ToggleFileCreator_CreateNewFilePrompt, (Object)ToggleFileCreator.this.getNewFileName(), (Object)functionName));
            }
        };
        PlatformUI.getWorkbench().getDisplay().syncExec(r);
        return answer[0];
    }

    public String getIncludeStatement() {
        return "#include \"" + ToggleNodeHelper.getFilenameWithoutExtension(this.getNewFileName()) + ".h\"\n";
    }

    private String getNewFileName() {
        return String.valueOf(ToggleNodeHelper.getFilenameWithoutExtension(this.context.getSelectionFile().getFullPath().toString())) + this.ending;
    }

    private String getPath() {
        String result = this.context.getSelectionFile().getFullPath().toOSString();
        return result.replaceAll("(\\w)*\\.(\\w)*", EMPTY_STRING);
    }
}

