/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.build;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.internal.envvar.BuildEnvVar;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.util.OSChecker;
import org.tizen.core.gputil.MacroUtil;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativecommon.build.exception.SBIException;
import org.tizen.nativecommon.launch.LaunchUtils;
import org.tizen.nativecore.build.NativeCoreConfigurationManager;
import org.tizen.sbilib.ide.PluginManager;
import org.tizen.sbilib.ide.Rootstrap;
import org.tizen.sbilib.ide.Tool;
import org.tizen.sbilib.ide.Toolchain;

public class NativeCoreConfigurationEnvVarSupplier
implements IConfigurationEnvironmentVariableSupplier {
    public final String ENV_PATH_DELIMITER_WINDOWS = ";";
    public final String ENV_PATH_DELIMITER_LINUX = ":";
    public final String ENV_SA_REPORT_PATH = "SA_REPORT_PATH";
    private Map<String, String> macros = new HashMap<String, String>();
    private static Logger logger = LoggerFactory.getLogger(NativeCoreConfigurationEnvVarSupplier.class);

    public IBuildEnvironmentVariable getVariable(String variableName, IConfiguration configuration, IEnvironmentVariableProvider provider) {
        PluginManager pm = PluginManager.getInstance();
        IProject project = configuration.getOwner().getProject();
        String targetId = NativeCoreConfigurationManager.getTargetIdFromProject(project);
        Toolchain tc = null;
        Rootstrap rs = null;
        if (targetId != null) {
            SmartBuildInterface sbi = SmartBuildInterface.getInstance();
            tc = pm.getToolchain(sbi.getToolchainIDFromTargetID(targetId));
            rs = pm.getRootstrap(sbi.getRootstrapIDFromTargetID(targetId));
        }
        String envValue = "";
        switch (Variable.getIndex(variableName)) {
            case SBI_SYSROOT: {
                envValue = this.getEnvSysrootPath(configuration);
                break;
            }
            case SBI_COMPILER_PATH: {
                envValue = this.getEnvComplierPath(configuration);
                break;
            }
            case PATH: {
                envValue = this.getEnvPath();
                break;
            }
            case LD_LIBRARY_PATH: {
                envValue = this.getEnvLdLibPath();
                break;
            }
            case SDK_TOOLPATH: {
                envValue = this.getEnvSdkToolPath();
                break;
            }
            case SDK_INSTALL_PATH: 
            case SDK_PATH: {
                envValue = this.getEnvSdkInstallPath();
                break;
            }
            case SDK_ARCH: {
                envValue = this.getArch(configuration);
                break;
            }
            case MINGWBIN_PATH: {
                envValue = this.getEnvMingwBinPath();
                break;
            }
            case MSYSBIN_PATH: {
                envValue = this.getEnvMsysBinPath();
                break;
            }
            case APICHECKER_PATH: {
                envValue = this.getEnvAPICheckerPath();
                break;
            }
            case BINUTILS_PATH: {
                envValue = this.getEnvBinutilsPath(configuration);
                break;
            }
            case EFL_BIN_PATH: {
                envValue = this.getEnvEflBinPath(configuration);
                break;
            }
            case EFL_LIB_PATH: {
                String eflBinPath = this.getEnvEflBinPath(configuration);
                if (eflBinPath == null || !OSChecker.isLinux() && !OSChecker.isMAC()) break;
                envValue = this.getEflLibPath(configuration);
                break;
            }
            case MSGFMT_PATH: {
                envValue = this.getEnvMsgfmtPath(configuration);
                break;
            }
            case PROJ_PATH: {
                envValue = this.getEnvProjectPath(configuration);
                break;
            }
            case SA_REPORT_PATH: {
                envValue = this.getEnvSAReportPath(configuration);
                break;
            }
            case SA_REPORT_TYPE: {
                envValue = "xml";
                break;
            }
            case TC_COMPILER_MISC: {
                if (tc == null) break;
                envValue = tc.getCompilerMiscellaneousOption();
                break;
            }
            case TC_LINKER_MISC: {
                if (tc == null) break;
                envValue = tc.getLinkerMiscellaneousOption();
                break;
            }
            case RS_COMPILER_MISC: {
                if (rs == null) break;
                envValue = rs.getCompilerMiscellaneousOption();
                break;
            }
            case RS_LINKER_MISC: {
                if (rs == null) break;
                envValue = rs.getLinkerMiscellaneousOption();
                break;
            }
            case RS_LIBRARIES: {
                envValue = this.getRSLibraries(configuration);
                break;
            }
            case APPID: {
                envValue = this.getAppId(configuration);
                break;
            }
            case BUILD_CONFIG: {
                envValue = configuration.getName();
                break;
            }
            case OUTPUT_PATH: {
                envValue = this.getOutputPath(configuration);
                break;
            }
            case CC: {
                envValue = this.getEnvCCompiler(configuration);
                break;
            }
            case CXX: {
                envValue = this.getEnvCxxCompiler(configuration);
                break;
            }
            case AR: {
                envValue = this.getEnvArchiver(configuration);
                break;
            }
            case NOVALUE: {
                envValue = null;
            }
        }
        if (envValue != null) {
            envValue = this.resolveMacros(envValue);
            return new BuildEnvVar(variableName, envValue, 1, null);
        }
        return null;
    }

    public IBuildEnvironmentVariable[] getVariables(IConfiguration configuration, IEnvironmentVariableProvider provider) {
        ArrayList<Object> variables = new ArrayList<Object>();
        if (configuration == null) {
            String delimiter = OSChecker.isWindows() ? ";" : ":";
            String defaultToolchainPath = this.getDefaultToolchainPath();
            String path = String.valueOf(defaultToolchainPath) + delimiter + "${PATH}";
            variables.add(new BuildEnvVar("PATH", path, 1, null));
            return variables.toArray(new IBuildEnvironmentVariable[0]);
        }
        String defaultGccPath = this.getPlatformDefaultGCCPath(configuration);
        this.macros.put("PLATFORM_DEFAULT_GCC_PATH", defaultGccPath);
        variables.add(this.getVariable(Variable.SBI_SYSROOT.name(), configuration, provider));
        variables.add(this.getVariable(Variable.SBI_COMPILER_PATH.name(), configuration, provider));
        variables.add(this.getVariable(Variable.PATH.name(), configuration, provider));
        variables.add(this.getVariable(Variable.LD_LIBRARY_PATH.name(), configuration, provider));
        variables.add(this.getVariable(Variable.SDK_TOOLPATH.name(), configuration, provider));
        variables.add(this.getVariable(Variable.SDK_INSTALL_PATH.name(), configuration, provider));
        variables.add(this.getVariable(Variable.SDK_ARCH.name(), configuration, provider));
        variables.add(this.getVariable(Variable.APICHECKER_PATH.name(), configuration, provider));
        variables.add(this.getVariable(Variable.BINUTILS_PATH.name(), configuration, provider));
        variables.add(this.getVariable(Variable.EFL_BIN_PATH.name(), configuration, provider));
        variables.add(this.getVariable(Variable.EFL_LIB_PATH.name(), configuration, provider));
        variables.add(this.getVariable(Variable.MSGFMT_PATH.name(), configuration, provider));
        variables.add(this.getVariable(Variable.PROJ_PATH.name(), configuration, provider));
        variables.add(this.getVariable(Variable.SDK_PATH.name(), configuration, provider));
        variables.add(this.getVariable(Variable.SA_REPORT_PATH.name(), configuration, provider));
        variables.add(this.getVariable(Variable.SA_REPORT_TYPE.name(), configuration, provider));
        variables.add(this.getVariable(Variable.TC_COMPILER_MISC.name(), configuration, provider));
        variables.add(this.getVariable(Variable.TC_LINKER_MISC.name(), configuration, provider));
        variables.add(this.getVariable(Variable.RS_COMPILER_MISC.name(), configuration, provider));
        variables.add(this.getVariable(Variable.RS_LINKER_MISC.name(), configuration, provider));
        variables.add(this.getVariable(Variable.RS_LIBRARIES.name(), configuration, provider));
        variables.add(this.getVariable(Variable.APPID.name(), configuration, provider));
        variables.add(this.getVariable(Variable.BUILD_CONFIG.name(), configuration, provider));
        variables.add(this.getVariable(Variable.OUTPUT_PATH.name(), configuration, provider));
        variables.add(this.getVariable(Variable.CC.name(), configuration, provider));
        variables.add(this.getVariable(Variable.CXX.name(), configuration, provider));
        variables.add(this.getVariable(Variable.AR.name(), configuration, provider));
        if (OSChecker.isWindows()) {
            variables.add(this.getVariable(Variable.MINGWBIN_PATH.name(), configuration, provider));
            variables.add(this.getVariable(Variable.MSYSBIN_PATH.name(), configuration, provider));
        }
        return variables.toArray(new IBuildEnvironmentVariable[0]);
    }

    private String getArch(IConfiguration config) {
        String currentArch = NativeCoreConfigurationManager.getArchitecture((IConfiguration)config);
        return LaunchUtils.getArch((String)currentArch);
    }

    private String getEnvPath() {
        if (OSChecker.isWindows()) {
            return "${MINGWBIN_PATH};${MSYSBIN_PATH};${SDK_TOOLPATH};${SBI_COMPILER_PATH};${BINUTILS_PATH};${EFL_BIN_PATH};${MSGFMT_PATH};${APICHECKER_PATH};${PATH}";
        }
        if (OSChecker.isLinux() || OSChecker.isMAC()) {
            return "${SDK_TOOLPATH}:${SBI_COMPILER_PATH}:${BINUTILS_PATH}:${EFL_BIN_PATH}:${MSGFMT_PATH}:${APICHECKER_PATH}:${PATH}";
        }
        return "${SDK_TOOLPATH}:${SBI_COMPILER_PATH}:${BINUTILS_PATH}:${PATH}";
    }

    private String getDefaultToolchainPath() {
        Toolchain tc = NativeCoreConfigurationManager.getLatestX86LLVM();
        if (tc == null && (tc = NativeCoreConfigurationManager.getLatestX86GCC()) == null) {
            return "";
        }
        String ccPath = tc.getTool("c_compiler").getPath();
        String path = new Path(ccPath).removeLastSegments(1).toPortableString();
        return path;
    }

    private String getEnvLdLibPath() {
        if (OSChecker.isLinux() || OSChecker.isMAC()) {
            return "${EFL_LIB_PATH}:${LD_LIBRARY_PATH}";
        }
        return "";
    }

    private String getEnvArchiver(IConfiguration config) {
        return NativeCoreConfigurationManager.getArchiveTool(config);
    }

    private String getEnvSysrootPath(IConfiguration config) {
        if (OSChecker.isWindows()) {
            SmartBuildInterface sbi = SmartBuildInterface.getInstance();
            return sbi.getWindowsPathFromMinGWPath(NativeCoreConfigurationManager.getRootstrapPath((IConfiguration)config));
        }
        return NativeCoreConfigurationManager.getRootstrapPath((IConfiguration)config);
    }

    private String getEnvComplierPath(IConfiguration config) {
        if (OSChecker.isWindows()) {
            SmartBuildInterface sbi = SmartBuildInterface.getInstance();
            return sbi.getWindowsPathFromMinGWPath(NativeCoreConfigurationManager.getCompilerToolchainBinPath(config));
        }
        return NativeCoreConfigurationManager.getCompilerToolchainBinPath(config);
    }

    private String getEnvMingwBinPath() {
        return SmartBuildInterface.getMingwBinPath();
    }

    private String getEnvMsysBinPath() {
        SmartBuildInterface sbi = SmartBuildInterface.getInstance();
        return sbi.getMsysBinPath();
    }

    private String getEnvAPICheckerPath() {
        SmartBuildInterface sbi = SmartBuildInterface.getInstance();
        return sbi.getAPICheckerPath();
    }

    private String getEnvEflBinPath(IConfiguration config) {
        String targetId;
        SmartBuildInterface sbi;
        block4: {
            sbi = SmartBuildInterface.getInstance();
            targetId = NativeCoreConfigurationManager.getBuildTargetName((IConfiguration)config);
            try {
                if (targetId != null) break block4;
                return null;
            }
            catch (SBIException e) {
                logger.error("Failed to get edje bin path", (Throwable)e);
                return null;
            }
        }
        String platformEdjeCCPath = this.getPlatformEdjeCCPath(targetId);
        if (platformEdjeCCPath != null && !platformEdjeCCPath.isEmpty()) {
            return platformEdjeCCPath;
        }
        return sbi.getEdjeBinPath(targetId);
    }

    private String getPlatformEdjeCCPath(String targetId) {
        SmartBuildInterface sbi;
        String rootstrapId;
        PluginManager pm = PluginManager.getInstance();
        Rootstrap rs = pm.getRootstrap(rootstrapId = (sbi = SmartBuildInterface.getInstance()).getRootstrapIDFromTargetID(targetId));
        if (rs == null) {
            return null;
        }
        Tool tool = rs.getTool("EDJE_CC");
        String platformEdjeCCPath = null;
        platformEdjeCCPath = tool != null ? tool.getPath() : sbi.getRootstrapPropertyValue(rootstrapId, "EDJE_CC");
        if (platformEdjeCCPath == null) {
            return null;
        }
        try {
            platformEdjeCCPath = new File(platformEdjeCCPath).getCanonicalPath();
        }
        catch (IOException e) {
            logger.error("Failed to get edje cc path", (Throwable)e);
            return null;
        }
        return new File(platformEdjeCCPath).getParent();
    }

    private String getEnvMsgfmtPath(IConfiguration config) {
        String targetId;
        SmartBuildInterface sbi;
        block3: {
            sbi = SmartBuildInterface.getInstance();
            targetId = NativeCoreConfigurationManager.getBuildTargetName((IConfiguration)config);
            try {
                if (targetId != null) break block3;
                return null;
            }
            catch (SBIException e) {
                logger.error("Failed to get msgfmt path", (Throwable)e);
                return null;
            }
        }
        String path = sbi.getMsgfmtPath(targetId);
        return new Path(path).removeLastSegments(1).toOSString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getEflLibPath(IConfiguration config) {
        String edjeLibPath;
        block5: {
            String targetId;
            SmartBuildInterface sbi;
            block4: {
                sbi = SmartBuildInterface.getInstance();
                targetId = NativeCoreConfigurationManager.getBuildTargetName((IConfiguration)config);
                try {
                    if (targetId != null) break block4;
                    return null;
                }
                catch (Exception e) {
                    logger.error("Failed to get edje lib path", (Throwable)e);
                    return null;
                }
            }
            String platformEdjeCCPath = this.getPlatformEdjeCCPath(targetId);
            if (platformEdjeCCPath == null || platformEdjeCCPath.isEmpty()) return sbi.getEdjeLibPath(targetId);
            String edjeHomePath = new File(platformEdjeCCPath).getParent();
            edjeLibPath = String.valueOf(edjeHomePath) + File.separator + "lib";
            if (edjeLibPath != null && !edjeLibPath.isEmpty()) break block5;
            return null;
        }
        return new File(edjeLibPath).getCanonicalPath();
    }

    private String getEnvSdkToolPath() {
        SmartBuildInterface sbi = SmartBuildInterface.getInstance();
        if (OSChecker.isWindows()) {
            return sbi.getSdkToolsPath().replace("\\", "/");
        }
        return sbi.getSdkToolsPath();
    }

    private String getEnvSdkInstallPath() {
        if (OSChecker.isWindows()) {
            SmartBuildInterface sbi = SmartBuildInterface.getInstance();
            return sbi.getWindowsPathFromMinGWPath(InstallPathConfig.getSDKPath());
        }
        return InstallPathConfig.getSDKPath();
    }

    private String getEnvCCompiler(IConfiguration config) {
        return NativeCoreConfigurationManager.getCCompilerTool(config);
    }

    private String getRSLibraries(IConfiguration config) {
        List<String> flagList = NativeCoreConfigurationManager.getFrameworkLibraries(config);
        StringBuffer sb = new StringBuffer();
        for (String lib : flagList) {
            sb.append(lib);
            sb.append(" ");
        }
        if (sb.length() > 0) {
            sb = sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private String getAppId(IConfiguration config) {
        IProject project = (IProject)config.getOwner();
        String appId = ProjectUtil.getAppId((IProject)project);
        if (appId == null) {
            return "";
        }
        return appId;
    }

    private String getEnvCxxCompiler(IConfiguration config) {
        return NativeCoreConfigurationManager.getCxxCompilerTool(config);
    }

    private String getEnvSAReportPath(IConfiguration config) {
        IProject project = (IProject)config.getOwner();
        return project.getLocation().append("SA_Report").toOSString();
    }

    private String getEnvBinutilsPath(IConfiguration config) {
        String binutilsPath;
        SmartBuildInterface sbi = SmartBuildInterface.getInstance();
        String targetId = NativeCoreConfigurationManager.getBuildTargetName((IConfiguration)config);
        try {
            binutilsPath = sbi.getBinutilsPath(targetId);
        }
        catch (SBIException e) {
            logger.error("Failed to get binutils path", (Throwable)e);
            return null;
        }
        return binutilsPath;
    }

    private String getPlatformDefaultGCCPath(IConfiguration config) {
        String targetId;
        block3: {
            try {
                targetId = NativeCoreConfigurationManager.getBuildTargetName((IConfiguration)config);
                if (targetId != null) break block3;
                return "";
            }
            catch (Exception e) {
                logger.error("Failed to get platform gcc path", (Throwable)e);
                return "";
            }
        }
        String projectType = NativeCoreConfigurationManager.getProjectType((IConfiguration)config);
        PluginManager pm = PluginManager.getInstance();
        String path = pm.getDefaultGCCToolchainPath(targetId, projectType);
        return path;
    }

    private String getEnvProjectPath(IConfiguration config) {
        IProject project = (IProject)config.getOwner();
        return NativeCoreConfigurationEnvVarSupplier.getPathForResource((IResource)project).toOSString();
    }

    private String getOutputPath(IConfiguration config) {
        IProject project = (IProject)config.getOwner();
        return project.getLocation().append(config.getName()).toOSString();
    }

    private static IPath getPathForResource(IResource resource) {
        return new Path(resource.getLocationURI().getPath());
    }

    private String resolveMacros(String source) {
        return MacroUtil.processMacro((String)source, this.macros, (String)"#{", (String)"}");
    }

    static enum Variable {
        SBI_SYSROOT,
        SBI_COMPILER_PATH,
        PATH,
        LD_LIBRARY_PATH,
        SDK_TOOLPATH,
        SDK_INSTALL_PATH,
        SDK_ARCH,
        MINGWBIN_PATH,
        MSYSBIN_PATH,
        APICHECKER_PATH,
        BINUTILS_PATH,
        EFL_BIN_PATH,
        EFL_LIB_PATH,
        MSGFMT_PATH,
        PROJ_PATH,
        SDK_PATH,
        SA_REPORT_PATH,
        SA_REPORT_TYPE,
        TC_COMPILER_MISC,
        TC_LINKER_MISC,
        RS_COMPILER_MISC,
        RS_LINKER_MISC,
        RS_LIBRARIES,
        APPID,
        BUILD_CONFIG,
        OUTPUT_PATH,
        CC,
        CXX,
        AR,
        NOVALUE;


        public static Variable getIndex(String str) {
            try {
                return Variable.valueOf(str);
            }
            catch (Exception e) {
                logger.trace("There is no value", (Throwable)e);
                return NOVALUE;
            }
        }
    }
}

