/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.core.gputil;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.tizen.core.gputil.Assert;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XMLUtil {
    public static boolean existChildElement(Element parentElem) {
        NodeList nodeList = parentElem.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEqualNode(Node a, Node b) {
        String b_text;
        String a_text;
        String a_name = a.getNodeName();
        String b_name = b.getNodeName();
        if (a_name != null ? !a_name.equals(b_name) : b_name != null) {
            return false;
        }
        if (a.getAttributes().getLength() != b.getAttributes().getLength()) {
            return false;
        }
        for (int i = 0; i < a.getAttributes().getLength(); ++i) {
            Node attrNode = a.getAttributes().item(i);
            if (!(attrNode instanceof Attr)) continue;
            Node attrNode2 = b.getAttributes().getNamedItem(((Attr)attrNode).getName());
            if (attrNode2 == null) {
                return false;
            }
            if (((Attr)attrNode2).getValue().equals(((Attr)attrNode).getValue())) continue;
            return false;
        }
        return !(a instanceof Element) || XMLUtil.existChildElement((Element)a) || (a_text = a.getTextContent()).equals(b_text = b.getTextContent());
    }

    private static void mergeChildNode(Document doc, Element desRoot, Element srcRoot) {
        NodeList nodeList = srcRoot.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String text;
            Node node = nodeList.item(i);
            if (node instanceof Element) {
                boolean exist = false;
                Node pos = null;
                NodeList desNodeList = desRoot.getChildNodes();
                for (int j = 0; j < desNodeList.getLength(); ++j) {
                    Node desNode = desNodeList.item(j);
                    if (desNode == null || !desNode.getNodeName().equals(node.getNodeName())) continue;
                    if (XMLUtil.isEqualNode(node, desNode)) {
                        XMLUtil.mergeChildNode(doc, (Element)desNode, (Element)node);
                        exist = true;
                        break;
                    }
                    pos = desNode;
                }
                if (exist) continue;
                if (pos != null) {
                    desRoot.insertBefore(doc.importNode(node, true), pos.getNextSibling());
                    continue;
                }
                desRoot.appendChild(doc.importNode(node, true));
                continue;
            }
            if (node instanceof Text && (text = node.getTextContent()).trim().isEmpty()) continue;
        }
    }

    private static void removeWhitespace(Node parentNode) {
        NodeList nodeList = parentNode.getChildNodes();
        if (nodeList.getLength() <= 0) {
            return;
        }
        for (int i = nodeList.getLength() - 1; i >= 0; --i) {
            String text;
            Node node = nodeList.item(i);
            if (node instanceof Element) {
                XMLUtil.removeWhitespace(node);
                continue;
            }
            if (!(node instanceof Text) || !(text = node.getTextContent()).trim().isEmpty()) continue;
            parentNode.removeChild(node);
        }
    }

    public static Document readXML(InputStream xmlStream, boolean whiteSpace) {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringElementContentWhitespace(!whiteSpace);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e1) {
            e1.printStackTrace();
            return null;
        }
        Document doc = null;
        try {
            doc = builder.parse(xmlStream);
            if (!whiteSpace) {
                XMLUtil.removeWhitespace(doc.getDocumentElement());
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return doc;
    }

    public static Document readXML(InputStream xmlStream) {
        return XMLUtil.readXML(xmlStream, false);
    }

    public static Document readXML(File xmlFile, boolean whiteSpace) {
        Document doc = null;
        try {
            doc = XMLUtil.readXML(new FileInputStream(xmlFile), whiteSpace);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return doc;
    }

    public static Document readXML(File xmlFile) {
        return XMLUtil.readXML(xmlFile, false);
    }

    public static Document mergeXML(List<File> listOfFiles) {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringElementContentWhitespace(true);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e1) {
            e1.printStackTrace();
            return null;
        }
        Document newDoc = null;
        for (File listOfFile : listOfFiles) {
            Document doc;
            try {
                doc = builder.parse(listOfFile);
                XMLUtil.removeWhitespace(doc.getDocumentElement());
            }
            catch (SAXException e) {
                e.printStackTrace();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            if (newDoc == null) {
                newDoc = doc;
                continue;
            }
            if (doc == null) continue;
            XMLUtil.mergeChildNode(newDoc, newDoc.getDocumentElement(), doc.getDocumentElement());
        }
        return newDoc;
    }

    public static List<Element> getElementsByTag(Element parent, String tag) {
        Assert.notNull(parent);
        Assert.notNull(tag);
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList nodeList = parent.getElementsByTagName(tag);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            result.add((Element)node);
        }
        return result;
    }

    public static Node getDOMNodeNS(Element elem, String xpathStr, String nameSpace) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        if (nameSpace != null) {
            xPath.setNamespaceContext(new UniversalNamespaceResolver(elem, nameSpace));
        }
        Object node = null;
        try {
            node = xPath.evaluate(xpathStr, elem, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        if (node instanceof Node) {
            return (Node)node;
        }
        return null;
    }

    public static Node getDOMNodeNS(Element elem, String xpathStr) {
        return XMLUtil.getDOMNodeNS(elem, xpathStr, "");
    }

    public static Node getDOMNode(Element elem, String xpathStr) {
        return XMLUtil.getDOMNodeNS(elem, xpathStr, null);
    }

    public static NodeList getDOMNodesNS(Element elem, String xpathStr, String nameSpace) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        if (nameSpace != null) {
            xPath.setNamespaceContext(new UniversalNamespaceResolver(elem, nameSpace));
        }
        Object node = null;
        try {
            node = xPath.evaluate(xpathStr, elem, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        if (node instanceof NodeList) {
            return (NodeList)node;
        }
        return null;
    }

    public static NodeList getDOMNodesNS(Element elem, String xpathStr) {
        return XMLUtil.getDOMNodesNS(elem, xpathStr, "");
    }

    public static NodeList getDOMNodes(Element elem, String xpathStr) {
        return XMLUtil.getDOMNodesNS(elem, xpathStr, null);
    }

    public static String getDOMValueNS(Element elem, String xpathStr, String nameSpace) {
        Object value;
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        if (nameSpace != null) {
            xPath.setNamespaceContext(new UniversalNamespaceResolver(elem, nameSpace));
        }
        try {
            value = xPath.evaluate(xpathStr, elem, XPathConstants.STRING);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public static String getDOMValueNS(Element elem, String xpathStr) {
        return XMLUtil.getDOMValueNS(elem, xpathStr, "");
    }

    public static String getDOMValue(Element elem, String xpathStr) {
        return XMLUtil.getDOMValueNS(elem, xpathStr, null);
    }

    public static void setDOMValueNS(Element elem, String xpathStr, String value, String nameSpace) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        if (nameSpace != null) {
            xPath.setNamespaceContext(new UniversalNamespaceResolver(elem, nameSpace));
        }
        Object node = null;
        try {
            node = xPath.evaluate(xpathStr, elem, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        if (node instanceof Node) {
            ((Node)node).setNodeValue(value);
        }
    }

    public static void setDOMValueNS(Element elem, String xpathStr, String value) {
        XMLUtil.setDOMValueNS(elem, xpathStr, value, "");
    }

    public static void setDOMValue(Element elem, String xpathStr, String value) {
        XMLUtil.setDOMValueNS(elem, xpathStr, value, null);
    }

    public static String getDOMValueNS(Document doc, String xpathStr) {
        return XMLUtil.getDOMValueNS(doc.getDocumentElement(), xpathStr);
    }

    public static String getDOMValueNS(Document doc, String xpathStr, String nameSpace) {
        return XMLUtil.getDOMValueNS(doc.getDocumentElement(), xpathStr, nameSpace);
    }

    public static Node getDOMNodeNS(Document doc, String xpathStr) {
        return XMLUtil.getDOMNodeNS(doc.getDocumentElement(), xpathStr);
    }

    public static Node getDOMNodeNS(Document doc, String xpathStr, String nameSpace) {
        return XMLUtil.getDOMNodeNS(doc.getDocumentElement(), xpathStr, nameSpace);
    }

    public static String getDOMValue(Document doc, String xpathStr) {
        return XMLUtil.getDOMValue(doc.getDocumentElement(), xpathStr);
    }

    public static Node getDOMNode(Document doc, String xpathStr) {
        return XMLUtil.getDOMNode(doc.getDocumentElement(), xpathStr);
    }

    public static NodeList getDOMNodesNS(Document doc, String xpathStr) {
        return XMLUtil.getDOMNodesNS(doc.getDocumentElement(), xpathStr);
    }

    public static NodeList getDOMNodes(Document doc, String xpathStr) {
        return XMLUtil.getDOMNodes(doc.getDocumentElement(), xpathStr);
    }

    public static void setDOMValue(Document doc, String xpathStr, String value) {
        XMLUtil.setDOMValue(doc.getDocumentElement(), xpathStr, value);
    }

    public static void setDOMValueNS(Document doc, String xpathStr, String value) {
        XMLUtil.setDOMValueNS(doc.getDocumentElement(), xpathStr, value);
    }

    public static void writeTo(Document doc, Writer writer) throws IOException, ParserConfigurationException {
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(writer);
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setAttribute("indent-number", new Integer(4));
        Transformer transformer = null;
        try {
            transformer = factory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
            return;
        }
        try {
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    public static String writeToString(Document doc) {
        StringWriter writer = new StringWriter();
        try {
            XMLUtil.writeTo(doc, writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return writer.getBuffer().toString();
    }

    public static void writeToFile(Document doc, String filePath) {
        try {
            XMLUtil.writeTo(doc, new FileWriter(filePath));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    private static class UniversalNamespaceResolver
    implements NamespaceContext {
        private Element sourceDocument;
        private String nameSpace;

        public UniversalNamespaceResolver(Element document, String nameSpace) {
            this.sourceDocument = document;
            this.nameSpace = nameSpace;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix == null) {
                throw new IllegalArgumentException("No prefix provided!");
            }
            if (prefix.equals("")) {
                if (this.nameSpace == null || this.nameSpace.isEmpty()) {
                    return this.sourceDocument.getNamespaceURI();
                }
                return this.nameSpace;
            }
            return this.sourceDocument.lookupNamespaceURI(prefix);
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return this.sourceDocument.lookupPrefix(namespaceURI);
        }

        public Iterator getPrefixes(String namespaceURI) {
            return null;
        }
    }
}

