/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ssilib;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.core.gputil.IOUtil;
import org.tizen.core.gputil.MacroUtil;
import org.tizen.core.gputil.OSChecker;
import org.tizen.core.gputil.PathUtil;
import org.tizen.core.gputil.XMLUtil;
import org.tizen.ssilib.SSIData;
import org.tizen.ssilib.SSIFileSet;
import org.tizen.ssilib.SSIMacro;
import org.tizen.ssilib.SSIParser;
import org.tizen.ssilib.SSIProc;
import org.tizen.ssilib.SSIRule;
import org.tizen.ssilib.SSIStructure;
import org.tizen.ssilib.SSITargetType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SSIProcess {
    protected final Logger logger = LoggerFactory.getLogger(SSIProcess.class);
    private static final String SHELL_COMMAND_LINUX = "/bin/sh";
    private static final String SHELL_COMMAND_MINGW = "sh";
    private static final String SHELL_COMMAND_LINUX_PARAM = "-c";
    private static final String SHELL_COMMAND_WINDOW = "cmd";
    private static final String SHELL_COMMAND_WINDOW_PARAM = "/c";
    private static final String SHELL_WIN_PATH_NAME = "Path";
    private static final int CMDLINEMAX = 65535;
    private boolean validate = false;
    private String sdkPath;
    private String ssiHomePath;
    private SSIParser.SSIScript ssi = new SSIParser.SSIScript();

    public static void setEnv(Map<String, String> env, String key, String value, Map<String, String> macros) {
        if (value != null) {
            value = MacroUtil.processMacro((String)value, macros);
            env.put(key, value);
        }
    }

    public static void setEnv(Map<String, String> env, String key, String value) {
        if (value != null) {
            value = MacroUtil.processMacro((String)value, env);
            env.put(key, value);
        }
    }

    public boolean isValidate() {
        return this.validate;
    }

    public SSIMacro getSSIMacro() {
        return this.ssi.ssiMacro;
    }

    public Map<String, String> getMacros() {
        return this.ssi.ssiMacro.getMacros();
    }

    public Map<String, String> getGlobalMacros() {
        return this.ssi.ssiMacro.getGlobalMacros();
    }

    public boolean analisysPackageScript(File sbiBuildConfFile, SSIData data, String requireVersion) {
        this.ssi = SSIParser.analisysPackageScript(sbiBuildConfFile, data, requireVersion);
        this.validate = this.ssi != null;
        return this.validate;
    }

    public boolean analisysPackageScript(File sbiBuildConfFile, SSIData data) {
        return this.analisysPackageScript(sbiBuildConfFile, data, null);
    }

    public SSIProcess() {
        this.sdkPath = null;
    }

    public SSIProcess(String ssiHomePath) {
        this.ssiHomePath = ssiHomePath;
    }

    public void setSdkPath(String sdkPath) {
        this.sdkPath = sdkPath;
    }

    public void setHomePath(String ssiHomePath) {
        this.ssiHomePath = ssiHomePath;
    }

    public static ProcessBuilder genProcessBuilder(ProcessBuilder pb) {
        if (pb == null) {
            pb = new ProcessBuilder(new String[0]);
        }
        if (OSChecker.isWindows()) {
            String curEnv = System.getenv(SHELL_WIN_PATH_NAME);
            pb.environment().put(SHELL_WIN_PATH_NAME, curEnv);
        }
        return pb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static int executeProcess(ProcessBuilder pb, String[] cmds, Logger logger) {
        String sbiTrace = "[SBI] command : ";
        for (String c : cmds) {
            sbiTrace = sbiTrace + c + " ";
        }
        logger.info(sbiTrace);
        pb.command(cmds);
        pb.redirectErrorStream(true);
        Process proc = null;
        BufferedReader input = null;
        try {
            proc = pb.start();
            input = new BufferedReader(new InputStreamReader(proc.getInputStream()), 65535);
            if (logger != null) {
                String line = null;
                while ((line = input.readLine()) != null) {
                    logger.info(line);
                }
            }
            proc.waitFor();
        }
        catch (IOException e) {
            if (logger != null) {
                logger.error("IOException occurred:", (Throwable)e);
            }
            int n = -1;
            IOUtil.tryClose((Object[])new Object[]{input});
            if (proc != null) {
                proc.destroy();
            }
            return n;
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
            int n = -1;
            {
                catch (Throwable throwable) {
                    IOUtil.tryClose((Object[])new Object[]{input});
                    if (proc != null) {
                        proc.destroy();
                    }
                    throw throwable;
                }
            }
            IOUtil.tryClose((Object[])new Object[]{input});
            if (proc != null) {
                proc.destroy();
            }
            return n;
        }
        IOUtil.tryClose((Object[])new Object[]{input});
        if (proc != null) {
            proc.destroy();
        }
        return proc.exitValue();
    }

    public static String[] getCommand(String[] commands, boolean isLinux) {
        String[] fullCommand;
        if (OSChecker.isWindows()) {
            if (isLinux) {
                fullCommand = new String[6 + commands.length];
                fullCommand[0] = SHELL_COMMAND_WINDOW;
                fullCommand[1] = SHELL_COMMAND_WINDOW_PARAM;
                fullCommand[2] = "\"";
                fullCommand[3] = SHELL_COMMAND_MINGW;
                fullCommand[4] = SHELL_COMMAND_LINUX_PARAM;
                System.arraycopy(commands, 0, fullCommand, 5, commands.length);
                int idx = 5 + commands.length;
                fullCommand[idx] = "\"";
            } else {
                fullCommand = new String[2 + commands.length];
                fullCommand[0] = SHELL_COMMAND_WINDOW;
                fullCommand[1] = SHELL_COMMAND_WINDOW_PARAM;
                System.arraycopy(commands, 0, fullCommand, 2, commands.length);
            }
        } else {
            fullCommand = new String[2 + commands.length];
            fullCommand[0] = SHELL_COMMAND_LINUX;
            fullCommand[1] = SHELL_COMMAND_LINUX_PARAM;
            System.arraycopy(commands, 0, fullCommand, 2, commands.length);
        }
        return fullCommand;
    }

    private Element createElement(Document doc, Element root, String path) {
        String[] tags = path.split("/");
        int startIdx = 0;
        Node node = null;
        for (int len = tags.length; len >= 0; --len) {
            String str = "";
            for (int i = 0; i < len; ++i) {
                if (str.isEmpty()) {
                    str = str + "/";
                }
                str = str + tags[i];
            }
            node = XMLUtil.getDOMNode((Element)root, (String)str);
            if (node == null) continue;
            startIdx = len;
            break;
        }
        for (int i = startIdx; i < tags.length; ++i) {
            String tag = tags[i];
            Element childNode = doc.createElement(tag);
            node.appendChild(childNode);
            node = childNode;
        }
        return (Element)node;
    }

    private static int copyAll(List<String> dirs, List<String> files, String home, File srcFile, List<String> includeFilters, List<String> excludeFilters, boolean isStrip) {
        if (!srcFile.exists()) {
            return 0;
        }
        int cnt = 0;
        if (srcFile.isFile()) {
            String relPath = PathUtil.getRelativePath((String)home, (String)srcFile.toString());
            if (includeFilters != null) {
                for (String filter : includeFilters) {
                    if (relPath.toString().matches(filter)) continue;
                    return 0;
                }
            }
            if (excludeFilters != null) {
                for (String filter : excludeFilters) {
                    if (!relPath.toString().matches(filter)) continue;
                    return 0;
                }
            }
            if (!relPath.equals(".")) {
                files.add(relPath);
                cnt = 1;
            }
        } else if (srcFile.isDirectory()) {
            File[] childs = srcFile.listFiles();
            String relPath = null;
            if (!dirs.contains(srcFile.toString())) {
                relPath = PathUtil.getRelativePath((String)home, (String)srcFile.toString());
                if (includeFilters != null) {
                    for (String filter : includeFilters) {
                        if (relPath.toString().matches(filter)) continue;
                        return 0;
                    }
                }
                if (excludeFilters != null) {
                    for (String filter : excludeFilters) {
                        if (!relPath.toString().matches(filter)) continue;
                        return 0;
                    }
                }
            }
            for (File childFile : childs) {
                cnt += SSIProcess.copyAll(dirs, files, home, childFile, includeFilters, excludeFilters, isStrip);
            }
            if (cnt > 0 || relPath != null && !isStrip) {
                dirs.add(relPath);
                ++cnt;
            }
        }
        return cnt;
    }

    private static void getCopyTarget(List<String> dirs, List<String> files, String home, List<String> includeFilters, List<String> excludeFilters, boolean isStrip) {
        SSIProcess.copyAll(dirs, files, home, new File(home), includeFilters, excludeFilters, isStrip);
    }

    public void calcFilesets(AllProc allProc, String projPath, List<SSIFileSet.FileEntry> fileEntryList, String[] desRoot, boolean isEmbDir) {
        for (SSIFileSet.FileEntry entry : fileEntryList) {
            List<String> excludeFilters;
            if (entry.isContainType("file")) {
                String src = this.ssi.ssiMacro.processValue(entry.src);
                if (src == null || src.isEmpty()) continue;
                String des = this.ssi.ssiMacro.processValue(entry.des);
                allProc.addCopyFileProc(PathUtil.getFullPath((String)projPath, (String)src), des, desRoot);
                continue;
            }
            if (!entry.isContainType("dir")) continue;
            ArrayList<String> dirs = new ArrayList<String>();
            ArrayList<String> files = new ArrayList<String>();
            String src = this.ssi.ssiMacro.processValue(entry.src);
            List<String> includeFilters = entry.includeFilters;
            if (includeFilters != null && includeFilters.isEmpty()) {
                includeFilters = null;
            }
            if ((excludeFilters = entry.excludeFilters) != null && excludeFilters.isEmpty()) {
                excludeFilters = null;
            }
            ArrayList<String> attrs = new ArrayList<String>();
            for (String string : entry.attrs) {
                String v = this.ssi.ssiMacro.processValue(string);
                if (v == null || v.isEmpty()) continue;
                attrs.add(v);
            }
            boolean isStrip = attrs.contains("strip");
            boolean isMandatory = attrs.contains("mandatory");
            SSIProcess.getCopyTarget(dirs, files, PathUtil.getFullPath((String)projPath, (String)src), includeFilters, excludeFilters, isStrip);
            if (!files.isEmpty()) {
                String srcDir = new File(PathUtil.getFullPath((String)projPath, (String)src)).toString();
                for (String file : files) {
                    allProc.addCopyFileProc(srcDir, file, entry.des, file, desRoot);
                }
            }
            if (!isEmbDir) continue;
            if (!dirs.isEmpty()) {
                for (String string : dirs) {
                    allProc.addMakeDirProc(null, entry.des, string, desRoot);
                }
                continue;
            }
            if (!isMandatory) continue;
            String relPath = entry.des;
            if (relPath != null && relPath.length() > 1 && !relPath.endsWith(":/") && relPath.endsWith("/")) {
                relPath = relPath.substring(0, relPath.length() - 1);
            }
            allProc.addMakeDirProc(null, relPath, desRoot);
        }
    }

    public int procStructuringOne(AllProc allProc, String actionName, String target, String targetType, int targetOrder, String workingPath, String projPath, String outputPath, SSIMacro.Runner runner, Logger logger) {
        int result = 0;
        SSIStructure struct = this.ssi.structs.get(actionName);
        if (struct == null) {
            return -1;
        }
        this.ssi.ssiMacro.setMacroRunner(runner);
        List<SSIProc> procs = struct.getProcList();
        for (SSIProc proc : procs) {
            String require = proc.getRequire();
            if (require != null && !require.isEmpty() && ((require = this.ssi.ssiMacro.processValue(require)) == null || require.isEmpty()) || !proc.matchTarget(target, targetType, targetOrder)) continue;
            if (logger != null) {
                String echoText = proc.getEcho();
                if ((echoText = this.ssi.ssiMacro.processValue(echoText)) != null && !echoText.isEmpty()) {
                    logger.info("[SSI] " + echoText);
                }
            }
            String type = proc.getType();
            ArrayList<SSIFileSet.FileEntry> fileEntryList = new ArrayList<SSIFileSet.FileEntry>();
            List<SSIRule> filesetRules = proc.getFileSetRules();
            if (filesetRules != null) {
                for (SSIRule filesetRule : filesetRules) {
                    Collection<SSIFileSet.FileEntry> entryList = SSIFileSet.getMatchFileFileEntrys(this.ssi.filesets, filesetRule);
                    if (entryList == null) continue;
                    fileEntryList.addAll(entryList);
                }
            }
            if (type.equals("copy")) {
                this.calcFilesets(allProc, projPath, fileEntryList, proc.getDes(), true);
                continue;
            }
            if (type.equals("dom")) {
                String domPath;
                String domName;
                String[] des = proc.getDes();
                if (des.length >= 2) {
                    domName = des[0].isEmpty() ? "dom" : des[0];
                    domPath = des[1].isEmpty() ? "/" : des[1];
                } else {
                    domName = "dom";
                    domPath = des.length >= 1 ? (des[0].isEmpty() ? "/" : des[0]) : "/";
                }
                for (SSIFileSet.FileEntry entry : fileEntryList) {
                    if (!entry.isContainType("file")) continue;
                    String src = this.ssi.ssiMacro.processValue(entry.src);
                    allProc.addGenDOMProc(projPath, src, domName, domPath);
                }
                continue;
            }
            if (type.equals("gen")) {
                allProc.addGenDocProc(proc.getSrc(), proc.getTransScript(), proc.getDes()[0]);
                continue;
            }
            if (!type.equals("exec")) continue;
            AllProc ap = new AllProc();
            this.calcFilesets(ap, projPath, fileEntryList, proc.getDes(), false);
            for (PartialProc p : ap.copyProcs) {
                allProc.addExecProc(proc.getContent(), p.getSrc(), p.getDes(), proc.getDes());
            }
        }
        return result;
    }

    private void doCopyFileProc(String projPath, String outPath, PartialProc proc) {
        String src = PathUtil.getFullPath((String)projPath, (String)proc.getSrc());
        String des = PathUtil.getFullPath((String)outPath, (String)proc.getDes());
        try {
            File desFile;
            File srcFile = new File(src);
            if (!srcFile.exists()) {
                // empty if block
            }
            if ((desFile = new File(des)).exists()) {
                if (desFile.isDirectory()) {
                    des = new File(desFile, srcFile.getName()).toString();
                }
            } else {
                File parentDesFile = new File(desFile.getParent());
                if (!parentDesFile.exists()) {
                    parentDesFile.mkdirs();
                }
            }
            FileInputStream inputStream = new FileInputStream(src);
            FileOutputStream outputStream = new FileOutputStream(des);
            FileChannel fcin = inputStream.getChannel();
            FileChannel fcout = outputStream.getChannel();
            long size = fcin.size();
            fcin.transferTo(0L, size, fcout);
            fcout.close();
            fcin.close();
            outputStream.close();
            inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void doMakeDirProc(String outPath, PartialProc proc) {
        String dir = PathUtil.getFullPath((String)outPath, (String)proc.getDir());
        new File(dir).mkdirs();
    }

    private void addDOM(String domId, Document doc) {
        this.ssi.doms.put(domId, doc);
    }

    private Document getDOM(String domId) {
        return this.ssi.doms.get(domId);
    }

    private void doAddDOMProc(String projPath, String outPath, PartialProc proc) {
        Document doc2;
        File manifestFile2;
        Element manifestElem;
        Document doc;
        if (proc.getSrc() == null || proc.getSrc().isEmpty()) {
            return;
        }
        String src = PathUtil.getFullPath((String)projPath, (String)proc.getSrc());
        String domId = proc.getDir();
        if (domId == null) {
            domId = "dom";
        }
        if ((doc = this.getDOM(domId)) == null) {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = null;
            try {
                docBuilder = docFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e1) {
                e1.printStackTrace();
                return;
            }
            doc = docBuilder.newDocument();
            Element rootElem = doc.createElement("root");
            doc.appendChild(rootElem);
            Element dataElem = doc.createElement("data");
            rootElem.appendChild(dataElem);
            Set<String> keySet = this.ssi.ssiMacro.getMacros().keySet();
            for (String key : keySet) {
                Element macro = doc.createElement("macro");
                macro.setAttribute("name", key);
                macro.setAttribute("value", this.ssi.ssiMacro.getMacros().get(key).toString());
                dataElem.appendChild(macro);
            }
            this.addDOM(domId, doc);
        }
        if ((manifestElem = (Element)XMLUtil.getDOMNode((Element)doc.getDocumentElement(), (String)proc.getDes())) == null) {
            manifestElem = this.createElement(doc, doc.getDocumentElement(), proc.getDes());
        }
        if ((manifestFile2 = new File(PathUtil.getFullPath((String)proc.getProjPath(), (String)proc.getSrc()))).exists() && (doc2 = XMLUtil.readXML((File)manifestFile2, (boolean)true)) != null) {
            manifestElem.appendChild(doc.adoptNode(doc2.getDocumentElement()));
        }
    }

    private void doGenDocProc(String projPath, String outPath, PartialProc proc) {
        Document doc;
        String des = PathUtil.getFullPath((String)outPath, (String)proc.getDes());
        String domId = proc.getSrc();
        if (domId == null) {
            domId = "dom";
        }
        if ((doc = this.getDOM(domId)) == null) {
            this.logger.error("Cannot found DOM Id : " + domId);
            return;
        }
        String xsl = PathUtil.getFullPath((String)this.ssiHomePath, (String)proc.getDir());
        if (!new File(xsl).exists()) {
            this.logger.error("Cannot found XSL file : " + xsl);
            return;
        }
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer trans = null;
        try {
            trans = transFactory.newTransformer(new StreamSource(xsl));
        }
        catch (TransformerConfigurationException e1) {
            e1.printStackTrace();
            return;
        }
        trans.setOutputProperty("indent", "yes");
        DOMSource src = new DOMSource(doc);
        StreamResult result = new StreamResult(des);
        try {
            trans.transform(src, result);
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    private void doExecProc(String exec, String projPath, String outPath, PartialProc proc) {
        String src = PathUtil.getFullPath((String)projPath, (String)proc.getSrc());
        String des = PathUtil.getFullPath((String)outPath, (String)proc.getDes());
        if (new File(src).isFile() && new File(des).isDirectory()) {
            des = new File(des, new File(src).getName()).toString();
        }
        this.ssi.ssiMacro.addMacro("FILEENTRY:SRC", src);
        this.ssi.ssiMacro.addMacro("FILEENTRY:DES", des);
        exec = this.ssi.ssiMacro.processValue(exec);
        this.ssi.ssiMacro.removeMacro("FILEENTRY:SRC");
        this.ssi.ssiMacro.removeMacro("FILEENTRY:DES");
        ProcessBuilder pb = SSIProcess.genProcessBuilder(null);
        String[] cmds = SSIProcess.getCommand(new String[]{exec}, false);
        SSIProcess.executeProcess(pb, cmds, this.logger);
    }

    public void doAllProc(String outPath, AllProc allProc) {
        for (PartialProc dir : allProc.makeProcs) {
            this.doMakeDirProc(outPath, dir);
        }
        for (PartialProc file : allProc.copyProcs) {
            this.doCopyFileProc(file.getProjPath(), outPath, file);
        }
        for (PartialProc file : allProc.domProcs) {
            this.doAddDOMProc(file.getProjPath(), outPath, file);
        }
        for (PartialProc file : allProc.genProcs) {
            this.doGenDocProc(null, outPath, file);
        }
        for (PartialProc exec : allProc.execProcs) {
            this.doExecProc(exec.getDir(), exec.getProjPath(), outPath, exec);
        }
    }

    public String getStructureFormat(String actionName) {
        SSIStructure struct = this.ssi.structs.get(actionName);
        if (struct == null) {
            return null;
        }
        return struct.getFileFormat();
    }

    public int procStructuring(String actionName, SSITargetType[] targetTypes, String outputPath, Logger logger) {
        AllProc allProc = new AllProc();
        int order = 0;
        for (SSITargetType target : targetTypes) {
            if (target == null) continue;
            this.procStructuringOne(allProc, actionName, target.target, target.targetType, order++, target.outputPath, target.projPath, outputPath, target.macroRunner, logger);
        }
        this.doAllProc(outputPath, allProc);
        return 0;
    }

    public class AllProc {
        public List<PartialProc> makeProcs = new ArrayList<PartialProc>();
        public List<PartialProc> copyProcs = new ArrayList<PartialProc>();
        public List<PartialProc> domProcs = new ArrayList<PartialProc>();
        public List<PartialProc> genProcs = new ArrayList<PartialProc>();
        public List<PartialProc> execProcs = new ArrayList<PartialProc>();

        public void addMakeDirProc(String projPath, String baseDir, String dir, String[] procDesList) {
            if (baseDir != null && !baseDir.isEmpty()) {
                dir = new File(baseDir, dir).toString();
            }
            this.addMakeDirProc(projPath, dir, procDesList);
        }

        public void addMakeDirProc(String projPath, String dir, String[] procDesList) {
            String[] desList;
            if (dir == null) {
                return;
            }
            if ((dir = PathUtil.trim((String)dir)).trim().isEmpty()) {
                return;
            }
            if (procDesList != null) {
                ArrayList<String> lst = new ArrayList<String>();
                String[] stringArray = procDesList;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String procDes = stringArray[i];
                    procDes = ((SSIProcess)SSIProcess.this).ssi.ssiMacro.processValue(procDes);
                    lst.add(PathUtil.getFullPath((String)procDes, (String)dir));
                }
                desList = lst.toArray(new String[lst.size()]);
            } else {
                desList = new String[]{dir};
            }
            for (String dir2 : desList) {
                for (PartialProc proc : this.makeProcs) {
                    if (!proc.getDir().equals(dir2)) continue;
                    return;
                }
                this.makeProcs.add(new PartialProc("", dir2, "", projPath));
            }
        }

        public void addCopyFileProc(String srcPath, String srcFile, String desPath, String desFile, String[] procDesList) {
            if (srcPath != null && !srcPath.isEmpty()) {
                srcFile = new File(srcPath, srcFile).toString();
            }
            if (desPath != null && !desPath.isEmpty()) {
                desFile = new File(desPath, desFile).toString();
            }
            this.addCopyFileProc(srcFile, desFile, procDesList);
        }

        public void addCopyFileProc(String src, String des, String[] procDesList) {
            String[] desList;
            if (src == null || src.trim().isEmpty()) {
                return;
            }
            if (procDesList != null) {
                ArrayList<String> lst = new ArrayList<String>();
                String[] stringArray = procDesList;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String procDes = stringArray[i];
                    procDes = ((SSIProcess)SSIProcess.this).ssi.ssiMacro.processValue(procDes);
                    lst.add(PathUtil.getFullPath((String)procDes, (String)des));
                }
                desList = lst.toArray(new String[lst.size()]);
            } else {
                desList = new String[]{des};
            }
            for (String des2 : desList) {
                for (PartialProc proc : this.copyProcs) {
                    if (!proc.getSrc().equals(src) || !proc.getDes().equals(des2)) continue;
                    return;
                }
                this.copyProcs.add(new PartialProc(src, "", des2, null));
            }
        }

        public void addGenDOMProc(String projPath, String src, String dir, String des) {
            this.domProcs.add(new PartialProc(src, dir, des, projPath));
        }

        public void addGenDocProc(String src, String xsl, String des) {
            this.genProcs.add(new PartialProc(src, xsl, des, null));
        }

        public void addExecProc(String exec, String src, String des, String[] procDesList) {
            String[] desList;
            if (src == null || src.trim().isEmpty()) {
                return;
            }
            if (procDesList != null) {
                ArrayList<String> lst = new ArrayList<String>();
                String[] stringArray = procDesList;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String procDes = stringArray[i];
                    procDes = ((SSIProcess)SSIProcess.this).ssi.ssiMacro.processValue(procDes);
                    lst.add(PathUtil.getFullPath((String)procDes, (String)des));
                }
                desList = lst.toArray(new String[lst.size()]);
            } else {
                desList = new String[]{des};
            }
            for (String des2 : desList) {
                for (PartialProc proc : this.execProcs) {
                    if (!proc.getSrc().equals(src) || !proc.getDes().equals(des2)) continue;
                    return;
                }
                this.execProcs.add(new PartialProc(src, exec, des2, null));
            }
        }
    }

    public class PartialProc {
        String type = null;
        String src;
        String dir;
        String des;
        String projPath;

        public PartialProc(String src, String dir, String des, String projPath) {
            this.src = src;
            this.dir = dir;
            this.des = des;
            this.projPath = projPath;
        }

        public String getSrc() {
            return this.src;
        }

        public String getDes() {
            return this.des;
        }

        public String getDir() {
            return this.dir;
        }

        public String getType() {
            return this.type;
        }

        public String getProjPath() {
            return this.projPath;
        }
    }
}

