/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.ext.manifest;

import java.util.ArrayList;
import java.util.List;
import org.tizen.nativecore.ext.manifest.CustomAttribute;
import org.tizen.nativecore.ext.manifest.CustomElement;
import org.tizen.nativecore.ext.manifest.Icon;
import org.tizen.nativecore.misc.core.IconType;
import org.tizen.nativecore.misc.editor.CoreAdvancedPage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SupportSize {
    public static final String ELEMENT = "support-size";
    private static final String ATTR_PREVIEW = "preview";
    private Icon preview = new Icon(IconType.ETC);
    private String value;
    private List<CustomAttribute> customAttrList = new ArrayList<CustomAttribute>();
    private List<CustomElement> customElementList = new ArrayList<CustomElement>();

    public void loadElement(Element element) {
        if (!element.getNodeName().equals(ELEMENT)) {
            return;
        }
        this.setPreview(element.getAttribute(ATTR_PREVIEW));
        NamedNodeMap attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Node node = attrs.item(i);
            String attr = node.getNodeName();
            if (this.isCustomAttribute(attr)) {
                CustomAttribute custom = new CustomAttribute();
                custom.loadAttribute(attr, node.getNodeValue());
                this.getCustomAttrList().add(custom);
            }
            ++i;
        }
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                CustomElement custom = new CustomElement();
                custom.loadElement((Element)node);
                this.getCustomElementList().add(custom);
            } else if (node.getNodeType() == 3 && node.getNodeValue() != null) {
                String value = node.getNodeValue().trim();
                String[] stringArray = CoreAdvancedPage.SUPPORT_SIZES;
                int n = CoreAdvancedPage.SUPPORT_SIZES.length;
                int n2 = 0;
                while (n2 < n) {
                    String size = stringArray[n2];
                    if (value.equals(size)) {
                        this.setValue(value);
                        break;
                    }
                    ++n2;
                }
            }
            node = node.getNextSibling();
        }
    }

    public void generateElement(Document dom, Element parent) {
        Element element = dom.createElement(ELEMENT);
        parent.appendChild(element);
        if (this.preview.getFileName() != null && this.preview.getFileName().length() > 0) {
            element.setAttribute(ATTR_PREVIEW, this.preview.getFileName());
        } else {
            element.setAttribute(ATTR_PREVIEW, "");
        }
        if (this.getValue() != null && this.getValue().length() > 0) {
            element.setTextContent(this.getValue());
        }
        for (CustomAttribute customAttribute : this.getCustomAttrList()) {
            customAttribute.generateAttribute(element);
        }
        for (CustomElement customElement : this.getCustomElementList()) {
            customElement.generateElement(dom, element);
        }
    }

    public Icon getPreview() {
        return this.preview;
    }

    public void setPreview(String preview) {
        this.preview.set(preview);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public List<CustomElement> getCustomElementList() {
        return this.customElementList;
    }

    public List<CustomAttribute> getCustomAttrList() {
        return this.customAttrList;
    }

    private boolean isCustomAttribute(String attr) {
        return !attr.equals(ATTR_PREVIEW);
    }
}

