/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.misc.editor;

import java.io.File;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.tizen.nativecore.ext.manifest.Icon;
import org.tizen.nativecore.misc.IConstants;
import org.tizen.nativecore.misc.editor.ManifestEditor;
import org.tizen.nativecore.misc.editor.TizenFormPage;
import org.tizen.nativecore.misc.editor.UiAttribute;
import org.tizen.nativecore.misc.editor.dlg.UiIconChooserDialog;

public class UiAttrIcon
extends UiAttribute {
    private Text fText;
    private Button fBrowseBtn;
    private Icon fRefInput;
    private Label previewImage;
    private Label previewLabel;
    private ManifestEditor fEditor;
    private boolean launchIcon;

    public UiAttrIcon(TizenFormPage page) {
        super(page, false);
        this.fEditor = page.getEditor();
    }

    public UiAttrIcon(TizenFormPage page, boolean mandatory) {
        super(page, mandatory);
        this.fEditor = page.getEditor();
    }

    public void setLaunchIcon(boolean launchIcon) {
        this.launchIcon = launchIcon;
    }

    public boolean isLaunchIcon() {
        return this.launchIcon;
    }

    protected Text getTextWidget() {
        return this.fText;
    }

    protected Button getButtonWidget() {
        return this.fBrowseBtn;
    }

    public Icon getIconInput() {
        return this.fRefInput;
    }

    public void setInput(Icon icon) {
        this.fRefInput = icon;
        if (icon != null) {
            if (icon.getFileName() != null) {
                this.fText.setText(icon.getFileName());
            } else {
                this.fText.setText("");
            }
        } else {
            this.fText.setText("");
        }
    }

    public void createUi(Composite parent, FormToolkit toolkit, String labelText, boolean preview) {
        Label label = toolkit.createLabel(parent, labelText);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.createIconUi(parent, toolkit);
        if (preview) {
            this.previewLabel = new Label(parent, 0);
            this.previewLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, true));
            this.previewLabel.setText("Launcher Icon");
            this.previewImage = new Label(parent, 128);
            GridData gd = new GridData(4, 4, false, false, 1, 2);
            gd.widthHint = 90;
            gd.heightHint = 90;
            this.previewImage.setLayoutData((Object)gd);
        }
    }

    private Font getNormalFont(Control label, int fontSize) {
        FontDescriptor fontDescriptor = FontDescriptor.createFrom((Font)label.getFont());
        Font boldFont = fontDescriptor.createFont((Device)label.getDisplay());
        FontData[] fD = boldFont.getFontData();
        if (fontSize != 0) {
            fD[0].setHeight(fontSize);
        }
        return new Font(null, fD[0]);
    }

    public void createUiOverview(Composite parent, FormToolkit toolkit, String labelText, boolean preview) {
        Label label = toolkit.createLabel(parent, labelText);
        GridData gd = new GridData(16384, 0x1000000, true, false);
        gd.widthHint = 140;
        label.setLayoutData((Object)gd);
        label.setFont(this.getNormalFont((Control)label, 10));
        this.createIconUiOverview(parent, toolkit);
        if (preview) {
            this.previewLabel = new Label(parent, 0);
            this.previewLabel.setLayoutData((Object)gd);
            this.previewLabel.setText("Launcher Icon");
            this.previewLabel.setFont(this.getNormalFont((Control)this.previewLabel, 10));
            this.previewImage = new Label(parent, 128);
            gd = new GridData(4, 4, false, false, 1, 2);
            gd.widthHint = 90;
            gd.heightHint = 90;
            this.previewImage.setLayoutData((Object)gd);
        }
    }

    protected void createIconUiOverview(Composite parent, FormToolkit toolkit) {
        Composite grid = toolkit.createComposite(parent);
        GridData gd = new GridData(4, 0x1000000, true, false);
        grid.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 1;
        grid.setLayout((Layout)gl);
        toolkit.paintBordersFor(grid);
        this.fText = toolkit.createText(grid, "");
        this.fText.setFont(this.getNormalFont((Control)this.fText, 10));
        gd.widthHint = 500;
        this.fText.setLayoutData((Object)gd);
        this.fText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UiAttrIcon.this.onTextModified();
            }
        });
        this.fBrowseBtn = toolkit.createButton(grid, "Browse...", 8);
        this.fBrowseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UiAttrIcon.this.onBrowse();
            }
        });
    }

    protected void createIconUi(Composite parent, FormToolkit toolkit) {
        Composite grid = toolkit.createComposite(parent);
        grid.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 1;
        grid.setLayout((Layout)gl);
        toolkit.paintBordersFor(grid);
        this.fText = toolkit.createText(grid, "");
        this.fText.setLayoutData((Object)new GridData(768));
        this.fText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UiAttrIcon.this.onTextModified();
            }
        });
        this.fBrowseBtn = toolkit.createButton(grid, "Browse...", 8);
        this.fBrowseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UiAttrIcon.this.onBrowse();
            }
        });
    }

    protected void onTextModified() {
        if (this.isLaunchIcon()) {
            if (this.fRefInput == null) {
                this.fRefInput = new Icon();
            }
            this.fRefInput.set(this.fText.getText());
            this.fRefInput.setValue(this.fText.getText());
            if (this.fText.getText().isEmpty()) {
                this.fEditor.getCoreManifest().getDefaultApp().setDefaultIcon(null);
            } else {
                this.fEditor.getCoreManifest().getDefaultApp().setDefaultIcon(this.fRefInput);
            }
        } else {
            this.fRefInput.set(this.fText.getText());
        }
        this.validate();
        this.update();
        this.getPage().setDirty(true);
    }

    public void update() {
        if (this.previewImage != null) {
            String image;
            if (this.getIconInput() != null && this.getIconInput().getFileName() != null && !this.getIconInput().getFileName().isEmpty() && new File(image = String.valueOf(this.getPage().getProject().getLocation().toFile().getAbsolutePath()) + File.separatorChar + IConstants.DIR_SHARED_RES + File.separatorChar + this.getIconInput().getFileName()).exists()) {
                Image origImage = new Image(null, image);
                Image scaledImage = new Image((Device)Display.getDefault(), origImage.getImageData().scaledTo(90, 90));
                this.previewImage.setImage(scaledImage);
                return;
            }
            this.previewImage.setImage(null);
        }
    }

    protected void onBrowse() {
        UiIconChooserDialog dlg = new UiIconChooserDialog(Display.getDefault().getActiveShell(), this);
        if (dlg.open() != 0) {
            this.validate();
            this.update();
            return;
        }
        String iconPath = dlg.getSelectedItemName();
        this.fText.setText(iconPath);
        this.fRefInput.set(iconPath);
        String image = String.valueOf(this.getPage().getProject().getLocation().toFile().getAbsolutePath()) + File.separatorChar + IConstants.DIR_SHARED_RES + File.separatorChar + iconPath;
        File imageFile = new File(image);
        if (imageFile.isFile()) {
            if (this.previewImage != null) {
                Image origImage = new Image(null, new ImageData(image));
                Image scaledImage = new Image((Device)Display.getDefault(), origImage.getImageData().scaledTo(90, 90));
                this.previewImage.setImage(scaledImage);
            }
            this.getPage().setDirty(true);
        }
    }

    @Override
    public boolean validate() {
        String image;
        File imageFile;
        String mandatoryErrorkey = "mandatory attribute";
        String iconNotFoundErrorkey = "Icon not found";
        if (this.isMandatory() && this.fRefInput.getFileName().length() == 0) {
            this.getPage().getManagedForm().getMessageManager().addMessage((Object)mandatoryErrorkey, "This icon is mandatory attribute.", null, 3, (Control)this.fText);
            return false;
        }
        if (this.getIconInput() != null && this.getIconInput().getFileName() != null && !this.getIconInput().getFileName().isEmpty() && !(imageFile = new File(image = String.valueOf(this.getPage().getProject().getLocation().toFile().getAbsolutePath()) + File.separatorChar + IConstants.DIR_SHARED_RES + File.separatorChar + this.getIconInput().getFileName())).isFile()) {
            this.getPage().getManagedForm().getMessageManager().addMessage((Object)iconNotFoundErrorkey, "The icon " + this.getIconInput().getFileName() + " does not exist", null, 3, (Control)this.fText);
            return false;
        }
        this.getPage().getManagedForm().getMessageManager().removeMessage((Object)mandatoryErrorkey, (Control)this.fText);
        this.getPage().getManagedForm().getMessageManager().removeMessage((Object)iconNotFoundErrorkey, (Control)this.fText);
        return true;
    }
}

