/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public final class ToggleCommentAction
extends TextEditorAction {
    private ITextOperationTarget fOperationTarget;
    private String fDocumentPartitioning;
    private Map<String, String[]> fPrefixesMap;

    public ToggleCommentAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    public void run() {
        if (this.fOperationTarget == null || this.fDocumentPartitioning == null || this.fPrefixesMap == null) {
            return;
        }
        ITextEditor editor = this.getTextEditor();
        if (editor == null) {
            return;
        }
        if (!this.validateEditorInputState()) {
            return;
        }
        final int operationCode = this.isSelectionCommented(editor.getSelectionProvider().getSelection()) ? 12 : 11;
        Shell shell = editor.getSite().getShell();
        if (!this.fOperationTarget.canDoOperation(operationCode)) {
            if (shell != null) {
                MessageDialog.openError((Shell)shell, (String)CEditorMessages.ToggleComment_error_title, (String)CEditorMessages.ToggleComment_error_message);
            }
            return;
        }
        Display display = null;
        if (shell != null && !shell.isDisposed()) {
            display = shell.getDisplay();
        }
        BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

            @Override
            public void run() {
                ToggleCommentAction.this.fOperationTarget.doOperation(operationCode);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isSelectionCommented(ISelection selection) {
        if (!(selection instanceof ITextSelection)) {
            return false;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        if (textSelection.getStartLine() < 0 || textSelection.getEndLine() < 0) {
            return false;
        }
        IDocument document = this.getTextEditor().getDocumentProvider().getDocument((Object)this.getTextEditor().getEditorInput());
        try {
            IRegion block = this.getTextBlockFromSelection(textSelection, document);
            ITypedRegion[] regions = TextUtilities.computePartitioning((IDocument)document, (String)this.fDocumentPartitioning, (int)block.getOffset(), (int)block.getLength(), (boolean)false);
            int[] lines = new int[regions.length * 2];
            int i = 0;
            int j = 0;
            while (i < regions.length) {
                lines[j] = this.getFirstCompleteLineOfRegion((IRegion)regions[i], document);
                int length = regions[i].getLength();
                int offset = regions[i].getOffset() + length;
                if (length > 0) {
                    --offset;
                }
                int n = lines[j + 1] = lines[j] == -1 ? -1 : document.getLineOfOffset(offset);
                assert (i < regions.length);
                assert (j < regions.length * 2);
                ++i;
                j += 2;
            }
            boolean hasComment = false;
            int i2 = 0;
            int j2 = 0;
            while (i2 < regions.length) {
                String[] prefixes = this.fPrefixesMap.get(regions[i2].getType());
                if (prefixes != null && prefixes.length > 0 && lines[j2] >= 0 && lines[j2 + 1] >= 0) {
                    if (this.isBlockCommented(lines[j2], lines[j2 + 1], prefixes, document)) {
                        hasComment = true;
                    } else if (!this.isBlockEmpty(lines[j2], lines[j2 + 1], document)) {
                        return false;
                    }
                }
                ++i2;
                j2 += 2;
            }
            return hasComment;
        }
        catch (BadLocationException e) {
            CUIPlugin.log(e);
            return false;
        }
    }

    private IRegion getTextBlockFromSelection(ITextSelection selection, IDocument document) throws BadLocationException {
        int start = document.getLineOffset(selection.getStartLine());
        int endLine = selection.getEndLine();
        int end = document.getNumberOfLines() > endLine + 1 ? document.getLineOffset(endLine + 1) : document.getLength();
        return new Region(start, end - start);
    }

    private int getFirstCompleteLineOfRegion(IRegion region, IDocument document) {
        try {
            int startLine = document.getLineOfOffset(region.getOffset());
            int offset = document.getLineOffset(startLine);
            if (offset >= region.getOffset()) {
                return startLine;
            }
            offset = document.getLineOffset(startLine + 1);
            return offset > region.getOffset() + region.getLength() ? -1 : startLine + 1;
        }
        catch (BadLocationException e) {
            CUIPlugin.log(e);
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isBlockCommented(int startLine, int endLine, String[] prefixes, IDocument document) {
        try {
            boolean hasComment = false;
            int i = startLine;
            while (true) {
                boolean isEmptyLine;
                if (i > endLine) {
                    return hasComment;
                }
                IRegion line = document.getLineInformation(i);
                String text = document.get(line.getOffset(), line.getLength());
                boolean bl = isEmptyLine = text.trim().length() == 0;
                if (!isEmptyLine) {
                    int[] found = TextUtilities.indexOf((String[])prefixes, (String)text, (int)0);
                    if (found[0] == -1) {
                        return false;
                    }
                    String s = document.get(line.getOffset(), found[0]);
                    if ((s = s.trim()).length() != 0) {
                        return false;
                    }
                    hasComment = true;
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            CUIPlugin.log(e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isBlockEmpty(int startLine, int endLine, IDocument document) {
        try {
            int i = startLine;
            while (true) {
                if (i > endLine) {
                    return true;
                }
                IRegion line = document.getLineInformation(i);
                String text = document.get(line.getOffset(), line.getLength());
                if (text.trim().length() != 0) return false;
                boolean bl = true;
                boolean isEmptyLine = bl;
                if (!isEmptyLine) {
                    return false;
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            CUIPlugin.log(e);
            return false;
        }
    }

    public void update() {
        super.update();
        if (!this.canModifyEditor()) {
            this.setEnabled(false);
            return;
        }
        ITextEditor editor = this.getTextEditor();
        if (this.fOperationTarget == null && editor != null) {
            this.fOperationTarget = (ITextOperationTarget)editor.getAdapter(ITextOperationTarget.class);
        }
        boolean isEnabled = this.fOperationTarget != null && this.fOperationTarget.canDoOperation(11) && this.fOperationTarget.canDoOperation(12);
        this.setEnabled(isEnabled);
    }

    public void setEditor(ITextEditor editor) {
        super.setEditor(editor);
        this.fOperationTarget = null;
    }

    public void configure(ISourceViewer sourceViewer, SourceViewerConfiguration configuration) {
        this.fPrefixesMap = null;
        String[] types = configuration.getConfiguredContentTypes(sourceViewer);
        HashMap<String, String[]> prefixesMap = new HashMap<String, String[]>(types.length);
        String[] stringArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            String[] prefixes = configuration.getDefaultPrefixes(sourceViewer, type);
            if (prefixes != null && prefixes.length > 0) {
                int emptyPrefixes = 0;
                String[] stringArray2 = prefixes;
                int n3 = prefixes.length;
                int n4 = 0;
                while (n4 < n3) {
                    String prefixe = stringArray2[n4];
                    if (prefixe.length() == 0) {
                        ++emptyPrefixes;
                    }
                    ++n4;
                }
                if (emptyPrefixes > 0) {
                    String[] nonemptyPrefixes = new String[prefixes.length - emptyPrefixes];
                    int j = 0;
                    int k = 0;
                    while (j < prefixes.length) {
                        String prefix = prefixes[j];
                        if (prefix.length() != 0) {
                            nonemptyPrefixes[k] = prefix;
                            ++k;
                        }
                        ++j;
                    }
                    prefixes = nonemptyPrefixes;
                }
                prefixesMap.put(type, prefixes);
            }
            ++n2;
        }
        this.fDocumentPartitioning = configuration.getConfiguredDocumentPartitioning(sourceViewer);
        this.fPrefixesMap = prefixesMap;
    }
}

