/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICExclusionPatternPathEntry;
import org.eclipse.cdt.core.settings.model.ICMultiItemsHolder;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.internal.ui.newui.Messages;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.cdt.ui.newui.AbstractCPropertyTab;
import org.eclipse.cdt.ui.newui.AbstractPage;
import org.eclipse.cdt.ui.newui.ExPatternDialog;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.NewFolderDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public abstract class CLocationTab
extends AbstractCPropertyTab {
    private final Image IMG_EN = CDTSharedImages.getImage("icons/tobj16/cfolder_obj.png");
    private final Image IMG_FI = CDTSharedImages.getImage("icons/obj16/exclusion_filter_attrib.gif");
    Label label;
    TreeViewer tree;
    ArrayList<_Entry> src;
    ICResourceDescription cfgd;
    ICProject cprj;

    @Override
    public void createControls(Composite parent) {
        super.createControls(parent);
        this.usercomp.setLayout((Layout)new GridLayout(1, false));
        this.label = new Label(this.usercomp, 0);
        this.label.setLayoutData((Object)new GridData(1));
        this.tree = new TreeViewer(this.usercomp);
        this.tree.getTree().setLayoutData((Object)new GridData(1808));
        this.tree.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CLocationTab.this.updateButtons();
            }
        });
        this.initButtons(new String[]{Messages.CLocationTab_4, Messages.CLocationTab_5, Messages.CLocationTab_6, Messages.CLocationTab_7}, 150);
        this.tree.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof _Entry) {
                    return ((_Entry)parentElement).f;
                }
                return null;
            }

            public Object getParent(Object element) {
                if (element instanceof _Filter) {
                    return ((_Filter)element).entry;
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                return element instanceof _Entry;
            }

            public Object[] getElements(Object inputElement) {
                return CLocationTab.this.src.toArray(new _Entry[CLocationTab.this.src.size()]);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tree.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof _Entry) {
                    return CLocationTab.this.IMG_EN;
                }
                if (element instanceof _Filter) {
                    return CLocationTab.this.IMG_FI;
                }
                return null;
            }
        });
    }

    @Override
    protected void updateButtons() {
        TreeItem[] sel = this.tree.getTree().getSelection();
        this.buttonSetEnabled(2, sel.length == 1);
        this.buttonSetEnabled(3, sel.length > 0 && sel[0].getData() instanceof _Entry);
    }

    @Override
    public void buttonPressed(int x) {
        Shell shell = this.usercomp.getShell();
        TreeItem[] sel = this.tree.getTree().getSelection();
        switch (x) {
            case 0: {
                String[] ss = this.getProjectDialog(shell);
                if (ss == null) break;
                String[] stringArray = ss;
                int n = ss.length;
                int n2 = 0;
                while (n2 < n) {
                    String element = stringArray[n2];
                    this.src.add(new _Entry(this.newEntry((IPath)new Path(element), new IPath[0], true)));
                    ++n2;
                }
                this.saveData();
                break;
            }
            case 1: {
                NewFolderDialog d = new NewFolderDialog(shell, (IContainer)this.page.getProject()){

                    public void create() {
                        super.create();
                        this.handleAdvancedButtonSelect();
                    }
                };
                if (d.open() != 0) break;
                IFolder f = (IFolder)d.getFirstResult();
                this.src.add(new _Entry(this.newEntry(f, new IPath[]{}, !f.isLinked())));
                this.saveData();
                break;
            }
            case 2: {
                if (sel.length == 0) {
                    return;
                }
                Object data = sel[0].getData();
                _Entry entry = null;
                if (data instanceof _Entry) {
                    entry = (_Entry)data;
                } else if (data instanceof _Filter) {
                    entry = ((_Filter)data).entry;
                } else {
                    return;
                }
                ExPatternDialog dialog = new ExPatternDialog(this.usercomp.getShell(), entry.ent.getExclusionPatterns(), entry.getPath(), this.page.getProject());
                if (dialog.open() != 0) break;
                IPath[] ps = dialog.getExclusionPattern();
                IPath path = entry.getPath();
                boolean isWsp = entry.ent.isValueWorkspacePath();
                entry.ent = this.newEntry(path, ps, isWsp);
                this.saveData();
                break;
            }
            case 3: {
                if (sel.length == 0) {
                    return;
                }
                TreeItem[] treeItemArray = sel;
                int n = sel.length;
                int n3 = 0;
                while (n3 < n) {
                    TreeItem element = treeItemArray[n3];
                    if (element.getData() instanceof _Entry) {
                        this.src.remove(element.getData());
                    }
                    ++n3;
                }
                this.saveData();
                break;
            }
        }
    }

    private void saveData() {
        ICExclusionPatternPathEntry[] p = new ICExclusionPatternPathEntry[this.src.size()];
        Iterator<_Entry> it = this.src.iterator();
        int i = 0;
        while (it.hasNext()) {
            p[i++] = it.next().ent;
        }
        this.setEntries(this.cfgd, p);
        this.tree.setInput((Object)this.cfgd);
        this.updateData(this.cfgd);
        if (this.page instanceof AbstractPage) {
            ICConfigurationDescription cfgDescription = this.cfgd.getConfiguration();
            ((AbstractPage)this.page).cfgChanged(cfgDescription);
        }
    }

    @Override
    public void updateData(ICResourceDescription _cfgd) {
        if (this.page.isMultiCfg()) {
            this.setAllVisible(false, "");
            return;
        }
        this.cfgd = _cfgd;
        IAdaptable ad = this.page.getElement();
        if (ad instanceof ICProject) {
            this.cprj = (ICProject)ad;
        }
        IResource rc = (IResource)ad;
        this.setAllVisible(true, null);
        this.src = new ArrayList();
        _Entry selectedSourcePath = null;
        ICExclusionPatternPathEntry[] iCExclusionPatternPathEntryArray = this.getEntries(this.cfgd);
        int n = iCExclusionPatternPathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICExclusionPatternPathEntry e = iCExclusionPatternPathEntryArray[n2];
            _Entry entry = new _Entry(e);
            if (entry.ent.isValueWorkspacePath() && entry.ent.getFullPath().equals((Object)rc.getFullPath())) {
                selectedSourcePath = entry;
            }
            this.src.add(entry);
            ++n2;
        }
        this.tree.setInput(this.src);
        if (selectedSourcePath != null) {
            StructuredSelection selection = new StructuredSelection(new Object[]{selectedSourcePath});
            this.tree.setSelection((ISelection)selection);
        }
        this.updateButtons();
    }

    @Override
    public boolean canSupportMultiCfg() {
        return false;
    }

    protected abstract ICExclusionPatternPathEntry[] getEntries(ICResourceDescription var1);

    protected abstract void setEntries(ICResourceDescription var1, ICExclusionPatternPathEntry[] var2);

    protected abstract ICExclusionPatternPathEntry newEntry(IPath var1, IPath[] var2, boolean var3);

    protected abstract ICExclusionPatternPathEntry newEntry(IFolder var1, IPath[] var2, boolean var3);

    @Override
    protected void performApply(ICResourceDescription src, ICResourceDescription dst) {
        this.setEntries(dst, this.getEntries(src));
    }

    @Override
    protected void performDefaults() {
        this.setEntries(this.cfgd, null);
        this.updateData(this.cfgd);
    }

    @Override
    public boolean canBeVisible() {
        if (this.page.getResDesc() instanceof ICMultiItemsHolder) {
            return false;
        }
        return this.page.isForProject() || this.page.isForFolder();
    }

    private String[] getProjectDialog(Shell shell) {
        Object[] resources;
        HashSet<IPath> set = new HashSet<IPath>(this.src.size());
        for (_Entry e : this.src) {
            set.add(e.getPath());
        }
        LocDialog dialog = new LocDialog(shell, set);
        dialog.setInput(this.page.getProject());
        dialog.setTitle(WORKSPACE_DIR_DIALOG_TITLE);
        dialog.setMessage(WORKSPACE_DIR_DIALOG_MSG);
        if (dialog.open() == 0 && (resources = dialog.getResult()) != null) {
            String[] ss = new String[resources.length];
            int i = 0;
            while (i < resources.length) {
                ss[i] = ((Holder)resources[i]).getPath().toString();
                ++i;
            }
            return ss;
        }
        return null;
    }

    class Holder
    implements IAdaptable {
        private IFolder f = null;
        private boolean isRoot = false;
        private IPath p = null;

        Holder(IProject _p) {
            this.f = _p.getFolder(_p.getName());
            this.isRoot = true;
            this.p = _p.getFullPath();
        }

        Holder(IFolder _f) {
            this.f = _f;
            this.isRoot = false;
            this.p = _f.getFullPath();
        }

        public Object getAdapter(Class adapter) {
            return this.f.getAdapter(adapter);
        }

        public boolean isRoot() {
            return this.isRoot;
        }

        public IFolder getFolder() {
            return this.f;
        }

        public IPath getPath() {
            return this.p;
        }

        private CLocationTab getOuterType() {
            return CLocationTab.this;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.p == null ? 0 : this.p.hashCode());
            result = 31 * result + (this.isRoot ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Holder other = (Holder)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.isRoot != other.isRoot) {
                return false;
            }
            return !(this.p == null ? other.p != null : !this.p.equals((Object)other.p));
        }

        public String toString() {
            return "[Holder] " + this.p;
        }
    }

    class LocDialog
    extends ElementTreeSelectionDialog {
        Set<IPath> existing;

        public LocDialog(Shell parent, Set<IPath> ex) {
            super(parent, (ILabelProvider)new WorkbenchLabelProvider(){

                protected String decorateText(String input, Object element) {
                    if (element instanceof Holder && ((Holder)element).isRoot()) {
                        return Messages.CLocationTab_8;
                    }
                    return super.decorateText(input, element);
                }
            }, (ITreeContentProvider)new WorkbenchContentProvider(){

                public Object[] getChildren(Object element) {
                    if (element instanceof IProject) {
                        Object[] ob1 = super.getChildren(element);
                        Object[] ob2 = new Object[ob1.length + 1];
                        int cnt = 0;
                        ob2[cnt++] = new Holder((IProject)element);
                        Object[] objectArray = ob1;
                        int n = ob1.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object ob = objectArray[n2];
                            if (ob instanceof IFolder) {
                                ob2[cnt++] = new Holder((IFolder)ob);
                            }
                            ++n2;
                        }
                        ob1 = new Object[cnt];
                        System.arraycopy(ob2, 0, ob1, 0, cnt);
                        return ob1;
                    }
                    if (element instanceof Holder) {
                        Holder h = (Holder)element;
                        if (h.isRoot()) {
                            return new Object[0];
                        }
                        Object[] ob1 = super.getChildren((Object)h.getFolder());
                        Object[] ob2 = new Object[ob1.length];
                        int cnt = 0;
                        Object[] objectArray = ob1;
                        int n = ob1.length;
                        int n3 = 0;
                        while (n3 < n) {
                            Object ob = objectArray[n3];
                            if (ob instanceof IFolder) {
                                ob2[cnt++] = new Holder((IFolder)ob);
                            }
                            ++n3;
                        }
                        ob1 = new Object[cnt];
                        System.arraycopy(ob2, 0, ob1, 0, cnt);
                        return ob1;
                    }
                    return super.getChildren(element);
                }
            });
            this.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    if (!(element instanceof Holder)) {
                        return false;
                    }
                    if (LocDialog.this.existing == null || LocDialog.this.existing.size() == 0) {
                        return true;
                    }
                    Holder h = (Holder)element;
                    return !LocDialog.this.existing.contains(h.getPath());
                }
            });
            this.existing = ex;
        }

        protected TreeViewer createTreeViewer(Composite parent) {
            TreeViewer treeViewer = super.createTreeViewer(parent);
            if (CLocationTab.this.page.getElement() instanceof IFolder) {
                IFolder folder = (IFolder)CLocationTab.this.page.getElement();
                ArrayList<Holder> list = new ArrayList<Holder>();
                list.add(new Holder(folder));
                IContainer parentFolder = folder.getParent();
                while (parentFolder instanceof IFolder) {
                    list.add(0, new Holder((IFolder)parentFolder));
                    parentFolder = parentFolder.getParent();
                }
                treeViewer.expandToLevel((Object)new TreePath(list.toArray()), 0);
                this.setInitialSelection(new Holder(folder));
            }
            return treeViewer;
        }
    }

    class _Entry {
        ICExclusionPatternPathEntry ent;
        _Filter[] f = new _Filter[1];

        _Entry(ICExclusionPatternPathEntry _ent) {
            this.ent = _ent;
            this.f[0] = new _Filter(this);
        }

        public String toString() {
            return this.getPath() == null ? "" : this.getPath().toString();
        }

        public IPath getPath() {
            return this.ent.isValueWorkspacePath() ? this.ent.getFullPath() : this.ent.getLocation();
        }
    }

    class _Filter {
        _Entry entry;

        _Filter(_Entry _entry) {
            this.entry = _entry;
        }

        public IPath[] getExtPaths() {
            IPath[] p = null;
            p = this.entry.ent.getExclusionPatterns();
            return p;
        }

        public String[] getExts() {
            IPath[] p = this.getExtPaths();
            if (p == null || p.length == 0) {
                return new String[0];
            }
            String[] s = new String[p.length];
            int i = 0;
            while (i < p.length) {
                s[i] = p[i].toOSString();
                ++i;
            }
            return s;
        }

        public String toString() {
            String[] s = this.getExts();
            if (s.length == 0) {
                return Messages.CLocationTab_0;
            }
            String x = Messages.CLocationTab_1;
            String[] stringArray = s;
            int n = s.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                x = String.valueOf(x) + element + Messages.CLocationTab_2;
                ++n2;
            }
            x = String.valueOf(x.substring(0, x.length() - 2)) + Messages.CLocationTab_3;
            return x;
        }
    }
}

