/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.templateengine.processes;

import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvidersKeeper;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsManager;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class AddLanguageSettingsProvider
extends ProcessRunner {
    private static final String PROJECTNAME_VARNAME = "projectName";
    private static final String PROVIDERS_VARNAME = "languageSettingsProviderIds";

    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        ICConfigurationDescription[] configDescs;
        IProject project = null;
        String[] extraProviderIds = null;
        ProcessArgument[] processArgumentArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessArgument arg = processArgumentArray[n2];
            String argName = arg.getName();
            if (PROJECTNAME_VARNAME.equals(argName)) {
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(arg.getSimpleValue());
            } else if (PROVIDERS_VARNAME.equals(argName)) {
                extraProviderIds = arg.getSimpleArrayValue();
            }
            ++n2;
        }
        if (project == null) {
            throw this.missingArgException(processId, PROJECTNAME_VARNAME);
        }
        if (extraProviderIds == null) {
            throw this.missingArgException(processId, PROVIDERS_VARNAME);
        }
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription des = mngr.getProjectDescription(project, true);
        ICConfigurationDescription[] iCConfigurationDescriptionArray = configDescs = des.getConfigurations();
        int n3 = configDescs.length;
        int n4 = 0;
        while (n4 < n3) {
            ICConfigurationDescription configDesc = iCConfigurationDescriptionArray[n4];
            if (configDesc instanceof ILanguageSettingsProvidersKeeper) {
                IConfiguration config = ManagedBuildManager.getConfigurationForDescription(configDesc);
                String[] ids = config.getDefaultLanguageSettingsProviderIds();
                String[] newIds = new String[ids.length + extraProviderIds.length];
                System.arraycopy(ids, 0, newIds, 0, ids.length);
                System.arraycopy(extraProviderIds, 0, newIds, ids.length, extraProviderIds.length);
                ILanguageSettingsProvidersKeeper keeper = (ILanguageSettingsProvidersKeeper)configDesc;
                keeper.setLanguageSettingProviders(LanguageSettingsManager.createLanguageSettingsProviders((String[])newIds));
            }
            ++n4;
        }
        try {
            mngr.setProjectDescription(project, des);
        }
        catch (CoreException e) {
            ManagedBuilderCorePlugin.log(e);
        }
    }
}

