/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.launch.ui;

import java.io.File;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.internal.ui.MIUIMessages;
import org.eclipse.cdt.debug.mi.internal.ui.StandardGDBDebuggerPage;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TizenDebuggerPage
extends StandardGDBDebuggerPage {
    private final Logger logger = LoggerFactory.getLogger(TizenDebuggerPage.class);
    protected Text GDBServerPort;

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        String attribute = "";
        try {
            attribute = configuration.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_COMMAND_FACTORY, "");
        }
        catch (CoreException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        super.setDefaults(configuration);
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_COMMAND_FACTORY, attribute);
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.PORT", "26102");
    }

    public void createTabs(TabFolder tabFolder) {
        super.createTabs(tabFolder);
        this.createGDBServerOptionTab(tabFolder);
    }

    private void createGDBServerOptionTab(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("Gdbserver Settings");
        Composite comp = new Composite((Composite)tabFolder, 0);
        comp.setLayout((Layout)new GridLayout(1, true));
        comp.setLayoutData((Object)new GridData(1808));
        ((GridLayout)comp.getLayout()).makeColumnsEqualWidth = false;
        comp.setFont(tabFolder.getFont());
        tabItem.setControl((Control)comp);
        Composite subComp = new Composite(comp, 0);
        subComp.setLayout((Layout)new GridLayout(2, true));
        subComp.setLayoutData((Object)new GridData(1808));
        ((GridLayout)subComp.getLayout()).makeColumnsEqualWidth = false;
        subComp.setFont(tabFolder.getFont());
        Label portLabel = new Label(subComp, 16384);
        portLabel.setText("Port Number:");
        GridData gd = new GridData();
        portLabel.setLayoutData((Object)gd);
        this.GDBServerPort = new Text(subComp, 2052);
        this.GDBServerPort.setTextLimit(5);
        GridData data = new GridData();
        this.GDBServerPort.setLayoutData((Object)data);
        this.GDBServerPort.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String string = e.text;
                char[] chars = new char[string.length()];
                string.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if ('0' > chars[i] || chars[i] > '9') {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        });
        this.GDBServerPort.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TizenDebuggerPage.this.updateLaunchConfigurationDialog();
            }
        });
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        String gdbserverPortNumber = null;
        try {
            gdbserverPortNumber = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.PORT", "26102");
        }
        catch (CoreException e) {
            this.logger.error("Unknown error occurred", (Throwable)e);
        }
        this.GDBServerPort.setText(gdbserverPortNumber);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        String gdbserverPortNumber = this.GDBServerPort.getText();
        gdbserverPortNumber = gdbserverPortNumber.trim();
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.PORT", gdbserverPortNumber);
    }

    public void createMainTab(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(MIUIMessages.getString((String)"StandardGDBDebuggerPage.2"));
        Composite comp = ControlFactory.createCompositeEx((Composite)tabFolder, (int)1, (int)1808);
        ((GridLayout)comp.getLayout()).makeColumnsEqualWidth = false;
        comp.setFont(tabFolder.getFont());
        tabItem.setControl((Control)comp);
        Composite subComp = ControlFactory.createCompositeEx((Composite)comp, (int)3, (int)768);
        ((GridLayout)subComp.getLayout()).makeColumnsEqualWidth = false;
        subComp.setFont(tabFolder.getFont());
        Label label = ControlFactory.createLabel((Composite)subComp, (String)MIUIMessages.getString((String)"StandardGDBDebuggerPage.3"));
        label.setVisible(false);
        GridData gd = new GridData();
        gd.heightHint = 0;
        gd.widthHint = 0;
        label.setLayoutData((Object)gd);
        this.fGDBCommandText = ControlFactory.createTextField((Composite)subComp, (int)2052);
        this.fGDBCommandText.setVisible(false);
        this.fGDBCommandText.setLayoutData((Object)gd);
        Button button = this.createPushButton(subComp, MIUIMessages.getString((String)"StandardGDBDebuggerPage.4"), null);
        button.setVisible(false);
        button.setLayoutData((Object)gd);
        label = ControlFactory.createLabel((Composite)subComp, (String)MIUIMessages.getString((String)"StandardGDBDebuggerPage.6"));
        gd = new GridData();
        label.setLayoutData((Object)gd);
        this.fGDBInitText = ControlFactory.createTextField((Composite)subComp, (int)2052);
        gd = new GridData(768);
        this.fGDBInitText.setLayoutData((Object)gd);
        this.fGDBInitText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                if (!TizenDebuggerPage.this.isInitializing()) {
                    TizenDebuggerPage.this.updateLaunchConfigurationDialog();
                }
            }
        });
        button = this.createPushButton(subComp, MIUIMessages.getString((String)"StandardGDBDebuggerPage.7"), null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                this.handleGDBInitButtonSelected();
                TizenDebuggerPage.this.updateLaunchConfigurationDialog();
            }

            private void handleGDBInitButtonSelected() {
                String res;
                FileDialog dialog = new FileDialog(TizenDebuggerPage.this.getShell(), 0);
                dialog.setText(MIUIMessages.getString((String)"StandardGDBDebuggerPage.8"));
                String gdbCommand = TizenDebuggerPage.this.fGDBInitText.getText().trim();
                int lastSeparatorIndex = gdbCommand.lastIndexOf(File.separator);
                if (lastSeparatorIndex != -1) {
                    dialog.setFilterPath(gdbCommand.substring(0, lastSeparatorIndex));
                }
                if ((res = dialog.open()) == null) {
                    return;
                }
                TizenDebuggerPage.this.fGDBInitText.setText(res);
            }
        });
        label = ControlFactory.createLabel((Composite)subComp, (String)MIUIMessages.getString((String)"StandardGDBDebuggerPage.9"), (int)200, (int)-1, (int)64);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.widthHint = 200;
        label.setLayoutData((Object)gd);
        Composite options = ControlFactory.createCompositeEx((Composite)subComp, (int)2, (int)768);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        options.setLayoutData((Object)gd);
        this.createCommandFactoryCombo(options);
        this.createProtocolCombo(options);
        this.createVerboseModeButton(subComp);
        this.createBreakpointFullPathName(subComp);
        GridData gd1 = new GridData();
        gd1.horizontalSpan = 3;
        this.fVerboseModeButton.setLayoutData((Object)gd1);
        GridData gd2 = new GridData();
        gd2.horizontalSpan = 3;
        this.fBreakpointsFullPath.setLayoutData((Object)gd2);
    }
}

