/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class LocalProjectScope
implements IScopeContext {
    private static final String QUALIFIER_EXT = ".prj-";
    public static final String SCOPE = "project-local";
    private String fContext;

    public LocalProjectScope(IProject context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        this.fContext = context.getName();
    }

    public LocalProjectScope(String projectName) {
        if (projectName == null) {
            throw new IllegalArgumentException();
        }
        this.fContext = projectName;
    }

    public IPath getLocation() {
        return null;
    }

    public String getName() {
        return SCOPE;
    }

    public IEclipsePreferences getNode(String qualifier) {
        return InstanceScope.INSTANCE.getNode(String.valueOf(qualifier) + QUALIFIER_EXT + this.fContext);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof LocalProjectScope)) {
            return false;
        }
        LocalProjectScope other = (LocalProjectScope)obj;
        return this.fContext.equals(other.fContext);
    }

    public int hashCode() {
        return this.fContext.hashCode();
    }

    private static Preferences getPPP(String name) {
        return new LocalProjectScope(name).getNode("org.eclipse.cdt.core");
    }

    public static void deletePreferences(IPath prjToDelete, IPath movedTo) {
        try {
            Preferences prefs = LocalProjectScope.getPPP(prjToDelete.lastSegment());
            if (movedTo != null) {
                Preferences target = LocalProjectScope.getPPP(movedTo.lastSegment());
                LocalProjectScope.copyPrefs(prefs, target);
            }
            LocalProjectScope.deletePrefs(prefs);
        }
        catch (BackingStoreException backingStoreException) {}
    }

    private static void deletePrefs(Preferences prefs) throws BackingStoreException {
        String[] children;
        prefs.clear();
        String[] stringArray = children = prefs.childrenNames();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            String child = stringArray[n2];
            prefs.node(child).removeNode();
            ++n2;
        }
        prefs.flush();
        prefs.removeNode();
    }

    private static void copyPrefs(Preferences prefs, Preferences target) throws BackingStoreException {
        String[] children;
        String[] keys;
        String[] stringArray = keys = prefs.keys();
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            String val = prefs.get(key, null);
            if (val != null) {
                target.put(key, val);
            }
            ++n2;
        }
        String[] stringArray2 = children = prefs.childrenNames();
        int n3 = children.length;
        n = 0;
        while (n < n3) {
            String child = stringArray2[n];
            LocalProjectScope.copyPrefs(prefs.node(child), target.node(child));
            ++n;
        }
        target.flush();
    }
}

