/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.ext.manifest;

import java.util.ArrayList;
import java.util.List;
import org.tizen.nativecore.ext.manifest.CustomAttribute;
import org.tizen.nativecore.ext.manifest.CustomElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class TrustAnchor {
    public static final String ELEMENT = "trust-anchor";
    private String use_system_certs;
    private List<CustomAttribute> customAttrList = new ArrayList<CustomAttribute>();
    private List<CustomElement> customElementList = new ArrayList<CustomElement>();

    public String getUse_system_certs() {
        return this.use_system_certs;
    }

    public void setUse_system_certs(String use_system_certs) {
        this.use_system_certs = use_system_certs;
    }

    public void loadElement(Element element) {
        if (!element.getNodeName().equals(ELEMENT)) {
            return;
        }
        this.setUse_system_certs(element.getAttribute("use_system_certs"));
        NamedNodeMap attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Node node = attrs.item(i);
            String attr = node.getNodeName();
            if (this.isCustomAttribute(attr)) {
                CustomAttribute custom = new CustomAttribute();
                custom.loadAttribute(attr, node.getNodeValue());
                this.getCustomAttrList().add(custom);
            }
            ++i;
        }
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                CustomElement custom = new CustomElement();
                custom.loadElement((Element)node);
                this.getCustomElementList().add(custom);
            }
            node = node.getNextSibling();
        }
    }

    public void generateElement(Document dom, Element parent) {
        Element element = dom.createElement(ELEMENT);
        if (this.use_system_certs != null && this.use_system_certs.length() > 0) {
            element.setAttribute("use_system_certs", this.use_system_certs);
        }
        for (CustomAttribute customAttribute : this.getCustomAttrList()) {
            customAttribute.generateAttribute(element);
        }
        for (CustomElement customElement : this.getCustomElementList()) {
            customElement.generateElement(dom, element);
        }
        parent.appendChild(element);
    }

    private boolean isCustomAttribute(String attr) {
        return !attr.equals("use_system_certs");
    }

    public List<CustomElement> getCustomElementList() {
        return this.customElementList;
    }

    public List<CustomAttribute> getCustomAttrList() {
        return this.customAttrList;
    }
}

