/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.c;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.internal.core.dom.ast.tag.TagManager;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.c.CArrayType;
import org.eclipse.cdt.internal.core.dom.parser.c.CBasicType;
import org.eclipse.cdt.internal.core.dom.parser.c.CFunctionType;
import org.eclipse.cdt.internal.core.dom.parser.c.CPointerType;
import org.eclipse.cdt.internal.core.dom.parser.c.CQualifierType;
import org.eclipse.cdt.internal.core.index.IIndexCBindingConstants;
import org.eclipse.cdt.internal.core.index.composite.CompositeIndexBinding;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeComparator;
import org.eclipse.cdt.internal.core.pdom.dom.FindBinding;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMMemberOwner;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMASTAdapter;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMGlobalScope;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCEnumeration;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCEnumerator;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCField;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCFunction;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCGlobalScope;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCStructure;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCTypedef;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCVariable;
import org.eclipse.core.runtime.CoreException;

class PDOMCLinkage
extends PDOMLinkage
implements IIndexCBindingConstants {
    public PDOMCLinkage(PDOM pdom, long record) {
        super(pdom, record);
    }

    public PDOMCLinkage(PDOM pdom) throws CoreException {
        super(pdom, "C", "C".toCharArray());
    }

    @Override
    public int getNodeType() {
        return 0;
    }

    @Override
    public String getLinkageName() {
        return "C";
    }

    @Override
    public int getLinkageID() {
        return 2;
    }

    private PDOMBinding addBinding(IBinding inputBinding, IASTName fromName) throws CoreException {
        if (this.cannotAdapt(inputBinding)) {
            return null;
        }
        PDOMBinding pdomBinding = this.attemptFastAdaptBinding(inputBinding);
        if (pdomBinding == null) {
            IBinding binding = PDOMASTAdapter.getAdapterForAnonymousASTBinding(inputBinding);
            if (binding == null) {
                return null;
            }
            PDOMNode parent = this.getAdaptedParent(binding);
            if (parent == null) {
                return null;
            }
            long[] localToFileHolder = new long[1];
            pdomBinding = this.adaptBinding(parent, binding, localToFileHolder);
            if (pdomBinding == null) {
                pdomBinding = this.createBinding(parent, binding, localToFileHolder[0]);
                if (pdomBinding != null) {
                    this.getPDOM().putCachedResult(inputBinding, pdomBinding);
                }
                TagManager.getInstance().syncTags(pdomBinding, inputBinding);
                return pdomBinding;
            }
            this.getPDOM().putCachedResult(inputBinding, pdomBinding);
        }
        if (this.shouldUpdate(pdomBinding, fromName)) {
            IBinding fromBinding = fromName.getBinding();
            pdomBinding.update(this, fromBinding);
            TagManager.getInstance().syncTags(pdomBinding, fromBinding);
        }
        return pdomBinding;
    }

    private PDOMBinding createBinding(PDOMNode parent, IBinding binding, long localToFile) throws CoreException {
        PDOMBinding pdomBinding = null;
        PDOMNode insertIntoIndex = null;
        if (binding instanceof IField) {
            if (parent instanceof IPDOMMemberOwner) {
                pdomBinding = new PDOMCField((PDOMLinkage)this, (IPDOMMemberOwner)((Object)parent), (IField)binding);
                if (parent instanceof ICompositeType && ((ICompositeType)((Object)parent)).isAnonymous() && (insertIntoIndex = parent.getParentNode()) == null) {
                    insertIntoIndex = this;
                }
            }
        } else if (binding instanceof IVariable) {
            IVariable var = (IVariable)binding;
            pdomBinding = new PDOMCVariable((PDOMLinkage)this, parent, var);
        } else if (binding instanceof IFunction) {
            IFunction func = (IFunction)binding;
            pdomBinding = new PDOMCFunction((PDOMLinkage)this, parent, func);
        } else if (binding instanceof ICompositeType) {
            pdomBinding = new PDOMCStructure((PDOMLinkage)this, parent, (ICompositeType)binding);
        } else if (binding instanceof IEnumeration) {
            pdomBinding = new PDOMCEnumeration((PDOMLinkage)this, parent, (IEnumeration)binding);
        } else if (binding instanceof IEnumerator) {
            assert (parent instanceof IEnumeration);
            pdomBinding = new PDOMCEnumerator((PDOMLinkage)this, parent, (IEnumerator)binding);
            insertIntoIndex = parent.getParentNode();
            if (insertIntoIndex == null) {
                insertIntoIndex = this;
            }
        } else if (binding instanceof ITypedef) {
            pdomBinding = new PDOMCTypedef((PDOMLinkage)this, parent, (ITypedef)binding);
        }
        if (pdomBinding != null) {
            pdomBinding.setLocalToFileRec(localToFile);
            parent.addChild(pdomBinding);
            if (insertIntoIndex != null) {
                insertIntoIndex.addChild(pdomBinding);
            }
            if (parent != this && insertIntoIndex != this) {
                this.insertIntoNestedBindingsIndex(pdomBinding);
            }
        }
        return pdomBinding;
    }

    private boolean shouldUpdate(PDOMBinding pdomBinding, IASTName fromName) throws CoreException {
        if (fromName != null) {
            if (fromName.isDefinition()) {
                return true;
            }
            if (fromName.isReference()) {
                return false;
            }
            return !pdomBinding.hasDefinition();
        }
        return false;
    }

    @Override
    public PDOMBinding addBinding(IASTName name) throws CoreException {
        if (name == null) {
            return null;
        }
        char[] namechars = name.getSimpleID();
        if (namechars == null) {
            return null;
        }
        IBinding binding = name.resolveBinding();
        return this.addBinding(binding, name);
    }

    @Override
    public int getBindingType(IBinding binding) {
        if (binding instanceof IField) {
            return 9;
        }
        if (binding instanceof IVariable) {
            return 6;
        }
        if (binding instanceof IFunction) {
            return 7;
        }
        if (binding instanceof ICompositeType) {
            return 8;
        }
        if (binding instanceof IEnumeration) {
            return 10;
        }
        if (binding instanceof IEnumerator) {
            return 3;
        }
        if (binding instanceof ITypedef) {
            return 12;
        }
        return 0;
    }

    private final PDOMNode getAdaptedParent(IBinding binding) throws CoreException {
        IIndexBinding ib;
        if (binding instanceof IIndexBinding && (ib = (IIndexBinding)binding).isFileLocal()) {
            return null;
        }
        IBinding owner = binding.getOwner();
        if (owner == null) {
            return this;
        }
        if (owner instanceof IFunction) {
            return null;
        }
        return this.adaptBinding(owner);
    }

    @Override
    public final PDOMBinding adaptBinding(IBinding inputBinding, boolean includeLocal) throws CoreException {
        return this.adaptBinding(null, inputBinding, (long[])(includeLocal ? FILE_LOCAL_REC_DUMMY : null));
    }

    private final PDOMBinding adaptBinding(PDOMNode parent, IBinding inputBinding, long[] localToFileHolder) throws CoreException {
        if (inputBinding instanceof CompositeIndexBinding) {
            inputBinding = ((CompositeIndexBinding)inputBinding).getRawBinding();
        }
        if (this.cannotAdapt(inputBinding)) {
            return null;
        }
        PDOMBinding result = this.attemptFastAdaptBinding(inputBinding);
        if (result != null) {
            return result;
        }
        IBinding binding = PDOMASTAdapter.getAdapterForAnonymousASTBinding(inputBinding);
        if (binding == null) {
            return null;
        }
        result = this.doAdaptBinding(parent, binding, localToFileHolder);
        if (result != null) {
            this.getPDOM().putCachedResult(inputBinding, result);
        }
        return result;
    }

    private final PDOMBinding doAdaptBinding(PDOMNode parent, IBinding binding, long[] localToFileHolder) throws CoreException {
        if (parent == null) {
            parent = this.getAdaptedParent(binding);
        }
        if (parent == this) {
            int[] bindingTypes = new int[]{this.getBindingType(binding)};
            char[] nameChars = binding.getNameCharArray();
            PDOMBinding nonLocal = FindBinding.findBinding(this.getIndex(), (PDOMLinkage)this, nameChars, bindingTypes, 0L);
            if (localToFileHolder == null) {
                return nonLocal;
            }
            long localToFileRec = this.getLocalToFileRec(parent, binding, nonLocal);
            if (localToFileRec == 0L) {
                return nonLocal;
            }
            localToFileHolder[0] = localToFileRec;
            return FindBinding.findBinding(this.getIndex(), (PDOMLinkage)this, nameChars, bindingTypes, localToFileRec);
        }
        if (parent instanceof IPDOMMemberOwner) {
            int[] bindingTypes = new int[]{this.getBindingType(binding)};
            char[] nameChars = binding.getNameCharArray();
            PDOMBinding nonLocal = FindBinding.findBinding(parent, (PDOMLinkage)this, nameChars, bindingTypes, 0L);
            if (localToFileHolder == null) {
                return nonLocal;
            }
            long localToFileRec = this.getLocalToFileRec(parent, binding, nonLocal);
            if (localToFileRec == 0L) {
                return nonLocal;
            }
            localToFileHolder[0] = localToFileRec;
            return FindBinding.findBinding(parent, (PDOMLinkage)this, nameChars, bindingTypes, localToFileRec);
        }
        return null;
    }

    @Override
    public PDOMNode getNode(long record, int nodeType) throws CoreException {
        switch (nodeType) {
            case 6: {
                return new PDOMCVariable((PDOMLinkage)this, record);
            }
            case 7: {
                return new PDOMCFunction((PDOMLinkage)this, record);
            }
            case 8: {
                return new PDOMCStructure((PDOMLinkage)this, record);
            }
            case 9: {
                return new PDOMCField((PDOMLinkage)this, record);
            }
            case 10: {
                return new PDOMCEnumeration((PDOMLinkage)this, record);
            }
            case 3: {
                return new PDOMCEnumerator((PDOMLinkage)this, record);
            }
            case 12: {
                return new PDOMCTypedef((PDOMLinkage)this, record);
            }
        }
        assert (false);
        return null;
    }

    @Override
    public IBTreeComparator getIndexComparator() {
        return new FindBinding.DefaultBindingBTreeComparator(this);
    }

    @Override
    public PDOMGlobalScope getGlobalScope() {
        return PDOMCGlobalScope.INSTANCE;
    }

    @Override
    public PDOMBinding addTypeBinding(IBinding type) throws CoreException {
        return this.addBinding(type, null);
    }

    @Override
    public IBinding unmarshalBinding(ITypeMarshalBuffer buffer) throws CoreException {
        throw new CoreException(CCorePlugin.createStatus("Cannot unmarshal a binding, first byte=" + buffer.getByte()));
    }

    @Override
    public IType unmarshalType(ITypeMarshalBuffer buffer) throws CoreException {
        short firstBytes = buffer.getShort();
        switch (firstBytes & 0x1F) {
            case 3: {
                return CArrayType.unmarshal(firstBytes, buffer);
            }
            case 1: {
                return CBasicType.unmarshal(firstBytes, buffer);
            }
            case 4: {
                return CQualifierType.unmarshal(firstBytes, buffer);
            }
            case 5: {
                return CFunctionType.unmarshal(firstBytes, buffer);
            }
            case 2: {
                return CPointerType.unmarshal(firstBytes, buffer);
            }
            case 9: {
                return ProblemType.unmarshal(firstBytes, buffer);
            }
        }
        throw new CoreException(CCorePlugin.createStatus("Cannot unmarshal a type, first bytes=" + firstBytes));
    }

    @Override
    public ISerializableEvaluation unmarshalEvaluation(ITypeMarshalBuffer buffer) throws CoreException {
        throw new CoreException(CCorePlugin.createStatus("Cannot unmarshal an evaluation, first byte=" + buffer.getByte()));
    }
}

