/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.build;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.cdtvariables.ICdtVariableManager;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsEditableProvider;
import org.eclipse.cdt.core.language.settings.providers.IWorkingDirectoryTracker;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.language.settings.providers.AbstractLanguageSettingsOutputScanner;
import org.eclipse.cdt.managedbuilder.language.settings.providers.ToolchainBuiltinSpecsDetector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.StringUtil;
import org.tizen.nativecore.build.NativeCoreConfigurationManager;
import org.tizen.sbilib.ide.PluginManager;
import org.tizen.sbilib.ide.RootstrapException;
import org.tizen.sbilib.ide.Toolchain;
import org.tizen.sbilib.ide.ToolchainNotFoundException;

public class TizenBuiltinSpecsDetector
extends ToolchainBuiltinSpecsDetector
implements ILanguageSettingsEditableProvider {
    private static final String GCC_TOOLCHAIN_ID = "org.tizen.nativecore.toolchain.sbi.gnu";
    private static final String EMPTY_STRING = "";
    private static final String MACRO_SYSROOT = "${SBI_SYSROOT}";
    private static final String MACRO_MISC = "${MISC}";
    private static final String MACRO_TARGET = "${TARGET}";
    private static Logger logger = LoggerFactory.getLogger(TizenBuiltinSpecsDetector.class);
    private State state = State.NONE;
    private static final AbstractLanguageSettingsOutputScanner.AbstractOptionParser[] optionParsers = new AbstractLanguageSettingsOutputScanner.AbstractOptionParser[]{new AbstractLanguageSettingsOutputScanner.IncludePathOptionParser("#include \"(\\S.*)\"", "$1", 7), new AbstractLanguageSettingsOutputScanner.IncludePathOptionParser("#include <(\\S.*)>", "$1", 3), new AbstractLanguageSettingsOutputScanner.IncludePathOptionParser("#framework <(\\S.*)>", "$1", 67), new AbstractLanguageSettingsOutputScanner.MacroOptionParser("#define\\s+(\\S*\\(.*?\\))\\s*(.*)", "$1", "$2", 3), new AbstractLanguageSettingsOutputScanner.MacroOptionParser("#define\\s+(\\S*)\\s*(.*)", "$1", "$2", 3)};

    protected AbstractLanguageSettingsOutputScanner.AbstractOptionParser[] getOptionParsers() {
        return optionParsers;
    }

    private List<String> makeList(String line) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(line);
        return list;
    }

    protected List<String> parseOptions(String line) {
        if ((line = line.trim()).startsWith("#define")) {
            return this.makeList(line);
        }
        if (line.equals("#include \"...\" search starts here:")) {
            this.state = State.EXPECTING_LOCAL_INCLUDE;
        } else if (line.equals("#include <...> search starts here:")) {
            this.state = State.EXPECTING_SYSTEM_INCLUDE;
        } else if (line.startsWith("End of search list.")) {
            this.state = State.NONE;
        } else if (line.equals("Framework search starts here:")) {
            this.state = State.EXPECTING_FRAMEWORKS;
        } else if (line.startsWith("End of framework search list.")) {
            this.state = State.NONE;
        } else {
            if (this.state == State.EXPECTING_LOCAL_INCLUDE) {
                line = "#include \"" + line + "\"";
                return this.makeList(line);
            }
            String frameworkIndicator = "(framework directory)";
            if (this.state == State.EXPECTING_SYSTEM_INCLUDE) {
                line = line.contains(frameworkIndicator) ? "#framework <" + line.replace(frameworkIndicator, EMPTY_STRING).trim() + ">" : "#include <" + line + ">";
                return this.makeList(line);
            }
            if (this.state == State.EXPECTING_FRAMEWORKS) {
                line = "#framework <" + line.replace(frameworkIndicator, EMPTY_STRING).trim() + ">";
                return this.makeList(line);
            }
        }
        return null;
    }

    protected String resolveCommand(String languageId) throws CoreException {
        String cmd = this.getCommand();
        if (cmd != null) {
            String specFileExt;
            String specFileName;
            String flags;
            String compiler;
            if (cmd.contains("${COMMAND}") && (compiler = this.getCompilerCommand(languageId)) != null) {
                cmd = cmd.replace("${COMMAND}", compiler);
            }
            if (cmd.contains("${FLAGS}") && (flags = this.getToolOptions(languageId)) != null) {
                cmd = cmd.replace("${FLAGS}", flags);
            }
            if (cmd.contains("${INPUTS}") && (specFileName = this.getSpecFile(languageId)) != null) {
                cmd = cmd.replace("${INPUTS}", specFileName);
            }
            if (cmd.contains("${EXT}") && (specFileExt = this.getSpecFileExtension(languageId)) != null) {
                cmd = cmd.replace("${EXT}", specFileExt);
            }
            if (cmd.contains(MACRO_SYSROOT)) {
                String rootstrapPath = this.resolveSysrootMacro();
                cmd = cmd.replace(MACRO_SYSROOT, new Path(rootstrapPath).toPortableString());
            }
            if (cmd.contains(MACRO_MISC)) {
                String miscOp = this.resolveMiscMacro();
                cmd = cmd.replace(MACRO_MISC, miscOp);
            }
            if (cmd.contains(MACRO_TARGET)) {
                String targetOp = this.resolveTargetMacro();
                cmd = cmd.replace(MACRO_TARGET, targetOp);
            }
            if (cmd.contains("${")) {
                try {
                    ICdtVariableManager varManager = CCorePlugin.getDefault().getCdtVariableManager();
                    cmd = varManager.resolveValue(cmd, EMPTY_STRING, null, this.currentCfgDescription);
                }
                catch (Exception e) {
                    ManagedBuilderCorePlugin.log((Throwable)e);
                }
            }
        }
        return cmd;
    }

    private String resolveSysrootMacro() {
        PluginManager pluginMgr = PluginManager.getInstance();
        String rootstrapPath = EMPTY_STRING;
        if (this.useGlobalProvider()) {
            Toolchain tc = NativeCoreConfigurationManager.getLatestX86LLVM();
            if (tc == null) {
                return EMPTY_STRING;
            }
            String rootstrapId = NativeCoreConfigurationManager.getLatestRootstrapId((String)tc.getId());
            if (!StringUtil.isEmpty((CharSequence)rootstrapId)) {
                rootstrapPath = pluginMgr.getRootstrap(rootstrapId).getPath();
            }
        } else {
            IProject project = this.currentCfgDescription.getProjectDescription().getProject();
            String targetId = NativeCoreConfigurationManager.getTargetIdFromProject(project);
            if (!StringUtil.isEmpty((CharSequence)targetId)) {
                rootstrapPath = pluginMgr.getRootstrapByTargetId(targetId).getPath();
            }
        }
        return rootstrapPath.trim();
    }

    private String resolveMiscMacro() {
        String targetId;
        String miscOption;
        PluginManager pluginMgr;
        block17: {
            Toolchain tc;
            block16: {
                block13: {
                    String rootstrapId;
                    String toolchainId;
                    block15: {
                        block14: {
                            pluginMgr = PluginManager.getInstance();
                            miscOption = EMPTY_STRING;
                            targetId = EMPTY_STRING;
                            tc = null;
                            if (!this.useGlobalProvider()) break block13;
                            tc = NativeCoreConfigurationManager.getLatestX86LLVM();
                            if (tc != null) break block14;
                            return EMPTY_STRING;
                        }
                        toolchainId = tc.getId();
                        rootstrapId = NativeCoreConfigurationManager.getLatestRootstrapId((String)toolchainId);
                        if (!StringUtil.isEmpty((CharSequence)rootstrapId)) break block15;
                        return EMPTY_STRING;
                    }
                    targetId = pluginMgr.makeTargetId(rootstrapId, toolchainId);
                    if (pluginMgr.getTarget(targetId) == null && !pluginMgr.createTarget(rootstrapId, toolchainId)) {
                        logger.error("Failed to create target: " + targetId);
                        return EMPTY_STRING;
                    }
                    break block16;
                }
                targetId = NativeCoreConfigurationManager.getTargetIdFromProject(this.currentCfgDescription.getProjectDescription().getProject());
                tc = pluginMgr.getToolchainByTargetId(targetId);
                if (tc != null) break block16;
                return EMPTY_STRING;
            }
            miscOption = tc.getCompilerMiscellaneousOption();
            if (!StringUtil.isEmpty((CharSequence)miscOption)) break block17;
            return EMPTY_STRING;
        }
        try {
            HashMap<String, String> macros = new HashMap<String, String>();
            Toolchain defaultGccToolchain = pluginMgr.getDefaultGCCToolchain(targetId);
            if (defaultGccToolchain != null) {
                String defaultToolchainPrefix;
                String defaultGccPath = defaultGccToolchain.getToolchainPath();
                if (defaultGccPath != null && !defaultGccPath.isEmpty()) {
                    macros.put("PLATFORM_DEFAULT_GCC_PATH", defaultGccPath);
                }
                if ((defaultToolchainPrefix = defaultGccToolchain.getPropertyValue("TOOLCHAIN_PREFIX")) != null && !defaultToolchainPrefix.isEmpty()) {
                    macros.put("PLATFORM_DEFAULT_GCC_PREFIX", defaultToolchainPrefix);
                }
            }
        }
        catch (IOException e) {
            logger.error("The default gcc path is not available", (Throwable)e);
            return EMPTY_STRING;
        }
        catch (RootstrapException e) {
            logger.error("Failed to get default toolchain from rootstrap", (Throwable)e);
            return EMPTY_STRING;
        }
        catch (ToolchainNotFoundException e) {
            logger.error("Failed to get toolchain", (Throwable)e);
            return EMPTY_STRING;
        }
        return miscOption.trim();
    }

    private String resolveTargetMacro() {
        String targetOption = EMPTY_STRING;
        if (!this.useGlobalProvider()) {
            String targetId = NativeCoreConfigurationManager.getTargetIdFromProject(this.currentCfgDescription.getProjectDescription().getProject());
            PluginManager pm = PluginManager.getInstance();
            Toolchain tc = pm.getToolchainByTargetId(targetId);
            targetOption = tc.getTargetOption();
        }
        return targetOption.trim();
    }

    private boolean useGlobalProvider() {
        return this.currentCfgDescription == null;
    }

    public void startup(ICConfigurationDescription cfgDescription, IWorkingDirectoryTracker cwdTracker) throws CoreException {
        super.startup(cfgDescription, cwdTracker);
        this.state = State.NONE;
    }

    public void shutdown() {
        this.state = State.NONE;
        super.shutdown();
    }

    public TizenBuiltinSpecsDetector cloneShallow() throws CloneNotSupportedException {
        return (TizenBuiltinSpecsDetector)super.cloneShallow();
    }

    public TizenBuiltinSpecsDetector clone() throws CloneNotSupportedException {
        return (TizenBuiltinSpecsDetector)super.clone();
    }

    public String getToolchainId() {
        return GCC_TOOLCHAIN_ID;
    }

    private static enum State {
        NONE,
        EXPECTING_LOCAL_INCLUDE,
        EXPECTING_SYSTEM_INCLUDE,
        EXPECTING_FRAMEWORKS;

    }
}

