/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.contentassist;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionStyleMacroParameter;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorFunctionStyleMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.c.ICFunctionScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDirective;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBlockScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateNonTypeParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTypeParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.IContentAssistMatcher;
import org.eclipse.cdt.internal.core.dom.parser.c.CBuiltinParameter;
import org.eclipse.cdt.internal.core.dom.parser.c.CBuiltinVariable;
import org.eclipse.cdt.internal.core.dom.parser.c.CImplicitFunction;
import org.eclipse.cdt.internal.core.dom.parser.c.CImplicitTypedef;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBuiltinParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBuiltinVariable;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitMethod;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitTypedef;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.AccessContext;
import org.eclipse.cdt.internal.core.parser.util.ContentAssistMatcherFactory;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProposal;
import org.eclipse.cdt.internal.ui.text.contentassist.CContentAssistInvocationContext;
import org.eclipse.cdt.internal.ui.text.contentassist.CProposalContextInformation;
import org.eclipse.cdt.internal.ui.text.contentassist.ParsingBasedProposalComputer;
import org.eclipse.cdt.internal.ui.viewsupport.CElementImageProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;

public class DOMCompletionProposalComputer
extends ParsingBasedProposalComputer {
    private static final String HASH = "#";
    private static final String DEFAULT_ARGUMENT_PATTERN = " = {0}";
    private static final String TEMPLATE_PARAMETER_PATTERN = "template<{0}> class";
    private static final String TYPENAME = "typename";
    private static final String ELLIPSIS = "...";

    @Override
    protected List<ICompletionProposal> computeCompletionProposals(CContentAssistInvocationContext context, IASTCompletionNode completionNode, String prefix) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        if (this.inPreprocessorDirective(context)) {
            if (!this.inPreprocessorKeyword(context)) {
                if (prefix.length() == 0) {
                    try {
                        prefix = context.computeIdentifierPrefix().toString();
                    }
                    catch (BadLocationException exc) {
                        CUIPlugin.log(exc);
                    }
                }
                this.addMacroProposals(context, prefix, proposals);
            }
        } else {
            IASTName[] names;
            boolean handleMacros = false;
            IASTName[] iASTNameArray = names = completionNode.getNames();
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                IASTCompletionContext astContext;
                IASTName name = iASTNameArray[n2];
                if (name.getTranslationUnit() != null && (astContext = name.getCompletionContext()) != null) {
                    IBinding[] bindings;
                    if (astContext instanceof IASTIdExpression || astContext instanceof IASTNamedTypeSpecifier) {
                        handleMacros = prefix.length() > 0;
                    }
                    if ((bindings = astContext.findBindings(name, !context.isContextInformationStyle())) != null) {
                        AccessContext accessibilityContext = new AccessContext(name);
                        IBinding[] iBindingArray = bindings;
                        int n3 = bindings.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IBinding binding = iBindingArray[n4];
                            if (accessibilityContext.isAccessible(binding)) {
                                this.handleBinding(binding, context, prefix, astContext, proposals);
                            }
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
            if (handleMacros) {
                this.addMacroProposals(context, prefix, proposals);
            }
        }
        return proposals;
    }

    private boolean inPreprocessorKeyword(CContentAssistInvocationContext context) {
        IDocument doc = context.getDocument();
        int offset = context.getInvocationOffset();
        try {
            String ppPrefix;
            ITypedRegion partition = TextUtilities.getPartition((IDocument)doc, (String)"___c_partitioning", (int)offset, (boolean)true);
            if ("__c_preprocessor".equals(partition.getType()) && (ppPrefix = doc.get(partition.getOffset(), offset - partition.getOffset())).matches("\\s*#\\s*\\w*")) {
                return true;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    private boolean inPreprocessorDirective(CContentAssistInvocationContext context) {
        IDocument doc = context.getDocument();
        int offset = context.getInvocationOffset();
        try {
            ITypedRegion partition = TextUtilities.getPartition((IDocument)doc, (String)"___c_partitioning", (int)offset, (boolean)true);
            if ("__c_preprocessor".equals(partition.getType())) {
                return true;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    private void addMacroProposals(CContentAssistInvocationContext context, String prefix, List<ICompletionProposal> proposals) {
        IASTCompletionNode completionNode = context.getCompletionNode();
        this.addMacroProposals(context, prefix, proposals, completionNode.getTranslationUnit().getMacroDefinitions());
        this.addMacroProposals(context, prefix, proposals, completionNode.getTranslationUnit().getBuiltinMacroDefinitions());
    }

    private void addMacroProposals(CContentAssistInvocationContext context, String prefix, List<ICompletionProposal> proposals, IASTPreprocessorMacroDefinition[] macros) {
        block6: {
            boolean matchPrefix;
            if (macros == null) break block6;
            char[] prefixChars = prefix.toCharArray();
            boolean bl = matchPrefix = !context.isContextInformationStyle();
            if (matchPrefix) {
                IContentAssistMatcher matcher = ContentAssistMatcherFactory.getInstance().createMatcher(prefixChars);
                int i = 0;
                while (i < macros.length) {
                    char[] macroName = macros[i].getName().toCharArray();
                    if (matcher.match(macroName)) {
                        this.handleMacro(macros[i], context, prefix, proposals);
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < macros.length) {
                    char[] macroName = macros[i].getName().toCharArray();
                    if (CharArrayUtils.equals((char[])macroName, (int)0, (int)macroName.length, (char[])prefixChars, (boolean)true)) {
                        this.handleMacro(macros[i], context, prefix, proposals);
                    }
                    ++i;
                }
            }
        }
    }

    private void handleMacro(IASTPreprocessorMacroDefinition macro, CContentAssistInvocationContext context, String prefix, List<ICompletionProposal> proposals) {
        String macroName = macro.getName().toString();
        int baseRelevance = this.computeBaseRelevance(prefix, macroName);
        Image image = this.getImage(CElementImageProvider.getMacroImageDescriptor());
        if (macro instanceof IASTPreprocessorFunctionStyleMacroDefinition) {
            IASTPreprocessorFunctionStyleMacroDefinition functionMacro = (IASTPreprocessorFunctionStyleMacroDefinition)macro;
            StringBuilder repStringBuff = new StringBuilder();
            repStringBuff.append(macroName);
            repStringBuff.append('(');
            StringBuilder args = new StringBuilder();
            IASTFunctionStyleMacroParameter[] params = functionMacro.getParameters();
            if (params != null) {
                String parameterDelimiter = context.getFunctionParameterDelimiter();
                int i = 0;
                while (i < params.length) {
                    if (i > 0) {
                        args.append(parameterDelimiter);
                    }
                    args.append(params[i].getParameter());
                    ++i;
                }
            }
            String argString = args.toString();
            StringBuilder descStringBuff = new StringBuilder(repStringBuff.toString());
            descStringBuff.append(argString);
            descStringBuff.append(')');
            repStringBuff.append(')');
            String repString = repStringBuff.toString();
            String descString = descStringBuff.toString();
            CCompletionProposal proposal = this.createProposal(repString, descString, prefix.length(), image, baseRelevance + 15, context);
            if (!context.isContextInformationStyle()) {
                if (argString.length() > 0) {
                    proposal.setCursorPosition(repString.length() - 1);
                } else {
                    proposal.setCursorPosition(repString.length());
                }
            }
            if (argString.length() > 0) {
                CProposalContextInformation info = new CProposalContextInformation(image, descString, argString);
                info.setContextInformationPosition(context.getContextInformationOffset());
                proposal.setContextInformation(info);
            }
            proposals.add(proposal);
        } else {
            proposals.add(this.createProposal(macroName, macroName, prefix.length(), image, baseRelevance + 15, context));
        }
    }

    protected void handleBinding(IBinding binding, CContentAssistInvocationContext cContext, String prefix, IASTCompletionContext astContext, List<ICompletionProposal> proposals) {
        if ((binding instanceof CPPImplicitFunction || binding instanceof CPPImplicitTypedef || binding instanceof CPPBuiltinVariable || binding instanceof CPPBuiltinParameter || binding instanceof CImplicitFunction || binding instanceof CImplicitTypedef || binding instanceof CBuiltinVariable || binding instanceof CBuiltinParameter || binding instanceof ICPPClassTemplatePartialSpecialization) && !(binding instanceof CPPImplicitMethod)) {
            return;
        }
        if (!this.isAnonymousBinding(binding)) {
            String name = binding.getName();
            int baseRelevance = this.computeBaseRelevance(prefix, name);
            if (binding instanceof ICPPClassType) {
                this.handleClass((ICPPClassType)binding, astContext, cContext, baseRelevance, proposals);
            } else if (binding instanceof IFunction) {
                this.handleFunction((IFunction)binding, cContext, baseRelevance, proposals);
            } else if (binding instanceof IVariable) {
                this.handleVariable((IVariable)binding, cContext, baseRelevance, proposals);
            } else if (!cContext.isContextInformationStyle()) {
                if (binding instanceof ITypedef) {
                    proposals.add(this.createProposal(name, name, this.getImage(binding), baseRelevance + 60, cContext));
                } else if (binding instanceof ICPPNamespace) {
                    this.handleNamespace((ICPPNamespace)binding, astContext, cContext, baseRelevance, proposals);
                } else if (binding instanceof IEnumeration) {
                    proposals.add(this.createProposal(name, name, this.getImage(binding), baseRelevance + 30, cContext));
                } else if (binding instanceof IEnumerator) {
                    proposals.add(this.createProposal(name, name, this.getImage(binding), baseRelevance + 40, cContext));
                } else {
                    proposals.add(this.createProposal(name, name, this.getImage(binding), baseRelevance + 20, cContext));
                }
            }
        }
    }

    private boolean isAnonymousBinding(IBinding binding) {
        char[] name = binding.getNameCharArray();
        return name.length == 0 || name[0] == '{';
    }

    private void addProposalForClassTemplate(ICPPClassTemplate templateType, CContentAssistInvocationContext context, int baseRelevance, List<ICompletionProposal> proposals) {
        int relevance = this.getClassTypeRelevance((ICPPClassType)templateType);
        StringBuilder representation = new StringBuilder(templateType.getName());
        boolean inUsingDeclaration = context.isInUsingDirective();
        String templateParameterRepresentation = "";
        if (!inUsingDeclaration) {
            representation.append("<{0}>");
            templateParameterRepresentation = this.buildTemplateParameters(templateType, context);
        } else if (!context.isFollowedBySemicolon()) {
            representation.append(';');
        }
        String representationString = MessageFormat.format(representation.toString(), "");
        String displayString = MessageFormat.format(representation.toString(), templateParameterRepresentation);
        CCompletionProposal proposal = this.createProposal(representationString, displayString, this.getImage((IBinding)templateType), baseRelevance + relevance, context);
        if (!inUsingDeclaration) {
            CProposalContextInformation info = new CProposalContextInformation(this.getImage((IBinding)templateType), displayString, templateParameterRepresentation);
            info.setContextInformationPosition(context.getContextInformationOffset());
            proposal.setContextInformation(info);
            if (!context.isContextInformationStyle()) {
                proposal.setCursorPosition(representationString.length() - 1);
            }
        }
        proposals.add(proposal);
    }

    private String buildTemplateParameters(ICPPClassTemplate templateType, CContentAssistInvocationContext context) {
        ICPPTemplateParameter[] parameters = templateType.getTemplateParameters();
        StringBuilder representation = new StringBuilder();
        String parameterDelimiter = context.getTemplateParameterDelimiter();
        boolean addDefaultedParameters = DOMCompletionProposalComputer.isDisplayDefaultedParameters();
        boolean addDefaultArguments = DOMCompletionProposalComputer.isDisplayDefaultArguments();
        int i = 0;
        while (i < parameters.length) {
            ICPPTemplateParameter parameter = parameters[i];
            ICPPTemplateArgument defaultValue = parameter.getDefaultValue();
            if (!addDefaultedParameters && defaultValue != null) break;
            if (i > 0) {
                representation.append(parameterDelimiter);
            }
            if (parameter instanceof ICPPTemplateNonTypeParameter) {
                IType parameterType = ((ICPPTemplateNonTypeParameter)parameter).getType();
                String typeName = ASTTypeUtil.getType((IType)parameterType);
                representation.append(typeName);
            } else if (parameter instanceof ICPPTemplateTypeParameter) {
                representation.append(TYPENAME);
            } else if (parameter instanceof ICPPTemplateTemplateParameter) {
                String templateParameterParameters = this.buildTemplateParameters((ICPPClassTemplate)((ICPPTemplateTemplateParameter)parameter), context);
                representation.append(MessageFormat.format(TEMPLATE_PARAMETER_PATTERN, templateParameterParameters));
                representation.append(templateParameterParameters);
            }
            if (parameter.isParameterPack()) {
                representation.append(ELLIPSIS);
            }
            representation.append(' ');
            representation.append(parameter.getName());
            if (addDefaultArguments && defaultValue != null) {
                String defaultArgumentRepresentation = MessageFormat.format(DEFAULT_ARGUMENT_PATTERN, defaultValue);
                int parameterIndex = 0;
                while (parameterIndex < i) {
                    String templateArgumentID = HASH + parameterIndex;
                    String templateArgumentValue = parameters[parameterIndex].getName();
                    defaultArgumentRepresentation = defaultArgumentRepresentation.replaceAll(templateArgumentID, templateArgumentValue);
                    ++parameterIndex;
                }
                representation.append(defaultArgumentRepresentation);
            }
            ++i;
        }
        return representation.toString();
    }

    private void handleClass(ICPPClassType classType, IASTCompletionContext astContext, CContentAssistInvocationContext context, int baseRelevance, List<ICompletionProposal> proposals) {
        if (context.isContextInformationStyle() && context.isAfterOpeningParenthesis()) {
            this.addProposalsForConstructors(classType, context, baseRelevance, proposals);
        } else if (classType instanceof ICPPClassTemplate) {
            this.addProposalForClassTemplate((ICPPClassTemplate)classType, context, baseRelevance, proposals);
        } else {
            IASTName name;
            int relevance = this.getClassTypeRelevance(classType);
            if (astContext instanceof IASTName && !(astContext instanceof ICPPASTQualifiedName) && (name = (IASTName)astContext).getParent() instanceof IASTDeclarator) {
                proposals.add(this.createProposal(String.valueOf(classType.getName()) + "::", classType.getName(), this.getImage((IBinding)classType), baseRelevance + relevance, context));
            }
            proposals.add(this.createProposal(classType.getName(), classType.getName(), this.getImage((IBinding)classType), baseRelevance + 90, context));
        }
    }

    private void addProposalsForConstructors(ICPPClassType classType, CContentAssistInvocationContext context, int baseRelevance, List<ICompletionProposal> proposals) {
        ICPPConstructor[] constructors;
        ICPPConstructor[] iCPPConstructorArray = constructors = classType.getConstructors();
        int n = constructors.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPConstructor constructor = iCPPConstructorArray[n2];
            this.handleFunction((IFunction)constructor, context, baseRelevance, proposals);
            ++n2;
        }
    }

    private int getClassTypeRelevance(ICPPClassType classType) {
        int relevance = 0;
        switch (classType.getKey()) {
            case 3: {
                relevance = 90;
                break;
            }
            case 1: {
                relevance = 80;
                break;
            }
            case 2: {
                relevance = 70;
            }
        }
        return relevance;
    }

    private void handleFunction(IFunction function, CContentAssistInvocationContext context, int baseRelevance, List<ICompletionProposal> proposals) {
        IType returnType;
        IFunctionType functionType;
        Image image = this.getImage((IBinding)function);
        StringBuilder repStringBuff = new StringBuilder();
        repStringBuff.append(function.getName());
        repStringBuff.append('(');
        StringBuilder dispargs = new StringBuilder();
        StringBuilder idargs = new StringBuilder();
        boolean hasArgs = true;
        String returnTypeStr = null;
        IParameter[] params = function.getParameters();
        if (params != null) {
            String parameterDelimiter = context.getFunctionParameterDelimiter();
            int i = 0;
            while (i < params.length) {
                ICPPParameter cppParam;
                IParameter param = params[i];
                if (this.skipDefaultedParameter(param)) break;
                IType paramType = param.getType();
                if (i > 0) {
                    dispargs.append(parameterDelimiter);
                    idargs.append(parameterDelimiter);
                }
                dispargs.append(ASTTypeUtil.getType((IType)paramType, (boolean)false));
                idargs.append(ASTTypeUtil.getType((IType)paramType, (boolean)false));
                String paramName = param.getName();
                if (paramName != null && paramName.length() > 0) {
                    dispargs.append(' ');
                    dispargs.append(paramName);
                }
                if (param instanceof ICPPParameter && (cppParam = (ICPPParameter)param).hasDefaultValue() && DOMCompletionProposalComputer.isDisplayDefaultArguments()) {
                    dispargs.append(MessageFormat.format(DEFAULT_ARGUMENT_PATTERN, cppParam.getDefaultValue()));
                }
                ++i;
            }
            if (function.takesVarArgs()) {
                if (params.length > 0) {
                    dispargs.append(parameterDelimiter);
                    idargs.append(parameterDelimiter);
                }
                dispargs.append(ELLIPSIS);
                idargs.append(ELLIPSIS);
            } else if (params.length == 0) {
                dispargs.append("void");
                idargs.append("void");
            }
        }
        if ((functionType = function.getType()) != null && (returnType = functionType.getReturnType()) != null) {
            returnTypeStr = ASTTypeUtil.getType((IType)returnType, (boolean)false);
        }
        hasArgs = ASTTypeUtil.functionTakesParameters((IFunction)function);
        String dispargString = dispargs.toString();
        String idargString = idargs.toString();
        String contextDispargString = hasArgs ? dispargString : null;
        StringBuilder dispStringBuff = new StringBuilder(repStringBuff.toString());
        dispStringBuff.append(dispargString);
        dispStringBuff.append(')');
        if (returnTypeStr != null && returnTypeStr.length() > 0) {
            dispStringBuff.append(" : ");
            dispStringBuff.append(returnTypeStr);
        }
        String dispString = dispStringBuff.toString();
        StringBuilder idStringBuff = new StringBuilder(repStringBuff.toString());
        idStringBuff.append(idargString);
        idStringBuff.append(')');
        String idString = idStringBuff.toString();
        boolean inUsingDeclaration = context.isInUsingDirective();
        if (inUsingDeclaration) {
            repStringBuff.setLength(repStringBuff.length() - 1);
            if (!context.isFollowedBySemicolon()) {
                repStringBuff.append(';');
            }
        } else {
            repStringBuff.append(')');
        }
        String repString = repStringBuff.toString();
        int relevance = function instanceof ICPPMethod ? 120 : 100;
        CCompletionProposal proposal = this.createProposal(repString, dispString, idString, context.getCompletionNode().getLength(), image, baseRelevance + relevance, context);
        if (!context.isContextInformationStyle()) {
            int cursorPosition = !inUsingDeclaration && hasArgs ? repString.length() - 1 : repString.length();
            proposal.setCursorPosition(cursorPosition);
        }
        if (contextDispargString != null && !inUsingDeclaration) {
            CProposalContextInformation info = new CProposalContextInformation(image, dispString, contextDispargString);
            info.setContextInformationPosition(context.getContextInformationOffset());
            proposal.setContextInformation(info);
        }
        proposals.add(proposal);
    }

    private boolean skipDefaultedParameter(IParameter param) {
        return !DOMCompletionProposalComputer.isDisplayDefaultedParameters() && param instanceof ICPPParameter && ((ICPPParameter)param).hasDefaultValue();
    }

    private void handleVariable(IVariable variable, CContentAssistInvocationContext context, int baseRelevance, List<ICompletionProposal> proposals) {
        if (context.isContextInformationStyle()) {
            IType t = variable.getType();
            if ((t = this.unwindTypedefs(t)) instanceof ICPPClassType) {
                ICPPConstructor[] constructors;
                ICPPClassType classType = (ICPPClassType)t;
                IASTTranslationUnit ast = context.getCompletionNode().getTranslationUnit();
                ICPPConstructor[] iCPPConstructorArray = constructors = ClassTypeHelper.getConstructors((ICPPClassType)classType, (IASTNode)ast);
                int n = constructors.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPConstructor constructor = iCPPConstructorArray[n2];
                    this.handleFunction((IFunction)constructor, context, baseRelevance, proposals);
                    ++n2;
                }
            }
            return;
        }
        StringBuilder repStringBuff = new StringBuilder();
        repStringBuff.append(variable.getName());
        String returnTypeStr = "<unknown>";
        IType varType = variable.getType();
        if (varType != null) {
            returnTypeStr = ASTTypeUtil.getType((IType)varType, (boolean)false);
        }
        StringBuilder dispStringBuff = new StringBuilder(repStringBuff.toString());
        if (returnTypeStr != null) {
            dispStringBuff.append(" : ");
            dispStringBuff.append(returnTypeStr);
        }
        String dispString = dispStringBuff.toString();
        StringBuilder idStringBuff = new StringBuilder(repStringBuff.toString());
        String idString = idStringBuff.toString();
        String repString = repStringBuff.toString();
        Image image = this.getImage((IBinding)variable);
        int relevance = DOMCompletionProposalComputer.isLocalVariable(variable) ? 140 : (DOMCompletionProposalComputer.isField(variable) ? 130 : 110);
        CCompletionProposal proposal = this.createProposal(repString, dispString, idString, context.getCompletionNode().getLength(), image, baseRelevance + relevance, context);
        proposals.add(proposal);
    }

    private IType unwindTypedefs(IType t) {
        IType r = t;
        while (r instanceof ITypedef) {
            r = ((ITypedef)r).getType();
        }
        return r != null ? r : t;
    }

    private static boolean isField(IVariable variable) {
        return variable instanceof IField;
    }

    private static boolean isLocalVariable(IVariable variable) {
        try {
            return DOMCompletionProposalComputer.isLocalScope(variable.getScope());
        }
        catch (DOMException dOMException) {
            return false;
        }
    }

    private static boolean isLocalScope(IScope scope) {
        while (scope != null) {
            if (scope instanceof ICPPFunctionScope || scope instanceof ICPPBlockScope || scope instanceof ICFunctionScope) {
                return true;
            }
            try {
                scope = scope.getParent();
            }
            catch (DOMException dOMException) {
                scope = null;
            }
        }
        return false;
    }

    private void handleNamespace(ICPPNamespace namespace, IASTCompletionContext astContext, CContentAssistInvocationContext cContext, int baseRelevance, List<ICompletionProposal> proposals) {
        if (astContext instanceof ICPPASTQualifiedName) {
            IASTCompletionContext parent = ((ICPPASTQualifiedName)astContext).getCompletionContext();
            this.handleNamespace(namespace, parent, cContext, baseRelevance, proposals);
            return;
        }
        StringBuilder repStringBuff = new StringBuilder();
        repStringBuff.append(namespace.getName());
        if (!(astContext instanceof ICPPASTUsingDeclaration) && !(astContext instanceof ICPPASTUsingDirective)) {
            repStringBuff.append("::");
        }
        String repString = repStringBuff.toString();
        proposals.add(this.createProposal(repString, namespace.getName(), this.getImage((IBinding)namespace), baseRelevance + 50, cContext));
    }

    private CCompletionProposal createProposal(String repString, String dispString, Image image, int relevance, CContentAssistInvocationContext context) {
        return this.createProposal(repString, dispString, null, context.getCompletionNode().getLength(), image, relevance, context);
    }

    private CCompletionProposal createProposal(String repString, String dispString, int prefixLength, Image image, int relevance, CContentAssistInvocationContext context) {
        return this.createProposal(repString, dispString, null, prefixLength, image, relevance, context);
    }

    private CCompletionProposal createProposal(String repString, String dispString, String idString, int prefixLength, Image image, int relevance, CContentAssistInvocationContext context) {
        int parseOffset = context.getParseOffset();
        int invocationOffset = context.getInvocationOffset();
        boolean doReplacement = !context.isContextInformationStyle();
        int repLength = doReplacement ? prefixLength : 0;
        int repOffset = doReplacement ? parseOffset - repLength : invocationOffset;
        repString = doReplacement ? repString : "";
        return new CCompletionProposal(repString, repOffset, repLength, image, dispString, idString, relevance, context.getViewer());
    }

    private Image getImage(ImageDescriptor desc) {
        return desc != null ? CUIPlugin.getImageDescriptorRegistry().get(desc) : null;
    }

    private Image getImage(IBinding binding) {
        IBinding[] delegates;
        ImageDescriptor imageDescriptor = null;
        if (binding instanceof ITypedef) {
            imageDescriptor = CElementImageProvider.getTypedefImageDescriptor();
        } else if (binding instanceof ICompositeType) {
            if (((ICompositeType)binding).getKey() == 3 || binding instanceof ICPPClassTemplate) {
                imageDescriptor = CElementImageProvider.getClassImageDescriptor();
            } else if (((ICompositeType)binding).getKey() == 1) {
                imageDescriptor = CElementImageProvider.getStructImageDescriptor();
            } else if (((ICompositeType)binding).getKey() == 2) {
                imageDescriptor = CElementImageProvider.getUnionImageDescriptor();
            }
        } else if (binding instanceof ICPPMethod) {
            switch (((ICPPMethod)binding).getVisibility()) {
                case 3: {
                    imageDescriptor = CElementImageProvider.getMethodImageDescriptor(ASTAccessVisibility.PRIVATE);
                    break;
                }
                case 2: {
                    imageDescriptor = CElementImageProvider.getMethodImageDescriptor(ASTAccessVisibility.PROTECTED);
                    break;
                }
                default: {
                    imageDescriptor = CElementImageProvider.getMethodImageDescriptor(ASTAccessVisibility.PUBLIC);
                    break;
                }
            }
        } else if (binding instanceof IFunction) {
            imageDescriptor = CElementImageProvider.getFunctionImageDescriptor();
        } else if (binding instanceof ICPPField) {
            switch (((ICPPField)binding).getVisibility()) {
                case 3: {
                    imageDescriptor = CElementImageProvider.getFieldImageDescriptor(ASTAccessVisibility.PRIVATE);
                    break;
                }
                case 2: {
                    imageDescriptor = CElementImageProvider.getFieldImageDescriptor(ASTAccessVisibility.PROTECTED);
                    break;
                }
                default: {
                    imageDescriptor = CElementImageProvider.getFieldImageDescriptor(ASTAccessVisibility.PUBLIC);
                    break;
                }
            }
        } else if (binding instanceof IField) {
            imageDescriptor = CElementImageProvider.getFieldImageDescriptor(ASTAccessVisibility.PUBLIC);
        } else if (binding instanceof IVariable) {
            imageDescriptor = CElementImageProvider.getVariableImageDescriptor();
        } else if (binding instanceof IEnumeration) {
            imageDescriptor = CElementImageProvider.getEnumerationImageDescriptor();
        } else if (binding instanceof IEnumerator) {
            imageDescriptor = CElementImageProvider.getEnumeratorImageDescriptor();
        } else if (binding instanceof ICPPNamespace) {
            imageDescriptor = CElementImageProvider.getNamespaceImageDescriptor();
        } else if (binding instanceof ICPPFunctionTemplate) {
            imageDescriptor = CElementImageProvider.getFunctionImageDescriptor();
        } else if (binding instanceof ICPPUsingDeclaration && (delegates = ((ICPPUsingDeclaration)binding).getDelegates()).length > 0) {
            return this.getImage(delegates[0]);
        }
        return imageDescriptor != null ? CUIPlugin.getImageDescriptorRegistry().get(imageDescriptor) : null;
    }

    private static boolean isDisplayDefaultArguments() {
        IPreferenceStore preferenceStore = DOMCompletionProposalComputer.getPreferenceStore();
        return preferenceStore.getBoolean("content_assist_default_argument_display_arguments");
    }

    private static boolean isDisplayDefaultedParameters() {
        IPreferenceStore preferenceStore = DOMCompletionProposalComputer.getPreferenceStore();
        return preferenceStore.getBoolean("content_assist_default_argument_display_parameters_with_default_argument");
    }

    private static IPreferenceStore getPreferenceStore() {
        return CUIPlugin.getDefault().getPreferenceStore();
    }
}

