/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.build.ui;

import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.TizenProjectType;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecommon.build.ProjectTypeManager;

public class TizenPropertyTester
extends PropertyTester {
    private final Logger logger = LoggerFactory.getLogger(TizenPropertyTester.class);
    private static String HAS_REFERENCDE_PROJECT = "hasReferencedProject";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        block15: {
            block17: {
                TizenProjectType type;
                block18: {
                    IProject project;
                    block12: {
                        IProject project2;
                        block16: {
                            block13: {
                                block14: {
                                    try {
                                        if (!property.equals("isTizenProject")) break block12;
                                        if (!(receiver instanceof IProject)) break block13;
                                        project = (IProject)receiver;
                                        if (!this.isUnitTestProject(project)) break block14;
                                        return false;
                                    }
                                    catch (Exception e) {
                                        this.logger.error("Failed to test isTizenProject", (Throwable)e);
                                        return false;
                                    }
                                }
                                IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
                                if (info != null) {
                                    if (ProjectTypeManager.isValidProjectType(project)) {
                                        return true;
                                    }
                                    break block15;
                                }
                                return false;
                            }
                            if (!(receiver instanceof IFolder)) break block15;
                            IFolder folder = (IFolder)receiver;
                            project2 = folder.getProject();
                            if (!this.isUnitTestProject(project2)) break block16;
                            return false;
                        }
                        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project2);
                        if (info != null) {
                            if (ProjectTypeManager.isValidProjectType(project2)) {
                                return true;
                            }
                            break block15;
                        }
                        return false;
                    }
                    if (property.equals(HAS_REFERENCDE_PROJECT)) {
                        return this.hasReferencedProject(receiver, property, args, expectedValue);
                    }
                    if (!property.equals("isPackagableNativeProject")) break block15;
                    if (!(receiver instanceof IProject)) break block17;
                    project = (IProject)receiver;
                    type = ProjectUtil.getTizenProjectType(project);
                    if (type != null) break block18;
                    return false;
                }
                if (!type.isNativeApplicationProject()) break block17;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean hasReferencedProject(Object receiver, String property, Object[] args, Object expectedValue) {
        if (!(receiver instanceof IProject)) {
            return false;
        }
        IProject project = (IProject)receiver;
        try {
            return ProjectUtil.hasReferencedLibraryProject(project);
        }
        catch (CoreException e) {
            e.printStackTrace();
            this.logger.error("Failed to test hasReferencedProject", (Throwable)e);
            return false;
        }
    }

    public boolean isUnitTestProject(IProject project) {
        String[] natureIds = null;
        try {
            natureIds = project.getDescription().getNatureIds();
        }
        catch (CoreException coreException) {
            return false;
        }
        if (natureIds != null) {
            String[] stringArray = natureIds;
            int n = natureIds.length;
            int n2 = 0;
            while (n2 < n) {
                String natureId = stringArray[n2];
                if ("org.tizen.tizentest.nature".equals(natureId)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

