/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ssilib;

import java.util.List;
import org.tizen.ssilib.SSIRuleOp;

public class SSIRule {
    private String target;
    private List<SSIRuleOp> targetRule;
    private String entry;
    private List<SSIRuleOp> entryRule;

    public SSIRule(String target, String targetRule, String entry, String entryRule) {
        this.setRule(target, targetRule, entry, entryRule);
    }

    public SSIRule(String targetRuleStr, String entryRuleStr) {
        this.setRule(targetRuleStr, entryRuleStr);
    }

    public SSIRule(String fullRuleStr) {
        String[] rules = fullRuleStr.split("/");
        if (rules != null) {
            int len = rules.length;
            String targetRuleStr = len > 0 ? rules[0] : null;
            String entryRuleStr = len > 1 ? rules[1] : null;
            this.setRule(targetRuleStr, entryRuleStr);
        }
    }

    private String[] parseRule(String ruleStr) {
        if (ruleStr == null) {
            return null;
        }
        int startIdx = ruleStr.indexOf(91);
        if (startIdx < 0) {
            return new String[]{ruleStr};
        }
        String target = ruleStr.substring(0, startIdx);
        int endIdx = ruleStr.indexOf(93, startIdx);
        if (endIdx < 0) {
            return new String[]{target};
        }
        String rule = ruleStr.substring(startIdx + 1, endIdx);
        return new String[]{target, rule};
    }

    public void setRule(String targetRuleStr, String entryRuleStr) {
        String entryRule;
        String entry;
        String targetRule;
        String target;
        int len;
        String[] rules = this.parseRule(targetRuleStr);
        if (rules != null) {
            len = rules.length;
            target = len > 0 ? rules[0] : null;
            targetRule = len > 1 ? rules[1] : null;
        } else {
            targetRule = null;
            target = null;
        }
        rules = this.parseRule(entryRuleStr);
        if (rules != null) {
            len = rules.length;
            entry = len > 0 ? rules[0] : null;
            entryRule = len > 1 ? rules[1] : null;
        } else {
            entryRule = null;
            entry = null;
        }
        this.setRule(target, targetRule, entry, entryRule);
    }

    public void setRule(String target, String targetRule, String entry, String entryRule) {
        this.target = target;
        this.targetRule = targetRule != null ? SSIRuleOp.parseFullRule(targetRule) : null;
        this.entry = entry;
        this.entryRule = entryRule != null ? SSIRuleOp.parseFullRule(entryRule) : null;
    }

    public String getTarget() {
        return this.target;
    }

    public List<SSIRuleOp> getTargetRule() {
        return this.targetRule;
    }

    public String getEntry() {
        return this.entry;
    }

    public List<SSIRuleOp> getEntryRule() {
        return this.entryRule;
    }
}

