/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecommon.build.ui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyValue;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.internal.core.MultiConfiguration;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractCBuildPropertyTab;
import org.eclipse.cdt.ui.newui.CDTPropertyManager;
import org.eclipse.cdt.ui.newui.ICPropertyProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.Version;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.nativecommon.build.CommonConfigurationManager;
import org.tizen.nativecommon.build.CommonProjectDependentBuilder;
import org.tizen.nativecommon.build.PlatformChangingManager;
import org.tizen.nativecommon.build.ProjectTypeManager;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativecommon.build.exception.SBIException;
import org.tizen.nativecommon.build.model.SBIModel;
import org.tizen.nativecommon.build.ui.Messages;
import org.tizen.sbilib.ide.PluginManager;
import org.tizen.sbilib.ide.Rootstrap;
import org.tizen.sbilib.ide.RootstrapException;
import org.tizen.sbilib.ide.Tool;
import org.tizen.sbilib.ide.Toolchain;

public class PlatformSettingTab
extends AbstractCBuildPropertyTab {
    private final Logger logger = LoggerFactory.getLogger(PlatformSettingTab.class);
    private final String LLVM_PREFIX = "llvm-";
    private final String LLVM_VERSION_37 = "3.7";
    protected IProject project;
    protected IConfiguration config;
    protected ICResourceDescription cfgdescr;
    private Label mPlatformVersionLabel;
    private Combo mPlatformArchitectureCombo;
    private Combo mRootstrapCombo;
    private Combo mToolchainCombo;
    private Label mRootstrapPathLabel;
    private TableViewer toolListTable;
    private int selectedColumn = 0;
    private String currentRootstrapID = null;
    private String currentToolchainID = null;
    private List<Rootstrap> availableRootstrap = new ArrayList<Rootstrap>();
    private Map<String, Toolchain> displayInfo = new HashMap<String, Toolchain>();
    private static int LABEL_WIDTH = 100;

    public void createControls(Composite parent, ICPropertyProvider provider) {
        this.page = provider;
        this.createControls(parent);
    }

    protected void createControls(Composite parent) {
        super.createControls(parent);
        this.config = this.getCfg();
        this.project = this.page.getProject();
        this.usercomp.setLayout((Layout)new GridLayout(1, false));
        this.usercomp.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite composite = new Composite(this.usercomp, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createRootstrapInfoComposite(composite);
        new Label(composite, 0);
        this.createToolchainComposite(composite);
    }

    private void createRootstrapInfoComposite(Composite parent) {
        Group rootstrapGroup = new Group(parent, 0);
        rootstrapGroup.setLayoutData((Object)new GridData(1840));
        rootstrapGroup.setLayout((Layout)new GridLayout(2, false));
        rootstrapGroup.setText(Messages.TIZEN_SETTINGS_PLATFORM_TAB_ROOTSTRAP_GROUP_LABEL);
        Label platformVersionLabel = new Label((Composite)rootstrapGroup, 0);
        platformVersionLabel.setText(Messages.TIZEN_SETTINGS_PLATFORM_TAB_ROOTSTRAP_PLATFORM_VERSION_LABEL);
        GridData gridData = new GridData(256);
        gridData.widthHint = LABEL_WIDTH;
        platformVersionLabel.setLayoutData((Object)gridData);
        this.mPlatformVersionLabel = new Label((Composite)rootstrapGroup, 0);
        gridData = new GridData(768);
        this.mPlatformVersionLabel.setLayoutData((Object)gridData);
        Label archLabel = new Label((Composite)rootstrapGroup, 0);
        gridData = new GridData(256);
        gridData.widthHint = LABEL_WIDTH;
        archLabel.setText(Messages.TIZEN_SETTINGS_PLATFORM_TAB_ROOTSTRAP_ARCHITECTURE_LABEL);
        archLabel.setLayoutData((Object)gridData);
        this.mPlatformArchitectureCombo = new Combo((Composite)rootstrapGroup, 0);
        gridData = new GridData(768);
        this.mPlatformArchitectureCombo.setLayoutData((Object)gridData);
        ArrayList architectureList = new ArrayList();
        this.mPlatformArchitectureCombo.setItems(architectureList.toArray(new String[0]));
        this.mPlatformArchitectureCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SWTUtil.asyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        String platformVersion = PlatformSettingTab.this.mPlatformVersionLabel.getText();
                        PlatformSettingTab.this.updatePlatformFromVersion(platformVersion);
                        Rootstrap selectedRootstrap = PlatformSettingTab.this.getRootstrap(platformVersion, PlatformSettingTab.this.mPlatformArchitectureCombo.getText(), PlatformSettingTab.this.mRootstrapCombo.getText());
                        if (selectedRootstrap != null) {
                            PlatformSettingTab.this.updateToolchainFromChanges(selectedRootstrap.getId(), null);
                            PlatformSettingTab.this.applyInfos();
                        } else {
                            PlatformSettingTab.this.logger.error("No rootstrap found: " + platformVersion);
                        }
                    }
                });
            }
        });
        Label nameLabel = new Label((Composite)rootstrapGroup, 0);
        nameLabel.setText(Messages.TIZEN_SETTINGS_PLATFORM_TAB_ROOTSTRAP_NAME_LABEL);
        gridData = new GridData(256);
        gridData.widthHint = LABEL_WIDTH;
        nameLabel.setLayoutData((Object)gridData);
        this.mRootstrapCombo = new Combo((Composite)rootstrapGroup, 0);
        gridData = new GridData(768);
        this.mRootstrapCombo.setLayoutData((Object)gridData);
        this.mRootstrapCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SWTUtil.asyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        PlatformSettingTab.this.updatePlatformPathFromName(PlatformSettingTab.this.mRootstrapCombo.getText());
                        Rootstrap selectedRootstrap = PlatformSettingTab.this.getRootstrap(PlatformSettingTab.this.mPlatformVersionLabel.getText(), PlatformSettingTab.this.mPlatformArchitectureCombo.getText(), PlatformSettingTab.this.mRootstrapCombo.getText());
                        if (selectedRootstrap != null) {
                            PlatformSettingTab.this.updateToolchainFromChanges(selectedRootstrap.getId(), null);
                            PlatformSettingTab.this.applyInfos();
                        } else {
                            PlatformSettingTab.this.logger.error("No rootstrap found: " + PlatformSettingTab.this.mPlatformVersionLabel.getText());
                        }
                    }
                });
            }
        });
        Label sysrootLabel = new Label((Composite)rootstrapGroup, 0);
        sysrootLabel.setText(Messages.TIZEN_SETTINGS_PLATFORM_TAB_ROOTSTRAP_PATH_LABEL);
        gridData = new GridData(256);
        gridData.widthHint = LABEL_WIDTH;
        sysrootLabel.setLayoutData((Object)gridData);
        this.mRootstrapPathLabel = new Label((Composite)rootstrapGroup, 0);
        gridData = new GridData(768);
        this.mRootstrapPathLabel.setLayoutData((Object)gridData);
    }

    private void createToolchainComposite(Composite parent) {
        Group toolchainGroup = new Group(parent, 0);
        toolchainGroup.setLayout((Layout)new GridLayout(2, false));
        toolchainGroup.setText(Messages.TIZEN_SETTINGS_PLATFORM_TAB_TOOLCHAIN_GROUP_LABEL);
        GridData gridData = new GridData(1794);
        toolchainGroup.setLayoutData((Object)gridData);
        Label toolchainNameLabel = new Label((Composite)toolchainGroup, 0);
        toolchainNameLabel.setText(Messages.TIZEN_SETTINGS_PLATFORM_TAB_TOOLCHAIN_NAME_LABEL);
        gridData = new GridData(256);
        gridData.widthHint = LABEL_WIDTH;
        toolchainNameLabel.setLayoutData((Object)gridData);
        this.mToolchainCombo = new Combo((Composite)toolchainGroup, 0);
        gridData = new GridData(768);
        this.mToolchainCombo.setLayoutData((Object)gridData);
        this.mToolchainCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final String name = PlatformSettingTab.this.mRootstrapCombo.getText();
                final String arch = PlatformSettingTab.this.mPlatformArchitectureCombo.getText();
                final String ver = PlatformSettingTab.this.mPlatformVersionLabel.getText();
                final String toolName = PlatformSettingTab.this.mToolchainCombo.getText();
                SWTUtil.asyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        String rootstrapId = PlatformSettingTab.this.fullMatchRootstrapId(name, arch, ver);
                        PlatformSettingTab.this.updateToolchainFromChanges(rootstrapId, toolName);
                        PlatformSettingTab.this.applyInfos();
                    }
                });
            }
        });
        Composite toolListcomposite = new Composite((Composite)toolchainGroup, 0);
        toolListcomposite.setLayout((Layout)new FillLayout());
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 250;
        toolListcomposite.setLayoutData((Object)gridData);
        this.createToolInfoComposite(toolListcomposite);
    }

    private String fullMatchRootstrapId(String name, String arch, String ver) {
        for (Rootstrap r : SBIModel.getRootstrapList()) {
            if (!r.getVersion().equals(ver) || !SBIModel.getDisplayArch(r).equals(arch) || !r.getName().equals(name)) continue;
            return r.getId();
        }
        return "";
    }

    private String getSelectedToolchainId(String rootstrapID, String toolchainName) {
        SmartBuildInterface sbi = SmartBuildInterface.getInstance();
        try {
            IBuildPropertyValue buildPropertyValue;
            String arch = sbi.getArchitectureFromRootstrapID(rootstrapID);
            String suppotedToolchainType = sbi.getSupportToolchainTypeFromRootstrapID(rootstrapID);
            String artifactType = "";
            if (this.config != null && (buildPropertyValue = this.config.getBuildArtefactType()) != null) {
                artifactType = buildPropertyValue.getId();
            }
            for (String toolchainId : SBIModel.getToolchainIdList()) {
                String iArchitecture = SBIModel.getToolchainById(toolchainId).getArchitecture();
                String iToolchainType = SBIModel.getToolchainById(toolchainId).getToolchainType();
                String iToolchainName = SBIModel.getToolchainById(toolchainId).getName();
                if (!CommonConfigurationManager.isSameArchType(arch, iArchitecture) || !iToolchainType.equals(suppotedToolchainType) || !iToolchainName.toUpperCase().equals(toolchainName.toUpperCase())) continue;
                return toolchainId;
            }
            for (String toolchainId : SBIModel.getToolchainIdList()) {
                String iProjectType = SBIModel.getToolchainById(toolchainId).getPropertyValue("PROJECT_TYPE");
                String iArchitecture = SBIModel.getToolchainById(toolchainId).getArchitecture();
                String iToolchainType = SBIModel.getToolchainById(toolchainId).getToolchainType();
                if (!CommonConfigurationManager.isSameArchType(arch, iArchitecture) || !iToolchainType.equals(suppotedToolchainType) || !artifactType.equals(iProjectType)) continue;
                return toolchainId;
            }
        }
        catch (SBIException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return "";
    }

    private void updatePlatformFromVersion(String platformVersion) {
        List<Rootstrap> availableRS = this.getAvailableRootstrapFromVersion(platformVersion);
        String preArch = this.mPlatformArchitectureCombo.getText();
        String preName = this.mRootstrapCombo.getText();
        this.setPlatformArchitecture(availableRS, preArch, platformVersion);
        this.setPlatformName(availableRS, preName);
        String currentArch = this.mPlatformArchitectureCombo.getText();
        String currentName = this.mRootstrapCombo.getText();
        Rootstrap rs = this.getRootstrap(platformVersion, currentArch, currentName);
        if (rs != null) {
            this.setPlatformPath(rs.getPath());
            this.setCurrentRootstrapId(rs.getId());
        } else {
            this.logger.error("Failed to get rootstrap: " + this.mPlatformVersionLabel.getText());
        }
    }

    private void updatePlatformPathFromName(String platformName) {
        String currentArch = this.mPlatformArchitectureCombo.getText();
        Rootstrap rs = this.getRootstrap(this.mPlatformVersionLabel.getText(), currentArch, platformName);
        if (rs != null) {
            this.setPlatformPath(rs.getPath());
            this.setCurrentRootstrapId(rs.getId());
        } else {
            this.logger.error("Failed to get rootstrap: " + this.mPlatformVersionLabel.getText());
        }
    }

    private Rootstrap getRootstrap(String platformVersion, String arch, String name) {
        for (Rootstrap rs : this.availableRootstrap) {
            if (!rs.getVersion().equals(platformVersion) || !SBIModel.getDisplayArch(rs).equals(arch) || !rs.getName().equals(name)) continue;
            return rs;
        }
        return null;
    }

    private List<Rootstrap> getAvailableRootstrapFromVersion(String platformVersion) {
        ArrayList<Rootstrap> availableRS = new ArrayList<Rootstrap>();
        for (Rootstrap rs : this.availableRootstrap) {
            if (!rs.getVersion().equals(platformVersion) || availableRS.contains(rs)) continue;
            availableRS.add(rs);
        }
        return availableRS;
    }

    private List<Rootstrap> getAvailableRootstrapFromName(String platformName) {
        List<Rootstrap> availableRS = this.getAvailableRootstrapFromVersion(this.mPlatformVersionLabel.getText());
        ArrayList<Rootstrap> availableRSFromName = new ArrayList<Rootstrap>();
        for (Rootstrap rs : availableRS) {
            String name = rs.getName();
            if (!name.equals(platformName) || availableRSFromName.contains(rs)) continue;
            availableRSFromName.add(rs);
        }
        return availableRSFromName;
    }

    private String getDefaultLLVMName(String rootstrapId) {
        Version ver2;
        String version;
        Version ver1;
        String name;
        PluginManager pm = PluginManager.getInstance();
        Rootstrap rs = pm.getRootstrap(rootstrapId);
        String arch = rs.getArchitecture();
        Toolchain latestTool = null;
        String latestVersion = "";
        for (Toolchain tc : pm.getToolchainList()) {
            String tcName = tc.getName().toLowerCase();
            String tcArch = tc.getArchitecture();
            if (!tcName.startsWith("llvm-") || !tcArch.equals(arch)) continue;
            String version2 = tcName.substring("llvm-".length());
            if (latestVersion.isEmpty()) {
                latestVersion = version2;
                latestTool = tc;
                continue;
            }
            Version ver22 = new Version(version2);
            Version ver12 = new Version(latestVersion);
            if (ver22.compareTo(ver12) <= 0) continue;
            latestVersion = version2;
            latestTool = tc;
        }
        if (latestTool != null && (name = latestTool.getName().toLowerCase()).startsWith("llvm-") && (ver1 = new Version(version = name.substring("llvm-".length()))).compareTo(ver2 = new Version("3.7")) >= 0) {
            return latestTool.getName();
        }
        return this.getDefaultToolchainName(rootstrapId);
    }

    private void updateToolchainFromChanges(String selectedRootstrapId, String toolName) {
        String toolchainId;
        if (StringUtil.isEmpty((CharSequence)selectedRootstrapId)) {
            return;
        }
        String tcName = this.getToolchainNameFromDisplayName(toolName);
        if (StringUtil.isEmpty((CharSequence)tcName)) {
            tcName = this.getDefaultLLVMName(selectedRootstrapId);
        }
        if (this.updateToolchainInfos(selectedRootstrapId, toolchainId = this.getSelectedToolchainId(selectedRootstrapId, tcName))) {
            this.setCurrentToolchainId(toolchainId);
        } else {
            this.logger.debug("[BUILDER LOG] update toolchain info failed - rsid: " + selectedRootstrapId + "   toolchainId: " + toolchainId);
        }
    }

    private String getDefaultToolchainName(String rsId) {
        PluginManager pm = PluginManager.getInstance();
        Rootstrap rs = pm.getRootstrap(rsId);
        try {
            Tool defaultToolchain = rs.getDefaultToolchain();
            return String.valueOf(defaultToolchain.getName()) + "-" + defaultToolchain.getVersion();
        }
        catch (RootstrapException e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
            String preToolchain = this.mToolchainCombo.getText();
            if (!StringUtil.isEmpty((CharSequence)this.mToolchainCombo.getText())) {
                return this.getToolchainNameFromDisplayName(preToolchain);
            }
            String arch = rs.getArchitecture();
            String toolchainType = rs.getSupportToolchainType();
            return this.getDefaultToolchainName(arch, toolchainType);
        }
    }

    private String getDefaultToolchainName(String arch, String toolchainType) {
        PluginManager pm = PluginManager.getInstance();
        for (Toolchain tc : pm.getToolchainList()) {
            if (!tc.getArchitecture().equals(arch) || !tc.getToolchainType().equals(toolchainType) || !tc.isDefault()) continue;
            return tc.getName();
        }
        for (Toolchain tc : pm.getToolchainList()) {
            if (!tc.getArchitecture().equals(arch) || !tc.getToolchainType().equals(toolchainType)) continue;
            return tc.getName();
        }
        return null;
    }

    private String getToolchainNameFromDisplayName(String displayName) {
        Toolchain toolChain;
        if (displayName != null && (toolChain = this.displayInfo.get(displayName)) != null) {
            return toolChain.getName();
        }
        return null;
    }

    private String getToolchainIdFromConfiguration() {
        SmartBuildInterface sbi = SmartBuildInterface.getInstance();
        return sbi.getToolchainIDFromTargetID(this.getTargetIdFromConfiguration());
    }

    private String getRootstrapIdFromConfiguration() {
        SmartBuildInterface sbi = SmartBuildInterface.getInstance();
        return sbi.getRootstrapIDFromTargetID(this.getTargetIdFromConfiguration());
    }

    private String getSelectedRootstrapVersionFromRootstrapId(String rootstrapId) {
        PluginManager pm = PluginManager.getInstance();
        if (pm.isAvailableRootstrapId(rootstrapId)) {
            return pm.getRootstrap(rootstrapId).getVersion();
        }
        return this.getPlatformVersionFromRootstrapId(rootstrapId);
    }

    private String getPlatformVersionFromRootstrapId(String rootstrapId) {
        if (StringUtil.isEmpty((CharSequence)rootstrapId)) {
            return null;
        }
        String[] sRootstrap = rootstrapId.split("-");
        if (sRootstrap.length < 2) {
            return null;
        }
        return String.valueOf(sRootstrap[0]) + " " + sRootstrap[1];
    }

    private void setRootstrapVersionCombo(List<String> list, int index) {
        this.mPlatformVersionLabel.setText(list.get(index));
    }

    private void setRootstrapPathLabel(String value, Color color) {
        this.mRootstrapPathLabel.setForeground(color);
        this.mRootstrapPathLabel.setText(value);
    }

    private void setToolchainNameCombo(List<String> list, int index) {
        this.mToolchainCombo.setItems(list.toArray(new String[0]));
        this.mToolchainCombo.select(index);
    }

    private void setRootstrapVerAndSift(String selectedId) {
        ArrayList<String> availableVerList = new ArrayList<String>();
        String selectedVersion = this.getSelectedRootstrapVersionFromRootstrapId(selectedId);
        List rootstrapList = PluginManager.getInstance().getRootstrapList();
        for (Rootstrap rs : rootstrapList) {
            if (availableVerList.contains(rs.getVersion()) || rs.compareTo((Object)selectedVersion) < 0) continue;
            availableVerList.add(rs.getVersion());
        }
        if (!PluginManager.getInstance().isAvailableRootstrapId(selectedId) && !availableVerList.contains(selectedVersion)) {
            availableVerList.add(selectedVersion);
        }
        int index = availableVerList.indexOf(selectedVersion);
        this.setRootstrapVersionCombo(availableVerList, index);
    }

    private boolean updateRootstrapInfos(String selectedId) {
        if (PluginManager.getInstance().isAvailableRootstrapId(selectedId)) {
            this.updateAvailableRootstrapInfos(selectedId);
        } else {
            this.updateInvalidRootstrapInfos(selectedId);
        }
        return true;
    }

    private boolean updateAvailableRootstrapInfos(String selectedId) {
        if (StringUtil.isEmpty((CharSequence)selectedId)) {
            this.logger.error("Selected rootstrap id is empty");
            return false;
        }
        SmartBuildInterface sbi = SmartBuildInterface.getInstance();
        List<Rootstrap> availableList = sbi.getAvailableRootstrapList(selectedId);
        if (availableList == null || availableList.size() <= 0) {
            this.logger.error("Available rootstrap is empty");
            return false;
        }
        this.setPlatformInfos(availableList, selectedId);
        return true;
    }

    private void selectPlatformArch(String arch) {
        int idx = this.mPlatformArchitectureCombo.indexOf(arch);
        if (idx < 0) {
            idx = 0;
        }
        this.mPlatformArchitectureCombo.select(idx);
    }

    private void selectPlatformName(String name) {
        int idx = this.mRootstrapCombo.indexOf(name);
        if (idx < 0) {
            idx = 0;
        }
        this.mRootstrapCombo.select(idx);
    }

    private void setPlatformPath(String path) {
        try {
            this.setRootstrapPathLabel(new File(path).getCanonicalPath(), Display.getCurrent().getSystemColor(2));
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void setPlatformInfos(List<Rootstrap> availableRS, String selectedRS) {
        Rootstrap rs = PluginManager.getInstance().getRootstrap(selectedRS);
        this.setPlatformVersion(availableRS, rs.getVersion());
        this.setPlatformArchitecture(availableRS, rs.getArchitecture(), rs.getVersion());
        this.setPlatformName(availableRS, rs.getName());
        this.setPlatformPath(rs.getPath());
    }

    private void setPlatformVersion(List<Rootstrap> availableRS, String selectedVersion) {
        if (availableRS != null) {
            for (Rootstrap rs : availableRS) {
                if (!selectedVersion.contains(rs.getVersion())) continue;
                this.mPlatformVersionLabel.setText(selectedVersion);
                break;
            }
        }
    }

    private void setPlatformArchitecture(List<Rootstrap> availableRS, String selectedArch, String selectedVersion) {
        if (availableRS == null) {
            return;
        }
        this.mPlatformArchitectureCombo.removeAll();
        ArrayList<String> archList = new ArrayList<String>();
        for (Rootstrap rs : availableRS) {
            String arch;
            if (!selectedVersion.contains(rs.getVersion()) || archList.contains(arch = SBIModel.getDisplayArch(rs))) continue;
            archList.add(arch);
        }
        Collections.sort(archList, new Comparator<String>(){

            @Override
            public int compare(String arch1, String arch2) {
                int idx0 = SBIModel.getDisplayArchIndex(arch1);
                int idx1 = SBIModel.getDisplayArchIndex(arch2);
                if (idx1 == -1) {
                    return -1;
                }
                if (idx0 < idx1) {
                    return -1;
                }
                return 1;
            }
        });
        this.mPlatformArchitectureCombo.setItems(archList.toArray(new String[0]));
        this.selectPlatformArch(PlatformSettingTab.getDisplayArch(selectedArch));
    }

    public static String getDisplayArch(String arch) {
        if (arch != null) {
            String[][] stringArray = SBIModel.ARCHITECTURES;
            int n = SBIModel.ARCHITECTURES.length;
            int n2 = 0;
            while (n2 < n) {
                String[] archGroup;
                String[] stringArray2 = archGroup = stringArray[n2];
                int n3 = archGroup.length;
                int n4 = 0;
                while (n4 < n3) {
                    String archItem = stringArray2[n4];
                    if (archItem.equalsIgnoreCase(arch)) {
                        return archGroup[0];
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return "";
    }

    private void setPlatformName(List<Rootstrap> availableRS, String selectedName) {
        if (availableRS == null) {
            return;
        }
        this.mRootstrapCombo.removeAll();
        String currentVersion = this.mPlatformVersionLabel.getText();
        String currentArch = this.mPlatformArchitectureCombo.getText();
        ArrayList<String> nameList = new ArrayList<String>();
        for (Rootstrap rs : availableRS) {
            if (!rs.getVersion().equals(currentVersion) || !SBIModel.getDisplayArch(rs).equals(currentArch) || nameList.contains(rs.getName())) continue;
            nameList.add(rs.getName());
        }
        Collections.sort(nameList);
        this.mRootstrapCombo.setItems(nameList.toArray(new String[0]));
        this.selectPlatformName(selectedName);
    }

    private void updateInvalidRootstrapInfos(String selectedId) {
        this.setRootstrapVerAndSift(this.getPlatformVersionFromRootstrapId(selectedId));
        Color color = Display.getCurrent().getSystemColor(3);
        String text = Messages.TIZEN_SETTINGS_PLATFORM_TAB_CHANGE_ROOTSTRAP_ERROR;
        if (this.mPlatformArchitectureCombo.getText().length() < 2) {
            text = Messages.TIZEN_SETTINGS_PLATFORM_TAB_NO_ROOTSTRAP_ERROR;
        }
        this.setRootstrapPathLabel(text, color);
    }

    private boolean updateToolchainInfos(String rootstrapId, String toolchainId) {
        if (StringUtil.isEmpty((CharSequence)rootstrapId) || PluginManager.getInstance().getRootstrap(rootstrapId) == null) {
            this.logger.error(String.format("Cannot find rootstrap (%s)", rootstrapId));
            return false;
        }
        if (StringUtil.isEmpty((CharSequence)toolchainId)) {
            this.logger.error("Rootstrap ID or toolchain ID is null");
            return false;
        }
        List<Toolchain> toolchainList = this.getAvailableToolchainList(rootstrapId);
        Collections.sort(toolchainList, new Comparator<Toolchain>(){

            @Override
            public int compare(Toolchain tc1, Toolchain tc2) {
                return tc1.getName().compareTo(tc2.getName());
            }
        });
        List<String> displayTCNameList = this.getDisplayTCNameList(toolchainList, rootstrapId);
        this.setDisplayInfo(displayTCNameList, toolchainList);
        PluginManager pm = PluginManager.getInstance();
        Toolchain tc = pm.getToolchain(toolchainId);
        String selectedName = this.getDisplayNameFromToolchainName(tc.getName(), rootstrapId);
        int index = displayTCNameList.indexOf(selectedName);
        if (index < 0) {
            return false;
        }
        if (!this.createTarget(rootstrapId, toolchainId)) {
            return false;
        }
        this.setToolchainNameCombo(displayTCNameList, index);
        this.setToolList(toolchainId);
        return true;
    }

    private List<String> getDisplayTCNameList(List<Toolchain> tcList, String rootstrapId) {
        if (tcList == null || tcList.size() <= 0) {
            return Collections.emptyList();
        }
        ArrayList<String> displayNameList = new ArrayList<String>();
        for (Toolchain tc : tcList) {
            displayNameList.add(this.getDisplayNameFromToolchainName(tc.getName(), rootstrapId));
        }
        return displayNameList;
    }

    private String getDisplayNameFromToolchainName(String tcName, String rootstrapId) {
        PluginManager pm = PluginManager.getInstance();
        Rootstrap rs = pm.getRootstrap(rootstrapId);
        ArrayList defaultTCList = null;
        try {
            defaultTCList = rs.getDefaultToolchainList();
        }
        catch (RootstrapException rootstrapException) {
            defaultTCList = new ArrayList();
        }
        String dpName = null;
        if (tcName.startsWith("LLVM") && !defaultTCList.isEmpty()) {
            String matchToolchain = null;
            for (Tool tc : defaultTCList) {
                if (!tc.getName().startsWith("GCC")) continue;
                matchToolchain = String.valueOf(tc.getName()) + "-" + tc.getVersion();
                break;
            }
            dpName = matchToolchain != null ? String.valueOf(tcName) + " with " + matchToolchain : tcName;
        } else {
            dpName = tcName;
        }
        return dpName;
    }

    private String getGCCVersionFromLLVMVersion(String llvmVersion) {
        if (llvmVersion != null) {
            if (llvmVersion.equals("3.6") || llvmVersion.equals("3.7")) {
                return "GCC-4.9";
            }
            if (llvmVersion.equals("3.4")) {
                return "GCC-4.6";
            }
            return llvmVersion;
        }
        return "";
    }

    private String getToolchainVersionFromName(String toolchainName) {
        String[] toolchainInfos = this.getToolchainInfos(toolchainName);
        if (toolchainInfos == null || toolchainInfos.length < 2) {
            return null;
        }
        return toolchainInfos[1];
    }

    private String[] getToolchainInfos(String toolchainName) {
        if (toolchainName != null) {
            return toolchainName.split("-");
        }
        return null;
    }

    private void setDisplayInfo(List<String> dpList, List<Toolchain> tcList) {
        int i = 0;
        while (i < dpList.size()) {
            this.displayInfo.put(dpList.get(i), tcList.get(i));
            ++i;
        }
    }

    private boolean createTarget(String rootstrapId, String toolchainId) {
        SmartBuildInterface sbi = SmartBuildInterface.getInstance();
        String targetID = SmartBuildInterface.makeTargetID(rootstrapId, toolchainId);
        if (SBIModel.getTargetById(targetID) == null) {
            try {
                sbi.writeTargetCfgFile(targetID);
            }
            catch (SBIException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                return false;
            }
        }
        this.logger.debug("[BUILDER LOG] rsId:" + rootstrapId + " tId:" + toolchainId + " targetID:" + targetID);
        return true;
    }

    private List<Toolchain> getAvailableToolchainList(String rootstrapId) {
        if (rootstrapId == null) {
            return Collections.emptyList();
        }
        PluginManager pm = PluginManager.getInstance();
        Rootstrap rs = pm.getRootstrap(rootstrapId);
        if (rs == null) {
            return Collections.emptyList();
        }
        String supportTCType = rs.getSupportToolchainType();
        String rsArchitecture = rs.getArchitecture();
        this.getArtifactType();
        ArrayList<Toolchain> availableTCList = new ArrayList<Toolchain>();
        for (Toolchain tc : pm.getToolchainList()) {
            String iArchitecture = tc.getArchitecture();
            String iToolchainType = tc.getToolchainType();
            if (this.config != null && (this.config.getName().equals("Debug-Tizen-Device") || this.config.getName().contains("Debug-Tizen-Emulator") || this.config.getName().contains("DA-Tizen-Device") || this.config.getName().contains("DA-Tizen-Emulator") || this.config.getName().contains("Tizen-Device") || this.config.getName().contains("Tizen-Emulator")) && !this.isToolchainSupportedByCurrentDevice(tc.getId()) || !CommonConfigurationManager.isSameArchType(rsArchitecture, iArchitecture) || !iToolchainType.equals(supportTCType)) continue;
            availableTCList.add(tc);
        }
        return availableTCList;
    }

    private String getArtifactType() {
        if (this.config != null && this.config.getBuildArtefactType() != null) {
            return this.config.getBuildArtefactType().getId();
        }
        return "";
    }

    private boolean isToolchainSupportedByCurrentDevice(String toolchainID) {
        String target = CommonConfigurationManager.getBuildTargetName(this.config);
        if (target == null) {
            return false;
        }
        SmartBuildInterface sbi = SmartBuildInterface.getInstance();
        String previousArch = sbi.getArchitectureFromToolchainID(sbi.getToolchainIDFromTargetID(target));
        String arch = sbi.getArchitectureFromToolchainID(toolchainID);
        return CommonConfigurationManager.isSameArchType(arch, previousArch);
    }

    private void createToolInfoComposite(Composite parent) {
        this.toolListTable = new TableViewer(parent, 258);
        Table table = this.toolListTable.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        String[] columnNames = new String[]{Messages.TIZEN_SETTINGS_PLATFORM_TAB_TOOLCHAIN_TABLE_TOOL, Messages.TIZEN_SETTINGS_PLATFORM_TAB_TOOLCHAIN_TABLE_NAME, Messages.TIZEN_SETTINGS_PLATFORM_TAB_TOOLCHAIN_TABLE_VERSION};
        int[] columnWidths = new int[]{200, 250, 250};
        int i = 0;
        while (i < columnNames.length) {
            TableColumn tableColumn = new TableColumn(table, 16384);
            tableColumn.setText(columnNames[i]);
            tableColumn.setWidth(columnWidths[i]);
            tableColumn.addSelectionListener((SelectionListener)new TooltableSelectionAdapter());
            ++i;
        }
        this.toolListTable.setLabelProvider((IBaseLabelProvider)new TableViewerProvider());
        this.toolListTable.setContentProvider((IContentProvider)new ArrayContentProvider());
    }

    protected void changeToolchain(IConfiguration cfg, String targetId) {
        CommonProjectDependentBuilder builder = ProjectTypeManager.getProjectBuilderInstance(this.project);
        if (builder != null) {
            builder.changeToolchain(cfg, targetId);
        }
    }

    private void setToolList(String toolchainId) {
        List list = SBIModel.getToolchainById(toolchainId).getToolList();
        this.toolListTable.setInput((Object)list);
    }

    private String getNameFromPath(String path) {
        String[] result = path.split("/");
        return result[result.length - 1];
    }

    private String getTargetIdFromConfiguration() {
        CommonProjectDependentBuilder builder = ProjectTypeManager.getProjectBuilderInstance(this.project);
        if (builder != null) {
            return builder.getTargetID(this.getCfg());
        }
        return "";
    }

    private synchronized void setCurrentRootstrapId(String id) {
        this.currentRootstrapID = id;
    }

    private synchronized void setCurrentToolchainId(String id) {
        this.currentToolchainID = id;
    }

    private String getCurrentRootstrapId() {
        return this.currentRootstrapID;
    }

    private String getCurrentToolchainId() {
        return this.currentToolchainID;
    }

    private void applyInfos() {
        IConfiguration conf = this.getCfg();
        String rootstrapId = this.getCurrentRootstrapId();
        String toolchainId = this.getCurrentToolchainId();
        if (rootstrapId == null || rootstrapId.isEmpty() || toolchainId == null || toolchainId.isEmpty()) {
            return;
        }
        String targetId = SmartBuildInterface.makeTargetID(rootstrapId, toolchainId);
        this.changeToolchain(conf, targetId);
        PlatformChangingManager.notifyChangedPlatformListener(conf);
    }

    protected void performOK() {
        IConfiguration conf = this.getCfg();
        String rootstrapId = this.getCurrentRootstrapId();
        String toolchainId = this.getCurrentToolchainId();
        if (rootstrapId == null || rootstrapId.isEmpty() || toolchainId == null || toolchainId.isEmpty()) {
            return;
        }
        if (conf instanceof MultiConfiguration) {
            String targetID = SmartBuildInterface.makeTargetID(rootstrapId, toolchainId);
            Object[] o = ((MultiConfiguration)conf).getItems();
            IConfiguration[] iConfigurationArray = (IConfiguration[])o;
            int n = iConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfiguration c = iConfigurationArray[n2];
                this.changeToolchain(c, targetID);
                ++n2;
            }
        }
        CDTPropertyManager.performOk(null);
        CommonConfigurationManager.changeTProject(this.project, this.getSelectedRootstrapVersionFromRootstrapId(rootstrapId));
        super.performOK();
    }

    protected void performApply(ICResourceDescription src, ICResourceDescription dst) {
        IConfiguration conf = this.getCfg();
        String rootstrapId = this.getCurrentRootstrapId();
        String toolchainId = this.getCurrentToolchainId();
        if (rootstrapId == null || rootstrapId.isEmpty() || toolchainId == null || toolchainId.isEmpty()) {
            return;
        }
        if (conf instanceof MultiConfiguration) {
            String targetID = SmartBuildInterface.makeTargetID(rootstrapId, toolchainId);
            Object[] o = ((MultiConfiguration)conf).getItems();
            IConfiguration[] iConfigurationArray = (IConfiguration[])o;
            int n = iConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfiguration c = iConfigurationArray[n2];
                this.changeToolchain(c, targetID);
                ++n2;
            }
        }
        CDTPropertyManager.performOk(null);
        CommonConfigurationManager.changeTProject(this.project, this.getSelectedRootstrapVersionFromRootstrapId(rootstrapId));
    }

    protected void performDefaults() {
        this.updateToolchainFromChanges(this.currentRootstrapID, null);
        this.applyInfos();
    }

    protected void updateButtons() {
    }

    protected void updateData(ICResourceDescription cfgd) {
        if (cfgd == null) {
            return;
        }
        this.config = PlatformSettingTab.getCfg((ICConfigurationDescription)cfgd.getConfiguration());
        this.cfgdescr = cfgd;
        SmartBuildInterface sbi = SmartBuildInterface.getInstance();
        this.currentRootstrapID = this.getRootstrapIdFromConfiguration();
        this.currentToolchainID = this.getToolchainIdFromConfiguration();
        this.availableRootstrap = sbi.getAvailableRootstrapList(this.currentRootstrapID);
        this.updateRootstrapInfos(this.currentRootstrapID);
        if (!this.updateToolchainInfos(this.currentRootstrapID, this.currentToolchainID)) {
            this.logger.debug("[BUILDER LOG] update toolchain info failed - rsid: " + this.currentRootstrapID + "   toolchainId: " + this.currentToolchainID);
        }
    }

    private class TableViewerProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableViewerProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Tool) {
                Tool tool = (Tool)element;
                String name = tool.getName();
                String path = tool.getPath();
                String binaryName = PlatformSettingTab.this.getNameFromPath(path);
                String version = tool.getVersion();
                switch (columnIndex) {
                    case 0: {
                        return name;
                    }
                    case 1: {
                        return binaryName;
                    }
                    case 2: {
                        return version;
                    }
                }
            }
            return null;
        }
    }

    private class TooltableSelectionAdapter
    extends SelectionAdapter {
        private TooltableSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            PlatformSettingTab.this.selectedColumn = PlatformSettingTab.this.toolListTable.getTable().indexOf((TableColumn)e.widget);
            PlatformSettingTab.this.toolListTable.getTable().setSortColumn((TableColumn)e.widget);
            if (PlatformSettingTab.this.toolListTable.getTable().getSortDirection() == 1024) {
                PlatformSettingTab.this.toolListTable.getTable().setSortDirection(128);
            } else {
                PlatformSettingTab.this.toolListTable.getTable().setSortDirection(1024);
            }
            PlatformSettingTab.this.toolListTable.setSorter(new ViewerSorter(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    Tool entry_1 = (Tool)e1;
                    Tool entry_2 = (Tool)e2;
                    switch (PlatformSettingTab.this.selectedColumn) {
                        case 0: {
                            if (PlatformSettingTab.this.toolListTable.getTable().getSortDirection() == 1024) {
                                return entry_1.getName().compareTo(entry_2.getName());
                            }
                            return entry_2.getName().compareTo(entry_1.getName());
                        }
                        case 1: {
                            if (PlatformSettingTab.this.toolListTable.getTable().getSortDirection() == 1024) {
                                return entry_1.getToolName().compareTo(entry_2.getToolName());
                            }
                            return entry_2.getToolName().compareTo(entry_1.getToolName());
                        }
                        case 2: {
                            if (PlatformSettingTab.this.toolListTable.getTable().getSortDirection() == 1024) {
                                return entry_1.getVersion().compareTo(entry_2.getVersion());
                            }
                            return entry_2.getVersion().compareTo(entry_1.getVersion());
                        }
                    }
                    return entry_1.getName().compareTo(entry_2.getName());
                }
            });
        }
    }
}

