/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.rename;

import java.util.HashSet;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.CSourceEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.WriteAccessException;
import org.eclipse.cdt.internal.ui.refactoring.rename.RenameMessages;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

public class RenameCSourceFolderChange
extends Change {
    private final IPath oldFolderPath;
    private final IPath newFolderPath;
    private final IProject project;
    private final IFolder oldFolder;

    public RenameCSourceFolderChange(IFolder oldFolder, IPath newFolderPath) {
        this.oldFolder = oldFolder;
        this.newFolderPath = newFolderPath;
        this.oldFolderPath = oldFolder.getFullPath();
        this.project = oldFolder.getProject();
    }

    public Object getModifiedElement() {
        return this.oldFolder;
    }

    public String getName() {
        return NLS.bind((String)RenameMessages.RenameCSourceFolderChange_Name0, (Object)this.oldFolderPath.lastSegment(), (Object)this.newFolderPath.lastSegment());
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.oldFolder.exists()) {
            return RefactoringStatus.create((IStatus)Status.OK_STATUS);
        }
        return RefactoringStatus.create((IStatus)new Status(4, "org.eclipse.cdt.ui", NLS.bind((String)RenameMessages.RenameCSourceFolderChange_ErrorMsg, (Object)this.oldFolder.getName())));
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        this.changeEntryInAllCfgs(CCorePlugin.getDefault().getProjectDescription(this.project, true));
        IFolder newFolder = this.project.getFolder(this.newFolderPath.removeFirstSegments(1));
        return new RenameCSourceFolderChange(newFolder, this.oldFolderPath);
    }

    private void changeEntryInAllCfgs(ICProjectDescription des) throws WriteAccessException, CoreException {
        ICConfigurationDescription[] cfgs;
        ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgs = des.getConfigurations();
        int n = cfgs.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription cfg = iCConfigurationDescriptionArray[n2];
            ICSourceEntry[] entries = cfg.getSourceEntries();
            entries = this.renameSourceEntries(entries);
            cfg.setSourceEntries(entries);
            ++n2;
        }
        CCorePlugin.getDefault().setProjectDescription(this.project, des, false, (IProgressMonitor)new NullProgressMonitor());
    }

    private ICSourceEntry[] renameSourceEntries(ICSourceEntry[] sourceEntries) {
        HashSet<ICSourceEntry> set = new HashSet<ICSourceEntry>();
        ICSourceEntry[] iCSourceEntryArray = sourceEntries;
        int n = sourceEntries.length;
        int n2 = 0;
        while (n2 < n) {
            ICSourceEntry entry = iCSourceEntryArray[n2];
            set.add(RenameCSourceFolderChange.renameSourceEntry(entry, this.oldFolderPath, this.newFolderPath));
            ++n2;
        }
        return set.toArray(new ICSourceEntry[set.size()]);
    }

    static ICSourceEntry renameSourceEntry(ICSourceEntry sourceEntry, IPath oldFolderPath, IPath newFolderPath) {
        String entryPath = sourceEntry.getName();
        if (entryPath.equals(oldFolderPath.toString())) {
            return new CSourceEntry(newFolderPath, sourceEntry.getExclusionPatterns(), sourceEntry.getFlags());
        }
        IPath oldSegments = oldFolderPath.removeFirstSegments(oldFolderPath.segmentCount() - 1);
        HashSet<IPath> exclusionPatterns = new HashSet<IPath>();
        IPath[] iPathArray = sourceEntry.getExclusionPatterns();
        int n = iPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPath pattern = iPathArray[n2];
            if (pattern.equals((Object)oldSegments)) {
                exclusionPatterns.add(newFolderPath.removeFirstSegments(newFolderPath.segmentCount() - 1));
            } else {
                exclusionPatterns.add(pattern);
            }
            ++n2;
        }
        return new CSourceEntry(sourceEntry.getValue(), exclusionPatterns.toArray(new IPath[exclusionPatterns.size()]), sourceEntry.getFlags());
    }
}

