/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ScalabilityIntegerFieldEditor
extends IntegerFieldEditor {
    private ControlDecoration fDecoration;
    private final String fEnableKey;
    private Button fCheckbox;
    private boolean fWasSelected;

    public ScalabilityIntegerFieldEditor(String enableKey, String nameKey, String labelText, Composite parent) {
        super(nameKey, labelText, parent);
        this.fEnableKey = enableKey;
    }

    public Text getTextControl(Composite parent) {
        Text control = super.getTextControl(parent);
        if (this.fDecoration == null) {
            this.fDecoration = new ControlDecoration((Control)control, 16512);
            FieldDecoration errorDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
            this.fDecoration.setImage(errorDecoration.getImage());
            this.fDecoration.setDescriptionText(this.getErrorMessage());
            control.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    ScalabilityIntegerFieldEditor.this.refreshValidState();
                }
            });
        }
        return control;
    }

    protected void showErrorMessage(String msg) {
        super.showErrorMessage(msg);
        if (this.fDecoration != null) {
            this.fDecoration.setDescriptionText(msg);
            this.fDecoration.show();
        }
    }

    protected void clearErrorMessage() {
        super.clearErrorMessage();
        if (this.fDecoration != null) {
            this.fDecoration.hide();
        }
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getCheckboxControl(parent);
        super.doFillIntoGrid(parent, numColumns);
    }

    private Button getCheckboxControl(Composite parent) {
        if (this.fCheckbox == null) {
            Composite inner = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginWidth = 0;
            inner.setLayout((Layout)layout);
            this.fCheckbox = new Button(inner, 32);
            this.fCheckbox.setFont(parent.getFont());
            this.fCheckbox.setText(this.getLabelText());
            Label label = this.getLabelControl(inner);
            label.setText("");
            label.setVisible(false);
            this.fCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean isSelected = ScalabilityIntegerFieldEditor.this.fCheckbox.getSelection();
                    ScalabilityIntegerFieldEditor.this.valueChanged(ScalabilityIntegerFieldEditor.this.fWasSelected, isSelected);
                    ScalabilityIntegerFieldEditor.this.fWasSelected = isSelected;
                }
            });
        } else {
            this.checkParent((Control)this.fCheckbox.getParent(), parent);
        }
        return this.fCheckbox;
    }

    public Label getLabelControl(Composite parent) {
        Label label = this.getLabelControl();
        if (label == null) {
            return super.getLabelControl(parent);
        }
        this.checkParent((Control)label.getParent(), parent);
        return label;
    }

    protected void valueChanged(boolean oldValue, boolean newValue) {
        if (oldValue != newValue) {
            this.valueChanged();
            this.fireStateChanged("field_editor_value", oldValue, newValue);
            this.getTextControl().setEnabled(newValue);
            this.getLabelControl().setEnabled(newValue);
        }
    }

    protected boolean checkState() {
        if (this.fCheckbox != null && !this.fCheckbox.getSelection()) {
            this.clearErrorMessage();
            return true;
        }
        return super.checkState();
    }

    protected void doLoad() {
        super.doLoad();
        if (this.fCheckbox != null) {
            boolean value = this.getPreferenceStore().getBoolean(this.fEnableKey);
            this.fCheckbox.setSelection(value);
            this.fWasSelected = value;
            this.getTextControl().setEnabled(value);
            this.getLabelControl().setEnabled(value);
        }
    }

    protected void doLoadDefault() {
        super.doLoadDefault();
        if (this.fCheckbox != null) {
            boolean value = this.getPreferenceStore().getDefaultBoolean(this.fEnableKey);
            this.fCheckbox.setSelection(value);
            this.fWasSelected = value;
            this.getTextControl().setEnabled(value);
            this.getLabelControl().setEnabled(value);
        }
    }

    protected void doStore() {
        super.doStore();
        this.getPreferenceStore().setValue(this.fEnableKey, this.fCheckbox.getSelection());
    }

    public boolean getBooleanValue() {
        return this.fCheckbox.getSelection();
    }

    public void setBooleanValue(boolean value) {
        if (this.fCheckbox != null) {
            this.fWasSelected = value;
            this.getLabelControl().setEnabled(value);
            this.getTextControl().setEnabled(value);
            this.fCheckbox.setSelection(value);
        }
    }
}

